

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('usuarios.index')); ?>">Usuarios</a></li>
    <li class="breadcrumb-item active" aria-current="page">Ver Usuario</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="tituloMorado" style="width: 100%">
        <h2>USUARIO</h2>
    </div>
    <div class="row justify-content-center userShow">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Información del usuario </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Usuario</label>
                        <input class="form-control" id="email" value="<?php echo e($usuario->email); ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->name); ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label>Estado</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->active ? 'ACTIVO' : 'INACTIVO'); ?>"
                            readonly>
                    </div>
                    <div class="form-group">
                        <label>Roles</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->getRoleNames()->implode(', ')); ?>"
                            readonly>
                    </div>
                    <div class="form-group">
                        <label>Permisos</label>
                        <input type="text" class="form-control"
                            value="<?php echo e($usuario->getAllPermissions()->pluck('name')->implode(', ')); ?>" readonly>
                    </div>
                    <?php if(auth()
            ->user()
            ->hasPermissionTo('Actualizar usuarios') ||
        auth()
            ->user()
            ->hasRole('admin') ||
        auth()
            ->user()
            ->hasRole('super-admin')): ?>
                        <div class="text-center">
                            <a href="<?php echo e(route('usuarios.edit', $usuario)); ?>" class="btn btn-primary  btn-crear">Editar
                                Usuario<i class="fa fa-pen"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Información del usuario en el sistema</div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Usuario creador</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->creatorUser->name); ?>" readonly />
                    </div>
                    <div class="form-group">
                        <label>Fecha de creación</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->created_at->format('d/m/Y H:i:s')); ?>"
                            readonly />
                    </div>

                    <div class="form-group">
                        <label>Usuario última actulización</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->updaterUser->name); ?>" readonly />
                    </div>
                    <div class="form-group">
                        <label>Fecha última actulización</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->updated_at->format('d/m/Y H:i:s')); ?>"
                            readonly />
                    </div>
                    <div class="form-group">
                        <label>Token</label>
                        <input type="text" class="form-control" value="<?php echo e($usuario->token); ?>"
                            readonly />
                    </div>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cisc/public_html/intranet/resources/views/usuarios/show.blade.php ENDPATH**/ ?>