

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
    <li class="breadcrumb-item active" aria-current="page">Roles</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="tituloMorado" style="width: 100%">
        <h2>ROLES</h2>
    </div>
    <div class="">


    </div>
    <div class="row justify-content-center">

        <div class="col-md-8 my-3">
            <?php if(auth()->user()->hasPermissionTo('Crear roles') || auth()->user()->hasRole('admin') || auth()->user()->hasRole('super-admin')): ?>
            <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-primary float-right btn-crear">Crear Rol<i
                    class="fa fa-plus"></i>
            </a>
            <?php endif; ?>

        </div>

        <div class="col-md-8 py-3 rounded-lg" style="background-color: rgba(0, 0, 0, 0.05);">

            <table id="tabla" class="table table-bordered table-striped mb-5" data-page-length='10'>
                <thead>
                    <tr>
                        <th>ID</th>

                        <th>NOMBRE</th>
                        <th>DESCRIPCIÓN</th>
                        <th>PERMISOS</th>
                        <th>FECHA DE CREACIÓN</th>
                        <th>ACCIONES</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td><?php echo e($role->id); ?></td>
                            <td><?php echo e($role->display_name); ?></td>
                            <td><?php echo e($role->description); ?></td>
                            <td><?php echo e($role->getPermissionNames()->implode(', ')); ?></td>
                            <td><?php echo e($role->created_at->format('d/m/Y')); ?></td>
                            <td>
                                <?php if(auth()->user()->hasPermissionTo('Ver roles') || auth()->user()->hasRole('admin') || auth()->user()->hasRole('super-admin')): ?>
                                    <a href="<?php echo e(route('roles.show', $role)); ?>" class="btn btn-sm btn-primary" title="Ver rol">
                                        <i class="fa fa-eye">
                                        </i>
                                    </a>
                                <?php endif; ?>
                                <?php if(auth()->user()->hasPermissionTo('Actualizar roles') || auth()->user()->hasRole('admin') || auth()->user()->hasRole('super-admin')): ?>
                                <?php if($role->id !== 1 && $role->id !== 2): ?>
                                    <a href="<?php echo e(route('roles.edit', $role)); ?>" class="btn btn-sm btn-secondary"
                                        title="Editar rol">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                <?php endif; ?>
                                <?php endif; ?>
                                <?php if(auth()->user()->hasPermissionTo('Eliminar roles') || auth()->user()->hasRole('admin') || auth()->user()->hasRole('super-admin')): ?>
                                    <?php if($role->id !== 1 && $role->id !== 2): ?>
                                        <a class="btn btn-sm btn-danger" title="Eliminar rol" data-toggle="modal"
                                            data-target="#confirmDialog">
                                            <i class="fa fa-times"></i>
                                        </a>
                                        <form id="roleDeleteForm" action="<?php echo e(route('roles.destroy', $role)); ?>" method="POST"
                                            style="display: inline-block">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        </form>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make('partials.confirm-dialog',['mensaje'=>'¿Desea eliminar este rol?','formId'=>'roleDeleteForm'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </tbody>

            </table>

        </div>

    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <?php echo $__env->make('datatable.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <?php echo $__env->make('datatable.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        var jqDataTable = $.noConflict(true);
        jqDataTable(function() {
            jqDataTable("#tabla").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "info": false,
                "language": {
                    "searchPlaceholder": "Buscar",
                    "decimal": "",
                    "emptyTable": "No hay registros",
                    "info": "Mostrando del  _START_ al _END_ de _TOTAL_ registros",
                    "infoEmpty": "Showing 0 to 0 of 0 entries",
                    "infoFiltered": "(filtered from _MAX_ total entries)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "Show _MENU_ entries",
                    "loadingRecords": "Cargando...",
                    "processing": "Procesando...",
                    "search": "",
                    "zeroRecords": "No se encontraron coincidencias",
                    "paginate": {
                        "first": "<<",
                        "last": ">>",
                        "next": ">",
                        "previous": "<"
                    },
                    "aria": {
                        "sortAscending": ": activate to sort column ascending",
                        "sortDescending": ": activate to sort column descending"
                    }
                },
                "columns": [
                    null,
                    null,
                    null,
                    null,
                    null,
                    {
                        "width": "15%"
                    },
                ],
                "buttons": [

                    {
                        extend: 'excel',
                        text: 'Excel'

                    }
                ]
            }).buttons().container().appendTo('#tabla_wrapper .col-md-5:eq(0)');

        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cisc/public_html/intranet/resources/views/roles/index.blade.php ENDPATH**/ ?>