<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo $__env->yieldContent('title','Intranet'); ?></title>
    <link rel="stylesheet" href="<?php echo e(mix('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('css/cheeseburger_menu.css')); ?>">
    <link rel="icon" type="image/png" href="/img/favicon.png">
    <?php echo $__env->yieldPushContent('styles'); ?>
    <script src="<?php echo e(mix('js/app.js')); ?>" defer></script>
    <script src="<?php echo e(mix('js/cheeseburger_menu.js')); ?>" defer></script>
 
    <script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>

</head>

<body class="<?php echo e(request()->is('/') ? 'bg-image-login' : ''); ?> 
    <?php echo e(request()->is('password/reset*') ? 'bg-image-login' : ''); ?> bg-white">
    <?php if(auth()->guard()->check()): ?>
        <div class="loader"></div>
    <?php endif; ?>
    <div id="app" class="d-flex flex-column h-screen justify-content-between">
        <header>

            <?php echo $__env->make('partials/nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </header>
        <main class="py-3">
            <?php if(auth()->guard()->check()): ?>

                <section class="welcome" style="margin-top:65px;">
                    <img src="/img/bienvenido.png" alt="Bienvenido">
                    <h3 class="pt-2"><?php echo e(Auth::user()->name); ?></h3>  
                </section>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                    </ol>
                </nav>
                <?php echo $__env->make('partials.flash-messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <div class="container" style="max-width: 100%">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>


        <footer class="footer" style=" ">
            <?php if(auth()->guard()->check()): ?>

                <div class="row  " style=" ">
				 <div class="col-sm-12" style="text-align:center;">
				  <img src="/img/logopitsfooter.jpg" alt="PITS">
				 </div>
				</div>
				
                <div class="row  " style="margin-top:20px;background-color:#D9D9D9 !important;color:#0B234F !important;  ">
                    <div class="col-sm-4" style="">
                        <div class="" style="">
                            <div style="margin: auto;width: 50%;font-family:FuturaBook;color:#0a244f;font-size:15px;">
                                <br>
								<p>Carrera 7 No. 26-20 piso 7 y 9,
                                    Edificio Tequendama.<br><strong>Teléfono:</strong> (571)
                                    6166044<br><strong>Email:</strong><u>fontur@pitscolombia.com.co</u><br><strong>Nit:</strong>
                                    900649119-9</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4" style="">
                        <div class="" style="">
                            <div style="margin: auto;width: 50%;font-family:FuturaBook;color:#0a244f;font-size:15px;">
                                <br> 
								<p><strong>Dirección de correspondencia:</strong><br>Calle 28 #13ª-24
                                    piso 6 Edificio Museo del Parque<br><strong>Teléfono:</strong> (57–1) 3275500
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4" style="">
                        <div class="" style="">
                            <div style="margin: auto;width: 50%;font-family:FuturaBook;color:#0a244f;font-size:15px;">
                                <br> 
								<p><strong>Horario de atención: </strong>de lunes a viernes de 8 AM a 5:00 PM -
                                    Bogotá, Colombia.<br><a
                                        data-cke-saved-href="/sites/default/files/politica-proteccion-datos-personales.pdf"
                                        href="/sites/default/files/politica-proteccion-datos-personales.pdf"
                                        target="_blank" style="color:#0B234F;"><u>Términos y condiciones</u></a><br><a
                                        data-cke-saved-href="/sites/default/files/aviso-privacidad.pdf"
                                        href="/sites/default/files/aviso-privacidad.pdf" target="_blank" style="color:#0B234F;"><u>Mapa del sitio</u></a></p>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endif; ?>

			 
            <div class="footer-login bg-white text-black-50 text-center  " style="color:#0a244f;font-size:16px; ">
                <div style="margin:20px;">
                &copy; <?php echo e(date('Y')); ?>, FONDO NACIONAL DE TURISMO - FONTUR. República de Colombia Bogotá D.C. 
                <br>
                Diseñado y Desarrollado por <a href="https://ciscsas.com/" target="_blank" style="text-decoration:none;color:#747A85"><b>CISC SAS</b></a> <?php echo e(date('Y')); ?>

                </div>
				<br> 
            </div>
			 
        </footer>
    </div>

    
    <script type="text/javascript">
        $(window).load(function() {
            $(".loader").fadeOut("slow");
        });

    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/cisc/public_html/intranet/resources/views/template.blade.php ENDPATH**/ ?>