<?php

use Illuminate\Support\Facades\Route;

Route::get('/', 'Auth\LoginController@showLoginForm')->name('index');
Route::group(['middleware' => 'auth'], function () {

	
    Route::get('turistas', 'TuristasController@index')->name('turistas');
    Route::get('reportes', 'ReporteController@index')->name('reportes');

    Route::get('home', 'HomeController@index')->name('home');
    Route::get('noticias/', 'NoticiaController@index')->name('noticia.index');
    Route::get('noticias/{noticia}/{title}', 'NoticiaController@show')->name('noticia.show');
    Route::get('galerias/', 'GaleriaController@index')->name('galeria.index');
    Route::get('galerias/{galeria}/{title}', 'GaleriaController@show')->name('galeria.show');
    Route::get('turistas/', 'VideoController@index')->name('video.index');
    Route::post('insertarTurista/', 'VideoController@store')->name('video.store');
    Route::get('videos/{video}/{title}', 'VideoController@show')->name('video.show');

    Route::get('correspondencia', 'CorrespondenciaController@index')->name('correspondencia.index');

    Route::post('correspondencia', 'CorrespondenciaController@store')->name('correspondencia.store');
    Route::post('correspondenciaIndex', 'CorrespondenciaController@store')->name('home.correspondencia.store');

    Route::get('documentos', 'FileManagerController@index')->name('filemanager.index');

    Route::resource('usuarios', 'UserController');
    Route::get('perfil', 'UserController@profile')->name('user.profile');
    Route::put('perfil/{usuario}', 'UserController@updatePassword')->name('user.updatePassword');

    Route::resource('roles', 'RolesController');

    Route::get('/cargos/{id}', 'DepartamentoController@getCargos')->name('cargos');
    
    
    //Route::get('turistas/export/', [ExportableController::class, 'export']);
    Route::get('turistas/export/',  'ExportableController@export')->name('export');
});

Route::resource('departamentos', 'DepartamentoController');
Route::post('departamentos', 'DepartamentoController@index')->name('departamentos.index');
Route::get('departamentos', 'DepartamentoController@index')->name('departamentos.index');

Route::get('puntos', 'PuntosController@index')->name('puntos');
Route::post('puntos', 'PuntosController@index')->name('puntos');

Route::get('maestros', 'MaestrosController@index')->name('maestros');
Route::post('maestros', 'MaestrosController@index')->name('maestros');

Route::post('contact', 'MessageController@store')->name('messages.store');


Route::get('reportes2', 'ReporteController@portal')->name('reportes2');
Route::get('exportable', 'ExportableController@exportable')->name('exportable');


/* Route::get('/', function () {
    return view('home');
})->name('home');
 */


Route::get('login', 'Auth\LoginController@showLoginForm')->name('login');
Route::post('login', 'Auth\LoginController@login');
Route::post('logout', 'Auth\LoginController@logout')->name('logout');

/* Route::get('register', 'Auth\RegisterController@showRegistrationForm')->name('register');
Route::post('register', 'Auth\RegisterController@register'); */

Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('password.update');
