@extends('template')

@section('title', 'Video')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('home')}}">Inicio</a></li>
    <li class="breadcrumb-item"><a href="{{route('video.index')}}">Videos</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{$videos[0]->title}}</li>
@endsection

@section('content')

    <section class="videoShow">
        
        @foreach ($videos as $video)

            <h1 class="my-5">{{ $video->title }}</h1>
            <div class="embed-responsive embed-responsive-16by9">
                <iframe class="embed-responsive-item" src="{{str_replace('https://www.youtube.com/watch?v=','https://www.youtube.com/embed/',str_replace('https://youtu.be/','https://www.youtube.com/embed/',$video->video))}}" frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>>
                </iframe>
            </div>
                    
                        <div class="cuerpo">{!!  str_replace('src="/', 'src="http://fontur.net/',$video->body) !!}</div>

                        {{-- <iframe width="853" height="480" src="https://www.youtube.com/embed/JnbgW2OZlmg" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> --}}
                        
                
        @endforeach
                   
    </section>
                                         

@endsection

