<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title','Intranet')</title>
    <link rel="stylesheet" href="{{ mix('css/app.css') }}">
    <link rel="stylesheet" href="{{ mix('css/cheeseburger_menu.css') }}">
    <link rel="icon" type="image/png" href="/img/favicon.png">
    @stack('styles')
    <script src="{{ mix('js/app.js') }}" defer></script>
    <script src="{{ mix('js/cheeseburger_menu.js') }}" defer></script>


</head>

<body class="{{ request()->is('/') ? 'bg-image-login' : '' }} 
    {{ request()->is('password/reset*') ? 'bg-image-login' : '' }} bg-white">
    @auth
        <div class="loader"></div>
    @endauth
    <div id="app" class="d-flex flex-column h-screen justify-content-between">
        <header>

            @include('partials/nav')

        </header>
        <main class="py-3">
            @auth

                <section class="welcome">
                    <img src="/img/bienvenido.png" alt="Bienvenido">
                    <h3 class="pt-2">{{ Auth::user()->name }}</h3>
                </section>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        @yield('breadcrumb')
                    </ol>
                </nav>
                @include('partials.flash-messages')
            @endauth
            <div class="container" style="max-width: 100%">
                @yield('content')
            </div>
        </main>


        <footer class="" style="">
            @auth

                <div class="row  " style="margin-top:20px;background-color:#D9D9D9 !important;color:#0C254E !important;">
                    <div class="col-sm-4" style="">
                        <div class="" style="">
                            <div style="margin: auto;width: 50%;">
                                <p>Carrera 7 No. 26-20 piso 7 y 9,
                                    Edificio<br>Tequendama.<br><strong>Teléfono:</strong> (571)
                                    6166044<br><strong>Email:</strong><u>contactenos@fontur.com.co</u><br><strong>Nit:</strong>
                                    900649119-9</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4" style="">
                        <div class="" style="">
                            <div style="margin: auto;width: 50%;">
                                <p><strong>Dirección de correspondencia de FONTUR :</strong><br>Calle 28 #13ª-24
                                    piso 6 Edificio Museo del Parque<br><strong>Teléfono:</strong> (57–1) 3275500
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4" style="">
                        <div class="" style="">
                            <div style="margin: auto;width: 50%;">
                                <p><strong>Horario de atención: </strong>de lunes a viernes<br>de 8 AM a 5:00 PM -
                                    Bogotá, Colombia.<br><a
                                        data-cke-saved-href="/sites/default/files/politica-proteccion-datos-personales.pdf"
                                        href="/sites/default/files/politica-proteccion-datos-personales.pdf"
                                        target="_blank" style="color:#0C254E;">Política Protección de Datos Personales</a><br><a
                                        data-cke-saved-href="/sites/default/files/aviso-privacidad.pdf"
                                        href="/sites/default/files/aviso-privacidad.pdf" target="_blank" style="color:#0C254E;">Aviso de
                                        privacidad</a></p>
                            </div>
                        </div>
                    </div>
                </div>

            @endauth
            <div class="footer-login bg-white text-black-50 text-center shadow" style="color:#0C254E;">
                &copy; {{ date('Y') }}, FONDO NACIONAL DE TURISMO - FONTUR - PITS. República de Colombia Bogotá D.C. <br>
                Diseñado y Desarrollado por <a href="https://ciscsas.com/" target="_blank">CISC SAS</a>
                {{ date('Y') }}
            </div>
        </footer>
    </div>

    <script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
    <script type="text/javascript">
        $(window).load(function() {
            $(".loader").fadeOut("slow");
        });

    </script>
    @stack('scripts')
</body>

</html>
