@extends('template')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
    <li class="breadcrumb-item active" aria-current="page">Registro de turistas</li>
@endsection

@section('content')

	<style>
	.select2-container--open {
		z-index: 9999999;
	}
	
	.select2-selection__rendered {
		line-height: 31px !important;
	}
	.select2-container .select2-selection--single {
		height: 35px !important;
	}
	.select2-selection__arrow {
		height: 34px !important;
	}	
	</style>


    <style>
	.tituloMorado h2::before {
		background: #D73D31;
	}	
	</style>
	
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
	<script src='https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.1.4/Chart.bundle.min.js'></script>
	<script src='https://cdn.plot.ly/plotly-2.4.2.min.js'></script>
	
    <div class="tituloMorado"  style="color:#D73D31;width: 100%">
        <h2 >REPORTES DE TURISTAS</h2>
    </div>
    @include('partials.validation-errors')
    
	<form name="formularioTurista" method="GET" action="" autocomplete="off" >
    @csrf

	<div class="row" style="margin-top:5px;">
         <div class="col-md-2" style="font-family:FuturaBook;"></div> 
    	 <div class="col-md-4"  style="font-family:FuturaBook;">
    	  Tipo reporte<br>
    	  <select name="valorTipoReporte" id="valorTipoReporte" class="form-control"   >
    	    <option value="">Seleccionar</option>
    	    <option value="1"  <?php if(trim($post['valorTipoReporte'])=="1"){?> selected <?php } ?> >Grafico Motivo viaje</option>
    	    <option value="2"  <?php if(trim($post['valorTipoReporte'])=="2"){?> selected <?php } ?> >Grafico Tipo transporte</option>
    	    <option value="3"  <?php if(trim($post['valorTipoReporte'])=="3"){?> selected <?php } ?> >Grafico Tipo alojamiento</option>
    	    <option value="4"  <?php if(trim($post['valorTipoReporte'])=="4"){?> selected <?php } ?> >Grafico Duracion estancia</option>
    	    <option value="11"  <?php if(trim($post['valorTipoReporte'])=="11"){?> selected <?php } ?> >Grafico por Sexo</option>
    	    <option value="5"  <?php if(trim($post['valorTipoReporte'])=="5"){?> selected <?php } ?> >Grafico Edad</option>
    	    <option value="6"  <?php if(trim($post['valorTipoReporte'])=="6"){?> selected <?php } ?> >Grafico Fidelidad</option>
    	    <option value="7"  <?php if(trim($post['valorTipoReporte'])=="7"){?> selected <?php } ?> >Grafico Motivo consulta</option>
    	    <option value="8"  <?php if(trim($post['valorTipoReporte'])=="8"){?> selected <?php } ?> >Grafico periodo actual</option>
    	    <option value="9"  <?php if(trim($post['valorTipoReporte'])=="9"){?> selected <?php } ?> >Grafico flujo de turistas</option>
    	    <option value="10"  <?php if(trim($post['valorTipoReporte'])=="10"){?> selected <?php } ?> >Grafico por PITS</option>
    	  </select>
    	 </div>
    </div>

	<div class="row" style="margin-top:5px;">
       <div class="col-md-2" style="font-family:FuturaBook;"></div> 
       <div class="col-md-4"  style="font-family:FuturaBook;">
         * Desde (yyyy/MM/dd)<br>
         <input type="text" id="fechaFiltroDesde" name="fechaFiltroDesde" class="form-control" maxlength="10"  value="<?=$fechaFiltroDesde?>"  placeholder="yyyy/MM/dd" required>
       </div>
       <div class="col-md-4"  style="font-family:FuturaBook;">
         * Hasta (yyyy/MM/dd)<br>
         <input type="text" id="fechaFiltroHasta" name="fechaFiltroHasta" class="form-control" maxlength="10"  value="<?=$fechaFiltroHasta?>"  placeholder="yyyy/MM/dd" required>
       </div>
       <div class="col-md-2" style="font-family:FuturaBook;"></div> 
    </div>


	<div class="row" style="margin-top:5px;">
       <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Nacionalidad<br>
	   <select name="valorNacionalidad" id="valorNacionalidad" class="form-control filtroBusqueda" style="height:30px !important;" onchange="configurarNacionalidad()"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoPaises as $row)
		 {
		  $seleccionadoRegistro="";
		  if(trim($post['valorNacionalidad'])==$row->CODIGO)
		   {
			$seleccionadoRegistro=" selected ";	  
		   }			  
		  ?>
		  <option value="<?=$row->CODIGO?>"  <?=$seleccionadoRegistro?>   ><?=$row->DESCRIPCION?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>

	 <div class="col-md-4"  style="font-family:FuturaBook;" id="zonaCiudad">
	   Ciudad<br>
	   <select name="valorCiudad" id="valorCiudad" class="form-control filtroBusqueda" style="height:30px !important;"  >
	    <option value="0">Seleccionar</option>
		@foreach ($listadoCiudadesPais as $ciudadPit)
		  <option value="{{ $ciudadPit->CODIGO_CIUDAD }}" <?php if(trim($post['valorCiudad'])==$ciudadPit->CODIGO_CIUDAD){?> selected <?php } ?> >{{ $ciudadPit->DESCRIPCION_CIUDAD }} | {{ $ciudadPit->DESCRIPCION_DEPTO }}</option> 
		@endforeach
	   </select>
	 </div>
       <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	</div> 

	<div class="row" style="margin-top:5px;">
       <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Motivo Viaje<br>
	   <select name="valorMotivoViaje" id="valorMotivoViaje"  class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoMotivoViaje as $row)
		 {
		  ?>
		  <option value="<?=$row->IdMotivoViaje ?>"    <?php if(trim($post['valorMotivoViaje'])==$row->IdMotivoViaje){?> selected <?php } ?>  ><?=$row->DetalleMotivoViaje?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	  <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	</div>

	<div class="row" style="margin-top:5px;">
	  <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Tipo Transporte<br>
	   <select name="valorTipoTransporte" id="valorTipoTransporte" class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoTipoTransporte as $row)
		 {
		  ?>
		  <option value="<?=$row->IdTipoTransporte?>"  <?php if(trim($post['valorTipoTransporte'])==$row->IdTipoTransporte){?> selected <?php } ?> ><?=$row->DetalleTipoTransporte?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Tipo Alojamiento<br>
	   <select name="valorTipoAlojamiento" id="valorTipoAlojamiento" class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoTipoAlojamiento as $row)
		 {
		  ?>
		  <option value="<?=$row->IdTipoAlojamiento?>" <?php if(trim($post['valorTipoAlojamiento'])==$row->IdTipoAlojamiento){?> selected <?php } ?> ><?=$row->DetalleTipoAlojamiento?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	  <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	</div>

	<div class="row" style="margin-top:5px;">
	  <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Duracion Estancia<br>
	   <select name="valorDuracionEstancia" id="valorDuracionEstancia" class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoDuracionEstancia as $row)
		 {
		  ?>
		  <option value="<?=$row->IdDuracionEstancia?>" <?php if(trim($post['valorDuracionEstancia'])==$row->IdDuracionEstancia){?> selected <?php } ?> ><?=$row->DetalleDuracionEstancia?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Sexo<br>
	   <select name="valorSexo" id="valorSexo"  class="form-control"  >
	    <option value="">Seleccionar</option>
	    <option value="1"  <?php if(trim($post['valorSexo'])=="1"){?> selected <?php } ?> >Masculino</option>
	    <option value="2"  <?php if(trim($post['valorSexo'])=="2"){?> selected <?php } ?>>Femenino</option>
	   </select>
	 </div>
	  <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	</div>

	<div class="row" style="margin-top:5px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Edad<br>
	   <select name="valorEdad" id="valorEdad" class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoEdad as $row)
		 {
		  ?>
		  <option value="<?=$row->IdEdad?>"  <?php if(trim($post['valorEdad'])==$row->IdEdad){?> selected <?php } ?> ><?=$row->DetalleEdad?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Fidelidad<br>
	   <select name="valorFidelidad"   id="valorFidelidad"  class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoFidelidad as $row)
		 {
		  ?>
		  <option value="<?=$row->IdFidelidad?>"  <?php if(trim($post['valorFidelidad'])==$row->IdFidelidad){?> selected <?php } ?> ><?=$row->DetalleFidelidad?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>

	  <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	</div>
	 
	<div class="row" style="margin-top:5px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   Motivo Consulta<br>
	   <select name="valorMotivoConsulta" id="valorMotivoConsulta" class="form-control"  >
	    <option value="">Seleccionar</option>
		<?php
		foreach ($listadoMotivoConsulta as $row)
		 {
		  ?>
		  <option value="<?=$row->IdMotivoConsulta?>"  <?php if(trim($post['valorMotivoConsulta'])==$row->IdMotivoConsulta){?> selected <?php } ?> ><?=$row->DetalleMotivoConsulta?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	 <div class="col-md-4"  style="font-family:FuturaBook;" title="Para seleccionar varios: CTRL + clic">
	   *PITS visitado<br>
	   <select name="valorPitsCiudad[]" id="valorPitsCiudad" class="form-control" multiple size="6"  required>
	    
	    <?php
		  $opcionControlPITSSeleccionada="";
		  if($post["valorPitsCiudad"]!="")
		   {
    		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
    		  for ($i=0;$i<count($valorPitsCiudad);$i++) 
    		   {
    		      if( "0" == trim($valorPitsCiudad[$i]) )
    		       {
    		         $opcionControlPITSSeleccionada=" selected ";   
    		       }
    		   }
		   }
	    ?>
	    
	    @if ( auth()->user()->hasRole('admin') )
	      <option value="0"  <?=$opcionControlPITSSeleccionada?>  >Todos los PITS</option>
	    @endif
	    
		@foreach ($pits as $pit)
		  <?php
		  $opcionControlPITSSeleccionada="";
		  if($post["valorPitsCiudad"]!="")
		   {
    		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
    		  for ($i=0;$i<count($valorPitsCiudad);$i++) 
    		   {
    		      if( trim($pit->nid) == trim($valorPitsCiudad[$i]) )
    		       {
    		         $opcionControlPITSSeleccionada=" selected ";   
    		       }
    		   }
		   }
		  ?>
		  <option value="{{ $pit->nid }}" <?=$opcionControlPITSSeleccionada?>  >{{ $pit->title }} ({{ $pit->nid }})</option>
		@endforeach
	   </select>
	 </div>
	 <div class="col-md-2" style="font-family:FuturaBook;"></div> 
	</div>


	<div class="row" style="margin-top:10px;">
	 <div class="col-md-12" style="text-align:center;">
	   <button type="submit" class="btn btn-success" style="background-color:#D73D31;color:#FFFFFF; ">Consultar</button>
	 </div>
	</div>
	</form>

    <?php
    if(trim($fechaFiltroDesde)!="")
     {
        ?>
    	<div class="row justify-content-center">
            <div class="col-md-12 py-3 rounded-lg"  >
                <br>
    
                <script>
                var coleccionData=[];
                var coleccionDataLabels=[];
                var totalItems=0;
                </script>   
                
                <?php
                //graficos
                if(trim($post['valorTipoReporte'])!="")
                 {
                   $tituloGrafico="";
                   if(trim($post['valorTipoReporte'])=="1")
                     {
                       echo("<script>var parametroTitulo='MOTIVO VIAJE';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="2")
                     {
                       echo("<script>var parametroTitulo='TIPO TRANSPORTE';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="3")
                     {
                       echo("<script>var parametroTitulo='TIPO ALOJAMIENTO';</script>");
                       echo("<script>var parametroAlturaReporte=700;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="4")
                     {
                       echo("<script>var parametroTitulo='DURACION ESTANCIA';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="5")
                     {
                       echo("<script>var parametroTitulo='EDAD';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="6")
                     {
                       echo("<script>var parametroTitulo='FIDELIDAD';</script>");
                       echo("<script>var parametroAlturaReporte=320;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="7")
                     {
                       echo("<script>var parametroTitulo='MOTIVO CONSULTA';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="8")
                     {
                       echo("<script>var parametroTitulo='PERIODO ACTUAL ".date("Y")."';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }            
                   if(trim($post['valorTipoReporte'])=="9")
                     {
                       echo("<script>var parametroTitulo='FLUJO DE TURISTAS ".date("Y")."';</script>");
                       echo("<script>var parametroAlturaReporte=500;</script>");
                     }  
                   if(trim($post['valorTipoReporte'])=="10")
                     {
                       echo("<script>var parametroTitulo='POR PITS';</script>");
                       
                       if(count($post['valorPitsCiudad']) > "0")
                        {
                          $valorPitsCiudad=$post["valorPitsCiudad"]; 
                          $opcionTodoSeleccionada="0";
                          if(count($valorPitsCiudad)>0)
                           {
                                //validar si tiene la opcion "todo" seleccionado
                                for ($i=0;$i<count($valorPitsCiudad);$i++) 
                                 {
                                   if( trim($valorPitsCiudad[$i])=="0" )
                                    {
                                       $opcionTodoSeleccionada="1";
                                    }
                                 }
                           }
                           
                          if( $opcionTodoSeleccionada == "0")
                           {
                              echo("<script>var parametroAlturaReporte=400;</script>");
                           }
                          else
                           {
                              echo("<script>var parametroAlturaReporte=2000;</script>");
                           }
                        }
                       else
                        {
                           echo("<script>var parametroAlturaReporte=2000;</script>");
                        }
                     }            
                   if(trim($post['valorTipoReporte'])=="11")
                     {
                       echo("<script>var parametroTitulo='SEXO';</script>");
                       echo("<script>var parametroAlturaReporte=320;</script>");
                     }            
                   ?>
                   
                   <center>
                   <!--
                   <div style="width:800px;height:300px; ">
                      <canvas id="chart-line"   class="chartjs-render-monitor" style="display: block; "></canvas>
                   </div>
                   -->
                   <div id='myDiv' ></div>
                    
                   </center>
                   
                   <?php
                   $labelsEach = explode("|", $coleccionLabels);
                   $dataEach = explode("|", $coleccionDatos);
                   
                   //labels 
                   for($i=0;$i<count($labelsEach);$i++)
                    {
                       if(trim($labelsEach[$i])!="")
                        {
                          echo("<script>coleccionDataLabels[".($i-1)."]='".trim($labelsEach[$i])."';</script>"); 
                          echo("<script>totalItems++;</script>");
                        }
                    }
                   
                   //data
                   for($i=0;$i<count($dataEach);$i++)
                    {
                       if(trim($dataEach[$i])!="")
                        {
                          echo("<script>coleccionData[".($i-1)."]=parseInt(".trim($dataEach[$i]).");</script>");  
                        }
                    }
                 }
                ?>    
                <br><br> 
                
                <div class="table-responsive">
                <table class="table table-bordered table-striped"  >
                    <thead>
                        <tr style="background-color:#D73D31 !important;color:white;">
                            <th>NOMBRE CONSULTANTE</th>
                            <th>EMAIL</th>
                            <th>PAIS</th>
                            <th>CIUDAD</th>
                            <th>MOTIVO VIAJE</th>
                            <th>NRO.TURISTAS</th>
                            <th>TIPO TRANSPORTE</th>
                            <th>TIPO ALOJAMIENTO</th>
                            <th>DURACION ESTANCIA</th>
                            <th>SEXO</th>
                            <th>EDAD</th>
                            <th>FIDELIDAD</th>
                            <th>MOTIVO CONSULTA</th>
                            <th>PITS</th>
                            <th>FECHA REGISTRO</th>
                            <th>USUARIO REGISTRO</th>
                        </tr>
                    </thead>
                    <tbody>
                          <?php
    					  foreach ($listadoTuristas as $row)
    					   {
    					       
    					    if($row->IdSexo=="1")
    					     {
    					       $sexo="Masculino";  
    					     }
    					    else
    					     {
    					       $sexo="Femenino";  
    					     }
    						?>
                            <tr>
    							<td style="text-align:left;"><?=$row->NombreConsultante?></td>
                                <td style="text-align:left;"><?=$row->Correo?></td>
                                <td style="text-align:left;"><?=$row->DESCRIPCIONPAIS?></td>
                                <td style="text-align:left;"><?=$row->DESCRIPCIONCIUDAD?></td>
                                <td style="text-align:left;"><?=$row->DetalleMotivoViaje?></td>
                                <td style="text-align:left;"><?=$row->NumeroTuristas?></td>
                                <td style="text-align:left;"><?=$row->DetalleTipoTransporte?></td>
                                <td style="text-align:left;"><?=$row->DetalleTipoAlojamiento?></td>
                                <td style="text-align:left;"><?=$row->DetalleDuracionEstancia?></td>
                                <td style="text-align:left;"><?=$sexo?></td>
                                <td style="text-align:left;"><?=$row->DetalleEdad?></td>
                                <td style="text-align:left;"><?=$row->DetalleFidelidad?></td>
                                <td style="text-align:left;"><?=$row->DetalleMotivoConsulta?></td>
                                <td style="text-align:left;"><?=$row->PitsDetalle?></td>
                                <td style="text-align:left;"><?=$row->FechaRegistro?></td>
                                <td style="text-align:left;"><?=$row->NombreUsuarioRegistro?></td>
                            </tr>
    						<?php							
    					   }
    					  ?>
    						
                    </tbody>
    
                </table>
                </div>
    
                                            <br><br>
											<center>
											
											<!-- inicio interfaz paginador -->
											<?php
											$topeRegistros=$_SESSION["topePaginacion"];
											if($_SESSION["totalRegistros"] >  $topeRegistros)
											 {
												$total_registros =$_SESSION["totalRegistros"]; 
												$total_paginas = ceil($total_registros / $topeRegistros);
												
												?>
												<div class='col-md-12'>
												 <center>
												 <table>
												  <tr>
												   
												   <!--primera pagina-->		
												   <form name="formularioPInicio"  action="" method="GET">
													  <input type="hidden" name="paginaActual" value="0">
													  <input type="hidden" name="paginaActualId" value="1">
                                                      <input type="hidden" id="fechaFiltroDesde" name="fechaFiltroDesde"   value="<?=$fechaFiltroDesde?>">
                                                      <input type="hidden" id="fechaFiltroHasta" name="fechaFiltroHasta"   value="<?=$fechaFiltroHasta?>">
                                                      <input type="hidden" name="valorTipoReporte" value="<?=trim($post['valorTipoReporte'])?>">
                                                      <input type="hidden" name="valorNacionalidad" value="<?=trim($post['valorNacionalidad'])?>">
                                                      <input type="hidden" name="valorCiudad" value="<?=trim($post['valorCiudad'])?>">
                                                      <input type="hidden" name="valorMotivoViaje" value="<?=trim($post['valorMotivoViaje'])?>">
                                                      <input type="hidden" name="valorTipoTransporte" value="<?=trim($post['valorTipoTransporte'])?>">
                                                      <input type="hidden" name="valorTipoAlojamiento" value="<?=trim($post['valorTipoAlojamiento'])?>">
                                                      <input type="hidden" name="valorDuracionEstancia" value="<?=trim($post['valorDuracionEstancia'])?>">
                                                      <input type="hidden" name="valorSexo" value="<?=trim($post['valorSexo'])?>">
                                                      <input type="hidden" name="valorEdad" value="<?=trim($post['valorEdad'])?>">
                                                      <input type="hidden" name="valorFidelidad" value="<?=trim($post['valorFidelidad'])?>">
                                                      <input type="hidden" name="valorMotivoConsulta" value="<?=trim($post['valorMotivoConsulta'])?>">
                                                      
                                                      <!---->
                                                	  <select name="valorPitsCiudad[]" id="valorPitsCiudad" class="form-control" multiple   style='display:none'>
                                                	    
                                                	    <?php
                                                		  $opcionControlPITSSeleccionada="";
                                                		  if($post["valorPitsCiudad"]!="")
                                                		   {
                                                    		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
                                                    		  for ($ii=0;$ii<count($valorPitsCiudad);$ii++) 
                                                    		   {
                                                    		      if( "0" == trim($valorPitsCiudad[$ii]) )
                                                    		       {
                                                    		         $opcionControlPITSSeleccionada=" selected ";   
                                                    		       }
                                                    		   }
                                                		   }
                                                	    ?>
                                                	    
                                                	    @if ( auth()->user()->hasRole('admin') )
                                                	      <option value="0"  <?=$opcionControlPITSSeleccionada?>  >Todos los PITS</option>
                                                	    @endif
                                                	    
                                                		@foreach ($pits as $pit)
                                                		  <?php
                                                		  $opcionControlPITSSeleccionada="";
                                                		  if($post["valorPitsCiudad"]!="")
                                                		   {
                                                    		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
                                                    		  for ($ii=0;$ii<count($valorPitsCiudad);$ii++) 
                                                    		   {
                                                    		      if( trim($pit->nid) == trim($valorPitsCiudad[$ii]) )
                                                    		       {
                                                    		         $opcionControlPITSSeleccionada=" selected ";   
                                                    		       }
                                                    		   }
                                                		   }
                                                		  ?>
                                                		  <option value="{{ $pit->nid }}" <?=$opcionControlPITSSeleccionada?>  >{{ $pit->title }} ({{ $pit->nid }})</option>
                                                		@endforeach
                                                	  </select>
                                                      <!---->
                                                      
													  <td>
													   <input type="submit" value="|<" style="font-size:10px;" class="btn btn-default">
													  </td>
												   </form>
												   
												   <?php
												   $contadorColumnas=1;
												   $presentadasPaginas=1;
												   for ($i=1; $i<=$total_paginas; $i++)
													{
													  
													  if( $i >= $paginaActualId  - 1 )
													   {
														  $presentadasPaginas++; 
														  $nombreFormularioDinamico="paginado".$i;
														  $estiloBoton="btn btn-default";
														  $inicio = ($i - 1) * $topeRegistros;
														  
														  if($i == $paginaActualId)
														   {
															 $estiloBoton="btn btn-primary"; 
														   }
														  
														  ?>
														  <form name="<?=$nombreFormularioDinamico?>"  action="" method="GET">
														  <input type="hidden" name="paginaActual" value="<?=($inicio)?>">
														  <input type="hidden" name="paginaActualId" value="<?=$i?>">
                                                          <input type="hidden" id="fechaFiltroDesde" name="fechaFiltroDesde"   value="<?=$fechaFiltroDesde?>">
                                                          <input type="hidden" id="fechaFiltroHasta" name="fechaFiltroHasta"   value="<?=$fechaFiltroHasta?>">
                                                          <input type="hidden" name="valorTipoReporte" value="<?=trim($post['valorTipoReporte'])?>">
                                                          <input type="hidden" name="valorNacionalidad" value="<?=trim($post['valorNacionalidad'])?>">
                                                          <input type="hidden" name="valorCiudad" value="<?=trim($post['valorCiudad'])?>">
                                                          <input type="hidden" name="valorMotivoViaje" value="<?=trim($post['valorMotivoViaje'])?>">
                                                          <input type="hidden" name="valorTipoTransporte" value="<?=trim($post['valorTipoTransporte'])?>">
                                                          <input type="hidden" name="valorTipoAlojamiento" value="<?=trim($post['valorTipoAlojamiento'])?>">
                                                          <input type="hidden" name="valorDuracionEstancia" value="<?=trim($post['valorDuracionEstancia'])?>">
                                                          <input type="hidden" name="valorSexo" value="<?=trim($post['valorSexo'])?>">
                                                          <input type="hidden" name="valorEdad" value="<?=trim($post['valorEdad'])?>">
                                                          <input type="hidden" name="valorFidelidad" value="<?=trim($post['valorFidelidad'])?>">
                                                          <input type="hidden" name="valorMotivoConsulta" value="<?=trim($post['valorMotivoConsulta'])?>">
                                                          
                                                          <!---->
                                                    	  <select name="valorPitsCiudad[]" id="valorPitsCiudad" class="form-control" multiple   style='display:none'>
                                                    	    
                                                    	    <?php
                                                    		  $opcionControlPITSSeleccionada="";
                                                    		  if($post["valorPitsCiudad"]!="")
                                                    		   {
                                                        		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
                                                        		  for ($ii=0;$ii<count($valorPitsCiudad);$ii++) 
                                                        		   {
                                                        		      if( "0" == trim($valorPitsCiudad[$ii]) )
                                                        		       {
                                                        		         $opcionControlPITSSeleccionada=" selected ";   
                                                        		       }
                                                        		   }
                                                    		   }
                                                    	    ?>
                                                    	    
                                                    	    @if ( auth()->user()->hasRole('admin') )
                                                    	      <option value="0"  <?=$opcionControlPITSSeleccionada?>  >Todos los PITS</option>
                                                    	    @endif
                                                    	    
                                                    		@foreach ($pits as $pit)
                                                    		  <?php
                                                    		  $opcionControlPITSSeleccionada="";
                                                    		  if($post["valorPitsCiudad"]!="")
                                                    		   {
                                                        		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
                                                        		  for ($ii=0;$ii<count($valorPitsCiudad);$ii++) 
                                                        		   {
                                                        		      if( trim($pit->nid) == trim($valorPitsCiudad[$ii]) )
                                                        		       {
                                                        		         $opcionControlPITSSeleccionada=" selected ";   
                                                        		       }
                                                        		   }
                                                    		   }
                                                    		  ?>
                                                    		  <option value="{{ $pit->nid }}" <?=$opcionControlPITSSeleccionada?>  >{{ $pit->title }} ({{ $pit->nid }})</option>
                                                    		@endforeach
                                                    	  </select>
                                                          <!---->

														  <td>
														   <input type="submit" value="<?=$i?>" style="font-size:10px;" class="<?=$estiloBoton?>">
														  </td>
														  </form>
														  <?php

														  if($contadorColumnas <= 20)
														   {
															  $contadorColumnas++;
														   }
														  else
														   {
															 ?>
															 </tr>
															 <tr>
															 <?php
															 $contadorColumnas=1;  
														   }
													   }
													
													  
													  if($presentadasPaginas == 10)
													   {
														 break;  
													   }
													}

												   $inicio = ($total_paginas - 1) * $topeRegistros;	
												   ?>
												   
												    
												   <!--última pagina-->		
												   <form name="formularioPFinal"  action="" method="GET">
													  <input type="hidden" name="paginaActual" value="<?=($inicio)?>">
													  <input type="hidden" name="paginaActualId" value="<?=$total_paginas?>">
                                                      <input type="hidden" id="fechaFiltroDesde" name="fechaFiltroDesde"   value="<?=$fechaFiltroDesde?>">
                                                      <input type="hidden" id="fechaFiltroHasta" name="fechaFiltroHasta"   value="<?=$fechaFiltroHasta?>">
                                                      <input type="hidden" name="valorTipoReporte" value="<?=trim($post['valorTipoReporte'])?>">
                                                      <input type="hidden" name="valorNacionalidad" value="<?=trim($post['valorNacionalidad'])?>">
                                                      <input type="hidden" name="valorCiudad" value="<?=trim($post['valorCiudad'])?>">
                                                      <input type="hidden" name="valorMotivoViaje" value="<?=trim($post['valorMotivoViaje'])?>">
                                                      <input type="hidden" name="valorTipoTransporte" value="<?=trim($post['valorTipoTransporte'])?>">
                                                      <input type="hidden" name="valorTipoAlojamiento" value="<?=trim($post['valorTipoAlojamiento'])?>">
                                                      <input type="hidden" name="valorDuracionEstancia" value="<?=trim($post['valorDuracionEstancia'])?>">
                                                      <input type="hidden" name="valorSexo" value="<?=trim($post['valorSexo'])?>">
                                                      <input type="hidden" name="valorEdad" value="<?=trim($post['valorEdad'])?>">
                                                      <input type="hidden" name="valorFidelidad" value="<?=trim($post['valorFidelidad'])?>">
                                                      <input type="hidden" name="valorMotivoConsulta" value="<?=trim($post['valorMotivoConsulta'])?>">
                                                      <!---->
                                                	  <select name="valorPitsCiudad[]" id="valorPitsCiudad" class="form-control" multiple   style='display:none'>
                                                	    
                                                	    <?php
                                                		  $opcionControlPITSSeleccionada="";
                                                		  if($post["valorPitsCiudad"]!="")
                                                		   {
                                                    		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
                                                    		  for ($ii=0;$ii<count($valorPitsCiudad);$ii++) 
                                                    		   {
                                                    		      if( "0" == trim($valorPitsCiudad[$ii]) )
                                                    		       {
                                                    		         $opcionControlPITSSeleccionada=" selected ";   
                                                    		       }
                                                    		   }
                                                		   }
                                                	    ?>
                                                	    
                                                	    @if ( auth()->user()->hasRole('admin') )
                                                	      <option value="0"  <?=$opcionControlPITSSeleccionada?>  >Todos los PITS</option>
                                                	    @endif
                                                	    
                                                		@foreach ($pits as $pit)
                                                		  <?php
                                                		  $opcionControlPITSSeleccionada="";
                                                		  if($post["valorPitsCiudad"]!="")
                                                		   {
                                                    		  $valorPitsCiudad=$post["valorPitsCiudad"]; 
                                                    		  for ($ii=0;$ii<count($valorPitsCiudad);$ii++) 
                                                    		   {
                                                    		      if( trim($pit->nid) == trim($valorPitsCiudad[$ii]) )
                                                    		       {
                                                    		         $opcionControlPITSSeleccionada=" selected ";   
                                                    		       }
                                                    		   }
                                                		   }
                                                		  ?>
                                                		  <option value="{{ $pit->nid }}" <?=$opcionControlPITSSeleccionada?>  >{{ $pit->title }} ({{ $pit->nid }})</option>
                                                		@endforeach
                                                	  </select>
                                                      <!---->

													  <td>
													   <input type="submit" value=">|" style="font-size:10px;" class="btn btn-default">
													  </td>
												   </form>
												   
												   
												  </tr>
												 </table>
												 </center>
												</div>
												<?php
											 }
											?>
											<!-- fin interfaz paginador -->
											
											<br><br>
											Total registros encontrados: <?=$_SESSION["totalRegistros"]?>
											<br><br>
											
											<?php
											if($_SESSION["totalRegistros"] > 0)
											 {
											   ?>
											   <!--<span data-href="/exportable" id="export" class="btn btn-success" style="background-color:#D73D31;color:#FFFFFF;" onclick="procesoExportacion(event.target);">Exportar datos</span>-->
											   <span data-href="turistas/export/" id="exportExcel" class="btn btn-success" onclick="exportExcel();">Exportar Registros Excel</span>
                         {{-- <a href="turistas/export/" class="btn btn-success">Exportar Registros</a> --}}
											   <?php
											 }
											
											?>
											
											</center>
											<br>
                
            </div>
        </div>
        <?php
     }
    ?>
    



@endsection
@push('styles')
    @include('datatable.styles')
@endpush

@push('scripts')
    @include('datatable.scripts')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet"/>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.standalone.css" integrity="sha512-JJG2fwOA2I97jdNmPpqlxOo3U4CDn31G6h1mBOB7GbfuBEjRccJzPumgm7nfbZ8zOcCH8+HoLUrwcPrgzEiSAw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js" integrity="sha512-T/tUfKSV1bihCnd+MxKD0Hm1uBBroVYBOYSk1knyvQ9VyZJpc/ALb4P0r6ubwVPSGB2GvjeoMAJJImBG12TiaQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    
    <style>
    .datepicker datepicker-dropdown dropdown-menu datepicker-orient-left datepicker-orient-top
    {
    background-color:red !important;    
    }
    </style>

    <?php
    if(trim($post['valorTipoReporte'])!="")
     {
        ?>
        <script>
        
        var trace1 = {
          x: coleccionData,
          y: coleccionDataLabels,
          xaxis: 'x1',
          yaxis: 'y1',
          type: 'bar',
          marker: {
            color: 'rgba(108,153,196,0.56)',
            line: {
              color: 'rgba(108,153,196,0.56)',
              width: 1
            }
          },
          orientation: 'h'
        };
        
        var data = [trace1 ];
        var alturaReporte=parametroAlturaReporte;
        
        var layout = {
          title: parametroTitulo,
          xaxis2: {
            range: [25000, 150000],
            domain: [0.5, 1],
            zeroline: false,
            showline: false,
            showticklabels: true,
            showgrid: true,
            side: 'top',
            dtick: 25000
          },
          legend: {
            x: 0.029,
            y: 1.238,
            font: {
              size: 10
            }
          },
          margin: {
            l: 400,
            r: 20,
            t: 200,
            b: 70
          },
          width: 700,
          height: alturaReporte,
          annotations: [
            
          ]
        };
        
        for ( var i = 0 ; i < coleccionData.length ; i++ ) {
          var result = {
            xref: 'x1',
            yref: 'y1',
            x: coleccionData[i]+2.3,
            y: coleccionDataLabels[i],
            text: '                '+coleccionData[i],
            font: {
              family: 'Arial',
              size: 10,
              color: 'rgb(50, 171, 96)'
            },
             showarrow: false,
          };
          
          layout.annotations.push(result);
        }
        
        Plotly.newPlot('myDiv', data, layout);
        
        
        /*
        $(document).ready(function() {
            var ctx = $("#chart-line");
            var myLineChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: coleccionDataLabels,
                    datasets: [{
    					label: 'Datos',
                        data: coleccionData,
                        backgroundColor: ["rgb(173,216,230)", "rgb(95,158,160)","rgb(95,100,140)","rgb(228,188,212)","rgb(244,217,236)","rgb(236,223,219)","rgb(198,225,241)","rgb(181,197,215)","rgb(198,167,176)","rgb(233,224,228)","rgb(221,229,227)","rgb(229,206,108)","rgb(202,155,53)","rgb(228,188,212)","rgb(156,202,204)","rgb(184,221,223)","rgb(242,225,175)","rgb(237,198,143)","rgb(181,213,123)"  ]
                    }]
                },
                options: {
                    title: {
                        display: true,
                        text: 'GRAFICO'
                    }
                }
            });
        });
        */
        </script>
        <?php
     }
    ?>
    
    <script>
    $("#fechaFiltroDesde").datepicker({ format: 'yyyy/mm/dd', autoclose: true, todayHighlight: true });
    $("#fechaFiltroHasta").datepicker({ format: 'yyyy/mm/dd', autoclose: true, todayHighlight: true });
    </script>

   <script>
   /*
   procesoExportacion
   */
   function procesoExportacion(_this)
   {
       /*
       let _url = $(_this).data('href');
       window.location.href = _url;
       */
        var fechaFiltroDesdeVal=$("#fechaFiltroDesde").val();      
        var fechaFiltroHastaVal=$("#fechaFiltroHasta").val();      
        var valorPitsCiudad=$("#valorPitsCiudad").val();
        var valorNacionalidad=$("#valorNacionalidad").val();      
        var valorCiudad=$("#valorCiudad").val();      
        var valorMotivoViaje=$("#valorMotivoViaje").val();      
        var valorTipoTransporte=$("#valorTipoTransporte").val();      
        var valorTipoAlojamiento=$("#valorTipoAlojamiento").val();      
        var valorDuracionEstancia=$("#valorDuracionEstancia").val();      
        var valorSexo=$("#valorSexo").val();      
        var valorEdad=$("#valorEdad").val();      
        var valorFidelidad=$("#valorFidelidad").val();      
        var valorMotivoConsulta=$("#valorMotivoConsulta").val();      

        $("#export").text("Generando resultados. Por favor espere un momento...");	 
        $.ajax({
        url         : '/exportable',
        type        : 'GET',
        data        :  {
                        valorPitsCiudad:valorPitsCiudad,
                        valorNacionalidad:valorNacionalidad,
                        valorCiudad:valorCiudad,
                        valorMotivoViaje:valorMotivoViaje,
                        valorTipoTransporte:valorTipoTransporte,
                        valorTipoAlojamiento:valorTipoAlojamiento,
                        valorDuracionEstancia:valorDuracionEstancia,
                        valorSexo:valorSexo,
                        valorEdad:valorEdad,
                        valorFidelidad:valorFidelidad,
                        valorMotivoConsulta:valorMotivoConsulta,
                        fechaFiltroDesde:fechaFiltroDesdeVal,
                        fechaFiltroHasta:fechaFiltroHastaVal
        },
        success: function(response)
         {
            /*
            Swal.fire(
    		'FONTUR PITS',
    		'Exportable generado',
    		'success'
    		);
		
            $("#export").text("Exportar datos"); 
            var blob=new Blob([response]);
            var link=document.createElement('a');
            link.href=window.URL.createObjectURL(blob);
            link.download="exportable.csv";
            link.click();
            */
            Swal.fire(
    		'FONTUR PITS',
    		'Exportable generado.',
    		'success'
    		);
		   
		   $("#export").text("Exportar datos");

            var blob=new Blob([response]);
            var link=document.createElement('a');
            link.href=window.URL.createObjectURL(blob);
            link.download="exportable.xls";
            link.click();
         }
        });
   }


   function exportExcel()
   {
		$(".loader").show();
        /*
        let _url = $(_this).data('href');
        window.location.href = _url;
        */
        var fechaFiltroDesdeVal=$("#fechaFiltroDesde").val();      
        var fechaFiltroHastaVal=$("#fechaFiltroHasta").val();      
        var valorPitsCiudad=$("#valorPitsCiudad").val();
        var valorNacionalidad=$("#valorNacionalidad").val();      
        var valorCiudad=$("#valorCiudad").val();      
        var valorMotivoViaje=$("#valorMotivoViaje").val();      
        var valorTipoTransporte=$("#valorTipoTransporte").val();      
        var valorTipoAlojamiento=$("#valorTipoAlojamiento").val();      
        var valorDuracionEstancia=$("#valorDuracionEstancia").val();      
        var valorSexo=$("#valorSexo").val();      
        var valorEdad=$("#valorEdad").val();      
        var valorFidelidad=$("#valorFidelidad").val();      
        var valorMotivoConsulta=$("#valorMotivoConsulta").val();
        $("#exportExcel").text("Generando resultados. Por favor espere un momento...");
        console.log("fechaFiltroDesdeVal = " +fechaFiltroDesdeVal);
        console.log("fechaFiltroHastaVal = " +fechaFiltroHastaVal);
        console.log("valorPitsCiudad = " +valorPitsCiudad);
        if(valorNacionalidad == ''){
          console.log("valorNacionalidad =  es blanco");
          
        }
        if(valorNacionalidad == null){
          console.log("valorNacionalidad =  es null");

        }
        console.log("valorNacionalidad = " +valorNacionalidad);
        console.log("valorCiudad = " +valorCiudad);
        console.log("valorMotivoViaje = " +valorMotivoViaje);
        console.log("valorTipoTransporte = " +valorTipoTransporte);
        console.log("valorTipoAlojamiento = " +valorTipoAlojamiento);
        console.log("valorDuracionEstancia = " +valorDuracionEstancia);
        console.log("valorSexo = " +valorSexo);
        console.log("valorEdad = " +valorEdad);
        console.log("valorFidelidad = " +valorFidelidad);
        console.log("valorMotivoConsulta = " +valorMotivoConsulta);
        $.ajax({
		xhrFields: {
        responseType: 'blob',
   		 },
        url         : 'turistas/export/',
        type        : 'GET',
        data        :  {
						            valorPitsCiudad:valorPitsCiudad,
                        valorNacionalidad:valorNacionalidad,
                        valorCiudad:valorCiudad,
                        valorMotivoViaje:valorMotivoViaje,
                        valorTipoTransporte:valorTipoTransporte,
                        valorTipoAlojamiento:valorTipoAlojamiento,
                        valorDuracionEstancia:valorDuracionEstancia,
                        valorSexo:valorSexo,
                        valorEdad:valorEdad,
                        valorFidelidad:valorFidelidad,
                        valorMotivoConsulta:valorMotivoConsulta,
                        fechaFiltroDesde:fechaFiltroDesdeVal,
                        fechaFiltroHasta:fechaFiltroHastaVal
        },
        success: function(response,status, xhr)
         {
			var disposition = xhr.getResponseHeader('content-disposition');
        var matches = /"([^"]*)"/.exec(disposition);
        var filename = (matches != null && matches[1] ? matches[1] : 'turistas.xlsx');
		var blob = new Blob([response], {
            type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        });
		var link = document.createElement('a');
        link.href = window.URL.createObjectURL(blob);
        link.download = filename;

        document.body.appendChild(link);

        link.click();
		$(".loader").fadeOut("slow");
        document.body.removeChild(link);
            Swal.fire(
    		'FONTUR PITS',
    		'Exportable generado.',
    		'success'
    		);
		   
		   $("#exportExcel").text("Exportar datos Excel");

            
         }
        });

   }

   </script>

	<script>
		//filtro listas
	    $('.filtroBusqueda').select2();
	
		/*
		configurarNacionalidad
		*/
	    function configurarNacionalidad()
		{
		  var valorNacionalidad=$( "select#valorNacionalidad" ).val();
		  if(valorNacionalidad=="10")
		   {
			 //colombia  
			 $("#zonaCiudad").css("visibility", "visible");
		   }
		  else
		   {
			 //extranjero
			 $("#zonaCiudad").css("visibility", "hidden");
		   }
		}
		
		configurarNacionalidad();
	
        var jqDataTable = $.noConflict(true);
        jqDataTable(function() {
            jqDataTable("#tabla").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "info": false,
                "ordering": false,
                "language": {
                    "searchPlaceholder": "Buscar",
                    "decimal": "",
                    "emptyTable": "No hay registros",
                    "info": "Mostrando del  _START_ al _END_ de _TOTAL_ registros",
                    "infoEmpty": "Showing 0 to 0 of 0 entries",
                    "infoFiltered": "(filtered from _MAX_ total entries)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "Show _MENU_ entries",
                    "loadingRecords": "Loading...",
                    "processing": "Processing...",
                    "search": "",
                    "zeroRecords": "No matching records found",
                    "paginate": {
                        "first": "<<",
                        "last": ">>",
                        "next": ">",
                        "previous": "<"
                    },
                    "aria": {
                        "sortAscending": ": activate to sort column ascending",
                        "sortDescending": ": activate to sort column descending"
                    },

                    "buttons": {
                        "copyTitle": 'Copiado al portapapeles',
                        "copySuccess": {
                            "_": '%d lineas copiadas',
                            "1": '1 lineas copiadas'
                        },
                    },
                },
                "buttons": [
                    /* {
                                            extend: 'copy',
                                            text: 'Copiar'
                                        },
                                        "csv", */
                    "excel",
                    /* "pdf", */
                    /*  {
                         extend: 'print',
                         text: 'Imprimir'

                     } */
                ]
            }).buttons().container().appendTo('#tabla_wrapper .col-md-5:eq(0)');

        });

    </script>
	
	<?php
	if(trim($procesoRegistroTurista)=="1" || trim($procesoEditarRegistroTurista)!="" )
	 {
	    ?>
		<script>
		Swal.fire(
		'FONTUR PITS',
		'Registro guardado',
		'success'
		);
		</script>
	    <?php	  
	 }
	?>

@endpush
