@extends('template')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
    <li class="breadcrumb-item active" aria-current="page">Registro de puntos</li>
@endsection

@section('content')

	<style>
	.select2-container--open {
		z-index: 9999999;
	}
	
	.select2-selection__rendered {
		line-height: 31px !important;
	}
	.select2-container .select2-selection--single {
		height: 35px !important;
	}
	.select2-selection__arrow {
		height: 34px !important;
	}	
	</style>


    <style>
	.tituloMorado h2::before {
		background: #D73D31;
	}	
	</style>
	
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
	
    <div class="tituloMorado"  style="color:#D73D31;width: 100%">
        <h2 >Informe Trimestral Red Nacional de PITs</h2>
    </div>
    @include('partials.validation-errors')
    
	<form name="formularioPuntos" method="POST" action="puntos" enctype="multipart/form-data">
	@csrf
	<?php
	if(trim($procesoEditarTurista)=="")
	 {
	   ?>
	   <input type="hidden" name="procesoRegistroTurista" value="1">
	   <?php	   
	 }
	else
	 {
	   ?>
	   <input type="hidden" name="procesoEditarRegistroTurista" value="<?=$procesoEditarTurista?>">
	   <?php	   
	 }
	?>

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-4" style="font-family:FuturaBook;">
	   *Seleccione el Nombre de su PIT<br>
	   <select name="valorPitsCiudad" id="valorPitsCiudad" class="form-control" required>
	    <option value="">Seleccionar</option>
		@foreach ($pits as $pit)
		  <option value="{{ $pit->nid }}" <?PHP if(trim($registro["IdPit"])==$pit->nid){?> selected <?php } ?> >{{ $pit->title }} ({{ $pit->nid }})</option>
		@endforeach
	   </select>
	 </div>
	 <div class="col-md-4"  style="font-family:FuturaBook;">
	   *Nombre completo<br>
	   <input type="text" name="valorNombreCompleto" class="form-control" value="<?=$registro["NombreCompleto"]?>" required>
	 </div>
	</div>
	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-2"  style="font-family:FuturaBook;">
	   *Cargo<br>
	   <input type="text" name="valorCargo" class="form-control" value="<?=$registro["Cargo"]?>" required>
	 </div>
	 <div class="col-md-3"  style="font-family:FuturaBook;">
	   *Celular de Quien Diligencia el Informe<br>
	   <input type="text" name="valorCelular" class="form-control" value="<?=$registro["Celular"]?>" required>
	 </div>
	 <div class="col-md-3" style="font-family:FuturaBook;">
	   *Correo de Quien Diligencia el Informe <br>
	   <input type="text" name="valorCorreo" class="form-control"  value="<?=$registro["Correo"]?>" required>
	 </div>
	</div> 
	
	 
	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-8"  style="font-family:FuturaBook;">
	   <b>*1. Número de registros del PIT en octubre, noviembre y diciembre de 2020</b><br>
	   <input type="number" name="valorNumeroRegistros" class="form-control"  value="<?=$registro["NroRegistros"]?>" required>
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>2. ¿Su PIT cuenta con convenio de Cooperación?</b><br>
	   <select name="valorConvenio" id="valorConvenio"   class="form-control"  onchange="configurarAdjuntoPregunta('valorConvenio','p2')"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["ConvenioCooperacion"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["ConvenioCooperacion"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p2"  style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"  name="file1" class="form-control">	 
	 </div>
	</div> 


	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>3. ¿El aliado cuenta con CDP (Certificado de disponibilidad presupuestal)? </b><br>
	   <select name="valorAliado" id="valorAliado"   class="form-control"  onchange="configurarAdjuntoPregunta('valorAliado','p3')"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["CuentaConCDP"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["CuentaConCDP"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p3"  style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file2" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>4. ¿El PIT cuenta con televisor? </b> <br>
	   <select name="valorTV" id="valorTV"   class="form-control"  onchange="configurarAdjuntoPregunta('valorTV','p4')"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["TieneTV"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["TieneTV"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2"  id="p4" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file3" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>5. ¿El PIT cuenta con internet? </b> <br>
	   <select name="valorInternet" id="valorInternet"   class="form-control"   onchange="configurarAdjuntoPregunta('valorInternet','p5')"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["TieneInternet"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["TieneInternet"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2"  id="p5" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file4" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>6. ¿El PIT cuenta con computador? </b> <br>
	   <select name="valorPC"  id="valorPC"   onchange="configurarAdjuntoPregunta('valorPC','p6')" class="form-control"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["TienePC"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["TienePC"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p6"  style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file5" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>7. ¿El PIT cuenta con energía? </b>  <br>
	   <select name="valorEnergia" id="valorEnergia"  class="form-control"  onchange="configurarAdjuntoPregunta('valorEnergia','p7')" required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["TieneEnergia"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["TieneEnergia"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p7"  style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file6" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>8. ¿El PIT cuenta con Informador?  </b>  <br>
	   <select name="valorInformador" id="valorInformador"   class="form-control" onchange="configurarAdjuntoPregunta('valorInformador','p8')"   required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["TieneInformador"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["TieneInformador"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p8" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"  name="file7" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-8"  style="font-family:FuturaBook;">
	   <b>9. Relacione el tiempo de contratación del informador (en meses)  </b>  <br>
	   <select name="valorMeses"  class="form-control"  required>
	    <option value="">Seleccionar</option>
		<?php
		for($m=1;$m<=12;$m++)
		 {
		  ?>
		  <option value="<?=$m?>" <?PHP if(trim($registro["TiempoMesesInformador"])==$m){?> selected <?php } ?> ><?=$m?></option>
		  <?php		  
		 }
		?>
	   </select>
	 </div>
	</div> 
	
	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>10. ¿El informador cuenta con formación académica en turismo?  </b> <br>
	   <select name="valorInformacionAcademica"  id="valorInformacionAcademica"   class="form-control"  onchange="configurarAdjuntoPregunta('valorInformacionAcademica','p10')"   required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["FormacionAcademicaTurismo"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["FormacionAcademicaTurismo"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p10"  style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"  name="file8" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>11. ¿El informador cuenta con formación en un segundo idioma?</b> <br>
	   <select name="valorSegundoIdioma" id="valorSegundoIdioma"  onchange="configurarAdjuntoPregunta('valorSegundoIdioma','p11')"   class="form-control"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["InformadorSegundoIdioma"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["InformadorSegundoIdioma"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2"  id="p11" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file9" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>12. Se ha realizado mantenimiento preventivo al PIT (Aseo ,pintura, etc.)</b>  <br>
	   <select name="valorMantenimiento" id="valorMantenimiento"  class="form-control"  onchange="configurarAdjuntoPregunta('valorMantenimiento','p12')"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["MantenimientoPIT"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["MantenimientoPIT"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p12" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"  name="file10" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>13. ¿El PIT cuenta con horario de operatividad visible? </b><br>
	   <select name="valorHorario"  id="valorHorario"    class="form-control" onchange="configurarAdjuntoPregunta('valorHorario','p13')"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["HorarioOperatividadVisible"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["HorarioOperatividadVisible"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2"  id="p13" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"  name="file11" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>14. ¿El PIT cuenta con material Promocional de la Región? (Brochures, mapas etc.) </b><br>
	   <select name="valorMaterial" id="valorMaterial"   onchange="configurarAdjuntoPregunta('valorMaterial','p14')"   class="form-control"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["MaterialPromocional"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["MaterialPromocional"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	 <div class="col-md-2" id="p14" style="font-family:FuturaBook;visibility:hidden;">
	   Evidencia (PDF)<br>
	   <input type="file"  name="file12" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-8"  style="font-family:FuturaBook;">
	   <b>15. ¿El PIT implemento los protocolos de bioseguridad? </b> <br>
	   <select name="valorProtocolosImplemento" id="valorProtocolosImplemento"    class="form-control"  required>
	    <option value="">Seleccionar</option>
		<option value="SI" <?PHP if(trim($registro["ProtocolosBioseguridad"])=="SI"){?> selected <?php } ?> >Si</option>
		<option value="NO" <?PHP if(trim($registro["ProtocolosBioseguridad"])=="NO"){?> selected <?php } ?> >No</option>
	   </select>
	 </div>
	</div> 
	
	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-6"  style="font-family:FuturaBook;">
	   <b>16. Seleccione elemento de protección implementado en el PIT </b><br>
	   <select name="valorElementosProteccion"   class="form-control"    required>
		<option value="Tapabocas" <?PHP if(trim($registro["ElementosProteccionPit"])=="Tapabocas"){?> selected <?php } ?> >Tapabocas</option>
		<option value="Careta" <?PHP if(trim($registro["ElementosProteccionPit"])=="Careta"){?> selected <?php } ?> >Careta</option>
		<option value="Gel antibacterial o alcohol" <?PHP if(trim($registro["ElementosProteccionPit"])=="Gel antibacterial o alcohol"){?> selected <?php } ?> >Gel antibacterial o alcohol</option>
		<option value="Guantes" <?PHP if(trim($registro["ElementosProteccionPit"])=="Guantes"){?> selected <?php } ?> >Guantes</option>
		<option value="Tapete desinfectante" <?PHP if(trim($registro["ElementosProteccionPit"])=="Tapete desinfectante"){?> selected <?php } ?> >Tapete desinfectante</option>
		<option value="Termómetro digital" <?PHP if(trim($registro["ElementosProteccionPit"])=="Termómetro digital"){?> selected <?php } ?> >Termómetro digital</option>
	   </select>
	 </div>
	 <div class="col-md-2"  style="font-family:FuturaBook;">
	   Evidencia (PDF)<br>
	   <input type="file"   name="file13" class="form-control">	 
	 </div>
	</div> 

	<div class="row" style="margin-top:20px;">
	 <div class="col-md-2" style="font-family:FuturaBook;"></div>
	 <div class="col-md-8"  style="font-family:FuturaBook;text-align:center;">
	   <button type="submit" class="btn btn-success" style="background-color:#D73D31;color:#FFFFFF; ">Guardar</button>
	 </div>
	</div>
	</form>
	
	<div class="row justify-content-center">
        <div class="col-md-12"  >
		    
            <table id="tabla" class="table  " data-page-length='5'>
                <thead>
                    <tr style="background-color:#D73D31 !important;">
                        <th></th>
                        <th>Nombre completo</th>
                        <th>Cargo</th>
                        <th>Email</th>
                        <th>Celular</th>
                        <th>NroRegistros</th>
                        <th>ConvenioCooperacion</th>
                        <th>CuentaConCDP</th>
                        <th>TieneTV</th>
                        <th>TieneInternet</th>
                        <th>TienePC</th>
                        <th>TieneEnergia</th>
                        <th>TieneInformador</th>
                        <th>TiempoMesesInformador</th>
                        <th>FormacionAcademicaTurismo</th>
                        <th>InformadorSegundoIdioma</th>
                        <th>MantenimientoPIT</th>
                        <th>HorarioOperatividadVisible</th>
                        <th>MaterialPromocional</th>
                        <th>ProtocolosBioseguridad</th>
                        <th>ElementosProteccionPit</th>
                        <th>Fecha registro</th>
                        <th>Usuario</th>
                    </tr>
                </thead>
                <tbody>
                      <?php
					  foreach ($listadoPuntos as $row)
					   {
						?>
                        <tr>
						    <form name="editarTurista<?=$row->IdPuntos ?>" method="GET" action="">
                            <input type="hidden" name="procesoEditarTurista" value="<?=$row->IdPuntos ?>">
							<td style="text-align:center;">
							<input type="submit" value="Editar" class="btn btn-success" style="background-color:#D73D31;color:#FFFFFF; ">
							</td>
                            </form>
							<td style="text-align:left;"><?=$row->NombreCompleto?></td>
                            <td style="text-align:left;"><?=$row->Cargo?></td>
                            <td style="text-align:left;"><?=$row->Correo?></td>
                            <td style="text-align:left;"><?=$row->Celular?></td>
                            <td style="text-align:left;"><?=$row->NroRegistros?></td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoConvenio)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoConvenio."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->ConvenioCooperacion."</a>");
							  }
							 else
							  {
								 echo($row->ConvenioCooperacion); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoCDP)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoCDP."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->CuentaConCDP."</a>");
							  }
							 else
							  {
								 echo($row->CuentaConCDP); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoTV)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoTV."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->TieneTV."</a>");
							  }
							 else
							  {
								 echo($row->TieneTV); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoInternet)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoInternet."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->TieneInternet."</a>");
							  }
							 else
							  {
								 echo($row->TieneInternet); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoPC)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoPC."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->TienePC."</a>");
							  }
							 else
							  {
								 echo($row->TienePC); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoEnergia)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoEnergia."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->TieneEnergia."</a>");
							  }
							 else
							  {
								 echo($row->TieneEnergia); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoInformador)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoInformador."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->TieneInformador."</a>");
							  }
							 else
							  {
								 echo($row->TieneInformador); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;"><?=$row->TiempoMesesInformador?></td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoFormacionAcademicaTurismo)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoFormacionAcademicaTurismo."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->FormacionAcademicaTurismo."</a>");
							  }
							 else
							  {
								 echo($row->FormacionAcademicaTurismo); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoInformadorSegundoIdioma)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoInformadorSegundoIdioma."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->InformadorSegundoIdioma."</a>");
							  }
							 else
							  {
								 echo($row->InformadorSegundoIdioma); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoMantenimientoPIT)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoMantenimientoPIT."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->MantenimientoPIT."</a>");
							  }
							 else
							  {
								 echo($row->MantenimientoPIT); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoHorarioOperatividadVisible)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoHorarioOperatividadVisible."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->HorarioOperatividadVisible."</a>");
							  }
							 else
							  {
								 echo($row->HorarioOperatividadVisible); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoMaterialPromocional)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoMaterialPromocional."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->MaterialPromocional."</a>");
							  }
							 else
							  {
								 echo($row->MaterialPromocional); 
							  }
							 ?>
							</td>
                            <td style="text-align:left;"><?=$row->ProtocolosBioseguridad?></td>
                            <td style="text-align:left;">
							 <?php
							 if(trim($row->AdjuntoElementosProteccionPit)!="")
							  {
								 echo("<a href='documentos/".$row->AdjuntoElementosProteccionPit."' style='color:#D73D31;text-decoration:underline;' target='_blank'>".$row->ElementosProteccionPit."</a>");
							  }
							 else
							  {
								 echo($row->ElementosProteccionPit); 
							  }
							 ?>
							</td>
							<td style="text-align:left;"><?=$row->FechaRegistro?></td>
                            <td style="text-align:left;"><?=$row->UsuarioRegistro?></td>
                        </tr>
						<?php							
					   }
					  ?>
						
                </tbody>

            </table>
	       
        </div>
    </div>


@endsection
@push('styles')
    @include('datatable.styles')
@endpush

@push('scripts')
    @include('datatable.scripts')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet"/>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>


    <script>
    /*
    configurarAdjuntoPregunta
    */
    function configurarAdjuntoPregunta(control,seccion)
    {
      var resp=$("#"+control).val();
      if(resp=="SI")
       {
          $("#"+seccion).css("visibility", "visible");
       }
      else
       {
          $("#"+seccion).val(null);
          $("#"+seccion).css("visibility", "hidden");
       }
    }
    </script>


	<script>
		//filtro listas
	    $('.filtroBusqueda').select2();
	
		/*
		configurarNacionalidad
		*/
	    function configurarNacionalidad()
		{
		  var valorNacionalidad=$( "select#valorNacionalidad" ).val();
		  if(valorNacionalidad=="10")
		   {
			 //colombia  
			 $("#zonaCiudad").css("visibility", "visible");
		   }
		  else
		   {
			 //extranjero
			 $("#zonaCiudad").css("visibility", "hidden");
		   }
		}
		
		configurarNacionalidad();
	
        var jqDataTable = $.noConflict(true);
        jqDataTable(function() {
            jqDataTable("#tabla").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "info": false,
                "ordering": false,
                "language": {
                    "searchPlaceholder": "Buscar",
                    "decimal": "",
                    "emptyTable": "No hay registros",
                    "info": "Mostrando del  _START_ al _END_ de _TOTAL_ registros",
                    "infoEmpty": "Showing 0 to 0 of 0 entries",
                    "infoFiltered": "(filtered from _MAX_ total entries)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "Show _MENU_ entries",
                    "loadingRecords": "Loading...",
                    "processing": "Processing...",
                    "search": "",
                    "zeroRecords": "No matching records found",
                    "paginate": {
                        "first": "<<",
                        "last": ">>",
                        "next": ">",
                        "previous": "<"
                    },
                    "aria": {
                        "sortAscending": ": activate to sort column ascending",
                        "sortDescending": ": activate to sort column descending"
                    },

                    "buttons": {
                        "copyTitle": 'Copiado al portapapeles',
                        "copySuccess": {
                            "_": '%d lineas copiadas',
                            "1": '1 lineas copiadas'
                        },
                    },
                },
                "buttons": [
                    /* {
                                            extend: 'copy',
                                            text: 'Copiar'
                                        },
                                        "csv", */
                    "excel",
                    /* "pdf", */
                    /*  {
                         extend: 'print',
                         text: 'Imprimir'

                     } */
                ]
            }).buttons().container().appendTo('#tabla_wrapper .col-md-5:eq(0)');

        });

    </script>
	
	<?php
	if(trim($procesoRegistroTurista)=="1" || trim($procesoEditarRegistroTurista)!="" )
	 {
	    ?>
		<script>
		Swal.fire(
		'FONTUR PITS',
		'Registro guardado',
		'success'
		);
		</script>
	    <?php	  
	 }
	?>

@endpush
