@extends('template')

@section('title', 'Portfolio')

@section('content')
    <div class="container">
        <div class="d-flex justify-content-between align-items-center mb-3">

            @isset($category)
                <div>

                    <h1 class="display-4 mb-0">{{ $category->name }}</h1>
                    <a href="{{ route('projects.index') }}">Regresar al protaforlio</a>
                </div>
            @else
                <h1 class="display-4 mb-0">Portfolio</h1>
            @endisset
            @can('create', $newProject)
                <a class="btn btn-primary" href="{{ route('projects.create') }}">Crear proyecto</a>
            @endcan

        </div>
        <div class="d-flex flex-wrap justify-content-between align-items-start">
            @forelse ($projects as $projectItem)
                <div class="card border-0 shadow-sm mt-4 mx-auto" style="width: 18rem">

                    @if ($projectItem->image)
                        <img class="card-img-top" src="/storage/{{ $projectItem->image }}" alt="{{ $projectItem->title }}"
                            style="height: 150px; object-fit: cover;
>
                    @endif
                    <div class="card-body">
                        <h5 class="card-title"><a
                                href="{{ route('projects.show', $projectItem) }}">{{ $projectItem->title }}</a></h5>
                        <h6 class="card-subtitle">
                            {{ $projectItem->created_at->format('d/m/Y') }}
                        </h6>
                        <p class="card-text text-truncate">{{ $projectItem->description }}</p>
                        <div class="d-flex flex-wrap justify-content-between align-items-center">
                            <a class="btn btn-primary" href="{{ route('projects.show', $projectItem) }}">
                                Ver más...
                            </a>
                            @if ($projectItem->category_id)
                                <a href="{{ route('categories.show', $projectItem->category) }}"
                                    class="badge badge-secondary">{{ $projectItem->category->name }}</a>
                            @endif
                        </div>
                    </div>

                </div>

            @empty
                <li class="list-group-item border-0 mb-3 shadow-sm align-items-center">Ho hay proyectos para mostrar</li>
            @endforelse
            {{ $projects->links() }}
        </div>
        @auth
            @can('view-deleted-projects')
                <h4>Papelera</h4>
                <ul class="list-group">
                    @foreach ($deletedProjects as $deletedProject)
                        <li class="list-group-item">
                            {{ $deletedProject->title }}
                            @can('restore', $deletedProject)
                                <form class="d-inline" action="{{ route('projects.restore', $deletedProject) }}" method="POST"
                                    onsubmit="return confirm('Está seguro de restaurar este proyecto')">
                                    @csrf @method('PATCH')
                                    <button class="btn btn-sm btn-info">Restaurar</button>
                                </form>
                            @endcan
                            @can('forceDelete', $deletedProject)
                                <form class="d-inline" action="{{ route('projects.forceDelete', $deletedProject) }}" method="POST"
                                    onsubmit="return confirm('Está seguro de eliminar este proyecto')">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-danger">Eliminar Permanentemente</button>
                                </form>
                            @endcan
                        </li>
                    @endforeach

                </ul>
            @endcan
        @endauth

    </div>
@endsection
