@csrf
@if ($project->image)
    <img class="card-img-top mb-2" src="/storage/{{ $project->image }}" alt="{{ $project->title }}">
@endif

<div class="form-group">
    <label for="category_id">Categoria del proyecto</label>
    <select name="category_id" id="category_id" class="form-control bg-light shadow-sm border-0">
        <option value="">Seleccione uno</option>
        @foreach ($categories as $id => $name)

            <option value="{{ $id }}" @if ($id == old('category_id', $project->category_id)) selected
        @endif
        >{{ $name }}</option>
        @endforeach
    </select>
</div>

<div class="custom-file mb-2">
    <input name="image" type="file" class="custom-file-input" id="customFileLang" lang="es">
    <label class="custom-file-label" for="customFileLang">Seleccionar Archivo</label>
</div>

<div class="form-group">

    <label for="title">
        Título del proyecto
    </label>
    <input class="form-control bg-light shadow-sm border-0" type="text" name="title" id="title"
        value="{{ old('title', $project->title) }}">
</div>
<div class="form-group">

    <label for="url"> Url del proyecto </label>
    <input class="form-control bg-light shadow-sm border-0" type="text" name="url" id="url"
        value="{{ old('url', $project->url) }}">
</div>
<div class="form-group">

    <label for="description"> Descripción del proyecto </label>
    <textarea type="text" name="description" class="form-control bg-light shadow-sm border-0"
        id="description">{{ old('description', $project->description) }}</textarea>
</div>

<button class="btn btn-primary btnlg btn-block">{{ $btnText }}</button>
<a class="btn btn-link btn-block" href="{{ route('projects.index') }}">Cancelar</a>
