@extends('template')

@section('title', 'Noticias')
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
    <li class="breadcrumb-item active" aria-current="page">noticias</li>
@endsection
@section('content')
    <div class="tituloSeccionNoticias" style="width: 100%">
        <h2>NOTICIAS...</h2>
    </div>
    <section class="noticiasGrid">
        <div class="row">


            @foreach ($noticias as $noticia)
                <div class="col-md-4" style="padding-top:100px ">
                    <div class="cbp-caption">
                        <div class="cbp-caption-defaultWrap">
                            <a href="{{ route('noticia.show', ['noticia' => $noticia, 'title' => strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $noticia->title), '-'))]) }}"
                                class="ihe-overlay ihe-overlay--" data-hover>
                                <img class="img-fluid" src="<?= str_replace('public://', 'https://pits.ciscsas.com/sites/default/files/', $noticia->img) ?>" 
                                        alt="{{ $noticia->title }}">
                                    </a>
                                </div>
                            </div>
                            <div class="cbp-caption-activeWrap sp-cpb-caption-fields-animation" style="background: ; color:;">
                                <div class="cbp-l-caption-alignCenter">
                                    <div class="cbp-l-caption-body">
                                    </div>
                                </div>
                            </div>
                            <div class="cpb-other-fields">
                                <h6>{{ \Carbon\Carbon::parse($noticia->date)->isoformat('D MMMM, YYYY') }}</h6>
                                <h3><a href="{{ route('noticia.show', ['noticia' => $noticia, 'title' => strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $noticia->title), '-'))]) }}">{{ $noticia->title }}</a></h3></div>
                            </div>
                @endforeach
                </div>
                <div class="paginador mt-5">
                    {{ $noticias->onEachSide(1)->links() }}
                    
                </div>
            </section>
@endsection
