@extends('template')

@section('title', 'Galerias')
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
    <li class="breadcrumb-item active" aria-current="page">Galerias</li>
@endsection
@section('content')
    <div class="tituloSeccionNoticias" style="width: 100%">
        <h2>GALERIAS</h2>
    </div>
    <section class="noticiasGrid">
        <div class="row">


            @foreach ($galerias as $galeria)
                <div class="col-md-4" style="padding-top:100px ">
                    <div class="cbp-caption">
                        <div class="cbp-caption-defaultWrap">
                            <a href="{{ route('galeria.show', ['galeria' => $galeria, 'title' => strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $galeria->title), '-'))]) }}"
                                class="ihe-overlay ihe-overlay--" data-hover>
                                <img class="img-fluid" src="<?= str_replace('public://', 'https://fontur.com.co/sites/default/files/', $galeria->img) ?>" 
                                alt="{{ $galeria->title }}">
                            </a>
                        </div>
                    </div>
                    <div class="cbp-caption-activeWrap sp-cpb-caption-fields-animation" style="background: ; color:;">
                        <div class="cbp-l-caption-alignCenter">
                            <div class="cbp-l-caption-body">
                            </div>
                        </div>
                    </div>
                    <div class="cpb-other-fields">
                        <h6>{{ \Carbon\Carbon::parse($galeria->date)->isoformat('D MMMM, YYYY') }}</h6>
                        <h3><a href="{{ route('galeria.show', ['galeria' => $galeria, 'title' => strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $galeria->title), '-'))]) }}">{{ $galeria->title }}</a></h3></div>
                    </div>
        @endforeach
        </div>
        <div class="paginador mt-5">
            {{ $galerias->onEachSide(1)->links() }}
        </div>
    </section>
@endsection
