@extends('template')

@section('title', 'Galería')
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('home')}}">Inicio</a></li>
    <li class="breadcrumb-item"><a href="{{route('galeria.index')}}">Galerias</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{$titulo}}</li>
@endsection
@section('content')
    <section class="galeriaShow">
        <h1 class="my-5">{{ $titulo }}</h1>
        <div class="masonry-gallery masonry--h">

            @foreach ($imagenes as $imagen)

                <figure class="masonry-brick-gallery masonry-brick--h">
                    <a class="gallery cbp-lightbox" data-lightbox="gallery" href="<?= str_replace('public://', 'https://fontur.com.co/sites/default/files/', $imagen->img) ?>">
                <img src="<?= str_replace('public://', 'https://fontur.com.co/sites/default/files/', $imagen->img) ?>" class="masonry-img" alt="">
            </a>
        </figure>

        @endforeach
    </div>

    </section>

@endsection

@push('styles')
    <link rel="stylesheet" href="{{ mix('css/lightbox.css') }}" />
@endpush

@push('scripts')
    <script src="{{ mix('js/lightbox.js') }}"></script>
@endpush
