@extends('template')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
    <li class="breadcrumb-item"><a href="{{ route('departamentos.index') }}">Departamentos</a></li>
    <li class="breadcrumb-item active" aria-current="page">Ver Departamento</li>
@endsection

@section('content')
    <div class="tituloMorado" style="width: 100%">
        <h2>DEPARTAMENTO</h2>
    </div>
    <div class="row justify-content-center userShow">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Información del departamento </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" class="form-control" value="{{ $departamento->name }}" readonly>
                    </div>
                    <div class="form-group">
                        <label>Estado</label>
                        <input type="text" class="form-control"
                            value="{{ $departamento->active ? 'ACTIVO' : 'INACTIVO' }}" readonly>
                    </div>
                    <div class="form-group">
                        <label>Cargos</label>
                        <textarea id="autoresizing" type="text" class="form-control" readonly
                            style="display: block; overflow: hidden; resize: none;">{{ $departamento->cargos->pluck('name')->implode(', ') }}</textarea>
                    </div>

                    @if (auth()
            ->user()
            ->hasPermissionTo('Actualizar departamentos') ||
        auth()
            ->user()
            ->hasRole('admin') ||
        auth()
            ->user()
            ->hasRole('super-admin'))
                        <div class="text-center">
                            <a href="{{ route('departamentos.edit', $departamento) }}"
                                class="btn btn-primary  btn-crear">Editar
                                Departamento<i class="fa fa-pen"></i>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Información del departamento en el sistema</div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Usuario creador</label>
                        <input type="text" class="form-control" value="{{ $departamento->creatorUser->name }}" readonly />
                    </div>
                    <div class="form-group">
                        <label>Fecha de creación</label>
                        <input type="text" class="form-control"
                            value="{{ $departamento->created_at->format('d/m/Y H:i:s') }}" readonly />
                    </div>

                    <div class="form-group">
                        <label>Usuario última actulización</label>
                        <input type="text" class="form-control" value="{{ $departamento->updaterUser->name }}" readonly />
                    </div>
                    <div class="form-group">
                        <label>Fecha última actulización</label>
                        <input type="text" class="form-control"
                            value="{{ $departamento->updated_at->format('d/m/Y H:i:s') }}" readonly />
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script type="text/javascript">
        window.setTimeout(function() {
            $("textarea").height($("textarea")[0].scrollHeight);
        }, 1);

    </script>
@endpush
