@extends('template')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
    <li class="breadcrumb-item active" aria-current="page">Documentos</li>
@endsection

@section('content')
	<style>
	.tituloMorado h2::before {
		background: #D73D31;
	}	
	</style>
    <div class="tituloMorado" style="color:#D73D31;width: 100%">
        <h2>DOCUMENTOS</h2>
    </div>
    @include('partials.validation-errors')

	<!-- POST -->
	<form name="formularioDocumento" method="POST" action="departamentos" enctype="multipart/form-data" >
	@csrf
	<?php
	if(trim($procesoEditarDocumento)=="")
	 {
	   ?>
	   <input type="hidden" name="procesoRegistroDocumento" value="1">
	   <?php	   
	 }
	else
	 {
	   ?>
	   <input type="hidden" name="procesoEditarRegistroDocumento" value="<?=$procesoEditarDocumento?>">
	   <?php	   
	 }
	?>
	
	<div class="row" style="margin-top:5px;">
	  <div class="col-md-3"></div>
      <div class="col-md-6">
	    *Titulo<br>
	    <input type="text" name="valorDocumento" value="<?=$registro["Titulo"]?>" class="form-control" required>
	  </div>
	</div>
	
	<div class="row" style="margin-top:5px;">
	 <div class="col-md-3"></div>
     <div class="col-md-3">
	  *Archivo (PDF)<br>
	  <input type="file" name="archivo" id="archivo"  class="form-control"  >
	 </div>
     <div class="col-md-3">
	  *Activo<br> 
	  <select name="valorActivo" class="form-control">
	   <option value="1" <?php if($registro["ActivoArchivo"]=="1"){ ?>selected<?php }?> >Si</option>
	   <option value="0" <?php if($registro["ActivoArchivo"]=="0"){ ?>selected<?php }?> >No</option>
	  </select>
	 </div>
	</div>
	
	<div class="row" style="margin-top:10px;">	 
     <div class="col-md-12" style="text-align:center;">
	   <button type="submit" class="btn btn-success" style="background-color:#D73D31;color:#FFFFFF; ">Guardar</button>
	 </div>
	</div>
	
	</form>
	
	<div class="row justify-content-center" style="margin-top:50px;">
        <div class="col-md-12 py-3 rounded-lg"  >
            <table id="tabla" class="table table-bordered table-striped mb-5" data-page-length='5'>
                <thead>
                     <tr style="background-color:#D73D31 !important;">
                        <th>EDITAR</th>
                        <th>DOCUMENTO</th>
                    </tr>
                </thead>
                <tbody>
                     <?php
					 foreach ($listadoDocumentosHome as $row)
					  {
						?>
                        <tr>
						    <form name="editarDocumento<?=$row->IdDocumento ?>" method="GET" action="">
                            <input type="hidden" name="procesoEditarDocumento" value="<?=$row->IdDocumento ?>">
							<td style="text-align:center;">
							<input type="submit" value="Editar" class="btn btn-success" style="background-color:#D73D31;color:#FFFFFF; ">
							</td>
                            </form>
						
                            <td style="text-align:left !important;"><a href="documentos/<?=$row->Archivo?>" target="_blank" style="color:#0B234F;text-decoration:none;"><img src="img/documentopits.png"> <?=$row->Titulo?></a></td>
                        </tr>
						<?php						
					  }
					 ?>
                </tbody>

            </table>

        </div>
    </div>


@endsection
@push('styles')
    @include('datatable.styles')
@endpush

@push('scripts')
    @include('datatable.scripts')
    <script>
        var jqDataTable = $.noConflict(true);
        jqDataTable(function() {
            jqDataTable("#tabla").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "info": false,
                "ordering": false,
                "language": {
                    "searchPlaceholder": "Buscar",
                    "decimal": "",
                    "emptyTable": "No hay registros",
                    "info": "Mostrando del  _START_ al _END_ de _TOTAL_ registros",
                    "infoEmpty": "Showing 0 to 0 of 0 entries",
                    "infoFiltered": "(filtered from _MAX_ total entries)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "Show _MENU_ entries",
                    "loadingRecords": "Loading...",
                    "processing": "Processing...",
                    "search": "",
                    "zeroRecords": "No matching records found",
                    "paginate": {
                        "first": "<<",
                        "last": ">>",
                        "next": ">",
                        "previous": "<"
                    },
                    "aria": {
                        "sortAscending": ": activate to sort column ascending",
                        "sortDescending": ": activate to sort column descending"
                    },

                    "buttons": {
                        "copyTitle": 'Copiado al portapapeles',
                        "copySuccess": {
                            "_": '%d lineas copiadas',
                            "1": '1 lineas copiadas'
                        },
                    },
                },
                "buttons": [
                    /* {
                                            extend: 'copy',
                                            text: 'Copiar'
                                        },
                                        "csv", */
                    "excel",
                    /* "pdf", */
                    /*  {
                         extend: 'print',
                         text: 'Imprimir'

                     } */
                ]
            }).buttons().container().appendTo('#tabla_wrapper .col-md-5:eq(0)');

        });

    </script>

@endpush
