@extends('template')

@section('title', 'Contact')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-12 col-sm-10 col-lg-6 mx-auto">
                <form method="POST" class="bg-white shadow rounded py-3 px-4" action="{{ route('messages.store') }}">
                    @csrf
                    <h1 class="display-4">{{ __('Contact') }}</h1>
                    <hr>
                    <div class="form-group">
                        <label for="nombre">Nombre</label>
                        <input class="form-control bg-light shadow-sm @error('nombre')
                                                                        is-invalid @else border-0
                                                                    @enderror" type="text" name="nombre" id="nombre"
                            placeholder="Nombre..." value="{{ old('nombre') }}">
                        @error('nombre')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                    <div class="form-group">
                        <input class="form-control bg-light shadow-sm @error('email')
                                                        is-invalid @else border-0
                                                    @enderror" type="text" name="email" id="email" placeholder="Email..."
                            value="{{ old('email') }}">
                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <input class="form-control  bg-light shadow-sm @error('subject')
                                            is-invalid @else border-0
                                        @enderror" type="text" name="subject" id="subject" placeholder="Asunto..."
                            value="{{ old('subject') }}">
                        @error('subject')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>

                    <div class="form-group">
                        <textarea class="form-control  bg-light shadow-sm @error('content')
                                        is-invalid @else border-0
                                    @enderror" name="content" id="content" placeholder="Mensaje..."
                            value="{{ old('content') }}"></textarea>
                        @error('content')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror

                    </div>
                    <button class="btn btn-primary btnlg btn-block">@lang('Send')</button>
                </form>
            </div>
        </div>

    </div>
@endsection
