<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class Proceso extends Model
{
  /*
  listadoContratosXTipo
  */	
  public static  function listadoContratosXTipo($request,$post,$nombreArchivoDescarga,$generarDescarga,$paginaActual,$TipoProceso)
  {
	//filtros
	$topePaginacion="10";
	$filtro="";
	if(trim($request->session()->get('valorNumeroFiltro'))!="")
	 {
		$filtro=$filtro." AND ( proceso.Numero LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%' OR proceso.Objeto LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%' OR catastro.DESCRIPCION LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%' )  ";
	 }		
	if(trim($request->session()->get('valorTipoProcesoFiltro'))!="")
	 {
		$filtro=$filtro." AND  proceso.IdTipoProceso=".$request->session()->get('valorTipoProcesoFiltro');
	 }		
	if(trim($request->session()->get('valorFechaDesdeFiltro'))!="" && trim($request->session()->get('valorFechaHastaFiltro'))!="")
	 {
		$filtro=$filtro." AND  	FechaApertura>='".Proceso::formatoFechaYMD($request->session()->get('valorFechaDesdeFiltro'))." 00:00' AND FechaApertura<='".Proceso::formatoFechaYMD($request->session()->get('valorFechaHastaFiltro'))." 23:59'  ";
	 }		
	if(trim($request->session()->get('valorEstadoFiltro'))!="")
	 {
		$filtro=$filtro." AND estado.IdEstado=".$request->session()->get('valorEstadoFiltro');
	 }		
	
	//consulta sin paginación
	$sql="";  
	$sql=$sql." SELECT ";
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN catastro ON catastro.Codigo=proceso.Codigo ";  
	$sql=$sql." INNER JOIN tipo_proceso ON tipo_proceso.IdTipoProceso=proceso.IdTipoProceso ";  
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_proceso.IdEstado  ";  
	$sql=$sql." INNER JOIN moneda ON moneda.IdMoneda=proceso.IdMoneda ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=proceso.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.Vigencia DESC LIMIT 1000 ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga | todos los registros sin paginación
	if($generarDescarga=="1")
	 {
	   //generar descarga | 
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "Número;Fecha apertura;Fecha cierre;Estado;Dependencia;Cuantía;Moneda;Municipio;Objeto; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$txt = $row->Numero.";".$row->FechaApertura.";".$row->FechaCierre.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->Cuantia.";".$row->DetalleMoneda.";".$row->DESCRIPCION.";".$row->Objeto."; \n";
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	 }		
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN catastro ON catastro.Codigo=proceso.Codigo ";  
	$sql=$sql." INNER JOIN tipo_proceso ON tipo_proceso.IdTipoProceso=proceso.IdTipoProceso ";  
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_proceso.IdEstado  ";  
	$sql=$sql." INNER JOIN moneda ON moneda.IdMoneda=proceso.IdMoneda ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=proceso.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.Vigencia DESC LIMIT ".$paginaActual.",".$topePaginacion;	
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	return $listado;
  }

  /*
  listadoContratosXTipoExterna
  */	
  public static  function listadoContratosXTipoExterna($request,$post,$nombreArchivoDescarga,$generarDescarga,$paginaActual,$TipoProceso)
  {
	//filtros
	$topePaginacion="10";
	$filtro="";
	if(trim($post['valorNumeroFiltro'])!="")
	 {
		$filtro=$filtro." AND ( proceso.Numero LIKE '%".trim($post['valorNumeroFiltro'])."%' OR proceso.Objeto LIKE '%".trim($post['valorNumeroFiltro'])."%' OR catastro.DESCRIPCION LIKE '%".trim($post['valorNumeroFiltro'])."%' )  ";
	 }		
	if(trim($post['valorTipoProcesoFiltro'])!="")
	 {
		$filtro=$filtro." AND  proceso.IdTipoProceso=".$post['valorTipoProcesoFiltro'];
	 }		
	if(trim($post['valorFechaDesdeFiltro'])!="" && trim($post['valorFechaHastaFiltro'])!="")
	 {
		$filtro=$filtro." AND  	FechaApertura>='".Proceso::formatoFechaYMD($post['valorFechaDesdeFiltro'])." 00:00' AND FechaApertura<='".Proceso::formatoFechaYMD($post['valorFechaHastaFiltro'])." 23:59'  ";
	 }		
	if(trim($post['valorEstadoFiltro'])!="")
	 {
		$filtro=$filtro." AND estado.IdEstado=".$post['valorEstadoFiltro'];
	 }		
	
	//consulta sin paginación
	$sql="";  
	$sql=$sql." SELECT ";
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN catastro ON catastro.Codigo=proceso.Codigo ";  
	$sql=$sql." INNER JOIN tipo_proceso ON tipo_proceso.IdTipoProceso=proceso.IdTipoProceso ";  
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_proceso.IdEstado  ";  
	$sql=$sql." INNER JOIN moneda ON moneda.IdMoneda=proceso.IdMoneda ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=proceso.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.FechaApertura DESC LIMIT 1000 ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga | todos los registros sin paginación
	if($generarDescarga=="1")
	 {
	   //generar descarga | 
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "Número;Fecha apertura;Fecha cierre;Estado;Dependencia;Cuantía;Moneda;Municipio;Objeto; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$txt = $row->Numero.";".$row->FechaApertura.";".$row->FechaCierre.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->Cuantia.";".$row->DetalleMoneda.";".$row->DESCRIPCION.";".$row->Objeto."; \n";
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	 }		
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN catastro ON catastro.Codigo=proceso.Codigo ";  
	$sql=$sql." INNER JOIN tipo_proceso ON tipo_proceso.IdTipoProceso=proceso.IdTipoProceso ";  
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_proceso.IdEstado  ";  
	$sql=$sql." INNER JOIN moneda ON moneda.IdMoneda=proceso.IdMoneda ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=proceso.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.FechaApertura DESC LIMIT ".$paginaActual.",".$topePaginacion;	
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	return $listado;
  }

  /*
  listadoContratosProyectosXTipo
  */	
  public static  function listadoContratosProyectosXTipo($request,$post,$nombreArchivoDescarga,$generarDescarga,$paginaActual,$TipoProceso)
  {
	//filtros
	$topePaginacion="10";
	$filtro="";
	if(trim($request->session()->get('valorNumeroFiltro'))!="")
	 {
		$filtro=$filtro." AND ( proceso.Numero LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%' OR proceso.EntidadProponente LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%' )  ";
	 }		
	if(trim($request->session()->get('valorFechaDesdeFiltro'))!="" && trim($request->session()->get('valorFechaHastaFiltro'))!="")
	 {
		$filtro=$filtro." AND  	FechaApertura>='".Proceso::formatoFechaYMD($request->session()->get('valorFechaDesdeFiltro'))." 00:00' AND FechaApertura<='".Proceso::formatoFechaYMD($request->session()->get('valorFechaHastaFiltro'))." 23:59'  ";
	 }		
	if(trim($request->session()->get('valorEstadoFiltro'))!="")
	 {
		$filtro=$filtro." AND estado_proyecto.IdEstadoProyecto=".$request->session()->get('valorEstadoFiltro');
	 }		
	
	//consulta sin paginación
	$sql="";  
	$sql=$sql." SELECT ";
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN estado_proyecto ON estado_proyecto.IdEstadoProyecto=proceso.IdEstadoProyecto  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.Vigencia DESC LIMIT 1000 " ;
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga | todos los registros sin paginación
	if($generarDescarga=="1")
	 {
	   /*  
	   //generar descarga | 
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "Número;Fecha apertura;Fecha cierre;Estado;Dependencia;Cuantía;Moneda;Municipio;Objeto; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$txt = $row->Numero.";".$row->FechaApertura.";".$row->FechaCierre.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->Cuantia.";".$row->DetalleMoneda.";".$row->DESCRIPCION.";".$row->Objeto."; \n";
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	   */
	 }		
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN estado_proyecto ON estado_proyecto.IdEstadoProyecto=proceso.IdEstadoProyecto  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.Vigencia DESC LIMIT ".$paginaActual.",".$topePaginacion;	
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	return $listado;
  }


  /*
  listadoContratosProyectosXTipoExterno
  */	
  public static  function listadoContratosProyectosXTipoExterno($request,$post,$nombreArchivoDescarga,$generarDescarga,$paginaActual,$TipoProceso)
  {
	//filtros
	$topePaginacion="10";
	$filtro="";
	if(trim($post['valorNumeroFiltro'])!="")
	 {
		$filtro=$filtro." AND ( proceso.Numero LIKE '%".trim($post['valorNumeroFiltro'])."%' OR proceso.EntidadProponente LIKE '%".trim($post['valorNumeroFiltro'])."%' )  ";
	 }		
	if(trim($post['valorFechaDesdeFiltro'])!="" && trim($post['valorFechaHastaFiltro'])!="")
	 {
		$filtro=$filtro." AND  	FechaApertura>='".Proceso::formatoFechaYMD($post['valorFechaDesdeFiltro'])." 00:00' AND FechaApertura<='".Proceso::formatoFechaYMD($post['valorFechaHastaFiltro'])." 23:59'  ";
	 }		
	if(trim($post['valorEstadoFiltro'])!="")
	 {
		$filtro=$filtro." AND estado_proyecto.IdEstadoProyecto=".$post['valorEstadoFiltro'];
	 }		
	
	//consulta sin paginación
	$sql="";  
	$sql=$sql." SELECT ";
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN estado_proyecto ON estado_proyecto.IdEstadoProyecto=proceso.IdEstadoProyecto  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.FechaApertura DESC LIMIT 1000 " ;
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga | todos los registros sin paginación
	if($generarDescarga=="1")
	 {
	   /*  
	   //generar descarga | 
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "Número;Fecha apertura;Fecha cierre;Estado;Dependencia;Cuantía;Moneda;Municipio;Objeto; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$txt = $row->Numero.";".$row->FechaApertura.";".$row->FechaCierre.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->Cuantia.";".$row->DetalleMoneda.";".$row->DESCRIPCION.";".$row->Objeto."; \n";
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	   */
	 }		
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN estado_proyecto ON estado_proyecto.IdEstadoProyecto=proceso.IdEstadoProyecto  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.FechaApertura DESC LIMIT ".$paginaActual.",".$topePaginacion;	
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	return $listado;
  }

  /*
  listadoContratosXProyectosTipo
  */	
  public static  function listadoContratosXProyectosTipo($request,$post,$nombreArchivoDescarga,$generarDescarga,$paginaActual,$TipoProceso)
  {
	//filtros
	$topePaginacion="10";
	$filtro="";
	if(trim($request->session()->get('valorNumeroFiltro'))!="")
	 {
		$filtro=$filtro." AND ( proceso.Numero LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%' OR proceso.EntidadProponente LIKE '%".trim($request->session()->get('valorNumeroFiltro'))."%'  )  ";
	 }		
	if(trim($request->session()->get('valorFechaDesdeFiltro'))!="" && trim($request->session()->get('valorFechaHastaFiltro'))!="")
	 {
		$filtro=$filtro." AND  	FechaApertura>='".Proceso::formatoFechaYMD($request->session()->get('valorFechaDesdeFiltro'))." 00:00' AND FechaApertura<='".Proceso::formatoFechaYMD($request->session()->get('valorFechaHastaFiltro'))." 23:59'  ";
	 }		
	if(trim($request->session()->get('valorEstadoFiltro'))!="")
	 {
		$filtro=$filtro." AND  proceso.IdEstadoProyecto=".$request->session()->get('valorEstadoFiltro');
	 }		
	
	//consulta sin paginación
	$sql="";  
	$sql=$sql." SELECT ";
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN estado_proyecto ON estado_proyecto.IdEstadoProyecto=proceso.IdEstadoProyecto  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.Vigencia DESC LIMIT 1000 ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga | todos los registros sin paginación
	if($generarDescarga=="1")
	 {
	   //generar descarga | 
	   /*
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "Número;Fecha apertura;Fecha cierre;Estado;Dependencia;Cuantía;Moneda;Municipio;Objeto; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$txt = $row->Numero.";".$row->FechaApertura.";".$row->FechaCierre.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->Cuantia.";".$row->DetalleMoneda.";".$row->DESCRIPCION.";".$row->Objeto."; \n";
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	   */
	 }		
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN estado_proyecto ON estado_proyecto.IdEstadoProyecto=proceso.IdEstadoProyecto  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." AND  TipoProceso=".$TipoProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.Vigencia DESC LIMIT ".$paginaActual.",".$topePaginacion;	
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	return $listado;
  }
    
    
  /*
  listadoContratos
  */	
  public static  function listadoContratos($post,$nombreArchivoDescarga,$generarDescarga,$paginaActual)
  {
	//filtros
	$topePaginacion="10";
	$filtro="";
	if(trim($post['valorNumeroFiltro'])!="")
	 {
		$filtro=$filtro." AND ( proceso.Numero='".trim($post['valorNumeroFiltro'])."' OR proceso.Objeto LIKE '%".trim($post['valorNumeroFiltro'])."%' OR catastro.DESCRIPCION LIKE '%".trim($post['valorNumeroFiltro'])."%' )  ";
	 }		
	if(trim($post['valorTipoProcesoFiltro'])!="")
	 {
		$filtro=$filtro." AND  proceso.IdTipoProceso=".$post['valorTipoProcesoFiltro'];
	 }		
	if(trim($post['valorFechaDesdeFiltro'])!="" && trim($post['valorFechaHastaFiltro'])!="")
	 {
		$filtro=$filtro." AND  	FechaApertura>='".Proceso::formatoFechaYMD($post['valorFechaDesdeFiltro'])." 00:00' AND FechaApertura<='".Proceso::formatoFechaYMD($post['valorFechaHastaFiltro'])." 23:59'  ";
	 }		
	if(trim($post['valorEstadoFiltro'])!="")
	 {
		$filtro=$filtro." AND estado.IdEstado=".$post['valorEstadoFiltro'];
	 }		
	
	//consulta sin paginación
	$sql="";  
	$sql=$sql." SELECT ";
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN catastro ON catastro.Codigo=proceso.Codigo ";  
	$sql=$sql." INNER JOIN tipo_proceso ON tipo_proceso.IdTipoProceso=proceso.IdTipoProceso ";  
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_proceso.IdEstado  ";  
	$sql=$sql." INNER JOIN moneda ON moneda.IdMoneda=proceso.IdMoneda ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=proceso.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.IdProceso DESC LIMIT 1000 ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga | todos los registros sin paginación
	if($generarDescarga=="1")
	 {
	   //generar descarga | 
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "Número;Fecha apertura;Fecha cierre;Estado;Dependencia;Cuantía;Moneda;Municipio;Objeto; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$txt = $row->Numero.";".$row->FechaApertura.";".$row->FechaCierre.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->Cuantia.";".$row->DetalleMoneda.";".$row->DESCRIPCION.";".$row->Objeto."; \n";
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	 }		
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso";  
	$sql=$sql." INNER JOIN catastro ON catastro.Codigo=proceso.Codigo ";  
	$sql=$sql." INNER JOIN tipo_proceso ON tipo_proceso.IdTipoProceso=proceso.IdTipoProceso ";  
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_proceso.IdEstado  ";  
	$sql=$sql." INNER JOIN moneda ON moneda.IdMoneda=proceso.IdMoneda ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=proceso.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso > 0  ".$filtro;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso.IdProceso DESC LIMIT ".$paginaActual.",".$topePaginacion;	
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	return $listado;
  }


  /*
  procesoLinkDetalle
  */	
  public static  function procesoLinkDetalle($IdProceso)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso ";  
	$sql=$sql." ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDetalleUsuario
  */	
  public static  function listadoAdjuntosContratos($IdProceso,$filtro)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso_adjunto";  
	$sql=$sql." INNER JOIN tipo_documento ON tipo_documento.IdTipoDocumento=proceso_adjunto.IdTipoDocumento ";  
	$sql=$sql." ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso_adjunto.IdProcesoAdjunto DESC ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoAdjuntosContratosTodos
  */	
  public static  function listadoAdjuntosContratosTodos()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso_adjunto";  
	$sql=$sql." INNER JOIN tipo_documento ON tipo_documento.IdTipoDocumento=proceso_adjunto.IdTipoDocumento ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY IdProceso ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoTipoProceso
  */	
  public static  function listadoTipoProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_proceso ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleTipoProceso  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoDocumento
  */	
  public static  function listadoTipoDocumento()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_documento ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleTipoDocumento  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoEstadoProceso
  */	
  public static  function listadoEstadoProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=1 ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstadoProyectosProceso
  */	
  public static  function listadoEstadoProyectosProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." IdEstadoProyecto AS IdEstado,DetalleEstado ";  
	$sql=$sql." FROM estado_proyecto ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." ActivoEstadoProyecto=1 ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  
  /*
  listadoDetalleProceso
  */	
  public static  function listadoDetalleProceso($IdProceso)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso "; 
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoDetalleProyectoProceso
  */	
  public static  function listadoDetalleProyectoProceso($IdProceso)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso "; 
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDependencia
  */	
  public static  function listadoDependencia()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleDependencia  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoMunicipio
  */	
  public static  function listadoMunicipio()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." ciudad.Codigo AS CODIGO_CIUDAD, ciudad.DESCRIPCION AS DESCRIPCION_CIUDAD ,depto.DESCRIPCION AS DESCRIPCION_DEPTO  ";  
	$sql=$sql." FROM  catastro ciudad ";  
	$sql=$sql." INNER JOIN catastro depto ON  depto.Codigo=ciudad.LUGE_CODIGO ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." ciudad.tipo='CM'  ";  
	$sql=$sql." ORDER BY  ciudad.DESCRIPCION  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoMoneda
  */	
  public static  function listadoMoneda()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  moneda ";  
	$sql=$sql." ORDER BY  DetalleMoneda  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  actualizarProcesoContrato
  */	
  public static  function actualizarProcesoContrato($POST,$IdProceso,$usuario)
  {
	$mensaje="";
  
	$sql="";  
	$sql=$sql." UPDATE "; 
	$sql=$sql." proceso "; 
	$sql=$sql." SET "; 
	$sql=$sql." IdTipoProceso=".$POST["valorTipoProceso"].",IdDependencia=".$POST["valorDependenciaProceso"].", Codigo=".$POST["valorMunicipioProceso"].", "; 
	$sql=$sql." FechaApertura='".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."',FechaCierre='".Proceso::formatoFechaYMD($POST["valorFechaCierre"])."', "; 
	$sql=$sql." IdMoneda=".$POST["valorMonedaProceso"].",Cuantia='".$POST["valorCuantia"]."', "; 
	$sql=$sql." Objeto='".$POST["valorObjeto"]."',FechaModificacion='".date("Y/m/d H:i")."', "; 
	$sql=$sql." UsuarioModificacion='".$usuario."' "; 
	$sql=$sql."  "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProceso=".$IdProceso; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	
	$sql="";  
	$sql=$sql." UPDATE "; 
	$sql=$sql." estado_proceso "; 
	$sql=$sql." SET "; 
	$sql=$sql." IdEstado=".$POST["valorEstadoProceso"]; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProceso=".$IdProceso; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
    	
	$mensaje="Contrato actualizado exitosamente.";
    return $mensaje;
  }


  /*
  actualizarProcesoProyectoContrato
  */	
  public static  function actualizarProcesoProyectoContrato($POST,$IdProceso,$usuario)
  {
	$mensaje="";
  
	$sql="";  
	$sql=$sql." UPDATE "; 
	$sql=$sql." proceso "; 
	$sql=$sql." SET "; 
	$sql=$sql." Vigencia='".$POST["Vigencia"]."',FechaModificacion='".date("Y/m/d H:i")."', "; 
	$sql=$sql." UsuarioModificacion='".$usuario."',Objeto='".$POST["Objeto"]."',EntidadProponente='".$POST["EntidadProponente"]."', "; 
	$sql=$sql." Cobertura='".$POST["Cobertura"]."',IdEstadoProyecto=".$POST["valorEstadoProceso"].",FechaApertura='".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."',  "; 
	$sql=$sql." LineaEstrategica='".$POST["LineaEstrategica"]."',Cuantia='".$POST["valorCuantia"]."', "; 
	$sql=$sql." ValorFontur='".$POST["ValorFontur"]."',ValorAprobado='".$POST["ValorAprobado"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProceso=".$IdProceso; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	
	$mensaje="Proyecto actualizado exitosamente.";
    return $mensaje;
  }


  /*
  crearAdjuntoContrato
  */	
  public static function crearAdjuntoContrato($POST,$IdProceso,$Archivo,$usuario)
  {
	$sql="";  
	$sql=$sql." INSERT INTO proceso_adjunto "; 
	$sql=$sql." ( "; 
	$sql=$sql." IdTipoDocumento,IdProceso,Archivo, "; 
	$sql=$sql." FechaRegistro,UsuarioRegistro,FechaModificacion, "; 
	$sql=$sql." UsuarioModificacion,Activo,LlaveRegistro, "; 
	$sql=$sql." Numero,Nombre "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." ( "; 
	$sql=$sql." ".$POST["valorTipoProceso"].",".$IdProceso.",'".$Archivo."', "; 
	$sql=$sql." '".date("Y/m/d H:i")."','".$usuario."','".date("Y/m/d H:i")."', "; 
	$sql=$sql." '".$usuario."',1,'".rand(111111,999999)."', "; 
	$sql=$sql." '".$POST["valorNroAdjuntoContrato"]."','".$POST["valorObjetoAdjunto"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }

  /*
  borrarAdjuntoContrato
  */	
  public static function borrarAdjuntoContrato( $IdProcesoAdjunto,$LlaveRegistro)
  {
	$sql="";  
	$sql=$sql." DELETE FROM proceso_adjunto "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProcesoAdjunto=".$IdProcesoAdjunto; 
	$sql=$sql." AND LlaveRegistro='".$LlaveRegistro."' "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }

  /*
  borrarContrato
  */	
  public static function borrarContrato( $IdProceso,$Numero)
  {
	$sql="";  
	$sql=$sql." DELETE FROM proceso "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProceso=".$IdProceso; 
	$sql=$sql." AND Numero='".$Numero."' "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }
  
  /*
  ingresarLog
  */	
  public static function ingresarLog( $Usuario,$Detalle)
  {
	$sql="";  
	$sql=$sql." INSERT INTO  log  "; 
	$sql=$sql." (Usuario,Detalle)  "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." ('".$Usuario."','".$Detalle."')  "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }
  
  /*
  crearProcesoContrato
  */	
  public static  function crearProcesoContrato($POST,$usuario,$TipoProceso)
  {
	$mensaje="";
	
	//validar que no exista el contrato
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." IdProceso ";  
	$sql=$sql." FROM  proceso ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
     
	if(count($listado) == 0)
	 {
	   //crear
	   $sql="";
	   $sql=$sql." INSERT INTO proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." Codigo,IdTipoProceso,IdDependencia, "; 
	   $sql=$sql." Numero,FechaApertura,FechaCierre, "; 
	   $sql=$sql." IdMoneda,Cuantia,Objeto, "; 
	   $sql=$sql." Activo,UsuarioRegistro,UsuarioModificacion, "; 
	   $sql=$sql." LlaveRegistro,FechaModificacion,TipoProceso "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$POST["valorMunicipioProceso"].",".$POST["valorTipoProceso"].",".$POST["valorDependenciaProceso"].", "; 
	   $sql=$sql." '".$POST["valorContrato"]."','".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."','".Proceso::formatoFechaYMD($POST["valorFechaCierre"])."', "; 
	   $sql=$sql." ".$POST["valorMonedaProceso"].",'".$POST["valorCuantia"]."','".$POST["valorObjeto"]."', "; 
	   $sql=$sql." 1,'".$usuario."','".$usuario."', "; 
	   $sql=$sql." '".rand(111111,999999)."','".date("Y/m/d H:i")."', ".$TipoProceso." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   //conseguir el ID contrato
	   $IdProceso="0";
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdProceso ";  
	   $sql=$sql." FROM  proceso ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   foreach ($listado as $row)
	    {
		   $IdProceso=$row->IdProceso;
	    }
	   
	   $sql="";  
	   $sql=$sql." INSERT INTO estado_proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." IdProceso,IdEstado,LlaveRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$IdProceso.",".$POST["valorEstadoProceso"].",'".rand(111111,999999)."', "; 
	   $sql=$sql." '".$usuario."',1 "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Contrato creado exitosamente.";
	 }		
	else
	 {
		$mensaje="Error. Ya existe el número de contrato ".$POST["valorContrato"];
	 }
	 
	return $mensaje;
  }

  /*
  crearProcesoProyectoContrato
  */	
  public static  function crearProcesoProyectoContrato($POST,$usuario,$TipoProceso)
  {
	$mensaje="";
	
	//validar que no exista el contrato
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." IdProceso ";  
	$sql=$sql." FROM  proceso ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
     
	if(count($listado) == 0)
	 {
	   //crear
	   $sql="";
	   $sql=$sql." INSERT INTO proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." Numero,Vigencia,Objeto, "; 
	   $sql=$sql." EntidadProponente,Cobertura, IdEstadoProyecto, "; 
	   $sql=$sql." FechaApertura, LineaEstrategica,Cuantia, "; 
	   $sql=$sql." ValorFontur, ValorAprobado,TipoProceso ,LlaveRegistro , "; 
	   $sql=$sql." UsuarioRegistro,UsuarioModificacion,FechaRegistro, FechaModificacion , Activo "; 
	   $sql=$sql."  "; 
	   $sql=$sql."  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  '".$POST["valorContrato"]."','".$POST["Vigencia"]."','".$POST["Objeto"]."',  "; 
	   $sql=$sql." '".$POST["EntidadProponente"]."','".$POST["Cobertura"]."' , ".$POST["valorEstadoProceso"]."  , "; 
	   $sql=$sql." '".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."','".$POST["LineaEstrategica"]."' ,'".$POST["valorCuantia"]."', "; 
	   $sql=$sql." '".$POST["ValorFontur"]."','".$POST["ValorAprobado"]."', ".$TipoProceso.",'".rand(111111,999999)."',  "; 
	   $sql=$sql." '".$usuario."','".$usuario."','".date("Y/m/d H:i")."' , '".date("Y/m/d H:i")."', 1 "; 
	   $sql=$sql." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Proyecto creado exitosamente.";
	 }		
	else
	 {
		$mensaje="Error. Ya existe el número de contrato ".$POST["valorContrato"];
	 }
	 
	return $mensaje;
  }

  
  /*
  reemplazar
  */
  public static function reemplazar($cadena)
  {
	$cadena=str_replace("-","",$cadena);  
	$cadena=str_replace("'","",$cadena);  
	return $cadena;  
  }

 /*
 formatoFechaYMD | llega dd/MM/YYYY
 */
 public static function formatoFechaYMD($fecha)
 {
   if(trim($fecha)!="")
    {
      return substr($fecha, 6,4)."/".substr($fecha, 3, 2)."/".substr($fecha, 0, 2);
    }
   else
    {
	  return "";  
    }	   
 }
 
 /*
 formatoFechaDMY | llega YYYY/MM/dd
 */
 public static function formatoFechaDMY($fecha)
 {
   if(trim($fecha)!="")
    {
      return substr($fecha, 8, 2)."/".substr($fecha, 5, 2)."/".substr($fecha, 0, 4)  ;
    }
   else
    {
	  return ""; 
    }	   
 }
  
  
  /*
  borrarUsuarios
  */	
  public static  function borrarUsuarios($POST)
  {
	$sql = " DELETE FROM  perfil WHERE IdPerfil=3";
	DB::unprepared($sql);  
    return "1";
  }
  
}
