<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Pqr;

class PqrD extends Controller
{
  /*
  index | listado
  */	
  public function index(Request $request)
  {
    ini_set('memory_limit', '-1');
      
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	 
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$paginaActual = $request->input('paginaActual', '1');
	$paginaActualId = $request->input('paginaActualId', '1');
	
	$tipoSolicitudFiltro = $request->input('tipoSolicitudFiltro', '');
	$busquedaSolicitudFiltro = $request->input('busquedaSolicitudFiltro', '');
	$consultaFiltro = $request->input('consultaFiltro', '');
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$ingresarSolicitudMisional = $request->input('ingresarSolicitudMisional', '');
	$ingresarDelegacionMasivaSolicitud = $request->input('ingresarDelegacionMasivaSolicitud', '');
	$valorFechaDesde = $request->input('valorFechaDesde', '');
	$valorFechaHasta = $request->input('valorFechaHasta', '');
	$valorFechaFiltro = $request->input('valorFechaFiltro', '');
	$valorColorFechaVencimiento = $request->input('valorColorFechaVencimiento', '');
	$generarDescargaDatos = $request->input('generarDescargaDatos', '');

	$busquedaDocumento = $request->input('busquedaDocumento', '');
	$busquedaNombre = $request->input('busquedaNombre', '');
	$busquedaEmail = $request->input('busquedaEmail', '');
	$busquedaUsuario = $request->input('busquedaUsuario', '');
	$valorEstado = $request->input('valorEstado', '');
	$IdSolicitudBorrar = $request->input('IdSolicitudBorrar', '');
	$IdentificacionBorrar = $request->input('IdentificacionBorrar', '');
	$IdSolicitudProcesoRechazar = $request->input('IdSolicitudProcesoRechazar', '');
	$valorCambioOrigen = $request->input('valorCambioOrigen', '');
	
	$post['valorTipo'] = $request->input('valorTipo', '');
	$post['valorNombreCompleto'] = $request->input('valorNombreCompleto', '');
	$post['valorIdentificacion'] = $request->input('valorIdentificacion', '');
	$post['valorEmailicitud'] = $request->input('valorEmailicitud', '');

	$post['valorSolicitante'] = $request->input('valorSolicitante', '');
	$post['valorRecibirRespuesta'] = $request->input('valorRecibirRespuesta', '');
	$post['valorClaseSolicitud'] = $request->input('valorClaseSolicitud', '');
	$post['valorDireccion'] = $request->input('valorDireccion', '');
	$post['valorTelefono'] = $request->input('valorTelefono', '');
	$post['valorTipoidentificacion'] = $request->input('valorTipoidentificacion', '');
	$post['valorSegundoApellido'] = $request->input('valorSegundoApellido', '');
	$post['valorPrimerApellido'] = $request->input('valorPrimerApellido', '');
	$post['valorSegundoNombre'] = $request->input('valorSegundoNombre', '');
	$post['valorPrimerNombre'] = $request->input('valorPrimerNombre', '');
	$post['valorTipoRecepcion'] = $request->input('valorTipoRecepcion', '');
	$post['valorUsuario'] = $request->input('valorUsuario', '');
	$post['valorCambioOrigen'] = $request->input('valorCambioOrigen', '');
	
	$archivo = $request->file('archivo');
	$archivo2 = $request->file('archivo2');
	$archivo3 = $request->file('archivo3');
	$archivo4 = $request->file('archivo4');
	$archivo5 = $request->file('archivo5');
	$archivo6 = $request->file('archivo6');
	$archivo7 = $request->file('archivo7');
	$archivo8 = $request->file('archivo8');
	$archivo9 = $request->file('archivo9');
	$archivo10 = $request->file('archivo10');
	$post['valorSolicitud'] = $request->input('valorSolicitud', '');
	
	if(trim($tipoSolicitudFiltro)=="" && trim($request->session()->get('tipoSolicitudFiltro'))=="")
	 {
	   $tipoSolicitudFiltro="2"; //por defecto recaudo	
	   $request->session()->put('tipoSolicitudFiltro',$tipoSolicitudFiltro); // 1 MISIONAL | 2 parafiscal
	   $request->session()->put('busquedaSolicitudFiltro',"");
	 }  
	
	if(trim($consultaFiltro)=="1")
	 {
	    $request->session()->put('tipoSolicitudFiltro',$tipoSolicitudFiltro);	
	    $request->session()->put('busquedaSolicitudFiltro',$busquedaSolicitudFiltro);	
	    $request->session()->put('valorFechaDesde',$valorFechaDesde);	
	    $request->session()->put('valorFechaHasta',$valorFechaHasta);	
	    $request->session()->put('valorFechaFiltro',$valorFechaFiltro);	
	    $request->session()->put('busquedaDocumento',$busquedaDocumento);	
	    $request->session()->put('busquedaNombre',$busquedaNombre);	
	    $request->session()->put('busquedaEmail',$busquedaEmail);	
	    $request->session()->put('busquedaUsuario',$busquedaUsuario);	
	    $request->session()->put('valorEstado',$valorEstado);	
	    $request->session()->put('valorColorFechaVencimiento',$valorColorFechaVencimiento);	
	    $request->session()->put('valorCambioOrigen',$valorCambioOrigen);	
	 } 

	//adjunto 1 
	$archivoAdjuntoSolicitud="";
	if($archivo!="")
	 {
	  if( $archivo->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo->move($destinationPath,$llaveArchivo.$archivo->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud=$llaveArchivo.$archivo->getClientOriginalName();
	   }			  
	 }

	//adjunto 2 
	$archivoAdjuntoSolicitud2="";
	if($archivo2!="")
	 {
	  if( $archivo2->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo2->move($destinationPath,$llaveArchivo.$archivo2->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud2=$llaveArchivo.$archivo2->getClientOriginalName();
	   }			  
	 }

	//adjunto 3 
	$archivoAdjuntoSolicitud3="";
	if($archivo3!="")
	 {
	  if( $archivo3->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo3->move($destinationPath,$llaveArchivo.$archivo3->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud3=$llaveArchivo.$archivo3->getClientOriginalName();
	   }			  
	 }

	//adjunto 4 
	$archivoAdjuntoSolicitud4="";
	if($archivo4!="")
	 {
	  if( $archivo4->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo4->move($destinationPath,$llaveArchivo.$archivo4->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud4=$llaveArchivo.$archivo4->getClientOriginalName();
	   }			  
	 }
	 
	//adjunto 5 
	$archivoAdjuntoSolicitud5="";
	if($archivo5!="")
	 {
	  if( $archivo5->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo5->move($destinationPath,$llaveArchivo.$archivo5->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud5=$llaveArchivo.$archivo5->getClientOriginalName();
	   }			  
	 }

	//adjunto 6 
	$archivoAdjuntoSolicitud6="";
	if($archivo6!="")
	 {
	  if( $archivo6->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo6->move($destinationPath,$llaveArchivo.$archivo6->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud6=$llaveArchivo.$archivo6->getClientOriginalName();
	   }			  
	 }

	//adjunto 7 
	$archivoAdjuntoSolicitud7="";
	if($archivo7!="")
	 {
	  if( $archivo7->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo7->move($destinationPath,$llaveArchivo.$archivo7->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud7=$llaveArchivo.$archivo7->getClientOriginalName();
	   }			  
	 }

	//adjunto 8 
	$archivoAdjuntoSolicitud8="";
	if($archivo8!="")
	 {
	  if( $archivo8->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo8->move($destinationPath,$llaveArchivo.$archivo8->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud8=$llaveArchivo.$archivo8->getClientOriginalName();
	   }			  
	 }
	 
	//adjunto 9 
	$archivoAdjuntoSolicitud9="";
	if($archivo9!="")
	 {
	  if( $archivo9->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);	
		 $archivo9->move($destinationPath,$llaveArchivo.$archivo9->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud9=$llaveArchivo.$archivo9->getClientOriginalName();
	   }			  
	 }

	//adjunto 10 
	$archivoAdjuntoSolicitud10="";
	if($archivo10!="")
	 {
	  if( $archivo10->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png")
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo10->move($destinationPath,$llaveArchivo.$archivo10->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud10=$llaveArchivo.$archivo10->getClientOriginalName();
	   }			  
	 }
	
	//ingresar  RECAUDO | Contribucin parafiscal
	if(trim($ingresarSolicitud)=="1")
	 {
	   //ingresar 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearProcesoSolicitud($post,$archivoAdjuntoSolicitud,$archivoAdjuntoSolicitud2,$archivoAdjuntoSolicitud3,$archivoAdjuntoSolicitud4,$archivoAdjuntoSolicitud5,$archivoAdjuntoSolicitud6,$archivoAdjuntoSolicitud7,$archivoAdjuntoSolicitud8,$archivoAdjuntoSolicitud9,$archivoAdjuntoSolicitud10,$request->session()->get('usuarioFontur'));
	 }

	//ingresar  MISIONAL
	if(trim($ingresarSolicitudMisional)=="1")
	 {
	   //ingresar contacto MISIONAL 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearProcesoSolicitudMisional($post,$archivoAdjuntoSolicitud,$archivoAdjuntoSolicitud2,$archivoAdjuntoSolicitud3,$request->session()->get('usuarioFontur'));
	 }
	
	//delegacion masiva
	if(trim($ingresarDelegacionMasivaSolicitud)=="1")
	 {
		$mensajeTipo="1";
	    $mensaje=Pqr::crearDelegadoMasivoSolicitud($request->session()->get('tipoSolicitudFiltro'),$post['valorClaseSolicitud'],$post['valorUsuario'],$request->session()->get('usuarioFontur'));
	 }

	//borrar solicitud
	if(trim($IdSolicitudBorrar)!="" && trim($IdentificacionBorrar)!="")
	 {
	   //borrar 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::borrarSolicitudInterna($IdSolicitudBorrar,$IdentificacionBorrar);
	 }

	//rechazar solicitud
	if(trim($IdSolicitudProcesoRechazar)!="")
	 {
	   //rechazar 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::rechazarSolicitudProceso($IdSolicitudProcesoRechazar,$request->session()->get('usuarioFontur'));
	 }

    if(trim($request->session()->get('tipoSolicitudFiltro'))!="1")
     {
       //no es admin
       if(trim($request->session()->get('usuarioFonturMisional'))=="1")
        {
           //misional
           $request->session()->put('tipoSolicitudFiltro',"1");
        }
       
       if(trim($request->session()->get('usuarioFonturParafiscal'))=="1")
        {
           //parafiscal
           $request->session()->put('tipoSolicitudFiltro',"2");
        }
     }

	//listado de solicitudes  
	$nombreArchivoDescarga="descarga_".date("YmdHi").rand(111111,999999).".csv"; 
	$listadoPQR= Pqr::listadoColorPQR(trim($request->session()->get('busquedaSolicitudFiltro')),$request->session()->get('tipoSolicitudFiltro'),$request->session()->get('valorFechaDesde'),$request->session()->get('valorFechaHasta'),$request->session()->get('valorFechaFiltro'),$request->session()->get('busquedaDocumento'),$request->session()->get('busquedaNombre'),$request->session()->get('busquedaEmail'),$request->session()->get('busquedaUsuario'),$request->session()->get('valorEstado'),$generarDescargaDatos,$nombreArchivoDescarga,$paginaActual,$request->session()->get('valorColorFechaVencimiento'),$request->session()->get('valorCambioOrigen')); // 1 MISIONAL | 2 parafiscal

	//listado tipo identificacion
	$listadoTipoIdentificacionPQR= Pqr::listadoTipoIdentificacion();
	//listado clase solicitud
	$listadoClaseSolicitudPQR= Pqr::listadoClaseSolicitudFiltroPQR($request->session()->get('tipoSolicitudFiltro'));
	//listado respuesta
	$listadoRespuestaPQR= Pqr::listadoRespuestaPQR();
	//listado tipo recepcion
	$listadoTipoRecepcionPQR= Pqr::listadoTipoRecepcionFiltroPQR($request->session()->get('tipoSolicitudFiltro'));
    //listado usuarios x dependencias
	$listadoUsuariosXDependencia= Pqr::listadoUsuariosXDependencia();
	//listado estados
	$listadoEstados= Pqr::listadoEstadosXTipoSolicitudPQR($request->session()->get('tipoSolicitudFiltro'));
	//funcionarios  
	$listadoFuncionarios= Pqr::listadoFuncionariosXTipoSolicitud($request->session()->get('tipoSolicitudFiltro')); // 1 MISIONAL | 2 parafiscal
	
	//detalle proceso
	/*
	$registro= Contratos::detalleProceso($IdProceso);
	*/
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoPQR'] = $listadoPQR;
	$parametros['tipoSolicitudFiltro'] = $request->session()->get('tipoSolicitudFiltro');
	$parametros['valorFechaDesde'] = $request->session()->get('valorFechaDesde');
	$parametros['valorFechaHasta'] = $request->session()->get('valorFechaHasta');
	$parametros['valorFechaFiltro'] = $request->session()->get('valorFechaFiltro');
	$parametros['valorColorFechaVencimiento'] = $request->session()->get('valorColorFechaVencimiento');
	$parametros['busquedaSolicitudFiltro'] = $request->session()->get('busquedaSolicitudFiltro');
	$parametros['busquedaDocumento'] = $request->session()->get('busquedaDocumento');
	$parametros['busquedaNombre'] = $request->session()->get('busquedaNombre');
	$parametros['busquedaEmail'] = $request->session()->get('busquedaEmail');
	$parametros['busquedaUsuario'] = $request->session()->get('busquedaUsuario');
	$parametros['valorEstado'] = $request->session()->get('valorEstado');
	$parametros['valorCambioOrigen'] = $request->session()->get('valorCambioOrigen');
	$parametros['listadoTipoIdentificacionPQR'] = $listadoTipoIdentificacionPQR;
	$parametros['listadoClaseSolicitudPQR'] = $listadoClaseSolicitudPQR;
	$parametros['listadoRespuestaPQR'] = $listadoRespuestaPQR;
	$parametros['listadoTipoRecepcionPQR'] = $listadoTipoRecepcionPQR;
	$parametros['listadoUsuariosXDependencia'] = $listadoUsuariosXDependencia;
	$parametros['listadoEstados'] = $listadoEstados;
	$parametros['nombreArchivoDescarga'] = $nombreArchivoDescarga;
	$parametros['generarDescargaDatos'] = $generarDescargaDatos;
	$parametros['listadoFuncionarios'] = $listadoFuncionarios;
	$parametros['paginaActual'] = $paginaActual;
	$parametros['paginaActualId'] = $paginaActualId;
	$parametros['UsuariosVacaciones'] = $request->session()->get('UsuariosVacaciones');
	$parametros['usuarioFonturPerfil'] = $request->session()->get('usuarioFonturPerfil');
	/*
	$parametros['registro'] = $registro;
	*/
	return view("pqrlistado",$parametros);    
  }

  /*
  parafiscal
  */	
  public function parafiscal(Request $request)
  {
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$tipoSolicitudFiltro = $request->input('tipoSolicitudFiltro', '');
	$busquedaSolicitudFiltro = $request->input('busquedaSolicitudFiltro', '');
	$consultaFiltro = $request->input('consultaFiltro', '');
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$ingresarSolicitudMisional = $request->input('ingresarSolicitudMisional', '');
	$ingresarDelegacionMasivaSolicitud = $request->input('ingresarDelegacionMasivaSolicitud', '');
	$valorFechaDesde = $request->input('valorFechaDesde', '');
	$valorFechaHasta = $request->input('valorFechaHasta', '');
	
	$post['valorTipo'] = Pqr::reemplazar($request->input('valorTipo', ''));
	$post['valorNombreCompleto'] = Pqr::reemplazar($request->input('valorNombreCompleto', ''));
	$post['valorIdentificacion'] = Pqr::reemplazar($request->input('valorIdentificacion', ''));
	$post['valorEmailicitud'] = Pqr::reemplazar($request->input('valorEmailicitud', ''));

	$post['valorSolicitante'] = Pqr::reemplazar($request->input('valorSolicitante', ''));
	$post['valorRecibirRespuesta'] = Pqr::reemplazar($request->input('valorRecibirRespuesta', ''));
	$post['valorClaseSolicitud'] = Pqr::reemplazar($request->input('valorClaseSolicitud', ''));
	$post['valorDireccion'] = Pqr::reemplazar($request->input('valorDireccion', ''));
	$post['valorTelefono'] = Pqr::reemplazar($request->input('valorTelefono', ''));
	$post['valorTipoidentificacion'] = Pqr::reemplazar($request->input('valorTipoidentificacion', ''));
	$post['valorSegundoApellido'] = Pqr::reemplazar($request->input('valorSegundoApellido', ''));
	$post['valorPrimerApellido'] = Pqr::reemplazar($request->input('valorPrimerApellido', ''));
	$post['valorSegundoNombre'] = Pqr::reemplazar($request->input('valorSegundoNombre', ''));
	$post['valorPrimerNombre'] = Pqr::reemplazar($request->input('valorPrimerNombre', ''));
	$post['valorTipoRecepcion'] = Pqr::reemplazar($request->input('valorTipoRecepcion', ''));
	$post['valorUsuario'] = Pqr::reemplazar($request->input('valorUsuario', ''));
	
	$archivo = $request->file('archivo');
	$archivo2 = $request->file('archivo2');
	$archivo3 = $request->file('archivo3');
	$archivo4 = $request->file('archivo4');
	$archivo5 = $request->file('archivo5');
	$archivo6 = $request->file('archivo6');
	$archivo7 = $request->file('archivo7');
	$archivo8 = $request->file('archivo8');
	$archivo9 = $request->file('archivo9');
	$archivo10 = $request->file('archivo10');
	$post['valorSolicitud'] = $request->input('valorSolicitud', '');
	
	$request->session()->put('tipoSolicitudFiltro',"2"); // 1 MISIONAL | 2 parafiscal
	
	//adjunto 1 
	$archivoAdjuntoSolicitud="";
	if($archivo!="")
	 {
	  if( $archivo->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png") 
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo->move($destinationPath,$llaveArchivo.$archivo->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud=$llaveArchivo.$archivo->getClientOriginalName();
	   }			  
	 }

	//adjunto 2 
	$archivoAdjuntoSolicitud2="";
	if($archivo2!="")
	 {
	  if( $archivo2->getClientOriginalExtension() == "pdf" || $archivo2->getClientOriginalExtension() == "jpg" || $archivo2->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo2->move($destinationPath,$llaveArchivo.$archivo2->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud2=$llaveArchivo.$archivo2->getClientOriginalName();
	   }			  
	 }

	//adjunto 3 
	$archivoAdjuntoSolicitud3="";
	if($archivo3!="")
	 {
	  if( $archivo3->getClientOriginalExtension() == "pdf" || $archivo3->getClientOriginalExtension() == "jpg" || $archivo3->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo3->move($destinationPath,$llaveArchivo.$archivo3->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud3=$llaveArchivo.$archivo3->getClientOriginalName();
	   }			  
	 }

	//adjunto 4 
	$archivoAdjuntoSolicitud4="";
	if($archivo4!="")
	 {
	  if( $archivo4->getClientOriginalExtension() == "pdf" || $archivo4->getClientOriginalExtension() == "jpg" || $archivo4->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo4->move($destinationPath,$llaveArchivo.$archivo4->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud4=$llaveArchivo.$archivo4->getClientOriginalName();
	   }			  
	 }

	//adjunto 5 
	$archivoAdjuntoSolicitud5="";
	if($archivo5!="")
	 {
	  if( $archivo5->getClientOriginalExtension() == "pdf" || $archivo5->getClientOriginalExtension() == "jpg" || $archivo5->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo5->move($destinationPath,$llaveArchivo.$archivo5->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud5=$llaveArchivo.$archivo5->getClientOriginalName();
	   }			  
	 }

	//adjunto 6 
	$archivoAdjuntoSolicitud6="";
	if($archivo6!="")
	 {
	  if( $archivo6->getClientOriginalExtension() == "pdf" || $archivo6->getClientOriginalExtension() == "jpg" || $archivo6->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo6->move($destinationPath,$llaveArchivo.$archivo6->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud6=$llaveArchivo.$archivo6->getClientOriginalName();
	   }			  
	 }

	//adjunto 7 
	$archivoAdjuntoSolicitud7="";
	if($archivo7!="")
	 {
	  if( $archivo7->getClientOriginalExtension() == "pdf" || $archivo7->getClientOriginalExtension() == "jpg" || $archivo7->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo7->move($destinationPath,$llaveArchivo.$archivo7->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud7=$llaveArchivo.$archivo7->getClientOriginalName();
	   }			  
	 }

	//adjunto 8 
	$archivoAdjuntoSolicitud8="";
	if($archivo8!="")
	 {
	  if( $archivo8->getClientOriginalExtension() == "pdf" || $archivo8->getClientOriginalExtension() == "jpg" || $archivo8->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo8->move($destinationPath,$llaveArchivo.$archivo8->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud8=$llaveArchivo.$archivo8->getClientOriginalName();
	   }			  
	 }

	//adjunto 9 
	$archivoAdjuntoSolicitud9="";
	if($archivo9!="")
	 {
	  if( $archivo9->getClientOriginalExtension() == "pdf" || $archivo9->getClientOriginalExtension() == "jpg" || $archivo9->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo9->move($destinationPath,$llaveArchivo.$archivo9->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud9=$llaveArchivo.$archivo9->getClientOriginalName();
	   }			  
	 }
	 
	//adjunto 10 
	$archivoAdjuntoSolicitud10="";
	if($archivo10!="")
	 {
	  if( $archivo10->getClientOriginalExtension() == "pdf" || $archivo10->getClientOriginalExtension() == "jpg" || $archivo10->getClientOriginalExtension() == "png" )
	   {
		 $destinationPath = 'assets/pdf';
		 $llaveArchivo=date("YmdHi").rand(1111,9999);
		 $archivo10->move($destinationPath,$llaveArchivo.$archivo10->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud10=$llaveArchivo.$archivo10->getClientOriginalName();
	   }			  
	 }
	 
	//ingresar  
	if(trim($ingresarSolicitud)=="1")
	 {
	   //ingresar 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearProcesoSolicitud($post,$archivoAdjuntoSolicitud,$archivoAdjuntoSolicitud2,$archivoAdjuntoSolicitud3,$archivoAdjuntoSolicitud4,$archivoAdjuntoSolicitud5,$archivoAdjuntoSolicitud6,$archivoAdjuntoSolicitud7,$archivoAdjuntoSolicitud8,$archivoAdjuntoSolicitud9,$archivoAdjuntoSolicitud10,"PORTAL"); 
	   $request->session()->put('tokenVerificacionComunicatte',rand(1111,9999));
	 }
	else
	 {
	   $request->session()->put('tokenVerificacionComunicatte',rand(1111,9999));		
	 }

	//listado tipo identificacion
	$listadoTipoIdentificacionPQR= Pqr::listadoTipoIdentificacion();
	//listado clase solicitud
	$listadoClaseSolicitudPQR= Pqr::listadoClaseSolicitudFiltroPQR($request->session()->get('tipoSolicitudFiltro'));
	//listado respuesta
	$listadoRespuestaPQR= Pqr::listadoRespuestaPQR();
	//listado tipo recepcion
	$listadoTipoRecepcionPQR= Pqr::listadoTipoRecepcionFiltroPQR($request->session()->get('tipoSolicitudFiltro'));
    //listado usuarios x dependencias
	$listadoUsuariosXDependencia= Pqr::listadoUsuariosXDependencia();
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['tipoSolicitudFiltro'] = $request->session()->get('tipoSolicitudFiltro');
	$parametros['tokenVerificacionComunicatte'] = $request->session()->get('tokenVerificacionComunicatte');
	$parametros['listadoTipoIdentificacionPQR'] = $listadoTipoIdentificacionPQR;
	$parametros['listadoClaseSolicitudPQR'] = $listadoClaseSolicitudPQR;
	$parametros['listadoRespuestaPQR'] = $listadoRespuestaPQR;
	$parametros['listadoTipoRecepcionPQR'] = $listadoTipoRecepcionPQR;
	$parametros['listadoUsuariosXDependencia'] = $listadoUsuariosXDependencia;
	return view("parafiscal",$parametros);    
  }
  
  
  /*
  misional
  */	
  public function misional(Request $request)
  {
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$tipoSolicitudFiltro = $request->input('tipoSolicitudFiltro', '');
	$busquedaSolicitudFiltro = $request->input('busquedaSolicitudFiltro', '');
	$consultaFiltro = $request->input('consultaFiltro', '');
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$ingresarSolicitudMisional = $request->input('ingresarSolicitudMisional', '');
	$ingresarDelegacionMasivaSolicitud = $request->input('ingresarDelegacionMasivaSolicitud', '');
	$valorFechaDesde = $request->input('valorFechaDesde', '');
	$valorFechaHasta = $request->input('valorFechaHasta', '');
	
	$post['valorTipo'] = Pqr::reemplazar($request->input('valorTipo', ''));
	$post['valorNombreCompleto'] = Pqr::reemplazar($request->input('valorNombreCompleto', ''));
	$post['valorIdentificacion'] = Pqr::reemplazar($request->input('valorIdentificacion', ''));
	$post['valorEmailicitud'] = Pqr::reemplazar($request->input('valorEmailicitud', ''));

	$post['valorSolicitante'] = Pqr::reemplazar($request->input('valorSolicitante', ''));
	$post['valorRecibirRespuesta'] = Pqr::reemplazar($request->input('valorRecibirRespuesta', ''));
	$post['valorClaseSolicitud'] = Pqr::reemplazar($request->input('valorClaseSolicitud', ''));
	$post['valorDireccion'] = Pqr::reemplazar($request->input('valorDireccion', ''));
	$post['valorTelefono'] = Pqr::reemplazar($request->input('valorTelefono', ''));
	$post['valorTipoidentificacion'] =Pqr::reemplazar($request->input('valorTipoidentificacion', ''));
	$post['valorSegundoApellido'] = Pqr::reemplazar($request->input('valorSegundoApellido', ''));
	$post['valorPrimerApellido'] = Pqr::reemplazar($request->input('valorPrimerApellido', ''));
	$post['valorSegundoNombre'] = Pqr::reemplazar($request->input('valorSegundoNombre', ''));
	$post['valorPrimerNombre'] = Pqr::reemplazar($request->input('valorPrimerNombre', ''));
	$post['valorTipoRecepcion'] =Pqr::reemplazar($request->input('valorTipoRecepcion', ''));
	$post['valorUsuario'] = Pqr::reemplazar($request->input('valorUsuario', ''));
	
	$archivo = $request->file('archivo');
	$archivo2 = $request->file('archivo2');
	$archivo3 = $request->file('archivo3');
	$post['valorSolicitud'] = Pqr::reemplazar($request->input('valorSolicitud', ''));
	
	$request->session()->put('tipoSolicitudFiltro',"1"); // 1 MISIONAL | 2 parafiscal
	
	//adjunto 1 
	$archivoAdjuntoSolicitud="";
	if($archivo!="")
	 {
	  if( $archivo->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "jpg"  || $archivo->getClientOriginalExtension() == "png") 
	   {
		 $destinationPath = 'assets/pdf';
		 $archivo->move($destinationPath,$archivo->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud=$archivo->getClientOriginalName();
	   }			  
	 }

	//adjunto 2 
	$archivoAdjuntoSolicitud2="";
	if($archivo2!="")
	 {
	  if( $archivo2->getClientOriginalExtension() == "pdf" || $archivo2->getClientOriginalExtension() == "jpg"  || $archivo2->getClientOriginalExtension() == "png") 
	   {
		 $destinationPath = 'assets/pdf';
		 $archivo2->move($destinationPath,$archivo2->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud2=$archivo2->getClientOriginalName();
	   }			  
	 }

	//adjunto 3 
	$archivoAdjuntoSolicitud3="";
	if($archivo3!="")
	 {
	  if( $archivo3->getClientOriginalExtension() == "pdf" || $archivo3->getClientOriginalExtension() == "jpg"  || $archivo3->getClientOriginalExtension() == "png") 
	   {
		 $destinationPath = 'assets/pdf';
		 $archivo3->move($destinationPath,$archivo3->getClientOriginalName());	  
		 $archivoAdjuntoSolicitud3=$archivo3->getClientOriginalName();
	   }			  
	 }
	 
	//ingresar  MISIONAL
	if(trim($ingresarSolicitudMisional)=="1")
	 {
	   //ingresar contacto MISIONAL 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearProcesoSolicitudMisional($post,$archivoAdjuntoSolicitud,$archivoAdjuntoSolicitud2,$archivoAdjuntoSolicitud3,"PORTAL");
	   $request->session()->put('tokenVerificacionComunicatte',rand(1111,9999));
	 }
	else
	 {
	   $request->session()->put('tokenVerificacionComunicatte',rand(1111,9999));
	 }
	 
	//listado tipo identificacion
	$listadoTipoIdentificacionPQR= Pqr::listadoTipoIdentificacion();
	//listado clase solicitud
	$listadoClaseSolicitudPQR= Pqr::listadoClaseSolicitudFiltroPQR($request->session()->get('tipoSolicitudFiltro'));
	//listado respuesta
	$listadoRespuestaPQR= Pqr::listadoRespuestaPQR();
	//listado tipo recepcion
	$listadoTipoRecepcionPQR= Pqr::listadoTipoRecepcionFiltroPQR($request->session()->get('tipoSolicitudFiltro'));
    //listado usuarios x dependencias
	$listadoUsuariosXDependencia= Pqr::listadoUsuariosXDependencia();
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['tipoSolicitudFiltro'] = $request->session()->get('tipoSolicitudFiltro');
	$parametros['tokenVerificacionComunicatte'] = $request->session()->get('tokenVerificacionComunicatte');
	$parametros['listadoTipoIdentificacionPQR'] = $listadoTipoIdentificacionPQR;
	$parametros['listadoClaseSolicitudPQR'] = $listadoClaseSolicitudPQR;
	$parametros['listadoRespuestaPQR'] = $listadoRespuestaPQR;
	$parametros['listadoTipoRecepcionPQR'] = $listadoTipoRecepcionPQR;
	$parametros['listadoUsuariosXDependencia'] = $listadoUsuariosXDependencia;
	return view("misional",$parametros);    
  }

  /*
  seguimiento
  */	
  public function seguimiento(Request $request)
  {
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$consultarDatosSeguimiento = $request->input('consultarDatosSeguimiento', '');
	$post['valorNroRadicado'] = $request->input('valorNroRadicado', '');
	$post['valorEmail'] = $request->input('valorEmail', '');

	//listado tipo identificacion
	$listadoContactenosGeneral= Pqr::listadoSeguimientoSolicitud($post);
	//listado tipo identificacion
	$listadoContactenosSeguimiento= Pqr::listadoSeguimientoSolicitudDetalle($post);
	//listado adjuntos
	$listadoAdjuntos= Pqr::listadoAdjuntos($post['valorNroRadicado']);
	//listado estados
	$listadoEstado= Pqr::listadoEstadosSolicitud($post['valorNroRadicado']);
	
	$parametros['listadoContactenosGeneral'] = $listadoContactenosGeneral;
	$parametros['listadoContactenosSeguimiento'] = $listadoContactenosSeguimiento;
	$parametros['consultarDatosSeguimiento'] = $consultarDatosSeguimiento;
	$parametros['listadoAdjuntos'] = $listadoAdjuntos;
	$parametros['listadoEstado'] = $listadoEstado;
	return view("seguimiento",$parametros);    
  }
  
  /*
  detalle
  */	
  public function detalle(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	 
    //POST
	$dependenciaSeleccionada = $request->input('dependenciaSeleccionada', '0');
	$ingresarContrato = $request->input('ingresarContrato', '');
	$IdSolicitud = $request->input('IdSolicitud', '');
	$ingresarSeguimiento = $request->input('ingresarSeguimiento', '');
	$ingresarAdjunto = $request->input('ingresarAdjunto', '');
	$ingresarEstado = $request->input('ingresarEstado', '');
	$ingresarDelegado = $request->input('ingresarDelegado', '');
	$actualizarTipoSolicitud = $request->input('actualizarTipoSolicitud', '');
	$actualizarAplazado = $request->input('actualizarAplazado', '');
	$IdSolicitudProcesoRechazar = $request->input('IdSolicitudProcesoRechazar', '');
	
	$post['valorActuacion'] = $request->input('valorActuacion', '');
	$archivo = $request->file('archivo');
	$post['valorSolicitud'] = $request->input('valorSolicitud', '');
	$post['valorEstado'] = $request->input('valorEstado', '');
	$post['valorUsuario'] = $request->input('valorUsuario', '');
	$post['valorRevision'] = $request->input('valorRevision', '');
	$post['valorUsuarioRevisor'] = $request->input('valorUsuarioRevisor', '');
	$post['valorTipoSolicitudConfig'] = $request->input('valorTipoSolicitudConfig', '');
	$post['valorMotivo'] = $request->input('valorMotivo', '');
	$post['procesoAprobado'] = $request->input('procesoAprobado', '');
	$post['valorComentarioFuncionario'] = $request->input('valorComentarioFuncionario', '');
	$post['comentarioAplazado'] = $request->input('comentarioAplazado', '');
	
	if(trim($IdSolicitud)!="")
	 {
	   $request->session()->put('IdSolicitud',$IdSolicitud); 
	 }
	
	$archivoAdjuntoSolicitud="";
	if($archivo!="")
	 {
	   if( $archivo->getClientOriginalExtension() == "pdf" )
	    {
			 $destinationPath = 'assets/pdf';
			 $llaveArchivo=date("YmdHi").rand(1111,9999);	
			 $archivo->move($destinationPath,$llaveArchivo.$archivo->getClientOriginalName());	  
			 $archivoAdjuntoSolicitud=$llaveArchivo.$archivo->getClientOriginalName();
	    }			  
	 }
	
	//rechazar solicitud
	if(trim($IdSolicitudProcesoRechazar)!="")
	 {
	   //rechazar 	
	   $mensajeTipo="1";
	   $mensaje=Pqr::rechazarSolicitudProceso($IdSolicitudProcesoRechazar,$request->session()->get('usuarioFontur'));
	 }

	//ingresar seguimiento | resolver
	if(trim($ingresarSeguimiento)=="1")
	 {
	   //ingresar	 
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearSeguimientoSolicitud($post,$request->session()->get('IdSolicitud'),$archivoAdjuntoSolicitud,$request->session()->get('usuarioFontur'));
	 }

	//ingresar adjunto
	if(trim($ingresarAdjunto)=="1")
	 {
	   //ingresar	 
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearAdjuntosSolicitud($post,$request->session()->get('IdSolicitud'),$archivoAdjuntoSolicitud,$request->session()->get('usuarioFontur'));
	 }

	//ingresar estado
	if(trim($ingresarEstado)=="1")
	 {
	   //ingresar	 
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearEstadoSolicitud($post,$request->session()->get('IdSolicitud'),$request->session()->get('usuarioFontur'));
	 }

	//ingresar delegado
	if(trim($ingresarDelegado)=="1")
	 {
	   //ingresar	 
	   $mensajeTipo="1";
	   $mensaje=Pqr::crearDelegadoSolicitud($post,$request->session()->get('IdSolicitud'),$request->session()->get('usuarioFontur'));
	 }
	
	//actualizar tipo solicitud
	if(trim($actualizarTipoSolicitud)=="1")
	 {
	   $mensajeTipo="1";
	   $mensaje=Pqr::actualizarTipoSolicitud($post,$request->session()->get('IdSolicitud'),$request->session()->get('usuarioFontur'));
	 }

	//aplazar solicitud
	if(trim($actualizarAplazado)=="1")
	 {
	   $mensajeTipo="1";
	   //detalle solicitud 
	   $registro= Pqr::listadoDetallePQR($request->session()->get('IdSolicitud'));
	   $mensaje=Pqr::actualizarAplazado($post,$request->session()->get('IdSolicitud'),$request->session()->get('usuarioFontur'),$registro);
	 }
	 
	//consultar la actuacin actual
	$IdActuacionActual= Pqr::consultarActuacionActual($request->session()->get('IdSolicitud'));	
	 
	//detalle solicitud
	$registro= Pqr::listadoDetallePQR($request->session()->get('IdSolicitud'));
	//listado actuaciones
	$listadoActuaciones= Pqr::listadoActuaciones();
	//listado seguimientos
	$listadoSeguimientos= Pqr::listadoSeguimientos($request->session()->get('IdSolicitud'));
	//listado  dependencias
	$listadoDependencia= Pqr::listadoDependenciaXTipoSolicitud($request->session()->get('tipoSolicitudFiltro'));
	//listado usuarios x dependencias
	$listadoUsuariosXDependencia= Pqr::listadoUsuariosXDependenciaTipoFiltro($dependenciaSeleccionada,$request->session()->get('tipoSolicitudFiltro'));
	
	if($request->session()->get('tipoSolicitudFiltro')=="2")
	 {
	   //parafiscal	 
	   foreach ($listadoDependencia as $row) 
	    {
		  //cargar usuarios parafiscal dependencia por defecto
		  $listadoUsuariosXDependencia= Pqr::listadoUsuariosXDependenciaTipoFiltro($row->IdDependencia,$request->session()->get('tipoSolicitudFiltro'));
	    }
	 }
	
	//listado usuarios revisores 
	$listadoUsuariosTodos= Pqr::listadoUsuariosRevisoresTodos();
	//listado adjuntos
	$listadoAdjuntos= Pqr::listadoAdjuntos($request->session()->get('IdSolicitud'));
	//listado estados solicitud
	$listadoEstadosSolicitud= Pqr::listadoEstadosSolicitud($request->session()->get('IdSolicitud'));
	//listado delegados solicitud
	$listadoDelegadosSolicitud= Pqr::listadoDelegadosSolicitud($request->session()->get('IdSolicitud'));
	//semaforo solicitud
	$semaforoSolicitud= Pqr::semaforoEstadoActual($request->session()->get('IdSolicitud'));
	//listado estados | 1 MISIONAL | 2 PARAFISCAL
	$listadoEstados= Pqr::listadoEstadosXTipoSolicitudPQR($request->session()->get('tipoSolicitudFiltro'));
	
	//validar si esta en estado RESUELTO
	$DetalleEstado="";
	foreach ($registro as $row)
	 {
	   $DetalleEstado=$row->DetalleEstado; 
	   if(trim($DetalleEstado)=="RESUELTO")
	    {
	      //actualizar semaforo
	      Pqr::actualizarSolicitudSemaforoResuelto($request->session()->get('IdSolicitud'));
	    }
	 }
	
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['IdProceso'] = "0";
	$parametros['registro'] = $registro;
	$parametros['listadoActuaciones'] = $listadoActuaciones;
	$parametros['listadoSeguimientos'] = $listadoSeguimientos;
	$parametros['listadoEstados'] = $listadoEstados;
	$parametros['listadoEstadosSolicitud'] = $listadoEstadosSolicitud;
	$parametros['listadoAdjuntos'] = $listadoAdjuntos;
	$parametros['listadoUsuariosXDependencia'] = $listadoUsuariosXDependencia;
	$parametros['listadoDelegadosSolicitud'] = $listadoDelegadosSolicitud;
	$parametros['listadoUsuariosTodos'] = $listadoUsuariosTodos;
	$parametros['listadoDependencia'] = $listadoDependencia;
	$parametros['dependenciaSeleccionada'] = $dependenciaSeleccionada;
	$parametros['semaforoSolicitud'] = $semaforoSolicitud;
	$parametros['IdActuacionActual'] = $IdActuacionActual;
	$parametros['usuarioFonturNombreCompleto'] = $request->session()->get('usuarioFonturNombreCompleto');
	return view("pqrdetalle",$parametros);    
  }
  
  /*
  detalleProceso
  */
  /*
  function detalleProceso($IdProceso)
  {
	  $registro["IdProceso"]=$IdProceso; 
	  $registro["Codigo"]=""; 
	  $registro["IdTipoProceso"]=""; 
	  $registro["IdDependencia"]=""; 
      $registro["Numero"]="";  
	  $registro["FechaApertura"]=""; 
	  $registro["FechaCierre"]=""; 
	  $registro["IdMoneda"]=""; 
	  $registro["Cuantia"]="";  
	  $registro["Objeto"]=""; 
	  $registro["Activo"]=""; 
	  $registro["IdEstado"]=""; 
	  
	  if(trim($IdProceso)!="" && trim($IdProceso)!="0")
	   {
		  $listado=Proceso::listadoDetalleProceso($IdProceso);
		  foreach ($listado as $row) 
		   {
			  $registro["Codigo"]=$row->Codigo; 
			  $registro["IdTipoProceso"]=$row->IdTipoProceso; 
			  $registro["IdDependencia"]=$row->IdDependencia; 
			  $registro["Numero"]=$row->Numero; 
			  $registro["FechaApertura"]=Proceso::formatoFechaDMY($row->FechaApertura); 
			  $registro["FechaCierre"]=Proceso::formatoFechaDMY($row->FechaCierre); 
			  $registro["IdMoneda"]=$row->IdMoneda; 
			  $registro["Cuantia"]=$row->Cuantia; 
			  $registro["Objeto"]=$row->Objeto; 
			  $registro["Activo"]=$row->Activo; 
			  $registro["IdEstado"]=$row->IdEstado; 
		   }
	   }
	  
	 return $registro;  
  }
  */
  
}
