<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
use DateTime;

class Pqr extends Model
{
  /*
  listadoPQR
  */	
  public static  function listadoPQR($filtro,$TipoSolictud,$fDesde,$fHasta,$fechaFiltro,$Identificacion,$NombreCompleto,$Email,$UsuarioModificacion,$IdEstado,$generarDescarga,$nombreArchivoDescarga,$paginaActual)
  {
	$filtroConsulta="";
	$topePaginacion="10";
	$_SESSION["topePaginacion"]=$topePaginacion;
    if(trim($IdEstado)!="")
	 {
	   $filtroConsulta=$filtroConsulta." AND ( estado.IdEstado=".$IdEstado." ) ";
	 }		
    if(trim($UsuarioModificacion)!="")  
	 {
	   $filtroConsulta=$filtroConsulta." AND ( solicitud.UsuarioModificacion LIKE '%".$UsuarioModificacion."%' OR usuario.NombreCompleto LIKE '%".$UsuarioModificacion."%' OR revisor.NombreCompleto LIKE '%".$UsuarioModificacion."%'  ) ";
	 }		
    if(trim($Email)!="")
	 {
	   $filtroConsulta=$filtroConsulta." AND ( solicitud.Email LIKE '%".$Email."%' ) ";
	 }		
    if(trim($NombreCompleto)!="")
	 {
	   $filtroConsulta=$filtroConsulta." AND ( solicitud.NombreCompleto LIKE '%".$NombreCompleto."%' ) ";
	 }		
    if(trim($Identificacion)!="")
	 {
	   $filtroConsulta=$filtroConsulta." AND ( solicitud.Identificacion = '".$Identificacion."' ) ";
	 }		
    if(trim($filtro)!="")
	 {
	   $filtroConsulta=$filtroConsulta." AND ( solicitud.IdSolicitud = ".$filtro." ) ";
	 }		
    if(trim($TipoSolictud)!="")
	 {
	   $filtroConsulta=$filtroConsulta." AND solicitud.TipoSolictud=".$TipoSolictud;
	 }		

    if(trim($fDesde)!="" && trim($fHasta)!="")
	 {
	   if($fechaFiltro=="2")
	    {
		  //fecha creación   
	      $filtroConsulta=$filtroConsulta." AND solicitud.FechaRegistro >= '".Proceso::formatoFechaYMD($fDesde)." 00:00' AND solicitud.FechaRegistro <= '".Proceso::formatoFechaYMD($fHasta)." 23:59'  ";
	    }		   
	   if($fechaFiltro=="1")
	    {
		  //fecha Vencimiento
	      $filtroConsulta=$filtroConsulta." AND solicitud.FechaVencimiento >= '".Proceso::formatoFechaYMD($fDesde)." 00:00' AND solicitud.FechaVencimiento <= '".Proceso::formatoFechaYMD($fHasta)." 23:59'  ";
	    }		   
	 }		
	 
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion, tipo_recepcion.DetalleTipoRecepcion,solicitud.Solicitud,solicitud.Telefono, ";  
	$sql=$sql." usuario.NombreCompleto AS NombreCompletoDelegado,revisor.NombreCompleto AS NombreCompletoRevisor,  ";  
	$sql=$sql." estado_solicitud.FechaRegistro AS FechaRegistroEstado,Identificacion, ";  
	$sql=$sql." delegar.FechaCreacion AS FechaCreacionDelegado ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." LEFT JOIN tipo_recepcion ON tipo_recepcion.IdTipoRecepcion=solicitud.IdTipoRecepcion   ";  
	$sql=$sql." LEFT JOIN usuario revisor ON revisor.IdUsuario=delegar.IdUsuarioRevisor ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.IdSolicitud > 0 ";  
	$sql=$sql." ".$filtroConsulta;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY solicitud.IdSolicitud DESC LIMIT 1000  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$totalRegistros=count($listado);
	$_SESSION["totalRegistros"]=$totalRegistros;
	
	//generar descarga
	if($generarDescarga=="1")
	 {
	   //generar descarga | 
	   $myfile = fopen("assets/descargas/".$nombreArchivoDescarga, "w") or die("Unable to open file!");
	   $txt = "IdSolicitud;FechaRegistro;FechaVencimiento;Identificacion;NombreCompleto;Email;Telefono;DetalleEstado;DetalleDependencia;DetalleTipoRecepcion;DelegadoA;Revisor;FechaDelegado;FechaResuelto;Respuesta;Solicitud; \n";
	   fwrite($myfile, $txt);
	   foreach ($listado as $row)
	    {
			$respuesta="";
		    $fechaResuelto="";
		    if(trim($row->DetalleEstado)=="RESUELTO")
			 {
			  $fechaResuelto=$row->FechaRegistroEstado;
			  $respuesta=Pqr::respuestaCasoResuelto($row->IdSolicitud);
			  $respuesta=strip_tags($respuesta);
			  $respuesta = str_replace(";", "", $respuesta);
			  $respuesta = str_replace("º", "", $respuesta);
			  $respuesta = str_replace("”", "", $respuesta);
			  $respuesta = trim(preg_replace('/\s\s+/', ' ', $respuesta));
			  $respuesta = trim(preg_replace('/\s+/', ' ', $respuesta));
			 }

			$Solicitud = str_replace(";", "", $row->Solicitud);
			$Solicitud = str_replace("º", "", $Solicitud);
			$Solicitud = str_replace("”", "", $Solicitud);
			$Solicitud = trim(preg_replace('/\s\s+/', ' ', $Solicitud));
			$Solicitud = trim(preg_replace('/\s+/', ' ', $Solicitud));
			 
			$txt = $row->IdSolicitud.";".$row->FechaRegistro.";".$row->FechaVencimiento.";".$row->Identificacion.";".$row->NombreCompleto.";".$row->Email.";".$row->Telefono.";".$row->DetalleEstado.";".$row->DetalleDependencia.";".$row->DetalleTipoRecepcion.";".$row->NombreCompletoDelegado.";".$row->NombreCompletoRevisor.";".$row->FechaCreacionDelegado.";".$fechaResuelto.";".$respuesta.";".$Solicitud."; \n"; 
			fwrite($myfile, $txt);
	    }
		
	   fclose($myfile);
	 }		
	
	
	//consulta paginada
	if($paginaActual=="1")
	 {
	   $paginaActual="0";	
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion, tipo_recepcion.DetalleTipoRecepcion,solicitud.Solicitud,solicitud.Telefono, ";  
	$sql=$sql." usuario.NombreCompleto AS NombreCompletoDelegado,revisor.NombreCompleto AS NombreCompletoRevisor,  ";  
	$sql=$sql." estado_solicitud.FechaRegistro AS FechaRegistroEstado,Identificacion, ";  
	$sql=$sql." delegar.FechaCreacion AS FechaCreacionDelegado ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." LEFT JOIN tipo_recepcion ON tipo_recepcion.IdTipoRecepcion=solicitud.IdTipoRecepcion   ";  
	$sql=$sql." LEFT JOIN usuario revisor ON revisor.IdUsuario=delegar.IdUsuarioRevisor ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.IdSolicitud > 0 ";  
	$sql=$sql." ".$filtroConsulta;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY solicitud.IdSolicitud DESC LIMIT ".$paginaActual.",".$topePaginacion; 
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	//recorrer resultados
	$coleccionDatos=array();
	foreach ($listado as $row)
	 {
	   //conseguir el estado semaforo actual
       $estadoSemaforo=Pqr::semaforoEstadoActual($row->IdSolicitud);	   
	   
	   //validar si esta resuelto
	   $fechaResuelto="";
	   if(trim($row->DetalleEstado)=="RESUELTO")
	    {
	      $fechaResuelto=$row->FechaRegistroEstado;
	    }
	   
	   
	   array_push($coleccionDatos,array("FechaCreacionDelegado"=>$row->FechaCreacionDelegado,"Identificacion"=>$row->Identificacion,"FechaRegistroEstado"=>$fechaResuelto ,"NombreCompletoRevisor"=> $row->NombreCompletoRevisor,"NombreCompletoDelegado"=> $row->NombreCompletoDelegado,"estadoSemaforo"=> $estadoSemaforo,"TipoSolictud"=> $row->TipoSolictud,"DetalleDependencia"=> $row->DetalleDependencia,"IdSolicitud"=> $row->IdSolicitud,"FechaRegistro"=>$row->FechaRegistro,"FechaVencimiento"=>$row->FechaVencimiento,"NombreCompleto"=>$row->NombreCompleto,"Email"=>$row->Email,"DetalleEstado"=>$row->DetalleEstado,"DetalleDependencia"=>$row->DetalleDependencia,"UsuarioModificacion"=>$row->UsuarioModificacion,"DetalleTipoRecepcion"=>$row->DetalleTipoRecepcion)); 
	 } 
	
    return $coleccionDatos;
  }

  /*
  respuestaCasoResuelto
  */  
  public static  function respuestaCasoResuelto($IdSolicitud)
  {
	$respuesta="";
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." ComentarioSeguimiento  ";  
	$sql=$sql."   ";  
	$sql=$sql." FROM seguimiento";  
	$sql=$sql."   ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." AND IdActuacion=1 ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$respuesta=$row->ComentarioSeguimiento;
	 }
	 
	 return $respuesta;
  }
  
  /*
  semaforoEstadoActual
  */  
  public static  function semaforoEstadoActual($IdSolicitud)
  {
	$estado="1";  //1 verde | 2 amarillo | 3 rojo
	
	//conseguir la fecha de vencimiento y estado actual
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion, tipo_recepcion.DetalleTipoRecepcion ";  
	$sql=$sql."   ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." LEFT JOIN tipo_recepcion ON tipo_recepcion.IdTipoRecepcion=solicitud.IdTipoRecepcion   ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$FechaCreacion="";
	$DetalleEstado="";
	foreach ($listado as $row)
	 {
		$DetalleEstado=$row->DetalleEstado;
		$FechaCreacion=$row->FechaRegistro;
		//$FechaCreacion=$row->FechaVencimiento;
	 }
	
	//datos del semaforo
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." *  ";  
	$sql=$sql." FROM semaforo";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	$Amarillo="0";
	$Rojo="0";
	$Vencimiento="0";
	foreach ($listado as $row)
	 {
		$Amarillo=$row->Amarillo;
		$Rojo=$row->Rojo;
		$Vencimiento=$row->Vencimiento;
	 }
	
	//validar si no esta cerrado 
	if(trim($DetalleEstado) != "RESUELTO")
	 {
	   //comparar fecha creacion VS fecha actual
	   $interval = date_diff(   new DateTime($FechaCreacion), new DateTime());
	   $nroDias=$interval->format("%a");
	   
	   //validar estados del semaforo
	   if(($nroDias) >= $Amarillo)
	    {
		  $estado="2"; 
	    }
	   if(($nroDias)>= $Rojo)
	    {
		  $estado="3"; 
	    }
	   // echo("<br> ".$nroDias." VS ama ".$Amarillo." | rojo ".$Rojo." | ".$FechaCreacion." --> ".$estado);
	 }
	
	return $estado;
  }
  
  /*
  listadoDetallePQR
  */	
  public static  function listadoDetallePQR($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,solicitud.Identificacion,solicitud.Solicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion ,solicitud.Telefono,solicitud.Direccion, ";  
	$sql=$sql." tipo_identificacion.DetalleTipoIdentificacion,respuesta.DetalleRespuesta,clase_solicitud.DetalleClase , ";  
	$sql=$sql." DetalleTipoRecepcion,Solicitante,solicitud.Aplazado,solicitud.ComentarioCambio,estado_solicitud.FechaRegistro AS FechaRegistroResuelto ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." LEFT JOIN tipo_identificacion ON tipo_identificacion.IdTipoIdentificacion=solicitud.IdTipoIdentificacion ";  
	$sql=$sql." LEFT JOIN respuesta ON respuesta.IdRespuesta=solicitud.IdRespuesta ";  
	$sql=$sql." LEFT JOIN clase_solicitud ON clase_solicitud.IdClase=solicitud.IdClase ";  
	$sql=$sql." LEFT JOIN tipo_recepcion ON tipo_recepcion.IdTipoRecepcion=solicitud.IdTipoRecepcion ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	return $listado;
  }
  
  /*
  listadoAdjuntosContratos
  */	
  public static  function listadoAdjuntosContratos($IdProceso,$filtro)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso_adjunto";  
	$sql=$sql." INNER JOIN tipo_documento ON tipo_documento.IdTipoDocumento=proceso_adjunto.IdTipoDocumento ";  
	$sql=$sql." ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso_adjunto.IdProcesoAdjunto DESC ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoProceso
  */	
  public static  function listadoTipoProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_proceso ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleTipoProceso  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoDocumento
  */	
  public static  function listadoTipoDocumento()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_documento ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleTipoDocumento  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoEstadoProceso
  */	
  public static  function listadoEstadoProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=1 ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDetalleProceso
  */	
  public static  function listadoDetalleProceso($IdProceso)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso "; 
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoIdentificacion
  */	
  public static  function listadoTipoIdentificacion()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_identificacion "; 
	$sql=$sql." ORDER BY DetalleTipoIdentificacion ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoClaseSolicitudPQR
  */	
  public static  function listadoClaseSolicitudPQR()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM clase_solicitud "; 
	$sql=$sql." ORDER BY DetalleClase ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoClaseSolicitudFiltroPQR
  */	
  public static  function listadoClaseSolicitudFiltroPQR($TipoSolicitud)
  {
    if(trim($TipoSolicitud)=="")
     {
       $TipoSolicitud="0";   
     }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM clase_solicitud "; 
	$sql=$sql." WHERE ";  
	$sql=$sql." TipoSolicitud=".$TipoSolicitud;  
	$sql=$sql." ORDER BY DetalleClase ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoRespuestaPQR
  */	
  public static  function listadoRespuestaPQR()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM respuesta "; 
	$sql=$sql." ORDER BY DetalleRespuesta ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoRecepcionPQR
  */	
  public static  function listadoTipoRecepcionPQR()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_recepcion "; 
	$sql=$sql." ORDER BY DetalleTipoRecepcion ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoTipoRecepcionPQR
  */	
  public static  function listadoTipoRecepcionFiltroPQR($TipoSolicitud)
  {
    if(trim($TipoSolicitud)=="")
    {
        $TipoSolicitud="0";
    }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_recepcion "; 
	$sql=$sql." WHERE ";  
	$sql=$sql." TipoSolicitud=".$TipoSolicitud;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleTipoRecepcion ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDependencia
  */	
  public static  function listadoDependencia()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleDependencia  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoDependenciaXTipoSolicitud
  */	
  public static  function listadoDependenciaXTipoSolicitud($Tipo)
  {
	if(trim($Tipo)=="")
	 {
	   $Tipo="0";	
	 }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=".$Tipo." AND Activo=1 ";  
	$sql=$sql." ORDER BY  DetalleDependencia  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoMunicipio
  */	
  public static  function listadoMunicipio()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  catastro ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." tipo='CM'  ";  
	$sql=$sql." ORDER BY  DESCRIPCION  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoMoneda
  */	
  public static  function listadoMoneda()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  moneda ";  
	$sql=$sql." ORDER BY  DetalleMoneda  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoActuaciones
  */	
  public static  function listadoActuaciones()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  actuacion ";  
	$sql=$sql." ORDER BY  DetalleActuacion  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoSeguimientoSolicitud
  */	
  public static  function listadoSeguimientoSolicitud($POST)
  {
	$valorNroRadicado="0";
	if(trim($POST["valorNroRadicado"])!="")
	 {
		$valorNroRadicado=trim($POST["valorNroRadicado"]);
	 }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.IdSolicitud, solicitud.FechaRegistro,solicitud.FechaVencimiento, ";  
	$sql=$sql." solicitud.NombreCompleto, solicitud.Email,solicitud.Solicitud,DetalleEstado, ";  
	$sql=$sql." DetalleDependencia ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql." FROM  solicitud ";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE  ";  
	$sql=$sql." solicitud.IdSolicitud=".$valorNroRadicado." ";  
	$sql=$sql." AND solicitud.Email='".$POST["valorEmail"]."' ";
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoSeguimientoSolicitudDetalle
  */	
  public static  function listadoSeguimientoSolicitudDetalle($POST)
  {
	$valorNroRadicado="0";
	if(trim($POST["valorNroRadicado"])!="")
	 {
		$valorNroRadicado=trim($POST["valorNroRadicado"]);
	 }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  solicitud ";  
	$sql=$sql." INNER JOIN seguimiento ON seguimiento.IdSolicitud=solicitud.IdSolicitud ";  
	$sql=$sql." INNER JOIN actuacion ON actuacion.IdActuacion=seguimiento.IdActuacion ";  
	$sql=$sql." WHERE  ";  
	$sql=$sql." solicitud.IdSolicitud=".$valorNroRadicado." ";  
	$sql=$sql." AND Email='".$POST["valorEmail"]."' ";
	$sql=$sql." ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  
  /*
  listadoEstadosPQR
  */	
  public static  function listadoEstadosPQR()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=2 AND Activo=1 ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstadosXTipoSolicitudPQR
  */	
  public static  function listadoEstadosXTipoSolicitudPQR($IdTipoSolicitud)
  {
	$Tipo="0";

	//misional
	if($IdTipoSolicitud=="1")
	 {
		$Tipo="3";
	 }
	//parafiscal
	if($IdTipoSolicitud=="2")
	 {
		$Tipo="4";
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=".$Tipo." AND Activo=1 ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoFuncionariosXTipoSolicitud
  */	
  public static  function listadoFuncionariosXTipoSolicitud($IdTipoSolicitud)
  {
	$filtroTipo="";

	//misional
	if($IdTipoSolicitud=="1")
	 {
	   $filtroTipo=" AND Misional=1 ";
	 }
	//parafiscal
	if($IdTipoSolicitud=="2")
	 {
	   $filtroTipo=" AND Parafiscal=1 ";
	 }
	
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  usuario ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdUsuario>0 AND Activo=1 ".$filtroTipo;  
	$sql=$sql." ORDER BY  NombreCompleto  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoSeguimientos
  */	
  public static  function listadoSeguimientos($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  seguimiento ";  
	$sql=$sql." INNER JOIN actuacion ON actuacion.IdActuacion=seguimiento.IdActuacion ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdSeguimiento DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstadosSolicitud
  */	
  public static  function listadoEstadosSolicitud($IdSolicitud)
  {
    if(trim($IdSolicitud)=="")
     {
       $IdSolicitud="0";   
     }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  estado_solicitud ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdEstadoSolicitud DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstados
  */	
  public static  function listadoEstados()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  estado ";  
	$sql=$sql." ORDER BY  DetalleEstado ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDelegadosSolicitud
  */	
  public static  function listadoDelegadosSolicitud($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." RequiereRevision,IdDelegar,usuario.NombreCompleto,  ";  
	$sql=$sql." usuario2.NombreCompleto as NombreCompleto2,DetalleDependencia,  ";  
	$sql=$sql." Comentario,UsuarioCreacion,FechaCreacion  ";  
	$sql=$sql."   ";  
	$sql=$sql."   ";  
	$sql=$sql."   ";  
	$sql=$sql."   ";  
	$sql=$sql." FROM  delegar ";  
	$sql=$sql." INNER JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." INNER JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." LEFT JOIN usuario usuario2 ON usuario2.IdUsuario=delegar.IdUsuarioRevisor ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdDelegar DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoUsuariosXDependencia
  */	
  public static  function listadoUsuariosXDependencia()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  dependencia_usuario ";  
	$sql=$sql." INNER JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  NombreCompleto    ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoUsuariosXDependenciaFiltro
  */	
  public static  function listadoUsuariosXDependenciaFiltro($IdDependencia)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  dependencia_usuario ";  
	$sql=$sql." INNER JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." dependencia_usuario.IdDependencia=".$IdDependencia;  
	$sql=$sql." AND usuario.Activo=1 ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  NombreCompleto    ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoUsuariosXDependenciaTipoFiltro
  */	
  public static  function listadoUsuariosXDependenciaTipoFiltro($IdDependencia,$tipo)
  {
	if($tipo==1)
	 {
       //misional
	   $filtro=" AND usuario.Misional=1 ";
	 }
	else
	 {
	   //parafiscal
	   $filtro=" AND usuario.Parafiscal=1 ";
	 }
	 
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  dependencia_usuario ";  
	$sql=$sql." INNER JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." dependencia_usuario.IdDependencia=".$IdDependencia;  
	$sql=$sql." AND usuario.Activo=1 ";  
	$sql=$sql." ".$filtro;  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  NombreCompleto    ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoUsuariosTodos
  */	
  public static  function listadoUsuariosTodos()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  usuario  ";  
	$sql=$sql." ORDER BY NombreCompleto   ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoUsuariosRevisoresTodos
  */	
  public static  function listadoUsuariosRevisoresTodos()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  usuario  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Revisor=1 AND usuario.Activo=1 ";  
	$sql=$sql." ORDER BY NombreCompleto   ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoAdjuntos
  */	
  public static  function listadoAdjuntos($IdSolicitud)
  {
	if(trim($IdSolicitud)=="")
	 {
	  $IdSolicitud="0";	
	 }
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  solicitud_adjunto ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdSolicitudAdjunto DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  actualizarProcesoContrato
  */	
  public static  function actualizarProcesoContrato($POST,$IdProceso,$usuario)
  {
	$mensaje="";
  
	$sql="";  
	$sql=$sql." UPDATE "; 
	$sql=$sql." proceso "; 
	$sql=$sql." SET "; 
	$sql=$sql." IdTipoProceso=".$POST["valorTipoProceso"].",IdDependencia=".$POST["valorDependenciaProceso"].", Codigo=".$POST["valorMunicipioProceso"].", "; 
	$sql=$sql." FechaApertura='".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."',FechaCierre='".Proceso::formatoFechaYMD($POST["valorFechaCierre"])."', "; 
	$sql=$sql." IdMoneda=".$POST["valorMonedaProceso"].",Cuantia='".$POST["valorCuantia"]."', "; 
	$sql=$sql." Objeto='".$POST["valorObjeto"]."',FechaModificacion='".date("Y/m/d H:m")."', "; 
	$sql=$sql." UsuarioModificacion='".$usuario."' "; 
	$sql=$sql."  "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProceso=".$IdProceso; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	$mensaje="Contrato actualizado exitosamente.";
  
    return $mensaje;
  }

  /*
  crearAdjuntoContrato
  */	
  public static function crearAdjuntoContrato($POST,$IdProceso,$Archivo,$usuario)
  {
	$sql="";  
	$sql=$sql." INSERT INTO proceso_adjunto "; 
	$sql=$sql." ( "; 
	$sql=$sql." IdTipoDocumento,IdProceso,Archivo, "; 
	$sql=$sql." FechaRegistro,UsuarioRegistro,FechaModificacion, "; 
	$sql=$sql." UsuarioModificacion,Activo,LlaveRegistro, "; 
	$sql=$sql." Numero,Nombre "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." ( "; 
	$sql=$sql." ".$POST["valorTipoProceso"].",".$IdProceso.",'".$Archivo."', "; 
	$sql=$sql." '".date("Y/m/d H:m")."','".$usuario."','".date("Y/m/d H:m")."', "; 
	$sql=$sql." '".$usuario."',1,'".rand(111111,999999)."', "; 
	$sql=$sql." '".$POST["valorNroAdjuntoContrato"]."','".$POST["valorObjetoAdjunto"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }

  /*
  borrarAdjuntoContrato
  */	
  public static function borrarAdjuntoContrato( $IdProcesoAdjunto,$LlaveRegistro)
  {
	$sql="";  
	$sql=$sql." DELETE FROM proceso_adjunto "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProcesoAdjunto=".$IdProcesoAdjunto; 
	$sql=$sql." AND LlaveRegistro='".$LlaveRegistro."' "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }

  /*
  consultarActuacionActual
  */	
  public static function consultarActuacionActual( $IdSolicitud )
  {
    $IdActuacion="4";
	$sql="";  
	$sql=$sql." SELECT IdActuacion ";  
	$sql=$sql." FROM ";  
	$sql=$sql." seguimiento ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY IdSeguimiento DESC ";  
	$sql=$sql." LIMIT 1 ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$IdActuacion=$row->IdActuacion;
	 }    	
	 
	return $IdActuacion;
  }  
  
  /*
  crearSeguimientoSolicitud
  */	
  public static function crearSeguimientoSolicitud($POST,$IdSolicitud,$ArchivoAdjunto,$usuario)
  {
	//validar si la configuración activa en delagacion requiere revision
	$RequiereRevision="0";
	$EmailRevision="";
	$EmailDelegado="";
	$sql="";  
	$sql=$sql." SELECT RequiereRevision, usuarioDelegado.Email AS EmailDelegado,usuarioRevision.Email AS EmailRevision FROM  delegar ";  
	$sql=$sql." LEFT JOIN usuario usuarioRevision ON usuarioRevision.IdUsuario=delegar.IdUsuarioRevisor ";  
	$sql=$sql." LEFT JOIN usuario usuarioDelegado ON usuarioDelegado.IdUsuario=delegar.IdUsuario ";  
	$sql=$sql."  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." AND ActivoDelegar=1 ";  
	$sql=$sql." ORDER BY IdDelegar DESC ";  
	$sql=$sql." LIMIT 1 ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$RequiereRevision=$row->RequiereRevision;
		$EmailRevision=$row->EmailRevision;
		$EmailDelegado=$row->EmailDelegado;
	 }    	
	
	//validar si tiene seguimientos registrados	
    $IdActuacion="1";
    $realizoActualizacionFLOW="0";
	$IdEstado=Pqr::consultaIDEstadoTipoContacto("RESUELTO","4"); // 4 parafiscal | 5 misional
	$sql="";  
	$sql=$sql." SELECT IdActuacion FROM  seguimiento ";  
	$sql=$sql."  ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY IdSeguimiento DESC ";  
	$sql=$sql." LIMIT 1 ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$IdActuacion=$row->IdActuacion;
	 }    	
	
	if( $RequiereRevision == "1" && ($IdActuacion == "4" || $IdActuacion == "5")  && $realizoActualizacionFLOW=="0")
	 {
		//requiere revision  | la actuacion actual es DELEGADO o APLAZADO | Se debe pasar a actuacion BORRADOR
		$IdActuacion="6";
		$IdEstado=Pqr::consultaIDEstadoTipoContacto("BORRADOR","4"); // 4 parafiscal | 5 misional
		$realizoActualizacionFLOW="1";
		
		//enviar correo a revisor
	    $asunto="FONTUR: Asignación para revisión Contacto Nro. ".$IdSolicitud;
		$cuerpo=" El contacto Nro. ".$IdSolicitud." le ha sido asignado para revisión. Por favor ingresar al sistema.";
		Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
		Pqr::envioMensajes($EmailRevision,$asunto,$cuerpo);
	 }

	if( $RequiereRevision == "1" && $IdActuacion == "7"  && $realizoActualizacionFLOW=="0")
	 {
		    //requiere revision  | la actuacion actual es CORRECCION | Se debe pasar a actuacion BORRADOR
		    $IdActuacion="6";
		    $IdEstado=Pqr::consultaIDEstadoTipoContacto("BORRADOR","4"); // 4 parafiscal | 5 misional
		    $realizoActualizacionFLOW="1";
		
		    //enviar correo a revisor
			$asunto="FONTUR: Asignación para revisión Contacto Nro. ".$IdSolicitud;
			$cuerpo=" El contacto Nro. ".$IdSolicitud." le ha sido asignado para revisión. Por favor ingresar al sistema.";
			Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
			Pqr::envioMensajes($EmailRevision,$asunto,$cuerpo);
	 }
	 
	if( $RequiereRevision == "1" && $IdActuacion == "6" && $realizoActualizacionFLOW=="0")
	 {
		//requiere revision  | la actuacion actual es BORRADOR | 
		if($POST["procesoAprobado"]=="1")
		 {
			$IdActuacion="8";  //aprobado
			$IdEstado=Pqr::consultaIDEstadoTipoContacto("APROBADO","4"); // 4 parafiscal | 5 misional
		 }
		else
		 {
			$IdActuacion="7";  //correccion
			$IdEstado=Pqr::consultaIDEstadoTipoContacto("CORRECCION","4"); // 4 parafiscal | 5 misional
		 }
		
		$realizoActualizacionFLOW="1";
		
		//correo a delegado
		$asunto="FONTUR: Actualización Revisor Contacto Nro. ".$IdSolicitud;
		$cuerpo=" El contacto Nro. ".$IdSolicitud." ha sido actualizado por el revisor. Por favor ingresar al sistema.";
		Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
		Pqr::envioMensajes($EmailDelegado,$asunto,$cuerpo);
	 }
	
	//caso especial
	if($realizoActualizacionFLOW=="0")
	 {
		//no cambio ninguna actuación. dejarlo RESUELTO
		$IdActuacion="1";
	 }		
	
	$sql="";  
	$sql=$sql." INSERT INTO seguimiento "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdSolicitud,IdActuacion, FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,ComentarioSeguimiento,LlaveRegistro,ArchivoAdjunto,Comentario "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$IdSolicitud.",".$IdActuacion.",'".date("Y/m/d H:m")."', "; 
	$sql=$sql." '".$usuario."','".$POST["valorSolicitud"]."','".rand(111111,999999)."' ,'".$ArchivoAdjunto."','".trim($POST["valorComentarioFuncionario"])."' "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	//cambiar estado ***
	$sql="";  
	$sql=$sql." UPDATE estado_solicitud SET  "; 
	$sql=$sql." ActivoEstado=0 "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	DB::unprepared($sql); 
   	 
	$sql="";  
	$sql=$sql." INSERT INTO estado_solicitud ";
	$sql=$sql." ( "; 
	$sql=$sql." IdEstado,IdSolicitud,FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,ActivoEstado "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." ( "; 
	$sql=$sql." ".$IdEstado.",".$IdSolicitud.",'".date("Y/m/d H:m")."','".$usuario."',1 "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	
	//enviar email al solicitante al estar RESUELTO el caso 
    if($IdActuacion=="1")
	 {
		$sql="";  
		$sql=$sql." SELECT * FROM  solicitud ";  
		$sql=$sql." WHERE ";  
		$sql=$sql." IdSolicitud=".$IdSolicitud;  
		$sql=$sql." ";  
		$listado=DB::select($sql);
		foreach ($listado as $row)
		 {
			$Email=$row->Email;
			$asunto="FONTUR: Respuesta Contacto Nro. ".$IdSolicitud;
			$cuerpo="".$POST["valorSolicitud"];
			
			//validar si hay adjunto
			if(trim($ArchivoAdjunto)!="")
			 {
				$cuerpo=$cuerpo."<br>Documento adjunto: <a href='https://herramientas.fontur.info/fontl/assets/pdf/".$ArchivoAdjunto."'>Descargar</a>";
			 }
			
			$cuerpo=$cuerpo."";
			Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
			Pqr::envioMensajes($Email,$asunto,$cuerpo);
		 }
	 }		
	
	return "Seguimiento ingresado";
  }

  /*
  crearAdjuntosSolicitud
  */	
  public static function crearAdjuntosSolicitud($POST,$IdSolicitud,$ArchivoAdjunto,$usuario)
  {
	$sql="";  
	$sql=$sql." INSERT INTO solicitud_adjunto "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,FechaModificacion,UsuarioModificacion, "; 
	$sql=$sql." Activo,LlaveRegistro,Detalle "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$IdSolicitud.",'".$ArchivoAdjunto."','".date("Y/m/d H:m")."', "; 
	$sql=$sql." '".$usuario."','".date("Y/m/d H:m")."','".$usuario."', "; 
	$sql=$sql." 1,'".rand(111111,999999)."','".$POST["valorSolicitud"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Adjunto ingresado";
  }

  /*
  crearEstadoSolicitud
  */	
  public static function crearEstadoSolicitud($POST,$IdSolicitud,$usuario)
  {
	$sql="";  
	$sql=$sql." UPDATE estado_solicitud "; 
	$sql=$sql." SET ActivoEstado=0 "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	$sql="";  
	$sql=$sql." INSERT INTO estado_solicitud "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdEstado,IdSolicitud,FechaRegistro,UsuarioRegistro, "; 
	$sql=$sql." ActivoEstado,Comentario "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$POST["valorEstado"].",".$IdSolicitud.",'".date("Y/m/d H:m")."','".$usuario."', "; 
	$sql=$sql." 1,'".$POST["valorSolicitud"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Estado ingresado";
  }

  /*
  actualizarTipoSolicitud
  */	
  public static function actualizarTipoSolicitud($POST,$IdSolicitud,$usuario)
  {
	$sql="";  
	$sql=$sql." UPDATE solicitud "; 
	$sql=$sql." SET TipoSolictud=".$POST["valorTipoSolicitudConfig"].",ComentarioCambio='".$POST["valorMotivo"]."'  "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Información actualizada";
  }  

  /*
  actualizarAplazado
  */	
  public static function actualizarAplazado($POST,$IdSolicitud,$usuario,$registro)
  {
	$FechaVencimientoActual=date("Y/m/d");
	foreach ($registro as $row)
	 {
		$FechaVencimientoActual=$row->FechaVencimiento;
	 }
	
	//nueva fecha de vencimiento  
	$FechaVencimiento=Pqr::calcularFechaVencimientoPersonalizada($FechaVencimientoActual);
	
	$sql="";  
	$sql=$sql." UPDATE solicitud "; 
	$sql=$sql." SET Aplazado=1,FechaVencimiento='".$FechaVencimiento."' "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	//enviar correo
	$EmailSolicitud="";
	$sql="";  
	$sql=$sql." SELECT * FROM  solicitud ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$EmailSolicitud=$row->Email;
	    $asunto="FONTUR: Aplazamiento Contacto Nro. ".$IdSolicitud;
	    $cuerpo="";
	    $cuerpo=$cuerpo." El Contacto Nro. ".$IdSolicitud." ha sido aplazado.";
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."";
	    Pqr::envioMensajes($EmailSolicitud,$asunto,$cuerpo);
	    Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
	 }
	 
	//cambiar estado
	$sql="";  
	$sql=$sql." UPDATE estado_solicitud ";
	$sql=$sql." SET "; 
	$sql=$sql." ActivoEstado=0 "; 
	$sql=$sql." WHERE  "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	
	$IdEstado=Pqr::consultaIDEstadoTipoContacto("APLAZADO","4"); // 4 parafiscal | 5 misional
	$sql="";  
	   $sql=$sql." INSERT INTO estado_solicitud ";
	   $sql=$sql." ( "; 
	   $sql=$sql." IdEstado,IdSolicitud,FechaRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$IdEstado.",".$IdSolicitud.",'".date("Y/m/d H:m")."','".$usuario."',1 "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	
	//ingresar seguimiento
	$sql="";  
	$sql=$sql." INSERT INTO seguimiento "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdSolicitud,IdActuacion, FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,ComentarioSeguimiento,LlaveRegistro,ArchivoAdjunto "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$IdSolicitud.",5,'".date("Y/m/d H:m")."', "; 
	$sql=$sql." '".$usuario."','Su solicitud ha sido aplazada.','".rand(111111,999999)."' ,'' "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	
	
	return "Información actualizada";
  }  
  
  /*
  crearDelegadoSolicitud
  */	
  public static function crearDelegadoSolicitud($POST,$IdSolicitud,$usuario)
  {
	$sql="";  
	$sql=$sql." UPDATE delegar "; 
	$sql=$sql." SET ActivoDelegar=0 "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	$sql="";  
	$sql=$sql." INSERT INTO delegar "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdUsuario,IdSolicitud,FechaCreacion, "; 
	$sql=$sql." UsuarioCreacion,LlaveRegistro,RequiereRevision,ActivoDelegar, "; 
	$sql=$sql." Comentario,IdUsuarioRevisor "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$POST["valorUsuario"].",".$IdSolicitud.",'".date("Y/m/d H:m")."', "; 
	$sql=$sql." '".$usuario."','".rand(111111,999999)."',".$POST["valorRevision"].",1,"; 
	$sql=$sql." '".$POST["valorSolicitud"]."',".$POST["valorUsuarioRevisor"]." "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	//datos del contacto
	$NombreCompleto="";
	$Solicitud="";
	$EmailSolicitud="";
	$FechaRegistro="";
	$FechaVencimiento="";
	$sql="";  
	$sql=$sql." SELECT * FROM  solicitud ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$NombreCompleto=$row->NombreCompleto;
		$Solicitud=$row->Solicitud;
		$EmailSolicitud=$row->Email;
		$FechaRegistro=$row->FechaRegistro;
		$FechaVencimiento=$row->FechaVencimiento;
	 }	
	
	//enviar correo
	$sql="";  
	$sql=$sql." SELECT * FROM  usuario ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdUsuario=".$POST["valorUsuario"];  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$Email=$row->Email;
	    $asunto="FONTUR: Nuevo Contacto Nro. ".$IdSolicitud;
	    $cuerpo="";
	    $cuerpo=$cuerpo." El administrativo le ha delegado el contacto Nro. ".$IdSolicitud;
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."Nombre completo:<br>".$NombreCompleto;
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."Email:<br>".$EmailSolicitud;
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."Fecha Registro:<br>".$FechaRegistro;
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."Fecha Vencimiento:<br>".$FechaVencimiento;
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."Solicitud:<br>".$Solicitud;
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."<br><br>";
	    $cuerpo=$cuerpo."Por favor ingresar al sistema para atender el caso.";
	    $cuerpo=$cuerpo."";
	    Pqr::envioMensajes($Email,$asunto,$cuerpo);
	    Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
	 }
	
	//cambiar estado
	$IdEstado=Pqr::consultaIDEstadoTipoContacto("DELEGADO","4"); // 4 parafiscal | 5 misional
	   
	$sql="";  
	$sql=$sql." UPDATE estado_solicitud SET  "; 
	$sql=$sql." ActivoEstado=0 "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	DB::unprepared($sql); 
   	 
	$sql="";  
	$sql=$sql." INSERT INTO estado_solicitud ";
	$sql=$sql." ( "; 
	$sql=$sql." IdEstado,IdSolicitud,FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,ActivoEstado "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." ( "; 
	$sql=$sql." ".$IdEstado.",".$IdSolicitud.",'".date("Y/m/d H:m")."','".$usuario."',1 "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	
	//ingresar seguimiento
	$sql="";  
	$sql=$sql." INSERT INTO seguimiento "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdSolicitud,IdActuacion, FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,ComentarioSeguimiento,LlaveRegistro,ArchivoAdjunto "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$IdSolicitud.",4,'".date("Y/m/d H:m")."', "; 
	$sql=$sql." '".$usuario."','Su solicitud ha sido delegada al profesional encargado.','".rand(111111,999999)."' ,'' "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	//enviar email solicitante
	$sql="";  
	$sql=$sql." SELECT * FROM  solicitud ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
		$Email=$row->Email;
	    $asunto="FONTUR: Delegación Contacto Nro. ".$IdSolicitud;
	    $cuerpo="Su solicitud ha sido delegada al profesional encargado.";
	    $cuerpo=$cuerpo."";
	    Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
	    Pqr::envioMensajes($Email,$asunto,$cuerpo);
	 }
	
	return "Delegado ingresado";
  }
  
  /*
  crearDelegadoMasivoSolicitud
  */	
  public static function crearDelegadoMasivoSolicitud($TipoSolictud,$IdClase,$valorUsuarioDependencia,$usuario)
  {
	//conseguir las solicitudes disponibles para delegar
	$sql="";  
	$sql=$sql." SELECT solicitud.IdSolicitud FROM   solicitud ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.TipoSolictud=".$TipoSolictud;  
	$sql=$sql." AND ";  
	$sql=$sql." solicitud.IdClase=".$IdClase;  
	$sql=$sql." AND ";  
	$sql=$sql." delegar.IdDelegar is NULL ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	foreach ($listado as $row)
	 {
	    $IdSolicitud=$row->IdSolicitud;
		
		$sql="";  
		$sql=$sql." UPDATE delegar "; 
		$sql=$sql." SET ActivoDelegar=0 "; 
		$sql=$sql." WHERE "; 
		$sql=$sql." IdSolicitud=".$IdSolicitud; 
		$sql=$sql."  "; 
		DB::unprepared($sql);
		
		$sql="";  
		$sql=$sql." INSERT INTO delegar "; 
		$sql=$sql." (  "; 
		$sql=$sql." IdUsuario,IdSolicitud,FechaCreacion, "; 
		$sql=$sql." UsuarioCreacion,LlaveRegistro,RequiereRevision,ActivoDelegar, "; 
		$sql=$sql." Comentario,IdUsuarioRevisor "; 
		$sql=$sql."  "; 
		$sql=$sql." ) "; 
		$sql=$sql." VALUES "; 
		$sql=$sql." (  "; 
		$sql=$sql." ".$valorUsuarioDependencia.",".$IdSolicitud.",'".date("Y/m/d H:m")."', "; 
		$sql=$sql." '".$usuario."','".rand(111111,999999)."',0,1,"; 
		$sql=$sql." '',0 "; 
		$sql=$sql."  "; 
		$sql=$sql." ) "; 
		$sql=$sql."  "; 
		DB::unprepared($sql);
	 }	
	  
	return "Delegado asignado";
  }
  
  /*
  crearProcesoContrato
  */	
  public static  function crearProcesoContrato($POST,$usuario)
  {
	$mensaje="";
	
	//validar que no exista el contrato
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." IdProceso ";  
	$sql=$sql." FROM  proceso ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
     
	if(count($listado) == 0)
	 {
	   //crear
	   $sql="";
	   $sql=$sql." INSERT INTO proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." Codigo,IdTipoProceso,IdDependencia, "; 
	   $sql=$sql." Numero,FechaApertura,FechaCierre, "; 
	   $sql=$sql." IdMoneda,Cuantia,Objeto, "; 
	   $sql=$sql." Activo,UsuarioRegistro,UsuarioModificacion, "; 
	   $sql=$sql." LlaveRegistro,FechaModificacion "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$POST["valorMunicipioProceso"].",".$POST["valorTipoProceso"].",".$POST["valorDependenciaProceso"].", "; 
	   $sql=$sql." '".$POST["valorContrato"]."','".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."','".Proceso::formatoFechaYMD($POST["valorFechaCierre"])."', "; 
	   $sql=$sql." ".$POST["valorMonedaProceso"].",'".$POST["valorCuantia"]."','".$POST["valorObjeto"]."', "; 
	   $sql=$sql." 1,'".$usuario."','".$usuario."', "; 
	   $sql=$sql." '".rand(111111,999999)."','".date("Y/m/d H:m")."' "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   //conseguir el ID contrato
	   $IdProceso="0";
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdProceso ";  
	   $sql=$sql." FROM  proceso ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   foreach ($listado as $row)
	    {
		   $IdProceso=$row->IdProceso;
	    }
	   
	   $sql="";  
	   $sql=$sql." INSERT INTO estado_proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." IdProceso,IdEstado,LlaveRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$IdProceso.",".$POST["valorEstadoProceso"].",'".rand(111111,999999)."', "; 
	   $sql=$sql." '".$usuario."',1 "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Contrato creado exitosamente.";
	 }		
	else
	 {
		$mensaje="Error. Ya existe el número de contrato ".$POST["valorContrato"];
	 }
	 
	return $mensaje;
  }

  /*
  crearProcesoSolicitud | PARAFISCAL
  */	
  public static  function crearProcesoSolicitud($POST,$archivo,$archivo2,$archivo3,$archivo4,$archivo5,$archivo6,$archivo7,$archivo8,$archivo9,$archivo10,$usuario) 
  {
	   $mensaje="";
	
	   //obtener la fecha calculada de vencimiento	
	   $FechaVencimiento=Pqr::calcularFechaVencimiento();
	   
	   $valorTipoRecepcion=$POST["valorTipoRecepcion"];
	   if(trim($POST["valorTipoRecepcion"])=="")
	    {
		   $valorTipoRecepcion="0";
	    }
	
	   $sql="";
	   $sql=$sql." INSERT INTO solicitud "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." NombreCompleto,Identificacion,Email, "; 
	   $sql=$sql." Solicitud,Codigo,LlaveRegistro, "; 
	   $sql=$sql." FechaRegistro,Activo,FechaModificacion,UsuarioModificacion, "; 
	   $sql=$sql." Origen,FechaVencimiento,TipoSolictud ,IdRespuesta,IdClase,IdTipoIdentificacion, "; 
	   $sql=$sql." Telefono,IdTipoRecepcion,Solicitante "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorNombreCompleto"]."','".$POST["valorIdentificacion"]."','".$POST["valorEmailicitud"]."', "; 
	   $sql=$sql." '".$POST["valorSolicitud"]."','CODIGO','".rand(111111,999999)."', "; 
	   $sql=$sql." '".date("Y/m/d H:m")."',1,'".date("Y/m/d H:m")."','".$usuario."', "; 
	   $sql=$sql." 1,'".$FechaVencimiento."',".$POST["valorTipo"].", "; 
	   $sql=$sql." 1,".$POST["valorClaseSolicitud"].",".$POST["valorTipoidentificacion"].",'".$POST["valorTelefono"]."',".$valorTipoRecepcion.", "; 
	   $sql=$sql." '".$POST["valorSolicitante"]."' "; 
	   $sql=$sql." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   //conseguir el ID contrato
	   $IdSolicitud="0";
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdSolicitud ";  
	   $sql=$sql." FROM  solicitud ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Identificacion='".$POST["valorIdentificacion"]."' ";  
	   $sql=$sql." ORDER BY IdSolicitud DESC ";  
	   $sql=$sql." LIMIT 1 ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   foreach ($listado as $row)
	    {
		   $IdSolicitud=$row->IdSolicitud;
	    }
	   
	   //conseguir el ID estado 
	   $IdEstado=Pqr::consultaIDEstadoTipoContacto("RECIBIDO","4"); // 4 parafiscal | 5 misional
	   
	   $sql="";  
	   $sql=$sql." INSERT INTO estado_solicitud ";
	   $sql=$sql." ( "; 
	   $sql=$sql." IdEstado,IdSolicitud,FechaRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$IdEstado.",".$IdSolicitud.",'".date("Y/m/d H:m")."','".$usuario."',1 "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	   
	   //adjuntos
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo2,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo3,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo4,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo5,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo6,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo7,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo8,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo9,$usuario);
	   Pqr::adjuntarArchivosSolicitud($IdSolicitud,$archivo10,$usuario);
		
	   //enviar correo	
	   $asunto="FONTUR: Contacto Nro. ".$IdSolicitud;
	   $cuerpo="";
	   $cuerpo=$cuerpo."Su solicitud ha sido radicada en nuestro sistema el día ".date("Y/m/d")." y con el número ".$IdSolicitud;
	   $cuerpo=$cuerpo."<br><br>";
	   $cuerpo=$cuerpo."La fecha de vencimiento es: ".$FechaVencimiento;
	   $cuerpo=$cuerpo."<br><br>";
	   $cuerpo=$cuerpo."Recuerde que puede consultar el estado de su solicitud digitando el Nro. de radicado y el correo registrado en la opción 'Consulta de solicitudes'.";
	   $cuerpo=$cuerpo."<br><br>";
	   $cuerpo=$cuerpo."Todas sus solicitudes deben ser radicadas a través del formulario de contáctenos de contribución parafiscal."; //  al cual puede acceder ingresando al link.
	   $cuerpo=$cuerpo."";
	   $cuerpo=$cuerpo."";
	   Pqr::envioMensajes($POST["valorEmailicitud"],$asunto,$cuerpo);
	   Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
	   
	   $mensaje="Su contacto ha sido radicado en nuestro sistema el ".date("Y/m/d H:m")." con el número ".$IdSolicitud." . La fecha de vencimiento es ".$FechaVencimiento;
	   return $mensaje;
  }

  /*
  adjuntarArchivosSolicitud
  */
  public static function adjuntarArchivosSolicitud($IdSolicitud,$archivo3,$usuario)
  {
	   if(trim($archivo3)!="")
	    {
		   $sql="";  
		   $sql=$sql." INSERT INTO solicitud_adjunto ";
		   $sql=$sql." ( "; 
		   $sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
		   $sql=$sql." UsuarioRegistro,Activo,FechaModificacion,UsuarioModificacion,LlaveRegistro,Detalle "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." ".$IdSolicitud.",'".$archivo3."','".date("Y/m/d H:m")."','".$usuario."',1,'".date("Y/m/d H:m")."','".$usuario."','".rand(111111,999999)."','' "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql."  "; 
		   DB::unprepared($sql); 
	    }
  }
  
  /*
  envioMensajes
  */
  public static function envioMensajes($email,$asunto,$mensaje)
  {
	mail( $email ,$asunto,$mensaje, "From:servicio@fontur.info\nReply-To:servicio@fontur.info\nContent-type: text/html; charset=UTF-8\r\n");
  }
  
  /*
  consultaIDEstadoTipoContacto
  */
  public static function consultaIDEstadoTipoContacto($DetalleEstado,$Tipo)
  {
	 $IdEstado="0";
	 
	 $sql="";  
	 $sql=$sql." SELECT ";  
	 $sql=$sql." IdEstado ";  
	 $sql=$sql." FROM estado ";  
	 $sql=$sql." WHERE  ";  
	 $sql=$sql." DetalleEstado='".trim($DetalleEstado)."' ";  
	 $sql=$sql." AND ";  
	 $sql=$sql." Activo=1 ";  
	 $sql=$sql." AND Tipo=".$Tipo;  
	 $sql=$sql." ";  
	 $listado=DB::select($sql);
	 foreach ($listado as $row)
	  {
		$IdEstado=$row->IdEstado;
	  }
	 
	 return $IdEstado ;
  }
  
  /*
  calcularFechaVencimiento
  */
  public static function calcularFechaVencimientoPersonalizada($fechaInicialYMD)
  {
	 $diasVencimiento=15;
	 $fechaVencimiento= $fechaInicialYMD;
	 
	 //obtener el número de dias para vencimiento
	 $sql="";  
	 $sql=$sql." SELECT ";  
	 $sql=$sql." * ";  
	 $sql=$sql." FROM  semaforo ";  
	 $sql=$sql."   ";  
	 $sql=$sql." ";  
	 $listado=DB::select($sql);
	 foreach ($listado as $row)
	  {
		$diasVencimiento=$row->Vencimiento;
	  }
	 
	 //recorrer dia a dia validando que no sea ni sabado, domingo, festivo
	 $dia=1;
	 while($dia <= $diasVencimiento)
	  {
		 $datetime = new DateTime($fechaVencimiento);
		 $fechaVencimiento=$datetime->modify('+1 day')->format('Y/m/d');
		 
		 //validar si NO es festivo
		 $sql="";  
		 $sql=$sql." SELECT ";  
		 $sql=$sql." * ";  
		 $sql=$sql." FROM  festivos ";  
		 $sql=$sql." WHERE  ";  
		 $sql=$sql." FechaFestivo='".$fechaVencimiento."' ";  
		 $sql=$sql." ";  
		 $listado=DB::select($sql);
	 
		 if(count($listado) == 0)
		  {
			 //no es festivo. validar que no sea sabado ni domingo
			 $dayofweek = date('w', strtotime($fechaVencimiento));
			 if( $dayofweek != "0" &&  $dayofweek != "6" )
			  {
				 //echo("<br><br>w: ".$dayofweek." | ".$fechaVencimiento);
				 $dia++;
			  }
		  }
	  }
	 
	 return $fechaVencimiento ;
  }
  
  /*
  calcularFechaVencimiento
  */
  public static function calcularFechaVencimiento()
  {
	 $diasVencimiento=15;
	 $fechaVencimiento= date("Y/m/d");
	 
	 //obtener el número de dias para vencimiento
	 $sql="";  
	 $sql=$sql." SELECT ";  
	 $sql=$sql." * ";  
	 $sql=$sql." FROM  semaforo ";  
	 $sql=$sql."   ";  
	 $sql=$sql." ";  
	 $listado=DB::select($sql);
	 foreach ($listado as $row)
	  {
		$diasVencimiento=$row->Vencimiento;
	  }
	 
	 //recorrer dia a dia validando que no sea ni sabado, domingo, festivo
	 $dia=1;
	 while($dia <= $diasVencimiento)
	  {
		 $datetime = new DateTime($fechaVencimiento);
		 $fechaVencimiento=$datetime->modify('+1 day')->format('Y/m/d');
		 
		 //validar si NO es festivo
		 $sql="";  
		 $sql=$sql." SELECT ";  
		 $sql=$sql." * ";  
		 $sql=$sql." FROM  festivos ";  
		 $sql=$sql." WHERE  ";  
		 $sql=$sql." FechaFestivo='".$fechaVencimiento."' ";  
		 $sql=$sql." ";  
		 $listado=DB::select($sql);
	 
		 if(count($listado) == 0)
		  {
			 //no es festivo. validar que no sea sabado ni domingo
			 $dayofweek = date('w', strtotime($fechaVencimiento));
			 if( $dayofweek != "0" &&  $dayofweek != "6" )
			  {
				 //echo("<br><br>w: ".$dayofweek." | ".$fechaVencimiento);
				 $dia++;
			  }
		  }
	  }
	 
	 return $fechaVencimiento ;
  }

  /*
  borrarSolicitudInterna
  */	
  public static function borrarSolicitudInterna($IdSolicitud,$Identificacion)
  {
	$sql="";
	$sql=$sql." DELETE FROM  solicitud WHERE Identificacion='".$Identificacion."' AND  IdSolicitud=".$IdSolicitud;
	$sql=$sql."";
	DB::unprepared($sql);  
	$mensaje="Registro eliminado.";
	return $mensaje;
  }
  
  /*
  crearProcesoSolicitudMisional
  */	
  public static  function crearProcesoSolicitudMisional($POST,$archivo,$archivo2,$archivo3,$usuario)
  {
	   $mensaje="";
	   $nombreCompleto=$POST["valorPrimerNombre"]." ".$POST["valorSegundoNombre"]." ".$POST["valorPrimerApellido"]." ".$POST["valorSegundoApellido"];
	   
	   //obtener la fecha calculada de vencimiento	
	   $FechaVencimiento=Pqr::calcularFechaVencimiento();
	   
	   $sql="";
	   $sql=$sql." INSERT INTO solicitud "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." NombreCompleto,Identificacion,Email, "; 
	   $sql=$sql." Solicitud,Codigo,LlaveRegistro, "; 
	   $sql=$sql." FechaRegistro,Activo,FechaModificacion,UsuarioModificacion, "; 
	   $sql=$sql." Origen,FechaVencimiento,TipoSolictud ,IdRespuesta,IdClase,IdTipoIdentificacion, "; 
	   $sql=$sql." Telefono,Direccion, "; 
	   $sql=$sql." PrimerNombre,SegundoNombre, "; 
	   $sql=$sql." PrimerApellido,SegundoApellido,IdTipoRecepcion "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$nombreCompleto."','".$POST["valorIdentificacion"]."','".$POST["valorEmailicitud"]."', "; 
	   $sql=$sql." '".$POST["valorSolicitud"]."','CODIGO','".rand(111111,999999)."', "; 
	   $sql=$sql." '".date("Y/m/d H:m")."',1,'".date("Y/m/d H:m")."','".$usuario."', "; 
	   $sql=$sql." 1,'".$FechaVencimiento."',".$POST["valorTipo"].", "; 
	   $sql=$sql." ".$POST["valorRecibirRespuesta"].",".$POST["valorClaseSolicitud"].",".$POST["valorTipoidentificacion"].", "; 
	   $sql=$sql." '".$POST["valorTelefono"]."','".$POST["valorDireccion"]."', "; 
	   $sql=$sql." '".$POST["valorPrimerNombre"]."','".$POST["valorSegundoNombre"]."',  "; 
	   $sql=$sql." '".$POST["valorPrimerApellido"]."','".$POST["valorSegundoApellido"]."',".$POST["valorRecibirRespuesta"]."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   //conseguir el ID contrato
	   $IdSolicitud="0";
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdSolicitud ";  
	   $sql=$sql." FROM  solicitud ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Identificacion='".$POST["valorIdentificacion"]."' ";  
	   $sql=$sql." ORDER BY IdSolicitud DESC ";  
	   $sql=$sql." LIMIT 1 ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   foreach ($listado as $row)
	    {
		   $IdSolicitud=$row->IdSolicitud;
	    }
	   
	   //conseguir el ID estado 
	   $IdEstado=Pqr::consultaIDEstadoTipoContacto("RECIBIDO","4"); // 4 parafiscal | 5 misional
	   
	   $sql="";  
	   $sql=$sql." INSERT INTO estado_solicitud ";
	   $sql=$sql." ( "; 
	   $sql=$sql." IdEstado,IdSolicitud,FechaRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$IdEstado.",".$IdSolicitud.",'".date("Y/m/d H:m")."','".$usuario."',1 "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	   
	   //adjuntos 1
	   if(trim($archivo)!="")
	    {
		   $sql="";  
		   $sql=$sql." INSERT INTO solicitud_adjunto ";
		   $sql=$sql." ( "; 
		   $sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
		   $sql=$sql." UsuarioRegistro,Activo,FechaModificacion,UsuarioModificacion,LlaveRegistro,Detalle "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." ".$IdSolicitud.",'".$archivo."','".date("Y/m/d H:m")."','".$usuario."',1,'".date("Y/m/d H:m")."','".$usuario."','".rand(111111,999999)."','' "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql."  "; 
		   DB::unprepared($sql); 
	    }

	   //adjuntos 2
	   if(trim($archivo2)!="")
	    {
		   $sql="";  
		   $sql=$sql." INSERT INTO solicitud_adjunto ";
		   $sql=$sql." ( "; 
		   $sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
		   $sql=$sql." UsuarioRegistro,Activo,FechaModificacion,UsuarioModificacion,LlaveRegistro,Detalle "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." ".$IdSolicitud.",'".$archivo2."','".date("Y/m/d H:m")."','".$usuario."',1,'".date("Y/m/d H:m")."','".$usuario."','".rand(111111,999999)."','' "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql."  "; 
		   DB::unprepared($sql); 
	    }

	   //adjuntos 3
	   if(trim($archivo3)!="")
	    {
		   $sql="";  
		   $sql=$sql." INSERT INTO solicitud_adjunto ";
		   $sql=$sql." ( "; 
		   $sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
		   $sql=$sql." UsuarioRegistro,Activo,FechaModificacion,UsuarioModificacion,LlaveRegistro,Detalle "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." ".$IdSolicitud.",'".$archivo3."','".date("Y/m/d H:m")."','".$usuario."',1,'".date("Y/m/d H:m")."','".$usuario."','".rand(111111,999999)."','' "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql."  "; 
		   DB::unprepared($sql); 
	    }
		
 	   $mensaje="Su contacto ha sido radicado en nuestro sistema el ".date("Y/m/d H:m")." con el número ".$IdSolicitud." . La fecha de vencimiento es ".$FechaVencimiento;
	   return $mensaje;
  }
  
  /*
  reemplazar
  */
  public static function reemplazar($cadena)
  {
	$cadena=str_replace("-","",$cadena);  
	$cadena=str_replace("+","",$cadena);  
	$cadena=str_replace("'","",$cadena);  
	return $cadena;  
  }

 /*
 formatoFechaYMD | llega dd/MM/YYYY
 */
 public static function formatoFechaYMD($fecha)
 {
   if(trim($fecha)!="")
    {
      return substr($fecha, 6,4)."/".substr($fecha, 3, 2)."/".substr($fecha, 0, 2);
    }
   else
    {
	  return "";  
    }	   
 }
 
 /*
 formatoFechaDMY | llega YYYY/MM/dd
 */
 public static function formatoFechaDMY($fecha)
 {
   if(trim($fecha)!="")
    {
      return substr($fecha, 8, 2)."/".substr($fecha, 5, 2)."/".substr($fecha, 0, 4)  ;
    }
   else
    {
	  return ""; 
    }	   
 }
  
  
  /*
  borrarUsuarios
  */	
  public static  function borrarUsuarios($POST)
  {
	$sql = " DELETE FROM  perfil WHERE IdPerfil=3";
	DB::unprepared($sql);  
    return "1";
  }

  /*
  procesoMasivoNotificacionVencimiento
  */	
  public static  function procesoMasivoNotificacionVencimiento()
  {
    echo("PROCESO MASIVO NOTIFICACIÓN VENCIMIENTO<hr>");
	
	//consultar todas las solicitudes que no se encuentren en estado RESUELTO
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion, tipo_recepcion.DetalleTipoRecepcion,solicitud.Solicitud,solicitud.Telefono, ";  
	$sql=$sql." usuario.NombreCompleto as NombreCompletoDelegado,usuario.Email AS EmailDelegado  ";  
	$sql=$sql."   ";  
	$sql=$sql."   ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." LEFT JOIN tipo_recepcion ON tipo_recepcion.IdTipoRecepcion=solicitud.IdTipoRecepcion   ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.IdSolicitud > 0 ";  
	$sql=$sql." AND DetalleEstado<>'RESUELTO' ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
	
	//recorrer resultados
	$coleccionDatos=array();
	foreach ($listado as $row)
	 {
	   //conseguir el estado semaforo actual
       $estadoSemaforo=Pqr::semaforoEstadoActual($row->IdSolicitud);	   
	   
	   // 2 por vencer | 3 vencida
	   if(($estadoSemaforo==2 || $estadoSemaforo==3) && trim($row->EmailDelegado)!="")
	    {
		  $asunto="FONTUR Notificación. Caso Nro. ".$row->IdSolicitud;
		  $cuerpo="FONTUR CONTÁCTENOS<br>Caso Nro. ".$row->IdSolicitud;
		  
		  if($estadoSemaforo==2)
		   {
			   // 2 por vencer
		       $asunto="FONTUR Notificación vencimiento próximo. Caso Nro. ".$row->IdSolicitud;
		       $cuerpo="FONTUR CONTÁCTENOS<br>Caso Nro. ".$row->IdSolicitud." próximo a vencer. Por favor ingresar al sistema.";
		   }			  
		   
		  if($estadoSemaforo==3)
		   {
			   // 3 vencida
		       $asunto="FONTUR Notificación vencida. Caso Nro. ".$row->IdSolicitud;
		       $cuerpo="FONTUR CONTÁCTENOS<br>Caso Nro. ".$row->IdSolicitud." vencido. Por favor ingresar al sistema.";
		   }	
		   
		  //enviar email 
		  Pqr::envioMensajes("arueda_1980@hotmail.com",$asunto,$cuerpo);
		  Pqr::envioMensajes($row->EmailDelegado,$asunto,$cuerpo);
		  
	      echo("<br>ID solicitud: ".$row->IdSolicitud);
	      echo("<br>semaforo: ".$estadoSemaforo);
	      echo("<br>Nombre Delegado: ".$row->NombreCompletoDelegado);
	      echo("<br>Email Delegado: ".$row->EmailDelegado);
	      echo("<hr>");
	    }
	   
	 }
	
	
	
	exit();
	return "1";
  }
  
}
