<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Proceso;

class Contratos extends Controller
{
  /*
  index | admin listado
  */	
  public function index(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarContrato = $request->input('ingresarContrato', '');
	$IdProceso = $request->input('IdProceso', '');
	$IdProcesoDelete = $request->input('IdProcesoDelete', '');
	$LlaveRegistroDelete = $request->input('LlaveRegistroDelete', '');
	$generarDescargaDatos = $request->input('generarDescargaDatos', '');
	$paginaActual = $request->input('paginaActual', '1');
	$paginaActualId = $request->input('paginaActualId', '1');
	$consultaFormulario = $request->input('consultaFormulario', '');
	$presentarGrupo = $request->input('presentarGrupo', '');
	
	$post['valorTipoProceso'] = $request->input('valorTipoProceso', '');
	$post['valorContrato'] = $request->input('valorContrato', '');
	$post['valorEstadoProceso'] = $request->input('valorEstadoProceso', '');
	$post['valorDependenciaProceso'] = $request->input('valorDependenciaProceso', '');
	$post['valorMunicipioProceso'] = $request->input('valorMunicipioProceso', '');
	$post['valorFechaApertura'] = $request->input('valorFechaApertura', '');
	$post['valorFechaCierre'] = $request->input('valorFechaCierre', '');
	$post['valorMonedaProceso'] = $request->input('valorMonedaProceso', '');
	$post['valorCuantia'] = $request->input('valorCuantia', '');
	$post['valorObjeto'] = $request->input('valorObjeto', '');
	$post['valorNumeroFiltro'] = $request->input('valorNumeroFiltro', '');
	$post['valorTipoProcesoFiltro'] = $request->input('valorTipoProcesoFiltro', '');
	$post['valorFechaDesdeFiltro'] = $request->input('valorFechaDesdeFiltro', '');
	$post['valorFechaHastaFiltro'] = $request->input('valorFechaHastaFiltro', '');
	$post['valorEstadoFiltro'] = $request->input('valorEstadoFiltro', '');

	$post['Vigencia'] = $request->input('Vigencia', '');
	$post['Objeto'] = $request->input('Objeto', '');
	$post['EntidadProponente'] = $request->input('EntidadProponente', '');
	$post['Cobertura'] = $request->input('Cobertura', '');
	$post['LineaEstrategica'] = $request->input('LineaEstrategica', '');
	$post['Cuantia'] = $request->input('Cuantia', '');
	$post['ValorFontur'] = $request->input('ValorFontur', '');
	$post['ValorAprobado'] = $request->input('ValorAprobado', '');

    if(trim($presentarGrupo)!="")
     {
        $request->session()->put('TipoProcesoContratos', $presentarGrupo);
     }
	
	if(trim($IdProceso )=="")
	 {
	   $IdProceso="0"; 	
	 }
	 
	//borrar data
	if(trim($IdProcesoDelete)!="")
	 {
	   //borrar	
	   $mensajeTipo="1";
	   $mensaje="Registro eliminado";
	   Proceso::borrarContrato($IdProcesoDelete,$LlaveRegistroDelete);
	   Proceso::ingresarLog($request->session()->get('usuarioFontur'),"BORRO CONTRATO. ID: ".$IdProcesoDelete );
	 }	
	 
	//ingresar data
	if(trim($ingresarContrato)=="1")
	 {
	    if($request->session()->get('TipoProcesoContratos')=="1")
	     {
	        //contratos
    		if(trim($IdProceso)=="0")
    		 {
    		   //ingresar	
    		   $mensajeTipo="1";
    		   $mensaje=Proceso::crearProcesoContrato($post,$request->session()->get('usuarioFontur'),$request->session()->get('TipoProcesoContratos'));
    		 }
    		else
    		 {
    		   //actualizar	
    		   $mensajeTipo="1";
    		   $mensaje=Proceso::actualizarProcesoContrato($post,trim($IdProceso),$request->session()->get('usuarioFontur'));
    		   $IdProceso="0";
    		 }
	     }
	    else
	     {
	       //proyectos
	       
    		if(trim($IdProceso)=="0")
    		 {
    		   //ingresar	
    		   $mensajeTipo="1";
    		   $mensaje=Proceso::crearProcesoProyectoContrato($post,$request->session()->get('usuarioFontur'),$request->session()->get('TipoProcesoContratos'));
    		 }
    		else
    		 {
    		   //actualizar	
    		   $mensajeTipo="1";
    		   $mensaje=Proceso::actualizarProcesoProyectoContrato($post,trim($IdProceso),$request->session()->get('usuarioFontur'));
    		   $IdProceso="0";
    		 }
	     }
	 }
	
	//listado de contratos  
	$nombreArchivoDescarga="descarga_".date("YmdHi").rand(111111,999999).".csv";
	
	//tipo proceso
	$listadoTipoProceso= Proceso::listadoTipoProceso();
	
	if(trim($consultaFormulario)=="1")
	 {
	    //filtros
	    $request->session()->put('valorNumeroFiltro',trim($post['valorNumeroFiltro']));  
	    $request->session()->put('valorTipoProcesoFiltro',trim($post['valorTipoProcesoFiltro']));  
	    $request->session()->put('valorEstadoFiltro',trim($post['valorEstadoFiltro']));  
	    $request->session()->put('valorFechaDesdeFiltro',trim($post['valorFechaDesdeFiltro']));  
	    $request->session()->put('valorFechaHastaFiltro',trim($post['valorFechaHastaFiltro']));  
	 }


	if($request->session()->get('TipoProcesoContratos')=="1")
	 {
	   //contratos
	   
	   //Estado proceso
	   $listadoEstadoProceso= Proceso::listadoEstadoProceso();
	   
	   $listadoContratos= Proceso::listadoContratosXTipo($request,$post,$nombreArchivoDescarga,$generarDescargaDatos,$paginaActual,$request->session()->get('TipoProcesoContratos'));
	   
       //detalle proceso
       $registro= Contratos::detalleProceso($IdProceso);
	 }
	else
	 {
	   //proyectos
	   
	   //Estado proceso
	   $listadoEstadoProceso= Proceso::listadoEstadoProyectosProceso();
	   
	   $listadoContratos= Proceso::listadoContratosXProyectosTipo($request,$post,$nombreArchivoDescarga,$generarDescargaDatos,$paginaActual,$request->session()->get('TipoProcesoContratos'));
	   
       //detalle proceso
       $registro= Contratos::detalleProyectoProceso($IdProceso);
	 }
	
	//Dependencia
	$listadoDependencia= Proceso::listadoDependencia();
	//municipio
	$listadoMunicipio= Proceso::listadoMunicipio();
	//lista moneda
	$listadoMoneda= Proceso::listadoMoneda();
	
	$parametros['TipoProcesoContratos'] = $request->session()->get('TipoProcesoContratos');
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['IdProceso'] = $IdProceso;
	$parametros['listadoContratos'] = $listadoContratos;
	$parametros['listadoTipoProceso'] = $listadoTipoProceso;
	$parametros['listadoEstadoProceso'] = $listadoEstadoProceso;
	$parametros['listadoDependencia'] = $listadoDependencia;
	$parametros['listadoMunicipio'] = $listadoMunicipio;
	$parametros['listadoMoneda'] = $listadoMoneda;
	$parametros['registro'] = $registro;
	$parametros['valorNumeroFiltro'] = trim($request->session()->get('valorNumeroFiltro'));
	$parametros['valorTipoProcesoFiltro'] = trim($request->session()->get('valorTipoProcesoFiltro'));
	$parametros['valorFechaDesdeFiltro'] =  trim($request->session()->get('valorFechaDesdeFiltro'));
	$parametros['valorFechaHastaFiltro'] =  trim($request->session()->get('valorFechaHastaFiltro'));
	$parametros['nombreArchivoDescarga'] = $nombreArchivoDescarga;
	$parametros['generarDescargaDatos'] = $generarDescargaDatos;
	$parametros['paginaActual'] = $paginaActual;
	$parametros['paginaActualId'] = $paginaActualId;
	$parametros['valorEstadoFiltro'] = $request->session()->get('valorEstadoFiltro');
	$parametros['ModuloContratos'] = $request->session()->get('ModuloContratos');
	$parametros['ModuloMercadeo'] = $request->session()->get('ModuloMercadeo');
	$parametros['ModuloInfraestructura'] = $request->session()->get('ModuloInfraestructura');
	$parametros['ModuloCompetitividad'] = $request->session()->get('ModuloCompetitividad');
	return view("contratos",$parametros);    
  }

  /*
  listado | consulta-de-contratos
  */	 
  public function listado(Request $request,$id=null)
  {
	$mensajeTipo="0";	
	$mensaje="";
	$idContratoLink="";

    //POST
	$ingresarContrato = $request->input('ingresarContrato', '');
	$IdProceso = $request->input('IdProceso', '');
	$paginaActual = $request->input('paginaActual', '1');
	$paginaActualId = $request->input('paginaActualId', '1');
	$TipoProcesoContratos = $request->input('TipoProcesoContratos', '1');
	$consultaFormulario = $request->input('consultaFormulario', '');
	
	$post['valorTipoProceso'] = $request->input('valorTipoProceso', '');
	$post['valorContrato'] = $request->input('valorContrato', '');
	$post['valorEstadoProceso'] = $request->input('valorEstadoProceso', '');
	$post['valorDependenciaProceso'] = $request->input('valorDependenciaProceso', '');
	$post['valorMunicipioProceso'] = $request->input('valorMunicipioProceso', '');
	$post['valorFechaApertura'] = $request->input('valorFechaApertura', '');
	$post['valorFechaCierre'] = $request->input('valorFechaCierre', '');
	$post['valorMonedaProceso'] = $request->input('valorMonedaProceso', '');
	$post['valorCuantia'] = $request->input('valorCuantia', '');
	$post['valorObjeto'] = $request->input('valorObjeto', '');
	
	$post['valorTipoProcesoFiltro'] = $request->input('valorTipoProcesoFiltro', '');
	$post['valorFechaDesdeFiltro'] = $request->input('valorFechaDesdeFiltro', '');
	$post['valorFechaHastaFiltro'] = $request->input('valorFechaHastaFiltro', '');
	$post['valorEstadoFiltro'] = $request->input('valorEstadoFiltro', '');
	$post['valorNumeroFiltro'] = $request->input('valorNumeroFiltro', '');
	
	//link contrato
    if(trim($id) != "")
	 {
	    $request->session()->put('idContratoLink',trim($id));  
		return redirect('contratos-listado/');
	 }		
	
	//llego id contrato link
	if(trim($request->session()->get('idContratoLink')) != "")
	 {
		$post['valorNumeroFiltro'] = trim($request->session()->get('idContratoLink'));
	   	$request->session()->put('idContratoLink',"");
		$idContratoLink="1";
	 }
	
	if(trim($IdProceso )=="")
	 {
	   $IdProceso="0"; 	
	 }
	 

	if(trim($consultaFormulario)=="1")
	 {
	    //filtros
        //echo("+filtro...");
	    //$request->session()->put('valorNumeroFiltro',trim($post['valorNumeroFiltro']));  
	    //$request->session()->put('valorTipoProcesoFiltro',trim($post['valorTipoProcesoFiltro'])); 
	    //$request->session()->put('valorEstadoFiltro',trim($post['valorEstadoFiltro']));  
	    //$request->session()->put('valorFechaDesdeFiltro',trim($post['valorFechaDesdeFiltro']));  
	    //$request->session()->put('valorFechaHastaFiltro',trim($post['valorFechaHastaFiltro']));  
	 }
	
	if($TipoProcesoContratos=="1")
	 {
	   //contratos
	   //listado de contratos
       $listadoContratos= Proceso::listadoContratosXTipoExterna($request,$post,"","",$paginaActual,$TipoProcesoContratos);
	   
       //Estado proceso
	   $listadoEstadoProceso= Proceso::listadoEstadoProceso();
	 }
	else
	 {
	   //proyectos

	   //listado de proyectos
       $listadoContratos= Proceso::listadoContratosProyectosXTipoExterno($request,$post,"","",$paginaActual,$TipoProcesoContratos);
	   
       //Estado proceso
	   $listadoEstadoProceso= Proceso::listadoEstadoProyectosProceso();
	 }
	
	
	//tipo proceso
	$listadoTipoProceso= Proceso::listadoTipoProceso();
	//listado adjuntos
	$listadoAdjuntos= Proceso::listadoAdjuntosContratosTodos();
	
	$parametros['TipoProcesoContratos'] = $TipoProcesoContratos;
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['IdProceso'] = $IdProceso;
	$parametros['listadoContratos'] = $listadoContratos;
	$parametros['listadoAdjuntos'] = $listadoAdjuntos;
	$parametros['listadoTipoProceso'] = $listadoTipoProceso;
	
	$parametros['valorNumeroFiltro'] = trim($post['valorNumeroFiltro']);
	$parametros['valorTipoProcesoFiltro'] =trim($post['valorTipoProcesoFiltro']);
	$parametros['valorEstadoFiltro'] =  trim($post['valorEstadoFiltro']);
	$parametros['valorFechaDesdeFiltro'] =  trim($post['valorFechaDesdeFiltro']);
	$parametros['valorFechaHastaFiltro'] = trim($post['valorFechaHastaFiltro']);
	
 	$parametros['paginaActual'] = $paginaActual;
	$parametros['paginaActualId'] = $paginaActualId;
	$parametros['listadoEstadoProceso'] = $listadoEstadoProceso;
	$parametros['idContratoLink'] = $idContratoLink;
	return view("listado",$parametros);    
  }
  
  /*
  detalleProceso
  */
  function detalleProceso($IdProceso)
  {
	  $registro["IdProceso"]=$IdProceso; 
	  $registro["Codigo"]=""; 
	  $registro["IdTipoProceso"]=""; 
	  $registro["IdDependencia"]=""; 
      $registro["Numero"]="";  
	  $registro["FechaApertura"]=""; 
	  $registro["FechaCierre"]=""; 
	  $registro["IdMoneda"]=""; 
	  $registro["Cuantia"]="";  
	  $registro["Objeto"]=""; 
	  $registro["Activo"]=""; 
	  $registro["IdEstado"]=""; 
	  
	  if(trim($IdProceso)!="" && trim($IdProceso)!="0")
	   {
		  $listado=Proceso::listadoDetalleProceso($IdProceso);
		  foreach ($listado as $row) 
		   {
			  $registro["Codigo"]=$row->Codigo; 
			  $registro["IdTipoProceso"]=$row->IdTipoProceso; 
			  $registro["IdDependencia"]=$row->IdDependencia; 
			  $registro["Numero"]=$row->Numero; 
			  $registro["FechaApertura"]=Proceso::formatoFechaDMY($row->FechaApertura); 
			  $registro["FechaCierre"]=Proceso::formatoFechaDMY($row->FechaCierre); 
			  $registro["IdMoneda"]=$row->IdMoneda; 
			  $registro["Cuantia"]=$row->Cuantia; 
			  $registro["Objeto"]=$row->Objeto; 
			  $registro["Activo"]=$row->Activo; 
			  $registro["IdEstado"]=$row->IdEstado; 
		   }
	   }
	  
	 return $registro;  
  }
  
  /*
  detalleProyectoProceso
  */
  function detalleProyectoProceso($IdProceso)
  {
	  $registro["IdProceso"]=$IdProceso; 
	  $registro["Codigo"]=""; 
	  $registro["IdTipoProceso"]=""; 
	  $registro["IdDependencia"]=""; 
      $registro["Numero"]="";  
	  $registro["FechaApertura"]=""; 
	  $registro["FechaCierre"]=""; 
	  $registro["IdMoneda"]=""; 
	  $registro["Cuantia"]="";  
	  $registro["Objeto"]=""; 
	  $registro["Activo"]=""; 
	  $registro["IdEstado"]=""; 
	  $registro["Vigencia"]=""; 
	  $registro["IdEstadoProyecto"]=""; 
	  $registro["EntidadProponente"]=""; 
	  $registro["LineaEstrategica"]=""; 
	  $registro["ValorFontur"]=""; 
	  $registro["ValorAprobado"]=""; 
	  $registro["Cobertura"]=""; 

	  if(trim($IdProceso)!="" && trim($IdProceso)!="0")
	   {
		  $listado=Proceso::listadoDetalleProyectoProceso($IdProceso);
		  foreach ($listado as $row) 
		   {
			  $registro["Codigo"]=$row->Codigo; 
			  $registro["IdTipoProceso"]=$row->IdTipoProceso; 
			  $registro["IdDependencia"]=$row->IdDependencia; 
			  $registro["Numero"]=$row->Numero; 
			  $registro["FechaApertura"]=Proceso::formatoFechaDMY($row->FechaApertura); 
			  $registro["FechaCierre"]=Proceso::formatoFechaDMY($row->FechaCierre); 
			  $registro["IdMoneda"]=$row->IdMoneda; 
			  $registro["Cuantia"]=$row->Cuantia; 
			  $registro["Objeto"]=$row->Objeto; 
			  $registro["Activo"]=$row->Activo; 
			  $registro["Vigencia"]=$row->Vigencia; 
			  $registro["IdEstadoProyecto"]=$row->IdEstadoProyecto; 
			  $registro["EntidadProponente"]=$row->EntidadProponente; 
			  $registro["Cobertura"]=$row->Cobertura; 
			  $registro["LineaEstrategica"]=$row->LineaEstrategica; 
			  $registro["ValorFontur"]=$row->ValorFontur; 
			  $registro["ValorAprobado"]=$row->ValorAprobado; 
		   }
	   }
	  
	 return $registro;  
  }
  
}
