<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Configurar;
use App\Pqr;

class ConfigurarD extends Controller
{
  /*
  index
  */	
  public function index(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	  
	return view("configurar");   
  }

  /*
  dependencia
  */	
  public function dependencia(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearDependenciaConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarDependenciaConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado de solicitudes
	$listadoDependenciaConfig= Configurar::listadoDependenciaConfig();  
	//detalle registro
	$registro= Configurar::listadoDependenciaXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("dependencia",$parametros);    
  }

  /*
  estado
  */	
  public function estado(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearEstadoConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarEstadoConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoEstadosConfig();  
	//detalle registro
	$registro= Configurar::listadoEstadoXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("estado",$parametros);    
  }

  /*
  actuacion
  */	
  public function actuacion(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearActuacionConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarActuacionConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoActuacionConfig();  
	//detalle registro
	$registro= Configurar::listadoActuacionXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("actuacion",$parametros);    
  }

  /*
  respuestas
  */	
  public function respuestas(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorClase'] = $request->input('valorClase', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearRespuestaConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarRespuestaConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoRespuetasConfig();  
	//detalle registro
	$registro= Configurar::listadoRespuestaXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("respuestas",$parametros);    
  }

  /*
  clase
  */	
  public function clase(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorClase'] = $request->input('valorClase', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearClaseConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarClaseConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoClasesConfig();  
	//detalle registro
	$registro= Configurar::listadoClaseXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("clase",$parametros);    
  }

  /*
  tipoidentificacion
  */	
  public function tipoidentificacion(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearTipoIdentificacionConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarTipoidentificacionConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoTipoIdentificacionConfig();  
	//detalle registro
	$registro= Configurar::listadoTipoIdentificacionXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("tipoidentificacion",$parametros);    
  }

  /*
  festivos
  */	
  public function festivos(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearFestivosConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarFestivosConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoFestivosConfig();  
	//detalle registro
	$registro= Configurar::listadoFestivosXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("festivos",$parametros);    
  }

  /*
  semaforo
  */	
  public function semaforo(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$procesoColoresPQR = $request->input('procesoColoresPQR', '');
	$procesoNotificacionesPQR = $request->input('procesoNotificacionesPQR', '');
	$id = $request->input('id', '');
	$post['valorAmarillo'] = $request->input('valorAmarillo', '1');
	$post['valorRojo'] = $request->input('valorRojo', '1');
	$post['valorVencimiento'] = $request->input('valorVencimiento', '1');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   // $mensaje=Configurar::crearFestivosConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarSemaforoConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	
	///proceso colores semaforo
	if(trim($procesoColoresPQR)=="1")
	 {
	    Pqr::procesoMasivoCambioSemaforo();
	 }

	///proceso notificaciones semaforo
	if(trim($procesoNotificacionesPQR)=="1")
	 {
	    Pqr::procesoMasivoNotificacionVencimiento(); 
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoSemaforoConfig();  
	//detalle registro
	$registro= Configurar::listadoSemaforoXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("semaforo",$parametros);    
  }
  
  /*
  tipoProceso
  */	
  public function tipoProceso(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorTipo'] = $request->input('valorTipo', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearTipoprocesoConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarTipoProcesoConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoTipoProcesoConfig();  
	//detalle registro
	$registro= Configurar::listadoTipoProcesoXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	return view("tipoproceso",$parametros);    
  }

  /*
  usuarios
  */	
  public function usuarios(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$filtro = $request->input('valorFiltro', '');
	
	$post['valorDetalle'] = $request->input('valorDetalle', '');
	$post['valorNombreCompleto'] = $request->input('valorNombreCompleto', '');
	$post['valorPerfil'] = $request->input('valorPerfil', '');
	$post['valorClave'] = $request->input('valorClave', '');
	$post['valorActivo'] = $request->input('valorActivo', '');
	$post['valorParafiscal'] = $request->input('valorParafiscal', '');
	$post['valorMisional'] = $request->input('valorMisional', '');
	$post['valorToken'] = $request->input('valorToken', '');
	$post['valorRevisor'] = $request->input('valorRevisor', '');
	$post['valorTipoContratos'] = $request->input('valorTipoContratos', '');
	$post['valorGeneral'] = $request->input('valorGeneral', '');
	$post['valorMercadeo'] = $request->input('valorMercadeo', '');
	$post['valorInfraestructura'] = $request->input('valorInfraestructura', '');
	$post['valorCompetitividad'] = $request->input('valorCompetitividad', '');
	$post['valorUsuariosVacaciones'] = $request->input('valorUsuariosVacaciones', '');

	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   $mensajeTipo="1"; 	 
	   if(trim($id)=="0")
	    {
		   //ingresar	
		   $mensaje=Configurar::crearUsuariosConfig($post,$request->session()->get('usuarioFontur'));
	    }
	   else
	    {
		  //actualiza
		  $mensaje=Configurar::actualizarUsuarioConfig($id,$post,$request->session()->get('usuarioFontur'));
          $id="0";		  
	    }
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoUsuariosFiltroConfig(trim($filtro));  
	//listado perfiles 
	$listadoPerfilesConfig= Configurar::listadoPerfiles();  
	//detalle registro
	$registro= Configurar::listadoUsuariosXIDConfig($id);
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['registro'] = $registro;
	$parametros['listadoPerfilesConfig'] = $listadoPerfilesConfig;
	return view("usuarios",$parametros);    
  }

  /*
  usuariodependencia
  */	
  public function usuariodependencia(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarSolicitud = $request->input('ingresarSolicitud', '');
	$id = $request->input('id', '');
	$nombreCompleto = $request->input('nombreCompleto', '');
	$post['valorDependencia'] = $request->input('valorDependencia', '');
	
	if(trim($id)=="")
	 {
	   $id="0";	
	 }
	
	//ingresar data
	if(trim($ingresarSolicitud)=="1")
	 {
	   //ingresar	
	   $mensajeTipo="1"; 	 
	   $mensaje=Configurar::crearDependenciasUsuariosConfig($post,$id,$request->session()->get('usuarioFontur'));
	 }
	
	//listado  
	$listadoDependenciaConfig= Configurar::listadoDependenciasUsuariosConfig($id);  
	//listado dependencias 
	$listadoDependenciasConfig= Configurar::listadoDependencia();  
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['listadoDependenciaConfig'] = $listadoDependenciaConfig;
	$parametros['id'] = $id;
	$parametros['nombreCompleto'] = $nombreCompleto;
	$parametros['listadoDependenciasConfig'] = $listadoDependenciasConfig;
	return view("usuariodependencia",$parametros);    
  }
  
  /*
  PQR
  */	
  public function PQR(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	  
	return view("pqr");  //login
  }
  
  /*
  dashboard
  */	
  public function dashboard(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	return view("inicio");  
  }
  
  /*
  maestros
  */	
  public function maestros()
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	  
	return view("maestros");  
  }
  
  /*
  reportes
  */	
  public function reportes()
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	  
	return view("reportes");  
  }
  
}
