<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Proceso;

class Adjuntos extends Controller
{
  /*
  index
  */	
  public function index(Request $request)
  {
	//seguridad
    if(trim($request->session()->get('usuarioFontur')) == "")
	 {
		return redirect('login/');
	 }		
	
	$mensajeTipo="0";	
	$mensaje="";
	
    //POST
	$ingresarContrato = $request->input('ingresarContrato', '');
	$IdProceso = $request->input('IdProceso', '');
	$IdProcesoAdjuntoDelete = $request->input('IdProcesoAdjuntoDelete', '');
	$IdProcesoAdjuntoKeyDelete = $request->input('IdProcesoAdjuntoKeyDelete', '');
	$archivo = $request->file('archivo');
	$post['valorTipoProceso'] = $request->input('valorTipoProceso', '');
	$post['valorNroAdjuntoContrato'] = $request->input('valorNroAdjuntoContrato', '');
	$post['valorObjetoAdjunto'] = $request->input('valorObjetoAdjunto', '');
	
	if(trim($IdProceso )=="")
	 {
	   $IdProceso="0"; 	
	 }
	
	//borrar data
	if(trim($IdProcesoAdjuntoDelete)!="")
	 {
	   //borrar	
	   $mensajeTipo="1";
	   $mensaje="Registro eliminado";
	   Proceso::borrarAdjuntoContrato($IdProcesoAdjuntoDelete,$IdProcesoAdjuntoKeyDelete );
	   Proceso::ingresarLog($request->session()->get('usuarioFontur'),"BORRO ADJUNTO. ID: ".$IdProcesoAdjuntoDelete );
	 }	
	
	//ingresar data
	if(trim($ingresarContrato)=="1")
	 {
	   //ingresar	
	   if($archivo!="")
		{
		  if( $archivo->getClientOriginalExtension() == "pdf" || $archivo->getClientOriginalExtension() == "xlsx" || $archivo->getClientOriginalExtension() == "docx")
		   {
			   $mensajeTipo="1";
			   $mensaje="Registro ingresado";
			   $llaveArchivo=date("YmdHi").rand(1111,9999);	
			   Proceso::crearAdjuntoContrato($post,$request->session()->get('IdProceso'),$llaveArchivo.$archivo->getClientOriginalName(),$request->session()->get('usuarioFontur'));
			   $destinationPath = 'assets/pdf';
			   $archivo->move($destinationPath,$llaveArchivo.$archivo->getClientOriginalName());		
		   }
		  else
		   {
			   $mensajeTipo="0";
			   $mensaje="Por favor adjunte el archivo en formato PDF, Excel, Word";
		   }
		}
	   else
	    {
	 	   //sin archivo
		   $mensajeTipo="0";
	       $mensaje="Por favor adjunte el archivo";
	    }
	 }

	//detalle proceso
	$registro= Adjuntos::detalleProceso($IdProceso);
	 
	if(trim($IdProceso )!="" && trim($IdProceso )!="0")
	 {
	   $request->session()->put('Numero',$registro["Numero"]);
	   $request->session()->put('IdProceso',$registro["IdProceso"]);
	 }
	 
	//listado de adjuntos
	$listadoContratos= Proceso::listadoAdjuntosContratos($request->session()->get('IdProceso'),"");
	//tipo proceso
	$listadoTipoProceso= Proceso::listadoTipoDocumento();
	//Estado proceso
	$listadoEstadoProceso= Proceso::listadoEstadoProceso();
	//Dependencia
	$listadoDependencia= Proceso::listadoDependencia();
	//municipio
	$listadoMunicipio= Proceso::listadoMunicipio();
	//lista moneda
	$listadoMoneda= Proceso::listadoMoneda();
	
	$parametros['mensaje'] = $mensaje;
	$parametros['mensajeTipo'] = $mensajeTipo;
	$parametros['IdProceso'] = $IdProceso;
	$parametros['listadoContratos'] = $listadoContratos;
	$parametros['listadoTipoProceso'] = $listadoTipoProceso;
	$parametros['listadoEstadoProceso'] = $listadoEstadoProceso;
	$parametros['listadoDependencia'] = $listadoDependencia;
	$parametros['listadoMunicipio'] = $listadoMunicipio;
	$parametros['listadoMoneda'] = $listadoMoneda;
	$parametros['numeroProceso'] = $request->session()->get('Numero');
	return view("adjuntos",$parametros);    
  }
  
  /*
  detalleProceso
  */
  function detalleProceso($IdProceso)
  {
	  $registro["IdProceso"]=$IdProceso; 
	  $registro["Codigo"]=""; 
	  $registro["IdTipoProceso"]=""; 
	  $registro["IdDependencia"]=""; 
      $registro["Numero"]="";  
	  $registro["FechaApertura"]=""; 
	  $registro["FechaCierre"]=""; 
	  $registro["IdMoneda"]=""; 
	  $registro["Cuantia"]="";  
	  $registro["Objeto"]=""; 
	  $registro["Activo"]=""; 
	  $registro["IdEstado"]=""; 
	  
	  if(trim($IdProceso)!="" && trim($IdProceso)!="0")
	   {
		  $listado=Proceso::listadoDetalleProceso($IdProceso);
		  foreach ($listado as $row) 
		   {
			  $registro["Codigo"]=$row->Codigo; 
			  $registro["IdTipoProceso"]=$row->IdTipoProceso; 
			  $registro["IdDependencia"]=$row->IdDependencia; 
			  $registro["Numero"]=$row->Numero; 
			  $registro["FechaApertura"]=Proceso::formatoFechaDMY($row->FechaApertura); 
			  $registro["FechaCierre"]=Proceso::formatoFechaDMY($row->FechaCierre); 
			  $registro["IdMoneda"]=$row->IdMoneda; 
			  $registro["Cuantia"]=$row->Cuantia; 
			  $registro["Objeto"]=$row->Objeto; 
			  $registro["Activo"]=$row->Activo; 
			  $registro["IdEstado"]=$row->IdEstado; 
		   }
	   }
	  
	 return $registro;  
  }
  
  
}
