<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class Configurar extends Model
{
  /*
  listadoPQR
  */	
  public static  function listadoPQR($filtro,$TipoSolictud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion  ";  
	$sql=$sql."   ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.TipoSolictud=".$TipoSolictud;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY solicitud.IdSolicitud DESC ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoDetallePQR
  */	
  public static  function listadoDetallePQR($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." solicitud.TipoSolictud,solicitud.IdSolicitud,solicitud.Identificacion,solicitud.Solicitud,  ";  
	$sql=$sql." solicitud.FechaRegistro,solicitud.FechaVencimiento,solicitud.NombreCompleto,  ";  
	$sql=$sql." solicitud.Email,DetalleEstado,DetalleDependencia,  ";  
	$sql=$sql." solicitud.UsuarioModificacion  ";  
	$sql=$sql."   ";  
	$sql=$sql." FROM solicitud";  
	$sql=$sql." INNER JOIN estado_solicitud ON estado_solicitud.IdSolicitud=solicitud.IdSolicitud  AND estado_solicitud.ActivoEstado=1 ";  
	$sql=$sql." LEFT JOIN delegar ON delegar.IdSolicitud=solicitud.IdSolicitud  AND delegar.ActivoDelegar=1 ";  
	$sql=$sql." LEFT JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado  ";  
	$sql=$sql." LEFT JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." LEFT JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." LEFT JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." solicitud.IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDetalleUsuario
  */	
  public static  function listadoAdjuntosContratos($IdProceso,$filtro)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso_adjunto";  
	$sql=$sql." INNER JOIN tipo_documento ON tipo_documento.IdTipoDocumento=proceso_adjunto.IdTipoDocumento ";  
	$sql=$sql." ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY proceso_adjunto.IdProcesoAdjunto DESC ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDependenciaConfig
  */	
  public static  function listadoDependenciaConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleDependencia ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstadosConfig
  */	
  public static  function listadoEstadosConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM estado ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleEstado ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoActuacionConfig
  */	
  public static  function listadoActuacionConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM actuacion ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleActuacion ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoRespuetasConfig
  */	
  public static  function listadoRespuetasConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_recepcion ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleTipoRecepcion ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoClasesConfig
  */	
  public static  function listadoClasesConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM clase_solicitud ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleClase ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoIdentificacionConfig
  */	
  public static  function listadoTipoIdentificacionConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_identificacion ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleTipoIdentificacion ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoFestivosConfig
  */	
  public static  function listadoFestivosConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM festivos ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY FechaFestivo ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoSemaforoConfig
  */	
  public static  function listadoSemaforoConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM semaforo ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY IdSemaforo ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoTipoProcesoConfig
  */	
  public static  function listadoTipoProcesoConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_proceso ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleTipoProceso ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoUsuariosConfig
  */	
  public static  function listadoUsuariosConfig()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM usuario ";  
	$sql=$sql." INNER JOIN perfil ON perfil.IdPerfil=usuario.IdPerfil ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY NombreCompleto ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoUsuariosFiltroConfig
  */	
  public static  function listadoUsuariosFiltroConfig($filtro)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM usuario ";  
	$sql=$sql." INNER JOIN perfil ON perfil.IdPerfil=usuario.IdPerfil ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Email LIKE '%".$filtro."%'  OR NombreCompleto LIKE '%".$filtro."%' ";  
	$sql=$sql." ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY NombreCompleto ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDependenciasUsuariosConfig
  */	
  public static  function listadoDependenciasUsuariosConfig($IdUsuario)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia_usuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdUsuario=".$IdUsuario."  ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY DetalleDependencia ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  
  /*
  listadoDependenciaXIDConfig
  */	
  public static  function listadoDependenciaXIDConfig($IdDependencia)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdDependencia=".$IdDependencia;  
	$sql=$sql." ORDER BY DetalleDependencia ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstadoXIDConfig
  */	
  public static  function listadoEstadoXIDConfig($IdEstado)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdEstado=".$IdEstado;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoActuacionXIDConfig
  */	
  public static  function listadoActuacionXIDConfig($IdActuacion)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM actuacion ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdActuacion=".$IdActuacion;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoRespuestaXIDConfig
  */	
  public static  function listadoRespuestaXIDConfig($IdRespuesta)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_recepcion ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdTipoRecepcion=".$IdRespuesta;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoClaseXIDConfig
  */	
  public static  function listadoClaseXIDConfig($IdClase)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM clase_solicitud ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdClase=".$IdClase;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoIdentificacionXIDConfig
  */	
  public static  function listadoTipoIdentificacionXIDConfig($IdTipoIdentificacion)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_identificacion ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdTipoIdentificacion=".$IdTipoIdentificacion;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoFestivosXIDConfig
  */	
  public static  function listadoFestivosXIDConfig($IdFestivo)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM festivos ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdFestivo=".$IdFestivo;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoSemaforoXIDConfig
  */	
  public static  function listadoSemaforoXIDConfig($IdSemaforo)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM semaforo ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSemaforo=".$IdSemaforo;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoTipoProcesoXIDConfig
  */	
  public static  function listadoTipoProcesoXIDConfig($IdTipoProceso)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_proceso ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdTipoProceso=".$IdTipoProceso;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoUsuariosXIDConfig
  */	
  public static  function listadoUsuariosXIDConfig($IdUsuario)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM usuario ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdUsuario=".$IdUsuario;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoTipoProceso
  */	
  public static  function listadoTipoProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_proceso ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleTipoProceso  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoTipoDocumento
  */	
  public static  function listadoTipoDocumento()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM tipo_documento ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleTipoDocumento  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoEstadoProceso
  */	
  public static  function listadoEstadoProceso()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=1 ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDetalleProceso
  */	
  public static  function listadoDetalleProceso($IdProceso)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM proceso "; 
	$sql=$sql." INNER JOIN estado_proceso ON estado_proceso.IdProceso=proceso.IdProceso AND ActivoEstado=1 ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." proceso.IdProceso=".$IdProceso;  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoDependencia
  */	
  public static  function listadoDependencia()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM dependencia ";  
	$sql=$sql." ";  
	$sql=$sql." ORDER BY  DetalleDependencia  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoMunicipio
  */	
  public static  function listadoMunicipio()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  catastro ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." tipo='CM'  ";  
	$sql=$sql." ORDER BY  DESCRIPCION  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoMoneda
  */	
  public static  function listadoMoneda()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  moneda ";  
	$sql=$sql." ORDER BY  DetalleMoneda  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoActuaciones
  */	
  public static  function listadoActuaciones()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  actuacion ";  
	$sql=$sql." ORDER BY  DetalleActuacion  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoPerfiles
  */	
  public static  function listadoPerfiles()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  perfil ";  
	$sql=$sql." ORDER BY  Detalle  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoEstadosPQR
  */	
  public static  function listadoEstadosPQR()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  estado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Tipo=2 AND Activo=1 ";  
	$sql=$sql." ORDER BY  DetalleEstado  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoSeguimientos
  */	
  public static  function listadoSeguimientos($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  seguimiento ";  
	$sql=$sql." INNER JOIN actuacion ON actuacion.IdActuacion=seguimiento.IdActuacion ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdSeguimiento DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoEstadosSolicitud
  */	
  public static  function listadoEstadosSolicitud($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  estado_solicitud ";  
	$sql=$sql." INNER JOIN estado ON estado.IdEstado=estado_solicitud.IdEstado ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdEstadoSolicitud DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }

  /*
  listadoDelegadosSolicitud
  */	
  public static  function listadoDelegadosSolicitud($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  delegar ";  
	$sql=$sql." INNER JOIN dependencia_usuario ON dependencia_usuario.IdDependenciaUsuario=delegar.IdUsuario ";  
	$sql=$sql." INNER JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdDelegar DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoUsuariosXDependencia
  */	
  public static  function listadoUsuariosXDependencia()
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  dependencia_usuario ";  
	$sql=$sql." INNER JOIN usuario ON usuario.IdUsuario=dependencia_usuario.IdUsuario ";  
	$sql=$sql." INNER JOIN dependencia ON dependencia.IdDependencia=dependencia_usuario.IdDependencia ";  
	$sql=$sql."  ";  
	$sql=$sql." ORDER BY DetalleDependencia,NombreCompleto    ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  listadoAdjuntos
  */	
  public static  function listadoAdjuntos($IdSolicitud)
  {
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." * ";  
	$sql=$sql." FROM  solicitud_adjunto ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." IdSolicitud=".$IdSolicitud;  
	$sql=$sql." ORDER BY  IdSolicitudAdjunto DESC  ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
    return $listado;
  }
  
  /*
  actualizarProcesoContrato
  */	
  public static  function actualizarProcesoContrato($POST,$IdProceso,$usuario)
  {
	$mensaje="";
  
	$sql="";  
	$sql=$sql." UPDATE "; 
	$sql=$sql." proceso "; 
	$sql=$sql." SET "; 
	$sql=$sql." IdTipoProceso=".$POST["valorTipoProceso"].",IdDependencia=".$POST["valorDependenciaProceso"].", Codigo=".$POST["valorMunicipioProceso"].", "; 
	$sql=$sql." FechaApertura='".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."',FechaCierre='".Proceso::formatoFechaYMD($POST["valorFechaCierre"])."', "; 
	$sql=$sql." IdMoneda=".$POST["valorMonedaProceso"].",Cuantia='".$POST["valorCuantia"]."', "; 
	$sql=$sql." Objeto='".$POST["valorObjeto"]."',FechaModificacion='".date("Y/m/d H:i")."', "; 
	$sql=$sql." UsuarioModificacion='".$usuario."' "; 
	$sql=$sql."  "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProceso=".$IdProceso; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
	$mensaje="Contrato actualizado exitosamente.";
  
    return $mensaje;
  }

  /*
  crearAdjuntoContrato
  */	
  public static function crearAdjuntoContrato($POST,$IdProceso,$Archivo,$usuario)
  {
	$sql="";  
	$sql=$sql." INSERT INTO proceso_adjunto "; 
	$sql=$sql." ( "; 
	$sql=$sql." IdTipoDocumento,IdProceso,Archivo, "; 
	$sql=$sql." FechaRegistro,UsuarioRegistro,FechaModificacion, "; 
	$sql=$sql." UsuarioModificacion,Activo,LlaveRegistro, "; 
	$sql=$sql." Numero,Nombre "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." ( "; 
	$sql=$sql." ".$POST["valorTipoProceso"].",".$IdProceso.",'".$Archivo."', "; 
	$sql=$sql." '".date("Y/m/d H:i")."','".$usuario."','".date("Y/m/d H:i")."', "; 
	$sql=$sql." '".$usuario."',1,'".rand(111111,999999)."', "; 
	$sql=$sql." '".$POST["valorNroAdjuntoContrato"]."','".$POST["valorObjetoAdjunto"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }

  /*
  borrarAdjuntoContrato
  */	
  public static function borrarAdjuntoContrato( $IdProcesoAdjunto,$LlaveRegistro)
  {
	$sql="";  
	$sql=$sql." DELETE FROM proceso_adjunto "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdProcesoAdjunto=".$IdProcesoAdjunto; 
	$sql=$sql." AND LlaveRegistro='".$LlaveRegistro."' "; 
	$sql=$sql."  "; 
	DB::unprepared($sql); 
  }

  /*
  crearSeguimientoSolicitud
  */	
  public static function crearSeguimientoSolicitud($POST,$IdSolicitud,$ArchivoAdjunto,$usuario)
  {
	$sql="";  
	$sql=$sql." INSERT INTO seguimiento "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdSolicitud,IdActuacion, FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,ComentarioSeguimiento,LlaveRegistro,ArchivoAdjunto "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$IdSolicitud.",".$POST["valorActuacion"].",'".date("Y/m/d H:i")."', "; 
	$sql=$sql." '".$usuario."','".$POST["valorSolicitud"]."','".rand(111111,999999)."' ,'".$ArchivoAdjunto."' "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Seguimiento ingresado";
  }

  /*
  crearAdjuntosSolicitud
  */	
  public static function crearAdjuntosSolicitud($POST,$IdSolicitud,$ArchivoAdjunto,$usuario)
  {
	$sql="";  
	$sql=$sql." INSERT INTO solicitud_adjunto "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
	$sql=$sql." UsuarioRegistro,FechaModificacion,UsuarioModificacion, "; 
	$sql=$sql." Activo,LlaveRegistro,Detalle "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$IdSolicitud.",'".$ArchivoAdjunto."','".date("Y/m/d H:i")."', "; 
	$sql=$sql." '".$usuario."','".date("Y/m/d H:i")."','".$usuario."', "; 
	$sql=$sql." 1,'".rand(111111,999999)."','".$POST["valorSolicitud"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Adjunto ingresado";
  }

  /*
  crearEstadoSolicitud
  */	
  public static function crearEstadoSolicitud($POST,$IdSolicitud,$usuario)
  {
	$sql="";  
	$sql=$sql." UPDATE estado_solicitud "; 
	$sql=$sql." SET ActivoEstado=0 "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	$sql="";  
	$sql=$sql." INSERT INTO estado_solicitud "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdEstado,IdSolicitud,FechaRegistro,UsuarioRegistro, "; 
	$sql=$sql." ActivoEstado,Comentario "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$POST["valorEstado"].",".$IdSolicitud.",'".date("Y/m/d H:i")."','".$usuario."', "; 
	$sql=$sql." 1,'".$POST["valorSolicitud"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Estado ingresado";
  }

  /*
  crearDelegadoSolicitud
  */	
  public static function crearDelegadoSolicitud($POST,$IdSolicitud,$usuario)
  {
	$sql="";  
	$sql=$sql." UPDATE delegar "; 
	$sql=$sql." SET ActivoDelegar=0 "; 
	$sql=$sql." WHERE "; 
	$sql=$sql." IdSolicitud=".$IdSolicitud; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	$sql="";  
	$sql=$sql." INSERT INTO delegar "; 
	$sql=$sql." (  "; 
	$sql=$sql." IdUsuario,IdSolicitud,FechaCreacion, "; 
	$sql=$sql." UsuarioCreacion,LlaveRegistro,RequiereRevision,ActivoDelegar, "; 
	$sql=$sql." Comentario "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql." VALUES "; 
	$sql=$sql." (  "; 
	$sql=$sql." ".$POST["valorUsuario"].",".$IdSolicitud.",'".date("Y/m/d H:i")."', "; 
	$sql=$sql." '".$usuario."','".rand(111111,999999)."',".$POST["valorRevision"].",1,"; 
	$sql=$sql." '".$POST["valorSolicitud"]."' "; 
	$sql=$sql."  "; 
	$sql=$sql." ) "; 
	$sql=$sql."  "; 
	DB::unprepared($sql);
	
	return "Delegado ingresado";
  }
  
  /*
  crearProcesoContrato
  */	
  public static  function crearProcesoContrato($POST,$usuario)
  {
	$mensaje="";
	
	//validar que no exista el contrato
	$sql="";  
	$sql=$sql." SELECT ";  
	$sql=$sql." IdProceso ";  
	$sql=$sql." FROM  proceso ";  
	$sql=$sql." WHERE ";  
	$sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	$sql=$sql." ";  
	$listado=DB::select($sql);
     
	if(count($listado) == 0)
	 {
	   //crear
	   $sql="";
	   $sql=$sql." INSERT INTO proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." Codigo,IdTipoProceso,IdDependencia, "; 
	   $sql=$sql." Numero,FechaApertura,FechaCierre, "; 
	   $sql=$sql." IdMoneda,Cuantia,Objeto, "; 
	   $sql=$sql." Activo,UsuarioRegistro,UsuarioModificacion, "; 
	   $sql=$sql." LlaveRegistro,FechaModificacion "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$POST["valorMunicipioProceso"].",".$POST["valorTipoProceso"].",".$POST["valorDependenciaProceso"].", "; 
	   $sql=$sql." '".$POST["valorContrato"]."','".Proceso::formatoFechaYMD($POST["valorFechaApertura"])."','".Proceso::formatoFechaYMD($POST["valorFechaCierre"])."', "; 
	   $sql=$sql." ".$POST["valorMonedaProceso"].",'".$POST["valorCuantia"]."','".$POST["valorObjeto"]."', "; 
	   $sql=$sql." 1,'".$usuario."','".$usuario."', "; 
	   $sql=$sql." '".rand(111111,999999)."','".date("Y/m/d H:i")."' "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   //conseguir el ID contrato
	   $IdProceso="0";
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdProceso ";  
	   $sql=$sql." FROM  proceso ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Numero='".$POST["valorContrato"]."' ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   foreach ($listado as $row)
	    {
		   $IdProceso=$row->IdProceso;
	    }
	   
	   $sql="";  
	   $sql=$sql." INSERT INTO estado_proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." IdProceso,IdEstado,LlaveRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." ".$IdProceso.",".$POST["valorEstadoProceso"].",'".rand(111111,999999)."', "; 
	   $sql=$sql." '".$usuario."',1 "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Contrato creado exitosamente.";
	 }		
	else
	 {
		$mensaje="Error. Ya existe el número de contrato ".$POST["valorContrato"];
	 }
	 
	return $mensaje;
  }

  /*
  crearProcesoSolicitud
  */	
  public static  function crearProcesoSolicitud($POST,$archivo,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO solicitud "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." NombreCompleto,Identificacion,Email, "; 
	   $sql=$sql." Solicitud,Codigo,LlaveRegistro, "; 
	   $sql=$sql." FechaRegistro,Activo,FechaModificacion,UsuarioModificacion, "; 
	   $sql=$sql." Origen,FechaVencimiento,TipoSolictud "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorNombreCompleto"]."','".$POST["valorIdentificacion"]."','".$POST["valorEmailicitud"]."', "; 
	   $sql=$sql." '".$POST["valorSolicitud"]."','CODIGO','".rand(111111,999999)."', "; 
	   $sql=$sql." '".date("Y/m/d H:i")."',1,'".date("Y/m/d H:i")."','".$usuario."', "; 
	   $sql=$sql." 1,'".date("Y/m/d H:i")."',".$POST["valorTipo"]; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   //conseguir el ID contrato
	   $IdSolicitud="0";
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdSolicitud ";  
	   $sql=$sql." FROM  solicitud ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Identificacion='".$POST["valorIdentificacion"]."' ";  
	   $sql=$sql." ORDER BY IdSolicitud DESC ";  
	   $sql=$sql." LIMIT 1 ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   foreach ($listado as $row)
	    {
		   $IdSolicitud=$row->IdSolicitud;
	    }
	   
	   $sql="";  
	   $sql=$sql." INSERT INTO estado_solicitud ";
	   $sql=$sql." ( "; 
	   $sql=$sql." IdEstado,IdSolicitud,FechaRegistro, "; 
	   $sql=$sql." UsuarioRegistro,ActivoEstado "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." 2,".$IdSolicitud.",'".date("Y/m/d H:i")."','".$usuario."',1 "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql."  "; 
	   DB::unprepared($sql); 
	   
	   //adjuntos
	   if(trim($archivo)!="")
	    {
		   $sql="";  
		   $sql=$sql." INSERT INTO solicitud_adjunto ";
		   $sql=$sql." ( "; 
		   $sql=$sql." IdSolicitud,Archivo,FechaRegistro, "; 
		   $sql=$sql." UsuarioRegistro,Activo,FechaModificacion,UsuarioModificacion,LlaveRegistro,Detalle "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." ".$IdSolicitud.",'".$archivo."','".date("Y/m/d H:i")."','".$usuario."',1,'".date("Y/m/d H:i")."','".$usuario."','".rand(111111,999999)."','' "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql."  "; 
		   DB::unprepared($sql); 
	    }
	   
	   $mensaje="Soliciud creada exitosamente.";
	 
	   return $mensaje;
  }

  /*
  crearDependenciaConfig
  */	
  public static  function crearDependenciaConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO dependencia "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleDependencia, Activo,Tipo "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES "; 
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."',".$POST["valorActivo"].",".$POST["valorTipo"]." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearEstadoConfig
  */	
  public static  function crearEstadoConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO estado "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleEstado, Activo,Tipo "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."',".$POST["valorActivo"].",".$POST["valorTipo"]." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearActuacionConfig
  */	
  public static  function crearActuacionConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO actuacion "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleActuacion  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."'  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearRespuestaConfig
  */	
  public static  function crearRespuestaConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO tipo_recepcion "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleTipoRecepcion,TipoSolicitud  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."',".$POST["valorClase"]."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearClaseConfig
  */	
  public static  function crearClaseConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO clase_solicitud "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleClase,TipoSolicitud  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."',".$POST["valorClase"]." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearTipoIdentificacionConfig
  */	
  public static  function crearTipoIdentificacionConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO tipo_identificacion "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleTipoIdentificacion  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."'  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearFestivosConfig
  */	
  public static  function crearFestivosConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO festivos "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  FechaFestivo  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."'  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }
  
  /*
  crearTipoprocesoConfig
  */	
  public static  function crearTipoprocesoConfig($POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." INSERT INTO tipo_proceso "; 
	   $sql=$sql." ( "; 
	   $sql=$sql."  DetalleTipoProceso,Activo  "; 
	   $sql=$sql."  "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." VALUES ";
	   $sql=$sql." ( "; 
	   $sql=$sql." '".$POST["valorDetalle"]."' ,".$POST["valorActivo"]." "; 
	   $sql=$sql." ) "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }

  /*
  crearUsuariosConfig
  */	
  public static  function crearUsuariosConfig($POST,$usuario)
  {
	   $mensaje="";
	   
	   //validar si el login existe
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdUsuario ";  
	   $sql=$sql." FROM  usuario ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." Email='".trim($POST["valorDetalle"])."'   ";  
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   
	   if(count($listado) == 0)
	    {
		   $sql="";
		   $sql=$sql." INSERT INTO usuario "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." Email,NombreCompleto, Clave,  "; 
		   $sql=$sql." Activo,IdPerfil,LlaveRegistro, "; 
		   $sql=$sql." FechaRegistro,Parafiscal,Misional,token,Revisor,TipoProcesoContratos, "; 
		   $sql=$sql." ModuloContratos,ModuloMercadeo,ModuloInfraestructura,ModuloCompetitividad,UsuariosVacaciones "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES ";
		   $sql=$sql." ( "; 
		   $sql=$sql." '".$POST["valorDetalle"]."','".$POST["valorNombreCompleto"]."','".md5($POST["valorClave"])."',  "; 
		   $sql=$sql." ".$POST["valorActivo"].",".$POST["valorPerfil"].",'".rand(111111,999999)."', "; 
		   $sql=$sql." '".date("Y/m/d H:i")."',".$POST["valorParafiscal"].",".$POST["valorMisional"].", "; 
		   $sql=$sql." '".$POST["valorToken"]."',".$POST["valorRevisor"].",".$POST["valorTipoContratos"].",   "; 
		   $sql=$sql." ".$POST["valorGeneral"].",".$POST["valorMercadeo"].",".$POST["valorInfraestructura"].",".$POST["valorCompetitividad"].", "; 
		   $sql=$sql." '".$POST["valorUsuariosVacaciones"]."' "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." "; 
		   DB::unprepared($sql); 
		   $mensaje="Registro realizado exitosamente.";
	    }	
	   else
	    {
		   $mensaje="ERROR: el email ya se encuentra registrado.";
	    }
		
	   return $mensaje;
  }

  /*
  crearDependenciasUsuariosConfig
  */	
  public static  function crearDependenciasUsuariosConfig($POST,$IdUsuario,$usuario)
  {
	   $mensaje="";
	   
	   //validar que no exista usurio en la dependencia
	   $sql="";  
	   $sql=$sql." SELECT ";  
	   $sql=$sql." IdDependenciaUsuario ";  
	   $sql=$sql." FROM  dependencia_usuario ";  
	   $sql=$sql." WHERE ";  
	   $sql=$sql." IdUsuario=".$IdUsuario."  ";  
	   $sql=$sql." AND IdDependencia=".$POST["valorDependencia"]." ";
	   $sql=$sql." ";  
	   $listado=DB::select($sql);
	   if(count($listado) == 0)
		 {
		   $sql="";
		   $sql=$sql." INSERT INTO dependencia_usuario "; 
		   $sql=$sql." ( "; 
		   $sql=$sql." IdUsuario,IdDependencia  "; 
		   $sql=$sql."  "; 
		   $sql=$sql."  "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." VALUES ";
		   $sql=$sql." ( "; 
		   $sql=$sql." ".$IdUsuario.",".$POST["valorDependencia"]." "; 
		   $sql=$sql."  "; 
		   $sql=$sql."  "; 
		   $sql=$sql." ) "; 
		   $sql=$sql." "; 
		   DB::unprepared($sql); 
		 }
	   
	   $mensaje="Registro realizado exitosamente.";
	   return $mensaje;
  }
  
  /*
  actualizarDependenciaConfig
  */	
  public static  function actualizarDependenciaConfig($IdDependencia,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  dependencia "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleDependencia='".$POST["valorDetalle"]."',Activo=".$POST["valorActivo"].",Tipo=".$POST["valorTipo"]." "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdDependencia=".$IdDependencia." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarEstadoConfig
  */	
  public static  function actualizarEstadoConfig($IdEstado,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  estado "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleEstado='".$POST["valorDetalle"]."',Activo=".$POST["valorActivo"].",Tipo=".$POST["valorTipo"]." "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdEstado=".$IdEstado." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarActuacionConfig
  */	
  public static  function actualizarActuacionConfig($IdActuacion,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  actuacion "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleActuacion='".$POST["valorDetalle"]."'  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdActuacion=".$IdActuacion." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarRespuestaConfig
  */	
  public static  function actualizarRespuestaConfig($IdRespuesta,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  tipo_recepcion "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleTipoRecepcion='".$POST["valorDetalle"]."',TipoSolicitud=".$POST["valorClase"]."  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdTipoRecepcion=".$IdRespuesta." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarClaseConfig
  */	
  public static  function actualizarClaseConfig($IdClase,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  clase_solicitud "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleClase='".$POST["valorDetalle"]."',TipoSolicitud=".$POST["valorClase"]."  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdClase=".$IdClase." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarTipoidentificacionConfig
  */	
  public static  function actualizarTipoidentificacionConfig($IdTipoIdentificacion,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  tipo_identificacion "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleTipoIdentificacion='".$POST["valorDetalle"]."'  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdTipoIdentificacion=".$IdTipoIdentificacion." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarFestivosConfig
  */	
  public static  function actualizarFestivosConfig($IdFestivo,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  festivos "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." FechaFestivo='".$POST["valorDetalle"]."'  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdFestivo=".$IdFestivo." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarSemaforoConfig
  */	
  public static  function actualizarSemaforoConfig($IdSemaforo,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  semaforo "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." Amarillo='".$POST["valorAmarillo"]."',Rojo='".$POST["valorRojo"]."',Vencimiento='".$POST["valorVencimiento"]."'  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdSemaforo=".$IdSemaforo." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }
  
  /*
  actualizarTipoProcesoConfig
  */	
  public static  function actualizarTipoProcesoConfig($IdTipoProceso,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  tipo_proceso "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." DetalleTipoProceso='".$POST["valorDetalle"]."',Activo=".$POST["valorActivo"]."  "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdTipoProceso=".$IdTipoProceso." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }

  /*
  actualizarUsuarioConfig
  */	
  public static  function actualizarUsuarioConfig($IdUsuario,$POST,$usuario)
  {
	   $mensaje="";
	
	   $sql="";
	   $sql=$sql." UPDATE  usuario "; 
	   $sql=$sql." SET "; 
	   $sql=$sql." TipoProcesoContratos=".$POST["valorTipoContratos"].",token='".$POST["valorToken"]."',Activo=".$POST["valorActivo"].",  "; 
	   $sql=$sql." NombreCompleto='".$POST["valorNombreCompleto"]."', "; 
	   $sql=$sql." IdPerfil=".$POST["valorPerfil"].",Parafiscal=".$POST["valorParafiscal"]." , Misional=".$POST["valorMisional"].", "; 
	   $sql=$sql." Revisor=".$POST["valorRevisor"]." , "; 
	   $sql=$sql." ModuloContratos=".$POST["valorGeneral"].", ModuloMercadeo=".$POST["valorMercadeo"].", ModuloInfraestructura=".$POST["valorInfraestructura"].",ModuloCompetitividad=".$POST["valorCompetitividad"].", "; 
	   $sql=$sql." UsuariosVacaciones='".$POST["valorUsuariosVacaciones"]."' "; 
	   $sql=$sql." "; 
	   $sql=$sql." WHERE "; 
	   $sql=$sql." IdUsuario=".$IdUsuario." "; 
	   $sql=$sql." "; 
	   $sql=$sql." "; 
	   DB::unprepared($sql); 
	   
	   if(trim($POST["valorClave"])!="")
	    {
		   $sql="";
		   $sql=$sql." UPDATE  usuario "; 
		   $sql=$sql." SET "; 
		   $sql=$sql." Clave='".md5($POST["valorClave"])."' "; 
		   $sql=$sql." "; 
		   $sql=$sql." WHERE "; 
		   $sql=$sql." IdUsuario=".$IdUsuario." "; 
		   $sql=$sql." "; 
		   $sql=$sql." "; 
		   DB::unprepared($sql); 
	    }
	   
	   $mensaje="Registro actualizado exitosamente.";
	   return $mensaje;
  }
  
  /*
  reemplazar
  */
  public static function reemplazar($cadena)
  {
	$cadena=str_replace("-","",$cadena);  
	$cadena=str_replace("'","",$cadena);  
	return $cadena;  
  }

 /*
 formatoFechaYMD | llega dd/MM/YYYY
 */
 public static function formatoFechaYMD($fecha)
 {
   if(trim($fecha)!="")
    {
      return substr($fecha, 6,4)."/".substr($fecha, 3, 2)."/".substr($fecha, 0, 2);
    }
   else
    {
	  return "";  
    }	   
 }
 
 /*
 formatoFechaDMY | llega YYYY/MM/dd
 */
 public static function formatoFechaDMY($fecha)
 {
   if(trim($fecha)!="")
    {
      return substr($fecha, 8, 2)."/".substr($fecha, 5, 2)."/".substr($fecha, 0, 4)  ;
    }
   else
    {
	  return ""; 
    }	   
 }
  
  
  /*
  borrarUsuarios
  */	
  public static  function borrarUsuarios($POST)
  {
	$sql = " DELETE FROM  perfil WHERE IdPerfil=3";
	DB::unprepared($sql);  
    return "1";
  }
  
}
