<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;


class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        Role::truncate();
        Permission::truncate();
        User::truncate();


        $superAdminRole = Role::create(['name' => 'super-admin', 'display_name' => 'Super Administrador', 'description' => 'Rol administracion del sistema', 'creator_user_id' => 1, 'updater_user_id' => 1]);
        $adminRole = Role::create(['name' => 'admin', 'display_name' => 'Administrador', 'description' => 'Rol administrador', 'creator_user_id' => 1, 'updater_user_id' => 1]);
        $usuarioRole = Role::create(['name' => 'user', 'display_name' => 'Usuario', 'description' => 'Rol usuario normal', 'creator_user_id' => 1, 'updater_user_id' => 1]);

        $viewUserPermission = Permission::create(['name' => 'Ver usuarios', 'description' => 'Permiso para ver usuarios']);
        $createUserPermission = Permission::create(['name' => 'Crear usuarios', 'description' => 'Permiso para crear usuarios']);
        $updateUserPermission = Permission::create(['name' => 'Actualizar usuarios', 'description' => 'Permiso para editar usuarios']);

        $viewRolePermission = Permission::create(['name' => 'Ver roles', 'description' => 'Permiso para ver roles']);
        $createRolePermission = Permission::create(['name' => 'Crear roles', 'description' => 'Permiso para crear roles']);
        $updateRolePermission = Permission::create(['name' => 'Actualizar roles', 'description' => 'Permiso para editar roles']);
        $deleteRolePermission = Permission::create(['name' => 'Eliminar roles', 'description' => 'Permiso para editar roles']);

        $fileManagerPermission = Permission::create(['name' => 'File Manager', 'description' => 'Permiso para administrar los documentos']);

        $appsPermission = Permission::create(['name' => 'Herramientas', 'description' => 'Permiso para ingresar a las herramientas fontur']);
        $portalPermission = Permission::create(['name' => 'Portal', 'description' => 'Permiso para administrar el contenido del portal']);
        $salesforcelPermission = Permission::create(['name' => 'Salesforce', 'description' => 'Permiso para el ingreso a salesforce']);
        $capacitacionesPermission = Permission::create(['name' => 'Capacitaciones', 'description' => 'Permiso para el ingreso al aplicativo de capacitaciones']);
        $centinelaPermission = Permission::create(['name' => 'Centinela', 'description' => 'Permiso para el ingreso a Centinela']);
        $sinefPermission = Permission::create(['name' => 'Sinef', 'description' => 'Permiso para el ingreso a SINEF']);

        $viewDepartamentoPermission = Permission::create(['name' => 'Ver Departamentos', 'description' => 'Permiso para ver departamentos']);
        $createDepartamentoPermission = Permission::create(['name' => 'Crear Departamentos', 'description' => 'Permiso para crear departamentos']);
        $updateDepartamentoPermission = Permission::create(['name' => 'Actualizar Departamentos', 'description' => 'Permiso para editar departamentos']);
        

    
        $adminRole->givePermissionTo($viewDepartamentoPermission);
        $adminRole->givePermissionTo($createDepartamentoPermission);
        $adminRole->givePermissionTo($updateDepartamentoPermission);


        $adminRole->givePermissionTo($viewUserPermission);
        $adminRole->givePermissionTo($createUserPermission);
        $adminRole->givePermissionTo($updateUserPermission);

        $adminRole->givePermissionTo($viewRolePermission);
        $adminRole->givePermissionTo($createRolePermission);
        $adminRole->givePermissionTo($updateRolePermission);
        $adminRole->givePermissionTo($deleteRolePermission);

        $adminRole->givePermissionTo($fileManagerPermission);

        $adminRole->givePermissionTo($appsPermission);
        $adminRole->givePermissionTo($portalPermission);
        $adminRole->givePermissionTo($salesforcelPermission);
        $adminRole->givePermissionTo($capacitacionesPermission);
        $adminRole->givePermissionTo($centinelaPermission);
        $adminRole->givePermissionTo($sinefPermission);

        $usuarioRole->givePermissionTo($capacitacionesPermission);
        $usuarioRole->givePermissionTo($centinelaPermission);
        $usuarioRole->givePermissionTo($sinefPermission);


        $admin = new User();
        $admin->name = 'Andrés Ballesteros';
        $admin->email = 'andresballesteros1988@gmail.com';
        $admin->password = 'Andres88120860369';
        $admin->active = true;
        $admin->token = Str::random(10);
        $admin->creator_user_id = 1;
        $admin->updater_user_id = 1;
        $admin->save();
        $admin->assignRole($superAdminRole);

        $writer = new User;
        $writer->name = 'Orlando Sandoval';
        $writer->email = 'nito140@gmail.com';
        $writer->password = 'orlando123';
        $writer->active = true;
        $writer->token = Str::random(10);
        $writer->creator_user_id = 1;
        $writer->updater_user_id = 1;
        $writer->save();
        $writer->assignRole($superAdminRole);

        $writer = new User;
        $writer->name = 'Vanessa Sandoval';
        $writer->email = 'vsandoval141@gmail.com';
        $writer->password = 'vanessa123';
        $writer->active = true;
        $writer->token = Str::random(10);
        $writer->creator_user_id = 1;
        $writer->updater_user_id = 1;
        $writer->save();
        $writer->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Astrid Johanna Uyaban Macias';
        $user->email = 'auyaban@fontur.com.co';
        $user->password = 'astrid123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'COORDINACIÓN DOCUMENTAL CORPORATIVA';
        $user->cargo = 'AUXILIAR DE ARCHIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan Carlos Escobar Barrera';
        $user->email = 'jcescobar@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'DIRECTOR DE APOYO A LAS REGIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Amin Enrique Diaz Yances';
        $user->email = 'aediaz@fontur.com.co';
        $user->password = 'amin123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carlos Andres Arredondo';
        $user->email = 'carredondo@fontur.com.co';
        $user->password = 'carlos123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carlos Mario Gil Mejia';
        $user->email = 'cgil@fontur.com.co';
        $user->password = 'carlos123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ivan Atuesta Garzon';
        $user->email = 'iatuesta@fontur.com.co';
        $user->password = 'ivan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ivon Adela Nelson Manuel';
        $user->email = 'inelson@fontur.com.co';
        $user->password = 'ivon123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luisa Fernanda Portilla Barco';
        $user->email = 'lportilla@fontur.com.co';
        $user->password = 'luisa123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Texeira Tatiana Aguilar';
        $user->email = 'taguilar@fontur.com.co';
        $user->password = 'texeira123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Dora Angelica Vargas Diaz';
        $user->email = 'dvargas@fontur.com.co';
        $user->password = 'dora123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTORA REGIONAL NEIVA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Tania Beatriz Peñafiel España';
        $user->email = 'tpenafiel@fontur.com.co';
        $user->password = 'tania123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTORA REGIONAL NEIVA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carlos Esteban Cardona Barguil';
        $user->email = 'ccardona@fontur.com.co';
        $user->password = 'carlos123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'PROFESIONAL DE APOYO A LAS REGIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Hermes Mauricio Narvaez';
        $user->email = 'hnarvaez@fontur.com.co';
        $user->password = 'hermes123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'PROFESIONAL MICITIO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jaime Andres Garcia Hellal';
        $user->email = 'jagarcia@fontur.com.co';
        $user->password = 'jaime123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'PROFESIONAL SENIOR DE APOYO A LAS REGIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Oscar Francisco Gomez Palacios';
        $user->email = 'ogomez@fontur.com.co';
        $user->password = 'oscar123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE APOYO A LAS REGIONES';
        $user->cargo = 'GESTOR REGIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lina Fernanda Prado';
        $user->email = 'lprado@fontur.com.co';
        $user->password = 'lina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'ASESOR DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Karen Johana Vargas Barrero';
        $user->email = 'kvargas@fontur.com.co';
        $user->password = 'karen123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'AUXILIAR DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diego Alejandro Pulido Rubio';
        $user->email = 'dpulido@fontur.com.co';
        $user->password = 'diego123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diana Maria Perafan Velasquez';
        $user->email = 'dperafan@fontur.com.co';
        $user->password = 'diana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Elijohanna Rodriguez Rubiano';
        $user->email = 'erodriguez@fontur.com.co';
        $user->password = 'elijohanna123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Evelyn Vasquez Barbosa';
        $user->email = 'evasquez@fontur.com.co';
        $user->password = 'evelyn123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Karen Julieth Celis Yara';
        $user->email = 'kcelis@fontur.com.co';
        $user->password = 'karen123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luisa Fernanda Bejarano A';
        $user->email = 'lbejarano@fontur.com.co';
        $user->password = 'luisa123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Paula Andrea Gomez Rivera';
        $user->email = 'pgomez@fontur.com.co';
        $user->password = 'paula123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Yuliana Bustamante Castrillon';
        $user->email = 'ybustamante@fontur.com.co';
        $user->password = 'yuliana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lina Natalia Ramirez';
        $user->email = 'lramirez@fontur.com.co';
        $user->password = 'lina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL SENIOR DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Natalia Riaño Davila';
        $user->email = 'ariano@fontur.com.co';
        $user->password = 'natalia123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE COMPETITIVIDAD';
        $user->cargo = 'PROFESIONAL DE COMPETITIVIDAD';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Hector Enrique Sandoval Duarte';
        $user->email = 'hsandoval@fontur.com.co';
        $user->password = 'hector123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'ASESOR DE COMUNICACIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan Camilo Ayala Daza';
        $user->email = 'jayala@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'DIRECTOR DE COMUNICACIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Miller Hernán Espitia Ruiz';
        $user->email = 'mespitia@fontur.com.co';
        $user->password = 'miller123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'DISEÑADOR GRAFICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniela Alejandra Correa Grisales';
        $user->email = 'dcorrea@fontur.com.co';
        $user->password = 'daniela123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'PRACTICANTE DE COMUNICACIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Natalia Andrea Guzmán Sanin';
        $user->email = 'nguzman@fontur.com.co';
        $user->password = 'natalia123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'PROFESIONAL COMUNICACIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ana Maria Cordoba Cadena';
        $user->email = 'acordoba@fontur.com.co';
        $user->password = 'ana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'PROFESIONAL DE COMUNICACIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Fernando Roa Botero';
        $user->email = 'froa@fontur.com.co';
        $user->password = 'fernando123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'PROFESIONAL DE COMUNICACIONES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Adriana Lorena Prieto Gomez';
        $user->email = 'aprieto@fontur.com.co';
        $user->password = 'adriana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE COMUNICACIONES';
        $user->cargo = 'PROFESIONAL DE COMUNICACIONES Y EVENTOS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniel Muñoz';
        $user->email = 'dmunoz@fontur.com.co';
        $user->password = 'daniel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRALORIA';
        $user->cargo = 'DIRECTOR DE CONTRALORIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Andrea Luengas Pachon';
        $user->email = 'aluengas@fontur.com.co';
        $user->password = 'andrea123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRALORIA';
        $user->cargo = 'PROFESIONAL DE CONTRALORIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Yeimi Triana Moreno';
        $user->email = 'ytriana@fontur.com.co';
        $user->password = 'yeimi123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'ANALISTA DE CONTRIBUCION PARAFISCAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Christian C Cortes Guerrero';
        $user->email = 'ccortes@fontur.com.co';
        $user->password = 'christian123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JUNIOR CONTRIBUCION PARAFISCAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lerwin F Pulido Aroca';
        $user->email = 'lpulido@fontur.com.co';
        $user->password = 'lerwin123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JUNIOR CONTRIBUCION PARAFISCAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniela Ardila Castaneda';
        $user->email = 'dardila@fontur.com.co';
        $user->password = 'daniela123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JUNIOR SECTORIAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan Carlos Mendivil Hernandez';
        $user->email = 'jmendivil@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JUNIOR SECTORIAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Laura Patricia Mateus Ramirez';
        $user->email = 'lmateus@fontur.com.co';
        $user->password = 'laura123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JURIDICO CONTRIBUCION PARAFISCAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Paola Andrea Suarez Panqueva';
        $user->email = 'psuarez@fontur.com.co';
        $user->password = 'paola123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JURIDICO CONTRIBUCION PARAFISCAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Victoria Ivonne Hernandez Vargas';
        $user->email = 'vhernandez@fontur.com.co';
        $user->password = 'victoria123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL JURIDICO SENIOR DE CONTRIBUCIÓN PARAFISCAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Adriana del Pilar Paez Henriquez';
        $user->email = 'apaez@fontur.com.co';
        $user->password = 'adriana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL SENIOR AUDITORIA Y GESTIÓN PERSUASIVA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diana Moreno Grimaldo';
        $user->email = 'dmoreno@fontur.com.co';
        $user->password = 'diana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE CONTRIBUCION PARAFISCAL';
        $user->cargo = 'PROFESIONAL SENIOR DE RECAUDO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ituriel Giraldo Marin';
        $user->email = 'igiraldo@fontur.com.co';
        $user->password = 'ituriel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'ANALISTA DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'María Victoria Florez';
        $user->email = 'mflorez@fontur.com.co';
        $user->password = 'maría123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'DIRECTORA DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Alberto Orlando Buenano Ortiz';
        $user->email = 'abuenano@fontur.com.co';
        $user->password = 'alberto123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'David Ricardo Perez Rodriguez';
        $user->email = 'dperez@fontur.com.co';
        $user->password = 'david123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Fredy Arias Medina';
        $user->email = 'fmedina@fontur.com.co';
        $user->password = 'fredy123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan Carlos Rozo Fernandez';
        $user->email = 'jrozo@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan David Niño';
        $user->email = 'jnino@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan Ramon Baron Zambrano';
        $user->email = 'jbaron@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Leida Valencia Mosquera';
        $user->email = 'lvalencia@fontur.com.co';
        $user->password = 'leida123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'María Paula Garcia';
        $user->email = 'mgarcia@fontur.com.co';
        $user->password = 'maría123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Jimena Levaza Burbano';
        $user->email = 'slevaza@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Rios';
        $user->email = 'srios@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Yenis Isabel Acevedo Marsiglia';
        $user->email = 'yacevedo@fontur.com.co';
        $user->password = 'yenis123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lina María Samper Pertuz';
        $user->email = 'lsamper@fontur.com.co';
        $user->password = 'lina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL SENIOR INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Guillermo Antonio Perilla Novoa';
        $user->email = 'gperilla@fontur.com.co';
        $user->password = 'guillermo123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Henry Colmenares Merchán';
        $user->email = 'hcolmenares@fontur.com.co';
        $user->password = 'henry123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'María Paula Díaz Parra';
        $user->email = 'mdiaz@fontur.com.co';
        $user->password = 'maría123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE INFRAESTRUCTURA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Liyibeth Ochoa Rodriguez';
        $user->email = 'lochoa@fontur.com.co';
        $user->password = 'liyibeth123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCUTRA';
        $user->cargo = 'PROFESIONAL DE INFRAESTRUCTURA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Angie Carolina Rojas Cruz';
        $user->email = 'arojas@fontur.com.co';
        $user->password = 'angie123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE NEGOCIOS ESPECIALES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Gustavo Adolfo Macias Mendez';
        $user->email = 'gmacias@fontur.com.co';
        $user->password = 'gustavo123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE NEGOCIOS ESPECIALES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jose David Veloza Mosquera';
        $user->email = 'jveloza@fontur.com.co';
        $user->password = 'jose123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE NEGOCIOS ESPECIALES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lizeth Daniela Castillo Sanchez';
        $user->email = 'lcastillo@fontur.com.co';
        $user->password = 'lizeth123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE NEGOCIOS ESPECIALES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Milena Cortes Cortes';
        $user->email = 'scortes@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE NEGOCIOS ESPECIALES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Rocio Cortes';
        $user->email = 'rcortes@fontur.com.co';
        $user->password = 'rocio123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE PAGOS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Héctor Raul Pinto';
        $user->email = 'hpinto@fontur.com.co';
        $user->password = 'héctor123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'PROFESIONAL FINANCIERO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jorge Mario Maya Ruiz';
        $user->email = 'jmaya@fontur.com.co';
        $user->password = 'jorge123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'PROFESIONAL JUNIOR DE RECUADOS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jose Orlando Rodriguez';
        $user->email = 'jrodriguez@fontur.com.co';
        $user->password = 'jose123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'PROFESIONAL SENIOR DE PRESUPUESTO Y PAGOS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ingrid Paola Blanco Rincon';
        $user->email = 'iblanco@fontur.com.co';
        $user->password = 'ingrid123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'PROFESIONAL SENIOR FINANCIERO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Milton Yesid Avendano Torres';
        $user->email = 'mavendano@fontur.com.co';
        $user->password = 'milton123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE NEGOCIOS ESPECIALES';
        $user->cargo = 'PROFESIONAL SENIOR FINANCIERO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Heidy Nataly Arias Romero';
        $user->email = 'harias@fontur.com.co';
        $user->password = 'heidy123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE NEGOCIOS ESPECIALES';
        $user->cargo = 'ANALISTA DE NEGOCIOS ESPECIALES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Alfonso Rafael Herrera Vargas';
        $user->email = 'aherrera@fontur.com.co';
        $user->password = 'alfonso123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'ASESOR DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniel de Jesus Acosta';
        $user->email = 'dacosta@fontur.com.co';
        $user->password = 'daniel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'AUXILIAR ADMINISTRATIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Angela Maria Montenegro';
        $user->email = 'amontenegro@fontur.com.co';
        $user->password = 'angela123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'DIRECTORA DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ingrid Paola Gorrón Gómez';
        $user->email = 'igorron@fontur.com.co';
        $user->password = 'ingrid123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PASANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jaime Andres Barrero Rubio';
        $user->email = 'jbarrero@fontur.com.co';
        $user->password = 'jaime123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniela Suarez Patino';
        $user->email = 'dsuarez@fontur.com.co';
        $user->password = 'daniela123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diana Carolina Novoa';
        $user->email = 'dnovoa@fontur.com.co';
        $user->password = 'diana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Laura Bayona Sanabria';
        $user->email = 'lbayona@fontur.com.co';
        $user->password = 'laura123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lederson Larrotta';
        $user->email = 'llarrotta@fontur.com.co';
        $user->password = 'lederson123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Maria Paula Tovar';
        $user->email = 'mtovar@fontur.com.co';
        $user->password = 'maria123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Paola Rivera';
        $user->email = 'privera@fontur.com.co';
        $user->password = 'paola123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diego Isaac Amaral Mardini';
        $user->email = 'damaral@fontur.com.co';
        $user->password = 'diego123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL SENIOR DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Julian David Escobar Florez';
        $user->email = 'jescobar@fontur.com.co';
        $user->password = 'julian123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL TARJETA JOVEN';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Adriana Duarte Trujillo';
        $user->email = 'aduarte@fontur.com.co';
        $user->password = 'adriana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE SEGUIMIENTO Y ANALISIS';
        $user->cargo = 'PROFESIONAL DE SEGUIMIENTO Y ANALISIS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Milena Quintero Castro';
        $user->email = 'squintero@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE SEGUIMIENTO Y ANALISIS';
        $user->cargo = 'PROFESIONAL DE SEGUIMIENTO Y ANALISIS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lina Marcela Morales Botero';
        $user->email = 'lmorales@fontur.com.co';
        $user->password = 'lina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE SEGUIMIENTO Y ANALISIS';
        $user->cargo = 'ASESORA DE SEGUIMIENTO Y ANÁLISIS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Silvana Jaramillo Posada';
        $user->email = 'sjaramillo@fontur.com.co';
        $user->password = 'silvana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN DE SEGUIMIENTO Y ANÁLISIS';
        $user->cargo = 'PROFESIONAL DE SEGUIMIENTO Y ANÁLISIS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Paola Andrea Chilito Ruano';
        $user->email = 'pchilito@fontur.com.co';
        $user->password = 'paola123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'ASISTENTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Karen Vanessa Castillo Parada';
        $user->email = 'kvcastillo@fontur.com.co';
        $user->password = 'karen123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'María Cristina Tobon Camacho';
        $user->email = 'mtobon@fontur.com.co';
        $user->password = 'maría123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'PROFESIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jaime Rafael Melo Paez';
        $user->email = 'jmelo@fontur.com.co';
        $user->password = 'jaime123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'PROFESIONAL DE SISTEMAS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Guillermo Hernando Junca Ospina';
        $user->email = 'gjunca@fontur.com.co';
        $user->password = 'guillermo123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'PROFESIONAL INTERINSTITUCIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carolina María Rodríguez Cuellar';
        $user->email = 'crodriguez@fontur.com.co';
        $user->password = 'carolina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'PROFESIONAL JUNIOR';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luisa Fernanda Parra Salazar';
        $user->email = 'lparra@fontur.com.co';
        $user->password = 'luisa123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION INTERINSTITUCIONAL';
        $user->cargo = 'PROFESIONAL PITS';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Pablo Restrepo Rodríguez';
        $user->email = 'prestrepo@fontur.com.co';
        $user->password = 'pablo123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN INTERINSTITUCIONAL';
        $user->cargo = 'DIRECTOR INTERINSTITUCIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luisa Fernanda Ruiz Gomez';
        $user->email = 'lfruiz@fontur.com.co';
        $user->password = 'luisa123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN INTERINSTITUCIONAL';
        $user->cargo = 'PROFESIONAL INTERINSTITUCIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Yamid Stiven Aguilera Betancourt';
        $user->email = 'yaguilera@fontur.com.co';
        $user->password = 'yamid123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'AUXILIAR DE ARCHIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Milena Penuela';
        $user->email = 'mpenuela@fontur.com.co';
        $user->password = 'milena123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'AUXILIAR JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luis Fernando Torres Ramirez';
        $user->email = 'ltorres@fontur.com.co';
        $user->password = 'luis123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'DIRECTOR JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Claudia Daniela Moreno Rodriguez';
        $user->email = 'cmoreno@fontur.com.co';
        $user->password = 'claudia123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniel Raffan Rodriguez Ramirez';
        $user->email = 'darodriguez@fontur.com.co';
        $user->password = 'daniel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diego Fernando Velasquez Baracaldo';
        $user->email = 'dvelasquez@fontur.com.co';
        $user->password = 'diego123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Liliana Maria Cardenas Vasquez';
        $user->email = 'lcardenas@fontur.com.co';
        $user->password = 'liliana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Mabel Tatiana Rodriguez Betancourt';
        $user->email = 'mtrodriguez@fontur.com.co';
        $user->password = 'mabel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Martha Millan';
        $user->email = 'mmillan@fontur.com.co';
        $user->password = 'martha123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Yenni Beatriz Martinez Menco';
        $user->email = 'ymartinez@fontur.com.co';
        $user->password = 'yenni123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diego Fernando Lopez Romero';
        $user->email = 'dlopez@fontur.com.co';
        $user->password = 'diego123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICO SENIOR';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'David Alejandro Gonzalez Herrera';
        $user->email = 'dgonzalez@fontur.com.co';
        $user->password = 'david123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL SENIOR JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Andrea Morales Sanchez';
        $user->email = 'amorales@fontur.com.co';
        $user->password = 'andrea123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL SENIOR JURIDICO BIENES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carolina Miranda';
        $user->email = 'cmiranda@fontur.com.co';
        $user->password = 'carolina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION JURIDICA';
        $user->cargo = 'PROFESIONAL SENIOR JURIDICO CONTRATACION';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Consuelo Forero';
        $user->email = 'cforero@fontur.com.co';
        $user->password = 'consuelo123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN JURIDICA';
        $user->cargo = 'AUXILIAR JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Vivian Andrea Rodríguez Pereira';
        $user->email = 'vrodriguez@fontur.com.co';
        $user->password = 'vivian123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCIÓN JURIDICA';
        $user->cargo = 'PROFESIONAL JURIDICA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Rafael Alberto Negrete Quintero';
        $user->email = 'rnegrete@fontur.com.co';
        $user->password = 'rafael123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION LEGAL';
        $user->cargo = 'DIRECTOR LEGAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ana Milena Acevedo Norena';
        $user->email = 'aacevedo@fontur.com.co';
        $user->password = 'ana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION LEGAL';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Cristobal A Maya Quintero';
        $user->email = 'cmaya@fontur.com.co';
        $user->password = 'cristobal123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION LEGAL';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Hayleen Bustillo Penaranda';
        $user->email = 'hbustillo@fontur.com.co';
        $user->password = 'hayleen123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION LEGAL';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Betancur';
        $user->email = 'sbetancur@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION LEGAL';
        $user->cargo = 'PROFESIONAL JURIDICO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diana Margarita Rojas Moreno';
        $user->email = 'drojas@fontur.com.co';
        $user->password = 'diana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE PROMOCION Y MERCADEO';
        $user->cargo = 'PROFESIONAL DE PROMOCION Y MERCADEO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ximena Sastoque Sarmiento';
        $user->email = 'xsastoque@fontur.com.co';
        $user->password = 'ximena123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA CONTABLE';
        $user->cargo = 'ANALISTA CONTABLE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carlos Andres Guarin Nunez';
        $user->email = 'cguarin@fontur.com.co';
        $user->password = 'carlos123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'GERENTE DE BIENES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniel Sarnari';
        $user->email = 'dsarnari@fontur.com.co';
        $user->password = 'daniel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL DE BIENES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jhoan Sebastian Valencia Sanchez';
        $user->email = 'jvalencia@fontur.com.co';
        $user->password = 'jhoan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL JUNIOR ADMINISTRATIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Kevin Vargas Becerra';
        $user->email = 'kbecerra@fontur.com.co';
        $user->password = 'kevin123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL JURIDICO ADMINISTRATIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Cesar Augusto Quintero Garcia';
        $user->email = 'cquintero@fontur.com.co';
        $user->password = 'cesar123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL SENIOR ADMINISTRATIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carolina Quiñones';
        $user->email = 'cquinones@fontur.com.co';
        $user->password = 'carolina123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL SENIOR DE BIENES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Lorena Rangel Gil';
        $user->email = 'srangel@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL SENIOR FINANCIERO DE BIENES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Abner Lopez Sinning';
        $user->email = 'alopez@fontur.com.co';
        $user->password = 'abner123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL SENIOR HOTELERO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Libardo Quintero Uribe';
        $user->email = 'lquintero@fontur.com.co';
        $user->password = 'libardo123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'PROFESIONAL SENIOR OBRAS CIVILES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Bibiana Cruz';
        $user->email = 'bcruz@fontur.com.co';
        $user->password = 'bibiana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE BIENES';
        $user->cargo = 'SECRETARIA DE BIENES';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Oscar Orlando Tinjaca Escamilla';
        $user->email = 'otinjaca@fontur.com.co';
        $user->password = 'oscar123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE TALENTO HUMANO Y ADMINISTRATIVO';
        $user->cargo = 'AUXILIAR DE OFICINA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Geraldine Rojas Barrero';
        $user->email = 'grojas@fontur.com.co';
        $user->password = 'geraldine123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE TALENTO HUMANO Y ADMINISTRATIVO';
        $user->cargo = 'AUXILIAR ADMINISTRATIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Patricia León Ardila';
        $user->email = 'sleon@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE TALENTO HUMANO Y ADMINISTRATIVO';
        $user->cargo = 'AUXILIAR ADMINISTRATIVO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Alvaro Andres Zarama Lopez';
        $user->email = 'azarama@fontur.com.co';
        $user->password = 'alvaro123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE TALENTO HUMANO Y ADMINISTRATIVO';
        $user->cargo = 'PROFESIONAL ADMINISTRATIVO JUNIOR';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan David Robayo Torres';
        $user->email = 'jrobayo@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE TALENTO HUMANO Y ADMINISTRATIVO';
        $user->cargo = 'PROFESIONAL ADMINISTRATIVO JUNIOR';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Milena Rodriguez Martinez';
        $user->email = 'srodriguez@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA DE TALENTO HUMANO Y ADMINISTRATIVO';
        $user->cargo = 'PROFESIONAL DE GESTION HUMANA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Carlos Roberto Pinto Tovar';
        $user->email = 'cpinto@fontur.com.co';
        $user->password = 'carlos123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA IT';
        $user->cargo = 'PROFESIONAL SENIOR IT';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diego Cadena';
        $user->email = 'dcadena@fontur.com.co';
        $user->password = 'diego123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA IT';
        $user->cargo = 'SOPORTE TECNICO IT';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'John A. Mora V.';
        $user->email = 'jmora@fontur.com.co';
        $user->password = 'john123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA IT';
        $user->cargo = 'TECNICO IT';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Daniel Eduardo Alvarez Castillo';
        $user->email = 'dalvarez@fontur.com.co';
        $user->password = 'daniel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'DIRECCION DE INFRAESTRUCUTRA';
        $user->cargo = 'Asesor externo';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Lizbeth Rocio Tamayo Martinez';
        $user->email = 'ltamayo@fontur.com.co';
        $user->password = 'lizbeth123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'GERENCIA IT';
        $user->cargo = 'PROFESIONAL IT';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luz Alejandra Barbosa Tarazona';
        $user->email = 'lbarbosa@fontur.com.co';
        $user->password = 'luz123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'ASESORA DE PRESIDENCIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Alejandra Femayor Antolinez';
        $user->email = 'afemayor@fontur.com.co';
        $user->password = 'alejandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jhon Alexander Lobo Aguillon';
        $user->email = 'jlobo@fontur.com.co';
        $user->password = 'jhon123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diana Marcela Silva Rojas';
        $user->email = 'dsilva@fontur.com.co';
        $user->password = 'diana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PRACTICANTE UNIVERSITARIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Raquel Garavito Chapaval';
        $user->email = 'rgaravito@fontur.com.co';
        $user->password = 'raquel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PRESIDENTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Johanna Calderon Bendek';
        $user->email = 'jcalderon@fontur.com.co';
        $user->password = 'johanna123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PROFECIONAL JUNIOR';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Alberto Antonio Montel Valbuena';
        $user->email = 'amontel@fontur.com.co';
        $user->password = 'alberto123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PROFESIONAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Fanny Johana Caicedo Caceres';
        $user->email = 'fcaicedo@fontur.com.co';
        $user->password = 'fanny123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PROFESIONAL DE AUDITORIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Ana María Peñuela';
        $user->email = 'apenuela@fontur.com.co';
        $user->password = 'ana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'PROFESIONAL JUNIOR';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Anayiber Molano Medina';
        $user->email = 'amolano@fontur.com.co';
        $user->password = 'anayiber123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'SECRETARIA DE PRESIDENCIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Laura Marcela Saraza Organista';
        $user->email = 'lsaraza@fontur.com.co';
        $user->password = 'laura123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'PRESIDENCIA';
        $user->cargo = 'SECRETARIA PRIVADA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'María del Mar Palacios Rubio';
        $user->email = 'mpalacios@fontur.com.co';
        $user->password = 'maría123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARIA GENERAL';
        $user->cargo = 'ASISTENTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Manuela González Grandett';
        $user->email = 'mgonzalez@fontur.com.co';
        $user->password = 'manuela123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARIA GENERAL';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Luisa Fernanda Mora Mora';
        $user->email = 'lmora@fontur.com.co';
        $user->password = 'luisa123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARIA GENERAL';
        $user->cargo = 'SECRETARIA GENERAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jorge Hernando Riano Morales';
        $user->email = 'jriano@fontur.com.co';
        $user->password = 'jorge123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARÍA GENERAL';
        $user->cargo = 'ANALISTA DE PPRESUPUESTO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'María Eugenia Vera Castro';
        $user->email = 'mvera@fontur.com.co';
        $user->password = 'maría123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARÍA GENERAL';
        $user->cargo = 'ASESORA DE SECRETARÍA GENERAL';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Geovanni Ayure Rativa';
        $user->email = 'gayure@fontur.com.co';
        $user->password = 'geovanni123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARÍA GENERAL';
        $user->cargo = 'PROFESIONAL JUNIOR FINANCIERO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Maria Andrea Rodriguez Ortega';
        $user->email = 'marodriguez@fontur.com.co';
        $user->password = 'maria123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENCIA DE PLANEACION Y PROYECTOS';
        $user->cargo = 'PRACTICANTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Idali Arevalo Peña';
        $user->email = 'sarevalo@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENCIA DE PLANEACION Y PROYECTOS';
        $user->cargo = 'PROFESIONAL DE  PRESIDENCIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Manuel Fernando Poveda Atara';
        $user->email = 'mpoveda@fontur.com.co';
        $user->password = 'manuel123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENCIA DE PLANEACION Y PROYECTOS';
        $user->cargo = 'PROFESIONAL FINANCIERO';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Oscar Alonso Gonzalez Rodriguez';
        $user->email = 'ogonzalez@fontur.com.co';
        $user->password = 'oscar123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENCIA DE PROYECTOS Y PLANEACIÓN';
        $user->cargo = 'ASESOR VICEPRESIDENCIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Aura Alejandra Torres';
        $user->email = 'atorres@fontur.com.co';
        $user->password = 'aura123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENCIA DE PROYECTOS Y PLANEACIÓN';
        $user->cargo = 'PROFESIONAL DE PLANEACIÓN';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Jorge Andrés Martinez';
        $user->email = 'jamartinez@fontur.com.co';
        $user->password = 'jorge123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENCIA DE PROYECTOS Y PLANEACIÓN';
        $user->cargo = 'PROFESIONAL DE PLANEACIÓN';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Maria lucia Villalba Gomez';
        $user->email = 'mvillalba@fontur.com.co';
        $user->password = 'maria123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'VICEPRESIDENTE DE PLANEACIÓN Y PROYECTOS';
        $user->cargo = 'VICEPRESIDENTE';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Sandra Murcia';
        $user->email = 'smurcia@fontur.com.co';
        $user->password = 'sandra123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = 'SECRETARIA GENERAL';
        $user->cargo = 'SECRETARIA';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Adriana Lozano Andrade';
        $user->email = 'alozano@fontur.com.co';
        $user->password = 'adriana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Adriana Marcela Castaneda';
        $user->email = 'acastaneda@fontur.com.co';
        $user->password = 'adriana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Baldora Mena Robledo';
        $user->email = 'bmena@fontur.com.co';
        $user->password = 'baldora123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diana Isabel Cuenca Gaitan';
        $user->email = 'dcuenca@fontur.com.co';
        $user->password = 'diana123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Diego Hernando Cardozo Riano';
        $user->email = 'dcardozo@fontur.com.co';
        $user->password = 'diego123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Edgar Hernando Rodriguez Torres';
        $user->email = 'ehrodriguez@fontur.com.co';
        $user->password = 'edgar123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Edward Orlando Moreno Pardo';
        $user->email = 'emoreno@fontur.com.co';
        $user->password = 'edward123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Fernando Acosta Diaz';
        $user->email = 'facosta@fontur.com.co';
        $user->password = 'fernando123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Juan Pablo Restrepo';
        $user->email = 'jrestrepo@fontur.com.co';
        $user->password = 'juan123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);

        $user = new User;
        $user->name = 'Santiago Restrepo Bahamon';
        $user->email = 'srestrepo@fontur.com.co';
        $user->password = 'santiago123';
        $user->active = true;
        $user->token = Str::random(10);
        $user->departamento = '';
        $user->cargo = '';
        $user->creator_user_id = 1;
        $user->updater_user_id = 1;
        $user->save();
        $user->assignRole($usuarioRole);
    }
}
