<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('departamento');
            $table->dropColumn('cargo');
            $table->unsignedBigInteger('cargo_id')->after('active')->nullable();
            $table->foreign('cargo_id')->references('id')->on('cargos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('departamento')->nullable();
            $table->string('cargo')->nullable();
            $table->dropForeign('users_cargo_id_foreign');
            $table->dropColumn('cargo_id');
        });
    }
}
