<?php

namespace App\Models;

use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasPermissions;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Notifications\ResetPasswordNotification;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'token',
        'active',
        'creator_user_id',
        'updater_user_id',
        'cargo_id',
        'FechaNacimiento',
        'IdCiudad',
        'Identificacion',
        'Celular',
        'Telefono',
        'Telefono',
        'DireccionUsuario',
        'IdAliado',
        'IdTalla',
        'IdGenero',
        'CorreoSecundadio',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $with = ['cargo','talla','genero','ciudad'];

    public function setPasswordAttribute($password)
    {
        $this->attributes['password'] = bcrypt($password);
    }

    public function creatorUser()
    {
        return $this->belongsTo(User::class, 'creator_user_id');
    }
    public function updaterUser()
    {
        return $this->belongsTo(User::class, 'updater_user_id');
    }


    public function correspondencias()
    {
        return $this->hasMany(Correspondencia::class);
    }

    public function cargo()
    {
        return $this->belongsTo(Cargo::class, 'cargo_id');
    }
    public function talla()
    {
        return $this->belongsTo(Talla::class, 'IdTalla');
    }
    public function genero()
    {
        return $this->belongsTo(Genero::class, 'IdGenero');
    }
    public function ciudad()
    {
        return $this->belongsTo(Ciudad::class, 'IdCiudad');
    }
}
