<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Turista extends Model
{
    use HasFactory;

    protected $table = 'turista';
    protected $primaryKey = 'IdTurista';

    protected $with = ['pais', 'ciudad','motivoViaje','tipoTransporte','tipoAlojamiento','duracionEstancia','genero','edad','fidelidad','usuario'];

    public function pais()
    {
        return $this->belongsTo(Catastro::class, 'IdCatastroPais');
    }
    public function ciudad()
    {
        return $this->belongsTo(Catastro::class, 'IdCatastroCiudad');
    }
    public function motivoViaje()
    {
        return $this->belongsTo(MotivoViaje::class, 'IdMotivoViaje');
    }
    public function tipoTransporte()
    {
        return $this->belongsTo(TipoTransporte::class, 'IdTipoTransporte');
    }
    public function tipoAlojamiento()
    {
        return $this->belongsTo(TipoAlojamiento::class, 'IdTipoAlojamiento');
    }
    public function duracionEstancia()
    {
        return $this->belongsTo(DuracionEstancia::class, 'IdDuracion');
    }
    public function genero()
    {
        return $this->belongsTo(Genero::class, 'IdSexo');
    }
    public function edad()
    {
        return $this->belongsTo(Edad::class, 'IdEdad');
    }
    public function fidelidad()
    {
        return $this->belongsTo(Fidelidad::class, 'IdFidelidad');
    }
    public function motivoConsulta()
    {
        return $this->belongsTo(MotivoConsulta::class, 'IdMotivoConsulta');
    }
    public function usuario()
    {
        return $this->belongsTo(User::class, 'UsuarioRegistroTurista');
    }
    
}
