<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use DateTime;

class Pits extends Model
{
	/*
  totalRegistros por usuario en session
  */
	public static  function totalRegistros($modo, $UsuarioRegistroTurista)
	{
		$total = 0;
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " COUNT(IdTurista) AS total ";
		$sql = $sql . " FROM turista ";
		$sql = $sql . " WHERE ";

		$sql = $sql . "   ";

		if ($modo == "1") {
			//dia
			$sql = $sql . "   ";
			$sql = $sql . "FechaRegistro >= '" . date("Y/m/d") . " 00:00' ";
			$sql = $sql . " AND FechaRegistro <= '" . date("Y/m/d") . " 23:59' ";
		}

		if ($modo == "2") {
			//mes
			$mesActual = date("m");
			$sql = $sql . "   ";
			$sql = $sql . "FechaRegistro >= '" . date("Y") . "/" . $mesActual . "/01 00:00' ";
			$sql = $sql . " AND FechaRegistro <= '" . date("Y") . "/" . $mesActual . "/28 23:59' ";
		}

		if ($modo == "3") {
			//year
			$anioActual = date("Y");
			$sql = $sql . "   ";
			$sql = $sql . "FechaRegistro >= '" . $anioActual . "/01/01 00:00' ";
			$sql = $sql . " AND FechaRegistro <= '" . $anioActual . "/12/31 23:59' ";
		}
		if (!auth()->user()->hasRole('admin')) {
			$sql = $sql . " AND UsuarioRegistroTurista=" . $UsuarioRegistroTurista . "  ";
		}

		$sql = $sql . " ";
		$listado = DB::select($sql);
		foreach ($listado as $row) {
			$total = $row->total;
		}

		return $total;
	}

	/*
  listadoDocumentosHome
  */
	public static  function listadoDocumentosHome()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   documentos_pits  ";
		$sql = $sql . " WHERE ActivoArchivo=1  ";
		$sql = $sql . " ORDER BY IdDocumento  DESC LIMIT 5   ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoDocumentosTodos
  */
	public static  function listadoDocumentosTodos()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   documentos_pits  ";
		$sql = $sql . "   ";
		$sql = $sql . " ORDER BY IdDocumento  DESC   ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTablaMaestra
  */
	public static  function listadoTablaMaestra($tablaMaestra, $tablaColumnaId, $tablaColumnaDetalle)
	{
		$listado = "";

		if (trim($tablaMaestra) != "") {
			$sql = "";
			$sql = $sql . " SELECT ";
			$sql = $sql . " " . $tablaColumnaId . "  AS Id," . $tablaColumnaDetalle . " AS Titulo ";
			$sql = $sql . " FROM " . $tablaMaestra . "  ";
			$sql = $sql . "   ";
			$sql = $sql . " ORDER BY " . $tablaColumnaDetalle . " ";
			$sql = $sql . " ";
			$listado = DB::select($sql);
		}

		return $listado;
	}

	/*
  listadoTablaMaestraDetalle
  */
	public static  function listadoTablaMaestraDetalle($Id, $tablaMaestra, $tablaColumnaId, $tablaColumnaDetalle)
	{
		$listado = "";

		if (trim($tablaMaestra) != "") {
			$sql = "";
			$sql = $sql . " SELECT ";
			$sql = $sql . " " . $tablaColumnaId . "  AS Id," . $tablaColumnaDetalle . " AS Titulo ";
			$sql = $sql . " FROM " . $tablaMaestra . "  ";
			$sql = $sql . " WHERE  ";
			$sql = $sql . " " . $tablaColumnaId . "=" . $Id;
			$sql = $sql . "   ";
			$listado = DB::select($sql);
		}

		return $listado;
	}

	/*
  crearTablaMaestra
  */
	public static  function crearTablaMaestra($tablaMaestra, $tablaColumnaDetalle, $detalle)
	{
		if (trim($tablaMaestra) != "") {
			$sql = "";
			$sql = $sql . "  INSERT INTO  " . $tablaMaestra . " ";
			$sql = $sql . "  ( ";
			$sql = $sql . "  " . $tablaColumnaDetalle . " ";
			$sql = $sql . "  )";
			$sql = $sql . "  VALUES ";
			$sql = $sql . "  ( ";
			$sql = $sql . "  '" . $detalle . "'   ";
			$sql = $sql . "  )";
			$sql = $sql . " ";
			DB::unprepared($sql);
		}

		return "1";
	}


	/*
  editarTablaMaestra
  */
	public static  function editarTablaMaestra($tablaMaestra, $tablaColumnaDetalle, $tablaColumnaId, $Id, $detalle)
	{
		if (trim($tablaMaestra) != "") {
			$sql = "";
			$sql = $sql . "  UPDATE  " . $tablaMaestra . " ";
			$sql = $sql . "  SET ";
			$sql = $sql . "  " . $tablaColumnaDetalle . "='" . $detalle . "'  ";
			$sql = $sql . "  ";
			$sql = $sql . "  WHERE ";
			$sql = $sql . "  " . $tablaColumnaId . "=" . $Id;
			$sql = $sql . " ";
			DB::unprepared($sql);
		}

		return "1";
	}


	/*
  listadoCumpleAniosHome
  */
	public static  function listadoCumpleAniosHome()
	{
		$mesActual = date("m");
		$sql = " SELECT * FROM users WHERE  Month(FechaNacimiento)='" . $mesActual . "' AND Active=1  ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoDirectorio
  */
	public static  function listadoDirectorio($IdCiudad)
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM users  ";
		$sql = $sql . " WHERE  ";
		$sql = $sql . " Active=1  ";

		if (trim($IdCiudad) != "0" && trim($IdCiudad) != "") {
			$sql = $sql . " AND IdCiudad=" . $IdCiudad;
		}

		$sql = $sql . " ORDER BY name  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoMunicipio
  */
	public static  function listadoMunicipio()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " ciudad.Codigo AS CODIGO_CIUDAD, ciudad.DESCRIPCION AS DESCRIPCION_CIUDAD ,depto.DESCRIPCION AS DESCRIPCION_DEPTO  ";
		$sql = $sql . " FROM  catastro ciudad ";
		$sql = $sql . " INNER JOIN catastro depto ON  depto.Codigo=ciudad.LUGE_CODIGO ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " ciudad.tipo='CM'  ";
		$sql = $sql . " ORDER BY  ciudad.DESCRIPCION  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoPaises
  */
	public static  function listadoPaises()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM catastro  ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " TIPO='PA' ";
		$sql = $sql . " ORDER BY DESCRIPCION  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoCiudades
  */
	public static  function listadoCiudades()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM catastro  ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " TIPO='CIU' ";
		$sql = $sql . " ORDER BY DESCRIPCION  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoAliados
  */
	public static  function listadoAliados()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM aliado  ";
		$sql = $sql . "   ";
		$sql = $sql . "   ";
		$sql = $sql . " ORDER BY DetalleAliado  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTallas
  */
	public static  function listadoTallas()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM  talla_camiseta  ";
		$sql = $sql . "   ";
		$sql = $sql . "   ";
		$sql = $sql . " ORDER BY DetalleTalla  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoGeneros
  */
	public static  function listadoGeneros()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   genero  ";
		$sql = $sql . "   ";
		$sql = $sql . "   ";
		$sql = $sql . " ORDER BY DetalleGenero  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoMotivoViaje
  */
	public static  function listadoMotivoViaje()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM motivo_viaje  ";
		$sql = $sql . " ORDER BY DetalleMotivoViaje  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTipoTransporte
  */
	public static  function listadoTipoTransporte()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM tipo_transporte  ";
		$sql = $sql . " ORDER BY DetalleTipoTransporte  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTipoAlojamiento
  */
	public static  function listadoTipoAlojamiento()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM tipo_alojamiento  ";
		$sql = $sql . " ORDER BY DetalleTipoAlojamiento  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoDuracionEstancia
  */
	public static  function listadoDuracionEstancia()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM duracion_estancia  ";
		$sql = $sql . " ORDER BY DetalleDuracionEstancia  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoEdad
  */
	public static  function listadoEdad()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM edad  ";
		$sql = $sql . " ORDER BY DetalleEdad  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoFidelidad
  */
	public static  function listadoFidelidad()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM  fidelidad  ";
		$sql = $sql . " ORDER BY DetalleFidelidad  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoMotivoConsulta
  */
	public static  function listadoMotivoConsulta()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM  motivo_consulta  ";
		$sql = $sql . " ORDER BY DetalleMotivoConsulta  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTuristas
  */
	public static  function listadoTuristas()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle ";
		$sql = $sql . "  ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " ";
		$sql = $sql . " ORDER BY IdTurista DESC  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTuristasFiltro
  */
	public static  function listadoTuristasFiltro($desde, $hasta)
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle ";
		$sql = $sql . "  ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " ";

		if (trim($desde) != "" && trim($hasta) != "") {
			$sql = $sql . " WHERE  ";
			$sql = $sql . " FechaRegistro >= '" . $desde . " 00:00' ";
			$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
			$sql = $sql . " ";
		}


		$sql = $sql . " ";
		$sql = $sql . " ORDER BY IdTurista DESC  LIMIT 10 ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTuristasFiltroPaginado
  */
	public static  function listadoTuristasFiltroPaginado($desde, $hasta, $paginaActual, $paginaActualId)
	{
		$topePaginacion = "5";
		$_SESSION["topePaginacion"] = $topePaginacion;
		$filtro = "";

		if (trim($desde) != "" && trim($hasta) != "") {
			$filtro = $filtro . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
			$filtro = $filtro . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
			$filtro = $filtro . " ";
		}

		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle ";
		$sql = $sql . "  ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " IdTurista > 0 ";
		$sql = $sql . " " . $filtro;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		$totalRegistros = count($listado);
		$_SESSION["totalRegistros"] = $totalRegistros;


		$sql = $sql . " ";
		$sql = $sql . " ORDER BY IdTurista DESC  LIMIT " . $paginaActual . "," . $topePaginacion;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTuristasFiltroPaginadoXPits
  */
	public static  function listadoTuristasFiltroPaginadoXPits($desde, $hasta, $paginaActual, $paginaActualId, $PitsDetalle)
	{
		$topePaginacion = "5";
		$_SESSION["topePaginacion"] = $topePaginacion;
		$filtro = "";

		if (trim($desde) != "" && trim($hasta) != "") {
			$filtro = $filtro . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
			$filtro = $filtro . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
			$filtro = $filtro . " ";
		}

		/*
		if (trim($PitsDetalle) != "" && trim($PitsDetalle) != "0") {
			$filtro = $filtro . " AND  PitsDetalle = '" . $PitsDetalle . "' ";
			$filtro = $filtro . " ";
		}
        */

		if ($PitsDetalle != "") {
			$valorPitsCiudad = $PitsDetalle;
			if (count($valorPitsCiudad) > 0) {
				//validar si tiene la opcion "todo" seleccionado
				$opcionTodoSeleccionada = "0";
				for ($i = 0; $i < count($valorPitsCiudad); $i++) {
					if (trim($valorPitsCiudad[$i]) == "0") {
						$opcionTodoSeleccionada = "1";
					}
				}

				if (trim($opcionTodoSeleccionada) == "0") {
					//no tiene TODO seleccionado
					$filtro = $filtro . " AND ( ";
					for ($i = 0; $i < count($valorPitsCiudad); $i++) {
						//$filtro = $filtro . "   turista.PitsDetalle='" . $valorPitsCiudad[$i] . "' ";
						$filtro = $filtro . "   turista.IdPits='" . $valorPitsCiudad[$i] . "' ";
						if ($i < count($valorPitsCiudad) - 1) {
							$filtro = $filtro . " OR  ";
						}
					}
					$filtro = $filtro . " ) ";
				}
			}
		}

		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle ";
		$sql = $sql . "  ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " IdTurista > 0 ";
		$sql = $sql . " " . $filtro;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		$totalRegistros = count($listado);
		$_SESSION["totalRegistros"] = $totalRegistros;


		$sql = $sql . " ";
		$sql = $sql . " ORDER BY IdTurista DESC  LIMIT " . $paginaActual . "," . $topePaginacion;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}


	/*
  listadoTuristasFiltroReporte
  */
	public static  function listadoTuristasFiltroReporte($desde, $hasta, $post)
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle ";
		$sql = $sql . "  ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " IdTurista > 0 ";

		if (trim($desde) != "" && trim($hasta) != "") {
			$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
			$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
		}

		//nacionalidad
		if (trim($post["valorNacionalidad"]) != "") {
			$sql = $sql . " AND turista.IdCatastroPais=" . $post["valorNacionalidad"];
		}

		//ciudad
		if (trim($post["valorCiudad"]) != "0" && trim($post["valorCiudad"]) != "") {
			$sql = $sql . " AND turista.IdCatastroCiudad=" . $post["valorCiudad"];
		}

		//motivo
		if (trim($post["valorMotivoViaje"]) != "") {
			$sql = $sql . " AND turista.IdMotivoViaje=" . $post["valorMotivoViaje"];
		}

		//tipo trnasporte
		if (trim($post["valorTipoTransporte"]) != "") {
			$sql = $sql . " AND turista.IdTipoTransporte=" . $post["valorTipoTransporte"];
		}

		//tipo alojamiento
		if (trim($post["valorTipoAlojamiento"]) != "") {
			$sql = $sql . " AND turista.IdTipoAlojamiento=" . $post["valorTipoAlojamiento"];
		}

		//duracion
		if (trim($post["valorDuracionEstancia"]) != "") {
			$sql = $sql . " AND turista.IdDuracion=" . $post["valorDuracionEstancia"];
		}

		//sexo
		if (trim($post["valorSexo"]) != "") {
			$sql = $sql . " AND turista.IdSexo=" . $post["valorSexo"];
		}

		//edad
		if (trim($post["valorEdad"]) != "") {
			$sql = $sql . " AND turista.IdEdad=" . $post["valorEdad"];
		}

		//fidelidad
		if (trim($post["valorFidelidad"]) != "") {
			$sql = $sql . " AND turista.IdFidelidad=" . $post["valorFidelidad"];
		}

		//motivo
		if (trim($post["valorMotivoConsulta"]) != "") {
			$sql = $sql . " AND turista.IdMotivoConsulta=" . $post["valorMotivoConsulta"];
		}

		//ciudad PITS
		if (trim($post["valorPitsCiudad"]) != "" && trim($post["valorPitsCiudad"]) != "0") {
			$sql = $sql . " AND turista.PitsDetalle='" . $post["valorPitsCiudad"] . "' ";
		}

		$sql = $sql . " ";
		$sql = $sql . " ORDER BY turista.IdTurista DESC   ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTuristasFiltroReportePaginado
  */
	public static  function listadoTuristasFiltroReportePaginado($desde, $hasta, $post, $paginaActual, $paginaActualId)
	{
		$topePaginacion = "5";
		$_SESSION["topePaginacion"] = $topePaginacion;
		$filtro = "";

		if ($paginaActual == "1") {
			$paginaActual = "0";
		}

		if (trim($desde) != "" && trim($hasta) != "") {
			$filtro = $filtro . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
			$filtro = $filtro . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
		}

		//nacionalidad
		if (trim($post["valorNacionalidad"]) != "") {
			$filtro = $filtro . " AND turista.IdCatastroPais=" . $post["valorNacionalidad"];
		}

		//ciudad
		if (trim($post["valorCiudad"]) != "0" && trim($post["valorCiudad"]) != "") {
			$filtro = $filtro . " AND turista.IdCatastroCiudad=" . $post["valorCiudad"];
		}

		//motivo
		if (trim($post["valorMotivoViaje"]) != "") {
			$filtro = $filtro . " AND turista.IdMotivoViaje=" . $post["valorMotivoViaje"];
		}

		//tipo trnasporte
		if (trim($post["valorTipoTransporte"]) != "") {
			$filtro = $filtro . " AND turista.IdTipoTransporte=" . $post["valorTipoTransporte"];
		}

		//tipo alojamiento
		if (trim($post["valorTipoAlojamiento"]) != "") {
			$filtro = $filtro . " AND turista.IdTipoAlojamiento=" . $post["valorTipoAlojamiento"];
		}

		//duracion
		if (trim($post["valorDuracionEstancia"]) != "") {
			$filtro = $filtro . " AND turista.IdDuracion=" . $post["valorDuracionEstancia"];
		}

		//sexo
		if (trim($post["valorSexo"]) != "") {
			$filtro = $filtro . " AND turista.IdSexo=" . $post["valorSexo"];
		}

		//edad
		if (trim($post["valorEdad"]) != "") {
			$filtro = $filtro . " AND turista.IdEdad=" . $post["valorEdad"];
		}

		//fidelidad
		if (trim($post["valorFidelidad"]) != "") {
			$filtro = $filtro . " AND turista.IdFidelidad=" . $post["valorFidelidad"];
		}

		//motivo
		if (trim($post["valorMotivoConsulta"]) != "") {
			$filtro = $filtro . " AND turista.IdMotivoConsulta=" . $post["valorMotivoConsulta"];
		}

		//ciudad PITS
		/*
	if(trim($post["valorPitsCiudad"])!="" && trim($post["valorPitsCiudad"])!="0")
	 {
	    $filtro=$filtro." AND turista.PitsDetalle='".$post["valorPitsCiudad"]."' ";
	 }
    */

		if ($post["valorPitsCiudad"] != "") {
			$valorPitsCiudad = $post["valorPitsCiudad"];
			if (count($valorPitsCiudad) > 0) {
				//validar si tiene la opcion "todo" seleccionado
				$opcionTodoSeleccionada = "0";
				for ($i = 0; $i < count($valorPitsCiudad); $i++) {
					if (trim($valorPitsCiudad[$i]) == "0") {
						$opcionTodoSeleccionada = "1";
					}
				}

				if (trim($opcionTodoSeleccionada) == "0") {
					//no tiene TODO seleccionado
					$filtro = $filtro . " AND ( ";
					for ($i = 0; $i < count($valorPitsCiudad); $i++) {
						$filtro = $filtro . "   turista.IdPits='" . $valorPitsCiudad[$i] . "' ";
						if ($i < count($valorPitsCiudad) - 1) {
							$filtro = $filtro . " OR  ";
						}
					}
					$filtro = $filtro . " ) ";
				}
			}
		}

		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle, ";
		$sql = $sql . " users.name AS NombreUsuarioRegistro ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " LEFT JOIN users ON users.id=turista.UsuarioRegistroTurista  ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " IdTurista > 0 ";
		$sql = $sql . " " . $filtro;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		$totalRegistros = count($listado);
		$_SESSION["totalRegistros"] = $totalRegistros;
		$sql = $sql . " ";
		$sql = $sql . " ORDER BY turista.IdTurista DESC  LIMIT " . $paginaActual . "," . $topePaginacion;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoTuristasFiltroReporteExportable
  */
	public static  function listadoTuristasFiltroReporteExportable($desde, $hasta, $post)
	{
		$filtro = "";		
		if (trim($desde) != "" && trim($hasta) != "") {
			$filtro = $filtro . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
			$filtro = $filtro . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
		}

		//nacionalidad
		if (trim($post["valorNacionalidad"]) != "") {
			$filtro = $filtro . " AND turista.IdCatastroPais=" . $post["valorNacionalidad"];
		}

		//ciudad
		if (trim($post["valorCiudad"]) != "0" && trim($post["valorCiudad"]) != "") {
			$filtro = $filtro . " AND turista.IdCatastroCiudad=" . $post["valorCiudad"];
		}

		//motivo
		if (trim($post["valorMotivoViaje"]) != "") {
			$filtro = $filtro . " AND turista.IdMotivoViaje=" . $post["valorMotivoViaje"];
		}

		//tipo trnasporte
		if (trim($post["valorTipoTransporte"]) != "") {
			$filtro = $filtro . " AND turista.IdTipoTransporte=" . $post["valorTipoTransporte"];
		}

		//tipo alojamiento
		if (trim($post["valorTipoAlojamiento"]) != "") {
			$filtro = $filtro . " AND turista.IdTipoAlojamiento=" . $post["valorTipoAlojamiento"];
		}

		//duracion
		if (trim($post["valorDuracionEstancia"]) != "") {
			$filtro = $filtro . " AND turista.IdDuracion=" . $post["valorDuracionEstancia"];
		}

		//sexo
		if (trim($post["valorSexo"]) != "") {
			$filtro = $filtro . " AND turista.IdSexo=" . $post["valorSexo"];
		}

		//edad
		if (trim($post["valorEdad"]) != "") {
			$filtro = $filtro . " AND turista.IdEdad=" . $post["valorEdad"];
		}

		//fidelidad
		if (trim($post["valorFidelidad"]) != "") {
			$filtro = $filtro . " AND turista.IdFidelidad=" . $post["valorFidelidad"];
		}

		//motivo
		if (trim($post["valorMotivoConsulta"]) != "") {
			$filtro = $filtro . " AND turista.IdMotivoConsulta=" . $post["valorMotivoConsulta"];
		}

		//ciudad PITS
		/*
	if(trim($post["valorPitsCiudad"])!="" && trim($post["valorPitsCiudad"])!="0")
	 {
	    $filtro=$filtro." AND turista.PitsDetalle='".$post["valorPitsCiudad"]."' ";
	 }
	*/

		if ($post["valorPitsCiudad"] != "") {
			$valorPitsCiudad = $post["valorPitsCiudad"];
			if (count($valorPitsCiudad) > 0) {
				//validar si tiene la opcion "todo" seleccionado
				$opcionTodoSeleccionada = "0";
				for ($i = 0; $i < count($valorPitsCiudad); $i++) {
					if (trim($valorPitsCiudad[$i]) == "0") {
						$opcionTodoSeleccionada = "1";
					}
				}

				if (trim($opcionTodoSeleccionada) == "0") {
					//no tiene TODO seleccionado
					$filtro = $filtro . " AND ( ";
					for ($i = 0; $i < count($valorPitsCiudad); $i++) {
						$filtro = $filtro . "   turista.PitsDetalle='" . $valorPitsCiudad[$i] . "' ";
						if ($i < count($valorPitsCiudad) - 1) {
							$filtro = $filtro . " OR  ";
						}
					}
					$filtro = $filtro . " ) ";
				}
			}
		}

		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " IdTurista, NombreConsultante,Correo,pais.DESCRIPCION AS DESCRIPCIONPAIS,ciudad.DESCRIPCION AS DESCRIPCIONCIUDAD  ,NumeroTuristas , ";
		$sql = $sql . " motivo_viaje.DetalleMotivoViaje,tipo_transporte.DetalleTipoTransporte,tipo_alojamiento.DetalleTipoAlojamiento , ";
		$sql = $sql . " duracion_estancia.DetalleDuracionEstancia ,IdSexo,edad.DetalleEdad,fidelidad.DetalleFidelidad , motivo_consulta.DetalleMotivoConsulta ,FechaRegistro,PitsDetalle, ";
		$sql = $sql . " users.name AS NombreUsuarioRegistro ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " LEFT JOIN catastro  pais ON pais.Codigo=turista.IdCatastroPais ";
		$sql = $sql . " LEFT JOIN catastro  ciudad ON ciudad.Codigo=turista.IdCatastroCiudad ";
		$sql = $sql . " LEFT JOIN motivo_viaje ON motivo_viaje.IdMotivoViaje=turista.IdMotivoViaje ";
		$sql = $sql . " LEFT JOIN tipo_transporte ON tipo_transporte.IdTipoTransporte=turista.IdTipoTransporte ";
		$sql = $sql . " LEFT JOIN tipo_alojamiento ON tipo_alojamiento.IdTipoAlojamiento=turista.IdTipoAlojamiento ";
		$sql = $sql . " LEFT JOIN duracion_estancia ON duracion_estancia.IdDuracionEstancia=turista.IdDuracion ";
		$sql = $sql . " LEFT JOIN edad ON edad.IdEdad=turista.IdEdad ";
		$sql = $sql . " LEFT JOIN fidelidad ON fidelidad.IdFidelidad=turista.IdFidelidad ";
		$sql = $sql . " LEFT JOIN motivo_consulta ON motivo_consulta.IdMotivoConsulta=turista.IdMotivoConsulta ";
		$sql = $sql . " LEFT JOIN users ON users.id=turista.UsuarioRegistroTurista  ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " IdTurista > 0 ";
		$sql = $sql . " " . $filtro;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}


	/*
  listadoTuristasFiltroReporteGrafico
  */
	public static  function listadoTuristasFiltroReporteGrafico($desde, $hasta, $post)
	{
		$coleccionLabels = "";
		$coleccionDatos = "";
		$sqlFiltro = "";

		//nacionalidad
		if (trim($post["valorNacionalidad"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdCatastroPais=" . $post["valorNacionalidad"];
		}

		//ciudad
		if (trim($post["valorCiudad"]) != "0" && trim($post["valorCiudad"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdCatastroCiudad=" . $post["valorCiudad"];
		}

		//motivo
		if (trim($post["valorMotivoViaje"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdMotivoViaje=" . $post["valorMotivoViaje"];
		}

		//tipo trnasporte
		if (trim($post["valorTipoTransporte"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdTipoTransporte=" . $post["valorTipoTransporte"];
		}

		//tipo alojamiento
		if (trim($post["valorTipoAlojamiento"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdTipoAlojamiento=" . $post["valorTipoAlojamiento"];
		}

		//duracion
		if (trim($post["valorDuracionEstancia"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdDuracion=" . $post["valorDuracionEstancia"];
		}

		//sexo
		if (trim($post["valorSexo"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdSexo=" . $post["valorSexo"];
		}

		//edad
		if (trim($post["valorEdad"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdEdad=" . $post["valorEdad"];
		}

		//fidelidad
		if (trim($post["valorFidelidad"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdFidelidad=" . $post["valorFidelidad"];
		}

		//motivo
		if (trim($post["valorMotivoConsulta"]) != "") {
			$sqlFiltro = $sqlFiltro . " AND turista.IdMotivoConsulta=" . $post["valorMotivoConsulta"];
		}

		//ciudad PITS
		/*
	if(trim($post["valorPitsCiudad"])!="" && trim($post["valorPitsCiudad"])!="0")
	 {
	    $sqlFiltro=$sqlFiltro." AND turista.PitsDetalle='".$post["valorPitsCiudad"]."' ";
	 }
    */

		$valorPitsCiudad = $post["valorPitsCiudad"];
		if (count($valorPitsCiudad) > 0) {
			//validar si tiene la opcion "todo" seleccionado
			$opcionTodoSeleccionada = "0";
			for ($i = 0; $i < count($valorPitsCiudad); $i++) {
				if (trim($valorPitsCiudad[$i]) == "0") {
					$opcionTodoSeleccionada = "1";
				}
			}

			if (trim($opcionTodoSeleccionada) == "0") {
				//no tiene TODO seleccionado
				$sqlFiltro = $sqlFiltro . " AND ( ";
				for ($i = 0; $i < count($valorPitsCiudad); $i++) {
					$sqlFiltro = $sqlFiltro . "   turista.IdPits='" . $valorPitsCiudad[$i] . "' ";
					if ($i < count($valorPitsCiudad) - 1) {
						$sqlFiltro = $sqlFiltro . " OR  ";
					}
				}
				$sqlFiltro = $sqlFiltro . " ) ";
			}
		}

		///motivo viaje
		if (trim($post["valorTipoReporte"]) == "1") {
			$sql = " SELECT * FROM motivo_viaje  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleMotivoViaje;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdTurista) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdMotivoViaje=" . $row->IdMotivoViaje;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///tipo transporte
		if (trim($post["valorTipoReporte"]) == "2") {
			$sql = " SELECT * FROM tipo_transporte  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleTipoTransporte;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdTurista) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdTipoTransporte=" . $row->IdTipoTransporte;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///tipo alojamiento
		if (trim($post["valorTipoReporte"]) == "3") {
			$sql = " SELECT * FROM tipo_alojamiento  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleTipoAlojamiento;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdTurista) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdTipoTransporte=" . $row->IdTipoAlojamiento;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///duraci���n estancia
		if (trim($post["valorTipoReporte"]) == "4") {
			$sql = " SELECT * FROM duracion_estancia  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleDuracionEstancia;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdDuracion) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdDuracion=" . $row->IdDuracionEstancia;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///edad
		if (trim($post["valorTipoReporte"]) == "5") {
			$sql = " SELECT * FROM  edad  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleEdad;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdEdad) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdEdad=" . $row->IdEdad;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///fidelidad
		if (trim($post["valorTipoReporte"]) == "6") {
			$sql = " SELECT * FROM   fidelidad  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleFidelidad;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdFidelidad) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdFidelidad=" . $row->IdFidelidad;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///motivo consulta
		if (trim($post["valorTipoReporte"]) == "7") {
			$sql = " SELECT * FROM   motivo_consulta  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleMotivoConsulta;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdMotivoConsulta) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdMotivoConsulta=" . $row->IdMotivoConsulta;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///meses del a���o
		$listaMeses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");

		///a���o actual
		if (trim($post["valorTipoReporte"]) == "8") {
			$anioActual = date("Y");
			for ($mes = 1; $mes <= 12; $mes++) {
				if (strlen($mes) == 1) {
					$mesActual = "0" . $mes;
				} else {
					$mesActual = $mes;
				}

				$fechaTemp = $anioActual . "-" . $mesActual . "-10";
				$numeroDiasMes = date("t", strtotime($fechaTemp));
				$fechaInicial = $anioActual . "-" . $mesActual . "-01";
				$fechaFinal = $anioActual . "-" . $mesActual . "-" . $numeroDiasMes;

				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $listaMeses[$mes - 1];
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdTurista) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " FechaRegistro >= '" . $fechaInicial . " 00:00' ";
				$sql = $sql . " AND  FechaRegistro <= '" . $fechaFinal . " 23:59' ";
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///flujo de turistas a���o actual
		if (trim($post["valorTipoReporte"]) == "9") {
			$anioActual = date("Y");
			for ($mes = 1; $mes <= 12; $mes++) {
				if (strlen($mes) == 1) {
					$mesActual = "0" . $mes;
				} else {
					$mesActual = $mes;
				}

				$fechaTemp = $anioActual . "-" . $mesActual . "-10";
				$numeroDiasMes = date("t", strtotime($fechaTemp));
				$fechaInicial = $anioActual . "-" . $mesActual . "-01";
				$fechaFinal = $anioActual . "-" . $mesActual . "-" . $numeroDiasMes;

				//total numero registros 
				$total2 = 0;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdTurista) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " FechaRegistro >= '" . $fechaInicial . " 00:00' ";
				$sql = $sql . " AND  FechaRegistro <= '" . $fechaFinal . " 23:59' ";
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total2 = $row2->total;
						}
					}
				}


				//total numero turistas 
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $listaMeses[$mes - 1] . "(" . $total2 . " registros)";
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " SUM(NumeroTuristas) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " FechaRegistro >= '" . $fechaInicial . " 00:00' ";
				$sql = $sql . " AND  FechaRegistro <= '" . $fechaFinal . " 23:59' ";
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}

				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///por PITS | $post["valorPitsCiudad"]
		if (trim($post["valorTipoReporte"]) == "10") {
			$filtroPitsCiudad = "";

			/*
        if(trim($post["valorPitsCiudad"])!="0" && trim($post["valorPitsCiudad"])!="")
         {
            $filtroPitsCiudad=" WHERE PitsDetalle='".trim($post["valorPitsCiudad"])."'  "; 
         }
        */

			$valorPitsCiudad = $post["valorPitsCiudad"];
			if (count($valorPitsCiudad) > 0) {
				//validar si tiene la opcion "todo" seleccionado
				$opcionTodoSeleccionada = "0";
				for ($i = 0; $i < count($valorPitsCiudad); $i++) {
					if (trim($valorPitsCiudad[$i]) == "0") {
						$opcionTodoSeleccionada = "1";
					}
				}

				if (trim($opcionTodoSeleccionada) == "0") {
					//no tiene TODO seleccionado
					$filtroPitsCiudad = $filtroPitsCiudad . " WHERE  ( ";
					for ($i = 0; $i < count($valorPitsCiudad); $i++) {
						$filtroPitsCiudad = $filtroPitsCiudad . "   turista.IdPits='" . $valorPitsCiudad[$i] . "' ";
						if ($i < count($valorPitsCiudad) - 1) {
							$filtroPitsCiudad = $filtroPitsCiudad . " OR  ";
						}
					}
					$filtroPitsCiudad = $filtroPitsCiudad . " ) ";
				}
			}

			$sql = " SELECT PitsDetalle FROM turista " . $filtroPitsCiudad . "  group by PitsDetalle order by PitsDetalle DESC ";
			$listadoGeneral = DB::select($sql);
			//echo "<script>console.log('Console: " . var_dump($listadoGeneral) . "' );</script>";

			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->PitsDetalle;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " SUM(NumeroTuristas) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " PitsDetalle='" . $row->PitsDetalle . "'   ";
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}

		///sexo
		if (trim($post["valorTipoReporte"]) == "11") {
			$sql = " SELECT * FROM genero  ";
			$listadoGeneral = DB::select($sql);
			foreach ($listadoGeneral as $row) {
				$total = 0;
				$coleccionLabels = $coleccionLabels . "|" . $row->DetalleGenero;
				$sql = "";
				$sql = $sql . " SELECT ";
				$sql = $sql . " COUNT(IdTurista) AS total ";
				$sql = $sql . " FROM   turista  ";
				$sql = $sql . " WHERE ";
				$sql = $sql . " IdSexo=" . $row->IdGenero;
				if (trim($desde) != "" && trim($hasta) != "") {
					$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
					$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
				}
				$sql = $sql . " " . $sqlFiltro;
				$sql = $sql . " ";
				$listado = DB::select($sql);
				if ($listado != "") {
					foreach ($listado as $row2) {
						if ($row2->total > 0) {
							$total = $row2->total;
						}
					}
				}
				$coleccionDatos = $coleccionDatos . "|" . $total;
			}
		}


		$listadoDataGraficoArray = array($coleccionLabels, $coleccionDatos);
		return $listadoDataGraficoArray;
	}


	/*
  listadoPortalFlujoGrafico
  */
	public static  function listadoPortalFlujoGrafico($desde, $hasta, $pits, $post)
	{
		$coleccionLabels = "";
		$coleccionDatos = "";
		$sqlFiltro = "";
		$sqlFiltroPits = "";

		//ciudad PITS
		if (trim($post["valorPitsCiudad"]) != "") {
			// $sqlFiltro=$sqlFiltro." AND turista.PitsDetalle='".$post["valorPitsCiudad"]."' ";
		}

		if (trim($pits) != "") {
			$sqlFiltroPits = "  WHERE PitsDetalle LIKE '%" . trim($pits) . "%'  ";
		}

		$sql = " SELECT PitsDetalle FROM turista " . $sqlFiltroPits . " group by PitsDetalle  ";
		$listadoGeneral = DB::select($sql);
		foreach ($listadoGeneral as $row) {
			$total = 0;
			$coleccionLabels = $coleccionLabels . "|" . $row->PitsDetalle;
			$sql = "";
			$sql = $sql . " SELECT ";
			$sql = $sql . " SUM(NumeroTuristas) AS total ";
			$sql = $sql . " FROM   turista  ";
			$sql = $sql . " WHERE ";
			$sql = $sql . " PitsDetalle='" . $row->PitsDetalle . "'   ";
			$sql = $sql . " AND  FechaRegistro >= '" . $desde . " 00:00' ";
			$sql = $sql . " AND  FechaRegistro <= '" . $hasta . " 23:59' ";
			$sql = $sql . " " . $sqlFiltro;
			$sql = $sql . " ";
			$listado = DB::select($sql);
			if ($listado != "") {
				foreach ($listado as $row2) {
					if ($row2->total > 0) {
						$total = $row2->total;
					}
				}
			}

			$coleccionDatos = $coleccionDatos . "|" . $total;
		}

		$listadoDataGraficoArray = array($coleccionLabels, $coleccionDatos);
		return $listadoDataGraficoArray;
	}

	/*
  listadoPuntos
  */
	public static  function listadoPuntos()
	{
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   puntos  ";
		$sql = $sql . " ORDER BY IdPuntos  DESC  ";
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoDetalleTurista
  */
	public static  function listadoDetalleTurista($IdTurista)
	{
		if (trim($IdTurista) == "") {
			$IdTurista = "0";
		}
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   turista  ";
		$sql = $sql . " WHERE  ";
		$sql = $sql . " IdTurista=" . $IdTurista;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoDetallePuntos
  */
	public static  function listadoDetallePuntos($IdPuntos)
	{
		if (trim($IdPuntos) == "") {
			$IdPuntos  = "0";
		}
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   puntos  ";
		$sql = $sql . " WHERE  ";
		$sql = $sql . " IdPuntos =" . $IdPuntos;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  listadoDetalleDocumento
  */
	public static  function listadoDetalleDocumento($IdDocumento)
	{
		if (trim($IdDocumento) == "") {
			$IdDocumento  = "0";
		}
		$sql = "";
		$sql = $sql . " SELECT ";
		$sql = $sql . " * ";
		$sql = $sql . " FROM   documentos_pits  ";
		$sql = $sql . " WHERE  ";
		$sql = $sql . " IdDocumento =" . $IdDocumento;
		$sql = $sql . " ";
		$listado = DB::select($sql);
		return $listado;
	}

	/*
  crearProcesoTurista
  */
	public static  function crearProcesoTurista($POST)
	{
		$sql = "";
		$sql = $sql . " INSERT INTO  turista ";
		$sql = $sql . " ( ";
		$sql = $sql . "  NombreConsultante,Correo ,IdCatastroPais, ";
		$sql = $sql . "  IdCatastroCiudad,IdMotivoViaje,NumeroTuristas, ";
		$sql = $sql . "  IdTipoTransporte,IdTipoAlojamiento,IdDuracion, ";
		$sql = $sql . "  IdEdad,IdFidelidad,IdMotivoConsulta,IdSexo, ";
		$sql = $sql . "  LlaveRegistro,PitsDetalle ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " VALUES ";
		$sql = $sql . " ( ";
		$sql = $sql . " '" . $POST["valorNombreConsultante"] . "','" . $POST["valorCorreo"] . "', " . $POST["valorNacionalidad"] . ", ";
		$sql = $sql . " " . $POST["valorCiudad"] . "," . $POST["valorMotivoViaje"] . "," . $POST["valorNroTuristas"] . ", ";
		$sql = $sql . " " . $POST["valorTipoTransporte"] . "," . $POST["valorTipoAlojamiento"] . "," . $POST["valorDuracionEstancia"] . ", ";
		$sql = $sql . " " . $POST["valorEdad"] . "," . $POST["valorFidelidad"] . "," . $POST["valorMotivoConsulta"] . "," . $POST["valorSexo"] . ", ";
		$sql = $sql . " '" . rand(111111, 999999) . "','" . $POST["valorPitsCiudad"] . "' ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " ";
		DB::unprepared($sql);
		return "1";
	}

	/*
  crearProcesoTuristaXLogin
  */
	public static  function crearProcesoTuristaXLogin($POST, $id)
	{
		$sql = "";
		$sql = $sql . " INSERT INTO  turista ";
		$sql = $sql . " ( ";
		$sql = $sql . "  NombreConsultante,Correo ,IdCatastroPais, ";
		$sql = $sql . "  IdCatastroCiudad,IdMotivoViaje,NumeroTuristas, ";
		$sql = $sql . "  IdTipoTransporte,IdTipoAlojamiento,IdDuracion, ";
		$sql = $sql . "  IdEdad,IdFidelidad,IdMotivoConsulta,IdSexo,IdPits, ";
		$sql = $sql . "  LlaveRegistro,PitsDetalle,UsuarioRegistroTurista ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " VALUES ";
		$sql = $sql . " ( ";
		$sql = $sql . " '" . $POST["valorNombreConsultante"] . "','" . $POST["valorCorreo"] . "', " . $POST["valorNacionalidad"] . ", ";
		$sql = $sql . " " . $POST["valorCiudad"] . "," . $POST["valorMotivoViaje"] . "," . $POST["valorNroTuristas"] . ", ";
		$sql = $sql . " " . $POST["valorTipoTransporte"] . "," . $POST["valorTipoAlojamiento"] . "," . $POST["valorDuracionEstancia"] . ", ";
		$sql = $sql . " " . $POST["valorEdad"] . "," . $POST["valorFidelidad"] . "," . $POST["valorMotivoConsulta"] . "," . $POST["valorSexo"] . ", " . $POST["valorPitsCiudad"]->nid . ", ";
		$sql = $sql . " '" . rand(111111, 999999) . "','" . $POST["valorPitsCiudad"]->title . "'," . $id . " ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " ";
		DB::unprepared($sql);
		return "1";
	}

	/*
  crearProcesoPuntos
  */
	public static  function crearProcesoPuntos($POST, $AdjuntoConvenio, $AdjuntoCDP, $AdjuntoTV, $AdjuntoInternet, $AdjuntoPC, $AdjuntoEnergia, $AdjuntoInformador, $AdjuntoFormacionAcademicaTurismo, $AdjuntoInformadorSegundoIdioma, $AdjuntoMantenimientoPIT, $AdjuntoHorarioOperatividadVisible, $AdjuntoMaterialPromocional, $AdjuntoElementosProteccionPit, $UsuarioRegistro)
	{
		$sql = "";
		$sql = $sql . " INSERT INTO  puntos ";
		$sql = $sql . " ( ";
		$sql = $sql . " IdPit,NombreCompleto,Cargo, ";
		$sql = $sql . " Celular,Correo,NroRegistros, ";
		$sql = $sql . " ConvenioCooperacion,AdjuntoConvenio, ";
		$sql = $sql . " CuentaConCDP,AdjuntoCDP, ";
		$sql = $sql . " TieneTV,AdjuntoTV, ";
		$sql = $sql . " TieneInternet,AdjuntoInternet, ";
		$sql = $sql . " TienePC,AdjuntoPC, ";
		$sql = $sql . " TieneEnergia,AdjuntoEnergia, ";
		$sql = $sql . " TieneInformador,AdjuntoInformador, ";
		$sql = $sql . " TiempoMesesInformador, ";
		$sql = $sql . " FormacionAcademicaTurismo,AdjuntoFormacionAcademicaTurismo, ";
		$sql = $sql . " InformadorSegundoIdioma,AdjuntoInformadorSegundoIdioma, ";
		$sql = $sql . " MantenimientoPIT,AdjuntoMantenimientoPIT, ";
		$sql = $sql . " HorarioOperatividadVisible,AdjuntoHorarioOperatividadVisible, ";
		$sql = $sql . " MaterialPromocional,AdjuntoMaterialPromocional, ";
		$sql = $sql . " ProtocolosBioseguridad,ElementosProteccionPit,AdjuntoElementosProteccionPit, ";
		$sql = $sql . " LlaveRegistro,UsuarioRegistro ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " VALUES ";
		$sql = $sql . " ( ";
		$sql = $sql . " " . $POST["valorPitsCiudad"] . ",'" . $POST["valorNombreCompleto"] . "','" . $POST["valorCargo"] . "', ";
		$sql = $sql . " '" . $POST["valorCelular"] . "','" . $POST["valorCorreo"] . "', '" . $POST["valorNumeroRegistros"] . "', ";
		$sql = $sql . " '" . $POST["valorConvenio"] . "','" . $AdjuntoConvenio . "',  ";
		$sql = $sql . " '" . $POST["valorAliado"] . "','" . $AdjuntoCDP . "',  ";
		$sql = $sql . " '" . $POST["valorTV"] . "','" . $AdjuntoTV . "',  ";
		$sql = $sql . " '" . $POST["valorInternet"] . "','" . $AdjuntoInternet . "',  ";
		$sql = $sql . " '" . $POST["valorPC"] . "','" . $AdjuntoPC . "',  ";
		$sql = $sql . " '" . $POST["valorEnergia"] . "','" . $AdjuntoEnergia . "',  ";
		$sql = $sql . " '" . $POST["valorInformador"] . "','" . $AdjuntoInformador . "',  ";
		$sql = $sql . " '" . $POST["valorMeses"] . "',   ";
		$sql = $sql . " '" . $POST["valorInformacionAcademica"] . "','" . $AdjuntoFormacionAcademicaTurismo . "',  ";
		$sql = $sql . " '" . $POST["valorSegundoIdioma"] . "','" . $AdjuntoInformadorSegundoIdioma . "',  ";
		$sql = $sql . " '" . $POST["valorMantenimiento"] . "','" . $AdjuntoMantenimientoPIT . "',  ";
		$sql = $sql . " '" . $POST["valorHorario"] . "','" . $AdjuntoHorarioOperatividadVisible . "',  ";
		$sql = $sql . " '" . $POST["valorMaterial"] . "','" . $AdjuntoMaterialPromocional . "',  ";
		$sql = $sql . " '" . $POST["valorProtocolosImplemento"] . "','" . $POST["valorElementosProteccion"] . "','" . $AdjuntoElementosProteccionPit . "',  ";
		$sql = $sql . " '" . rand(111111, 999999) . "','" . $UsuarioRegistro . "' ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " ";
		DB::unprepared($sql);
		return "1";
	}

	/*
  crearProcesoDocumento
  */
	public static  function crearProcesoDocumento($POST, $archivo)
	{
		$sql = "";
		$sql = $sql . " INSERT INTO  documentos_pits ";
		$sql = $sql . " ( ";
		$sql = $sql . " Titulo,Archivo,ActivoArchivo ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " VALUES ";
		$sql = $sql . " ( ";
		$sql = $sql . " '" . $POST["valorDocumento"] . "','" . $archivo . "'," . $POST["valorActivo"] . " ";
		$sql = $sql . "  ";
		$sql = $sql . " ) ";
		$sql = $sql . " ";
		DB::unprepared($sql);
		return "1";
	}

	/*
  actualizarProcesoDocumento
  */
	public static  function actualizarProcesoDocumento($IdDocumento, $POST, $archivo)
	{
		$sql = "";
		$sql = $sql . " UPDATE documentos_pits SET ";
		$sql = $sql . " Titulo='" . $POST["valorDocumento"] . "', ActivoArchivo=" . $POST["valorActivo"] . " ";
		$sql = $sql . " WHERE ";
		$sql = $sql . " IdDocumento=" . $IdDocumento;
		$sql = $sql . " ";
		DB::unprepared($sql);

		if (trim($archivo) != "") {
			$sql = "";
			$sql = $sql . " UPDATE documentos_pits SET ";
			$sql = $sql . " Archivo='" . $archivo . "'  ";
			$sql = $sql . " WHERE ";
			$sql = $sql . " IdDocumento=" . $IdDocumento;
			$sql = $sql . " ";
			DB::unprepared($sql);
		}

		return "1";
	}

	/*
  editarProcesoTurista
  */
	public static  function editarProcesoTurista($POST, $IdTurista)
	{
		$sql = "";
		$sql = $sql . "  UPDATE turista ";
		$sql = $sql . "  SET ";
		$sql = $sql . "  NombreConsultante='" . $POST["valorNombreConsultante"] . "',Correo='" . $POST["valorCorreo"] . "' ,IdCatastroPais=" . $POST["valorNacionalidad"] . ", ";
		$sql = $sql . "  IdCatastroCiudad=" . $POST["valorCiudad"] . ",IdMotivoViaje=" . $POST["valorMotivoViaje"] . ",NumeroTuristas=" . $POST["valorNroTuristas"] . ", ";
		$sql = $sql . "  IdTipoTransporte=" . $POST["valorTipoTransporte"] . ",IdTipoAlojamiento=" . $POST["valorTipoAlojamiento"] . ",IdDuracion=" . $POST["valorDuracionEstancia"] . ", ";
		$sql = $sql . "  IdEdad=" . $POST["valorEdad"] . ",IdFidelidad=" . $POST["valorFidelidad"] . ",IdMotivoConsulta=" . $POST["valorMotivoConsulta"] . ",IdSexo=" . $POST["valorSexo"] . ", ";
		$sql = $sql . "  PitsDetalle='" . $POST["valorPitsCiudad"] . "'  ";
		$sql = $sql . "  ";
		$sql = $sql . "  WHERE ";
		$sql = $sql . "  IdTurista=" . $IdTurista;
		$sql = $sql . " ";


		DB::unprepared($sql);
		return "1";
	}

	/*
  editarProcesoPuntos
  */
	public static  function editarProcesoPuntos($POST, $IdPuntos)
	{
		$sql = "";
		$sql = $sql . "  UPDATE puntos ";
		$sql = $sql . "  SET ";
		$sql = $sql . "  NombreCompleto='" . $POST["valorNombreCompleto"] . "',Cargo='" . $POST["valorCargo"] . "', ";
		$sql = $sql . "  Celular='" . $POST["valorCelular"] . "',Correo='" . $POST["valorCorreo"] . "' ";
		$sql = $sql . "  ";
		$sql = $sql . "  ";
		$sql = $sql . "  WHERE ";
		$sql = $sql . "  IdPuntos =" . $IdPuntos;
		$sql = $sql . " ";
		DB::unprepared($sql);
		return "1";
	}
}
