<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Departamento extends Model
{

    use HasFactory;

    protected $fillable = [
        'name',
        'active',
    ];

    protected $with = ['creatorUser', 'updaterUser'];
   
    public function creatorUser()
    {
        return $this->belongsTo(User::class, 'creator_user_id');
    }
    public function updaterUser()
    {
        return $this->belongsTo(User::class, 'updater_user_id');
    }

    public function cargos(){
        return $this->hasMany(Cargo::class);
    }
}
