<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Correspondencia extends Model
{
    use HasFactory;

    protected $fillable = [
        'para',
        'asunto',
        'user_id',

    ];

    protected $with = ['owner'];

    public function owner()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


    public function scopeAllowed($query)
    {
        if (auth()->user()->hasRole('super-admin')) {
            return $query;
        }else{
            return $query->where('user_id',auth()->id());
        }
    }
}
