<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cargo extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'departamento_id',
    ];

    protected $with = ['departamento','creatorUser','updaterUser'];

    public static function cargos($id)
    {
        return Cargo::where('departamento_id', '=', $id)->get();
    }

    public function departamento()
    {
        return $this->belongsTo(Departamento::class, 'departamento_id');
    }

    public function creatorUser()
    {
        return $this->belongsTo(User::class, 'creator_user_id');
    }
    public function updaterUser()
    {
        return $this->belongsTo(User::class, 'updater_user_id');
    }
}
