<?php

namespace App\Http\Controllers;

use App\Models\Departamento;
use App\Models\User;
use App\Models\Node;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Spatie\Permission\Models\Role;
use App\Models\Pits;

class UserController extends Controller
{
    public function index(Request $request)
    {
        $this->authorize('view', new User);
        $IdCiudad = $request->input('IdCiudad', '0');
        
		//ciudades PITS
		$ciudadesPits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->join('taxonomy_term_field_data', 'taxonomy_term_field_data.tid', '=', 'node__field_ciudad.field_ciudad_target_id')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->select('taxonomy_term_field_data.*')->orderBy('taxonomy_term_field_data.name')->distinct()->get();
        
        //filtro por ciudad PITS
        if(trim($IdCiudad) != "0" && trim($IdCiudad) != "")
         {
            $usuarios=User::where('IdCiudad',$IdCiudad)->get();
         }
        else
         {
            $usuarios=User::all();
         }
        
        return view('usuarios.index', ['usuarios' => $usuarios,'ciudadesPits' => $ciudadesPits,'IdCiudad' => $IdCiudad]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', new User);
        $departamentos = Departamento::where('active', true)->pluck('name', 'id');
		
		//ciudades
		$listadoCiudades=Pits::listadoCiudades();

		//aliados
		$listadoAliados=Pits::listadoAliados();

		//tallas
		$listadoTallas=Pits::listadoTallas();

		//generos
		$listadoGeneros=Pits::listadoGeneros();
        
		//ciudades PITS
		$ciudadesPits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->join('taxonomy_term_field_data', 'taxonomy_term_field_data.tid', '=', 'node__field_ciudad.field_ciudad_target_id')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->select('taxonomy_term_field_data.*')->orderBy('taxonomy_term_field_data.name')->distinct()->get();

		return view('usuarios.create', ['roles' => Role::all(),'listadoTallas' => $listadoTallas ,'listadoGeneros' => $listadoGeneros ,'listadoAliados' => $listadoAliados ,'usuario' => new User, 'departamentos' => $departamentos,'listadoCiudades' => $listadoCiudades,'ciudadesPits' => $ciudadesPits]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', new User);
        $data = $request->validate([
            'name' => 'required|max:255',
            'email' => 'required|email|max:255|unique:users',
            'departamento' => 'required',
            'cargo_id' => 'required',
            'password' => 'required|min:6|confirmed',
            'password_confirmation' => 'required',
            'FechaNacimiento' => 'required|max:10',
            'IdCiudad' => 'required|max:10',
            'IdGenero' => ['required', 'max:10'],
            'IdTalla' => ['required', 'max:10'],
            'IdAliado' => ['required', 'max:10'],
            'DireccionUsuario' => ['required', 'max:200'],
            'Telefono' => ['required', 'max:20'],
            'Celular' => ['required', 'max:20'],
            'Identificacion' => ['required', 'max:20'],
        ]);

        do {
            $token = Str::random(10);
        } while (User::where("token", "=", $token)->first() instanceof User);
        
        $data['token'] = $token;
        $data['creator_user_id'] = auth()->user()->id;
        $data['updater_user_id'] = auth()->user()->id;
		$user = User::create($data);
        $user->assignRole($request->roles);
        return redirect()->route('usuarios.index')->withFlash('El usuario ha sido creado de forma exitosa...');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(User $usuario)
    {
        $this->authorize('view', $usuario);
        return view('usuarios.show', compact('usuario'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $usuario)
    {
        $this->authorize('update', $usuario);
        $departamentos = Departamento::where('active', true)->pluck('name', 'id');
        $roles = Role::where('id', '!=', 1)->get();
		
		//ciudades
		$listadoCiudades=Pits::listadoCiudades();
        
		//aliados
		$listadoAliados=Pits::listadoAliados();

		//tallas
		$listadoTallas=Pits::listadoTallas();

		//generos
		$listadoGeneros=Pits::listadoGeneros();
		
		//ciudades PITS
		$ciudadesPits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->join('taxonomy_term_field_data', 'taxonomy_term_field_data.tid', '=', 'node__field_ciudad.field_ciudad_target_id')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->select('taxonomy_term_field_data.*')->orderBy('taxonomy_term_field_data.name')->distinct()->get();
		
		return view('usuarios.edit', compact('usuario', 'roles', 'listadoTallas'  ,'listadoGeneros'  ,'listadoAliados','departamentos','listadoCiudades','ciudadesPits'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $usuario)
    {

        $this->authorize('update', $usuario);
        $rules = [
            'name' => ['required', 'max:255'],
            'email' => ['required', 'email', 'max:255', Rule::unique('users')->ignore($usuario->id)],
            'departamento' => ['required'],
            'cargo_id' => ['required'],
            'FechaNacimiento' => ['required', 'max:10'],
            'IdCiudad' => ['required', 'max:10'],
            'IdGenero' => ['required', 'max:10'],
            'IdTalla' => ['required', 'max:10'],
            'IdAliado' => ['required', 'max:10'],
            'DireccionUsuario' => ['required', 'max:200'],
            'Telefono' => ['required', 'max:20'],
            'Celular' => ['required', 'max:20'],
            'Identificacion' => ['required', 'max:20'],
        ];

        if ($request->filled('password')) {
            $rules['password'] = ['min:6', 'confirmed'];
            $rules['password_confirmation'] = ['required'];
        }
        $data = $request->validate($rules);
        if ($request->has('active')) {
            $data['active'] = true;
        } else {
            $data['active'] = false;
        }
        $data['updater_user_id'] = auth()->user()->id;
        $usuario->update($data);
        $usuario->syncRoles($request->roles);
        return redirect()->route('usuarios.index')->withFlash('El usuario ha sido actualizado de forma exitosa...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function profile()
    {
        return view('usuarios.profile', ['usuario' => auth()->user()]);
    }

    public function updatePassword(Request $request, User $usuario)
    {
        $data = $request->validate([
            'password' => 'required|min:6|confirmed',
            'password_confirmation' => 'required'
        ]);

        $usuario->update($data);

        return redirect()->route('user.profile', ['usuario' => auth()->user()])->withFlash('Tu contraseña ha sido actualizada');
    }
}
