<?php

namespace App\Http\Controllers;

use App\Models\Node;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TuristasController extends Controller
{
    public function index()
    {   
        $noticias = Node::join('node__field_cms_page_body','node.nid','=','node__field_cms_page_body.entity_id')
        ->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
        ->join('node_field_data','node.nid','=','node_field_data.nid')
        ->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
        ->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
        ->join('node__field_cms_blog_category','node.nid','=','node__field_cms_blog_category.entity_id')
        ->where('node.type','cms_blog')
        ->where('node__field_cms_blog_category.field_cms_blog_category_target_id',1)
        ->where('node.langcode',"es")
        ->where('node__field_cms_page_body.langcode','es')
        ->where('node__field_cms_page_image.langcode','es')
        ->where('node_field_data.langcode','es')
        ->where('file_managed.langcode','es')
        ->where('node__field_fecha.langcode','es')
        ->where('node__field_cms_blog_category.langcode','es')
        ->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__field_cms_page_body.field_cms_page_body_value as body')->orderByDesc('node__field_fecha.field_fecha_value')
        ->take(2)->get();

        $galeriasId = new Node;
        /* $galeriasId = DB::connection('drupal')->select("select n.nid as id from node n
        inner join node__field_fecha d on n.nid = d.entity_id 
        where type = 'galeria' 
        order by d.field_fecha_value DESC LIMIT 4");*/

        /* $galerias = Node::join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
        ->join('node_field_data','node.nid','=','node_field_data.nid')
        ->join('node__field_image','node.nid','=','node__field_image.entity_id')
        ->where('node.type','galeria')
        ->select(DB::raw('node.*, (select file_managed.uri from file_managed where node__field_image.field_image_target_id = file_managed.fid LIMIT 1) as img, node_field_data.title as title'))
        ->orderByDesc('node__field_fecha.field_fecha_value')
        ->take(4)->get(); */
       
        $galerias = Node::join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
        ->join('node_field_data','node.nid','=','node_field_data.nid')
        ->where('node.type','galeria')
        ->select(DB::raw('node.*, (select f.uri from node__field_image i inner join file_managed f on i.field_image_target_id = f.fid where node.nid = i.entity_id   LIMIT 1) as img, node_field_data.title as title, node__field_fecha.field_fecha_value as date'))
        ->orderByDesc('node__field_fecha.field_fecha_value')
        ->take(4)->get();

      /* $galerias = []; */

       

        /* foreach ($galeriasId as $galeriaId) {
            
            $consulta = Node::join('node__field_image','node.nid','=','node__field_image.entity_id')
            ->join('file_managed','node__field_image.field_image_target_id','=','file_managed.fid')
            ->join('node_field_data','node.nid','=','node_field_data.nid')
            ->where('node.type','galeria')
            ->where('node.nid',$galeriaId->id)
            ->select('node.*','file_managed.uri as img','node_field_data.title as title')
            ->take(1)->get();
            array_push($galerias,$consulta );

        } */ 
            

        return view('turistas', [
            'noticias' => $noticias, 
            'galerias' => $galerias
        ]);
    }
}
