<?php

namespace App\Http\Controllers;

use App\Models\Pits;
use App\Models\Node;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReporteController extends Controller
{
	/*
	index
	*/
    public function index(Request $request)
	{
        ini_set('memory_limit', '-1');
	    $paginaActual = $request->input('paginaActual', '1');
	    $paginaActualId = $request->input('paginaActualId', '1');
	    
		$videos = Node::join('node__body','node.nid','=','node__body.entity_id')
		->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
		->join('node_field_data','node.nid','=','node_field_data.nid')
		->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
		->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
		->where('node.type','videos')
		->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__body.body_value as body')->orderByDesc('node__field_fecha.field_fecha_value')->paginate(9);
	
		$procesoRegistroTurista = $request->input('procesoRegistroTurista', '');
		$procesoEditarTurista = $request->input('procesoEditarTurista', '');
		$fechaFiltroDesde = $request->input('fechaFiltroDesde', '');
		$fechaFiltroHasta = $request->input('fechaFiltroHasta', '');
		$procesoEditarRegistroTurista = $request->input('procesoEditarRegistroTurista', '');
		$post['valorNombreConsultante'] = $request->input('valorNombreConsultante', '');
		$post['valorCorreo'] = $request->input('valorCorreo', '');
		$post['valorNacionalidad'] = $request->input('valorNacionalidad', '');
		$post['valorCiudad'] = $request->input('valorCiudad', '');
		$post['valorMotivoViaje'] = $request->input('valorMotivoViaje', '');
		$post['valorNroTuristas'] = $request->input('valorNroTuristas', '');
		$post['valorTipoTransporte'] = $request->input('valorTipoTransporte', '');
		$post['valorTipoAlojamiento'] = $request->input('valorTipoAlojamiento', '');
		$post['valorDuracionEstancia'] = $request->input('valorDuracionEstancia', '');
		$post['valorSexo'] = $request->input('valorSexo', '');
		$post['valorEdad'] = $request->input('valorEdad', '');
		$post['valorFidelidad'] = $request->input('valorFidelidad', '');
		$post['valorMotivoConsulta'] = $request->input('valorMotivoConsulta', '');
		$post['valorPitsCiudad'] = $request->input('valorPitsCiudad', '');
		$post['valorTipoReporte'] = $request->input('valorTipoReporte', '');
			
		//detalle registro
		$registro= ReporteController::detalleTurista($procesoEditarTurista);
		
		//paises
		$listadoPaises=Pits::listadoPaises();
		//ciudades
		$listadoCiudades=Pits::listadoCiudades();
		//motivos viaje
		$listadoMotivoViaje=Pits::listadoMotivoViaje();
		//tipo transporte
		$listadoTipoTransporte=Pits::listadoTipoTransporte();
		//tipo alojamiento
		$listadoTipoAlojamiento=Pits::listadoTipoAlojamiento();
		//duracion estancia
		$listadoDuracionEstancia=Pits::listadoDuracionEstancia();
		//edad
		$listadoEdad=Pits::listadoEdad();
		//fidelidad
		$listadoFidelidad=Pits::listadoFidelidad();
		//motivo consulta
		$listadoMotivoConsulta=Pits::listadoMotivoConsulta();
		//listado ciudades Colombia
		$listadoCiudadesPais=Pits::listadoMunicipio();

		//listado turistas paginado
		$listadoTuristas=Pits::listadoTuristasFiltroReportePaginado($fechaFiltroDesde,$fechaFiltroHasta,$post,$paginaActual,$paginaActualId);

		//data reporte grafico
		$coleccionLabels="";
		$coleccionDatos="";
		if(trim($post['valorTipoReporte'])!="")
		 {
		    $listadoDataGraficoArray=Pits::listadoTuristasFiltroReporteGrafico($fechaFiltroDesde,$fechaFiltroHasta,$post);
	        $coleccionLabels=$listadoDataGraficoArray[0];
		    $coleccionDatos=$listadoDataGraficoArray[1];
		 }

		//ciudades PITS
		$ciudadesPits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->join('taxonomy_term_field_data', 'taxonomy_term_field_data.tid', '=', 'node__field_ciudad.field_ciudad_target_id')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->select('taxonomy_term_field_data.*')->orderBy('taxonomy_term_field_data.name')->distinct()->get();
		
		//PITS ciudad del usuario actual
		if(auth()->user()->hasRole('admin')=="1")
		 {
		    //es admin
		    $perfilTipo="1";
    		$pits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
    		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
    		->where('node.type', "pits")
    		->where('node.langcode', "es")
    		->where('node_field_data.status', 1)
    		->select('node_field_data.*')->orderBy('node_field_data.title')->distinct()->get();
		 }
		else
		 {
		    //no es admin  
		    $perfilTipo="0";
    		$pits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
    		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
    		->where('node.type', "pits")
    		->where('node.langcode', "es")
    		->where('node_field_data.status', 1)
    		->where('node__field_ciudad.field_ciudad_target_id',auth()->user()->IdCiudad)
    		->select('node_field_data.*')->orderBy('node_field_data.title')->distinct()->get();
		 }
		
        return view('reportes', [
            'paginaActual' => $paginaActual, 
            'paginaActualId' => $paginaActualId, 
            'listadoPaises' => $listadoPaises, 
            'listadoCiudades' => $listadoCiudades,
            'listadoMotivoViaje' => $listadoMotivoViaje,
            'listadoTipoTransporte' => $listadoTipoTransporte,
            'listadoTipoAlojamiento' => $listadoTipoAlojamiento,
            'listadoDuracionEstancia' => $listadoDuracionEstancia,
            'listadoEdad' => $listadoEdad,
            'listadoFidelidad' => $listadoFidelidad,
            'listadoMotivoConsulta' => $listadoMotivoConsulta,
            'listadoTuristas' => $listadoTuristas,
            'procesoRegistroTurista' => $procesoRegistroTurista,
            'procesoEditarTurista' => $procesoEditarTurista,
            'procesoEditarRegistroTurista' => $procesoEditarRegistroTurista,
            'ciudadesPits' => $ciudadesPits,
            'listadoCiudadesPais' => $listadoCiudadesPais,
            'fechaFiltroDesde' => $fechaFiltroDesde,
            'fechaFiltroHasta' => $fechaFiltroHasta,
            'post' => $post,
            'pits' => $pits,
            'coleccionLabels' => $coleccionLabels,
            'coleccionDatos' => $coleccionDatos,
            'perfilTipo' => $perfilTipo,
            'IdCiudadUsuario' => auth()->user()->IdCiudad,
            'registro' => $registro
        ]);	
    }
	
	
	/*
	portal
	*/
    public function portal(Request $request)
	{

		$procesoRegistroTurista = $request->input('procesoRegistroTurista', '');
		$procesoEditarTurista = $request->input('procesoEditarTurista', '');
		$fechaFiltroDesde = $request->input('fechaFiltroDesde', '');
		$fechaFiltroHasta = $request->input('fechaFiltroHasta', '');
		$valorPits = $request->input('valorPits', '');

		$procesoEditarRegistroTurista = $request->input('procesoEditarRegistroTurista', '');
		$post['valorNombreConsultante'] = $request->input('valorNombreConsultante', '');
		$post['valorCorreo'] = $request->input('valorCorreo', '');
		$post['valorNacionalidad'] = $request->input('valorNacionalidad', '');
		$post['valorCiudad'] = $request->input('valorCiudad', '');
		$post['valorMotivoViaje'] = $request->input('valorMotivoViaje', '');
		$post['valorNroTuristas'] = $request->input('valorNroTuristas', '');
		$post['valorTipoTransporte'] = $request->input('valorTipoTransporte', '');
		$post['valorTipoAlojamiento'] = $request->input('valorTipoAlojamiento', '');
		$post['valorDuracionEstancia'] = $request->input('valorDuracionEstancia', '');
		$post['valorSexo'] = $request->input('valorSexo', '');
		$post['valorEdad'] = $request->input('valorEdad', '');
		$post['valorFidelidad'] = $request->input('valorFidelidad', '');
		$post['valorMotivoConsulta'] = $request->input('valorMotivoConsulta', '');
		$post['valorPitsCiudad'] = $request->input('valorPitsCiudad', '');
		$post['valorTipoReporte'] = $request->input('valorTipoReporte', '');
		

		//detalle registro
		$registro= ReporteController::detalleTurista($procesoEditarTurista);
		
		//paises
		$listadoPaises=Pits::listadoPaises();
		//ciudades
		$listadoCiudades=Pits::listadoCiudades();
		//motivos viaje
		$listadoMotivoViaje=Pits::listadoMotivoViaje();
		//tipo transporte
		$listadoTipoTransporte=Pits::listadoTipoTransporte();
		//tipo alojamiento
		$listadoTipoAlojamiento=Pits::listadoTipoAlojamiento();
		//duracion estancia
		$listadoDuracionEstancia=Pits::listadoDuracionEstancia();
		//edad
		$listadoEdad=Pits::listadoEdad();
		//fidelidad
		$listadoFidelidad=Pits::listadoFidelidad();
		//motivo consulta
		$listadoMotivoConsulta=Pits::listadoMotivoConsulta();
		//listado ciudades Colombia
		$listadoCiudadesPais=Pits::listadoMunicipio();
		//listado turistas
		//$listadoTuristas=Pits::listadoTuristasFiltroReporte($fechaFiltroDesde,$fechaFiltroHasta,$post);
		
		//data reporte grafico
		if(trim($fechaFiltroDesde)=="" || trim($fechaFiltroHasta)=="")
		 {
		    $fechaFiltroDesde=date("Y")."-01-01";
		    $fechaFiltroHasta=date("Y")."-12-31";
		 }
		 
		$listadoDataGraficoArray=Pits::listadoPortalFlujoGrafico($fechaFiltroDesde,$fechaFiltroHasta,$valorPits,$post);
	    $coleccionLabels=$listadoDataGraficoArray[0];
		$coleccionDatos=$listadoDataGraficoArray[1];


        return view('reportes2', [
            'listadoPaises' => $listadoPaises, 
            'listadoCiudades' => $listadoCiudades,
            'listadoMotivoViaje' => $listadoMotivoViaje,
            'listadoTipoTransporte' => $listadoTipoTransporte,
            'listadoTipoAlojamiento' => $listadoTipoAlojamiento,
            'listadoDuracionEstancia' => $listadoDuracionEstancia,
            'listadoEdad' => $listadoEdad,
            'listadoFidelidad' => $listadoFidelidad,
            'listadoMotivoConsulta' => $listadoMotivoConsulta,
            'listadoTuristas' => "",
            'procesoRegistroTurista' => $procesoRegistroTurista,
            'procesoEditarTurista' => $procesoEditarTurista,
            'procesoEditarRegistroTurista' => $procesoEditarRegistroTurista,
            'ciudadesPits' => "",
            'listadoCiudadesPais' => $listadoCiudadesPais,
            'fechaFiltroDesde' => $fechaFiltroDesde,
            'fechaFiltroHasta' => $fechaFiltroHasta,
            'valorPits' => $valorPits,
            'post' => $post,
            'pits' => "",
            'coleccionLabels' => $coleccionLabels,
            'coleccionDatos' => $coleccionDatos,
            'IdCiudadUsuario' => "0",
            'registro' => $registro
        ]);	
    }
	
  /*
  detalleTurista
  */
  function detalleTurista($IdTurista )
  {
	  $registro["IdTurista "]=$IdTurista ; 
	  $registro["NombreConsultante"]=""; 
	  $registro["Correo"]=""; 
	  $registro["IdCatastroPais"]=""; 
      $registro["IdCatastroCiudad"]="";  
	  $registro["IdMotivoViaje"]=""; 
	  $registro["NumeroTuristas"]=""; 
	  $registro["IdTipoTransporte"]=""; 
	  $registro["IdTipoAlojamiento"]="";  
	  $registro["IdDuracion"]=""; 
	  $registro["IdEdad"]=""; 
	  $registro["IdFidelidad"]=""; 
	  $registro["IdMotivoConsulta"]=""; 
	  $registro["FechaRegistro"]=""; 
	  $registro["IdSexo"]=""; 
	  $registro["IdPits"]=""; 
	  $registro["PitsDetalle"]=""; 

	  if(trim($IdTurista )!="" && trim($IdTurista )!="0")
	   {
		  $listado=Pits::listadoDetalleTurista($IdTurista);
		  foreach ($listado as $row) 
		   {
			  $registro["NombreConsultante"]=$row->NombreConsultante; 
			  $registro["Correo"]=$row->Correo; 
			  $registro["IdCatastroPais"]=$row->IdCatastroPais; 
			  $registro["IdCatastroCiudad"]=$row->IdCatastroCiudad; 
			  $registro["IdMotivoViaje"]=$row->IdMotivoViaje; 
			  $registro["NumeroTuristas"]=$row->NumeroTuristas; 
			  $registro["IdTipoTransporte"]=$row->IdTipoTransporte; 
			  $registro["IdTipoAlojamiento"]=$row->IdTipoAlojamiento; 
			  $registro["IdDuracion"]=$row->IdDuracion; 
			  $registro["IdEdad"]=$row->IdEdad; 
			  $registro["IdFidelidad"]=$row->IdFidelidad; 
			  $registro["IdMotivoConsulta"]=$row->IdMotivoConsulta; 
			  $registro["IdSexo"]=$row->IdSexo; 
			  $registro["IdPits"]=$row->IdPits; 
			  $registro["PitsDetalle"]=$row->PitsDetalle; 
		   }
	   }
	  
	 return $registro;  
  }
	
	
    /*
	show
	*/
    public function show(Node $video)
	{
        $videos = Node::join('node__body','node.nid','=','node__body.entity_id')
		->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
		->join('node_field_data','node.nid','=','node_field_data.nid')
		->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
		->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
		->join('node__field_video','node.nid','=','node__field_video.entity_id')
		->where('node.nid',$video->nid)
		->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__body.body_value as body', 'node__field_video.field_video_value as video')
		->take(1)->get();
		return view('videos.video', ['videos' => $videos]);
    }
    
}
