<?php

namespace App\Http\Controllers;

use App\Models\Pits;
use App\Models\Node;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PuntosController extends Controller
{
	/*
	index
	*/
    public function index(Request $request)
	{
		$videos = Node::join('node__body','node.nid','=','node__body.entity_id')
		->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
		->join('node_field_data','node.nid','=','node_field_data.nid')
		->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
		->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
		->where('node.type','videos')
		->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__body.body_value as body')->orderByDesc('node__field_fecha.field_fecha_value')->paginate(9);
	
		$procesoRegistroTurista = $request->input('procesoRegistroTurista', '');
		$procesoEditarTurista = $request->input('procesoEditarTurista', '');
		$procesoEditarRegistroTurista = $request->input('procesoEditarRegistroTurista', '');

		$post['valorPitsCiudad'] = $request->input('valorPitsCiudad', '');
		$post['valorNombreCompleto'] = $request->input('valorNombreCompleto', '');
		$post['valorCargo'] = $request->input('valorCargo', '');
		$post['valorCelular'] = $request->input('valorCelular', '');
		$post['valorCorreo'] = $request->input('valorCorreo', '');
		$post['valorNumeroRegistros'] = $request->input('valorNumeroRegistros', '');
		$post['valorConvenio'] = $request->input('valorConvenio', '');
		$post['valorAliado'] = $request->input('valorAliado', '');
		$post['valorTV'] = $request->input('valorTV', '');
		$post['valorInternet'] = $request->input('valorInternet', '');
		$post['valorPC'] = $request->input('valorPC', '');
		$post['valorEnergia'] = $request->input('valorEnergia', '');
		$post['valorInformador'] = $request->input('valorInformador', '');
		$post['valorMeses'] = $request->input('valorMeses', '');
		$post['valorInformacionAcademica'] = $request->input('valorInformacionAcademica', '');
		$post['valorSegundoIdioma'] = $request->input('valorSegundoIdioma', '');
		$post['valorMantenimiento'] = $request->input('valorMantenimiento', '');
		$post['valorHorario'] = $request->input('valorHorario', '');
		$post['valorMaterial'] = $request->input('valorMaterial', '');
		$post['valorProtocolosImplemento'] = $request->input('valorProtocolosImplemento', '');
		$post['valorElementosProteccion'] = $request->input('valorElementosProteccion', '');
			
		if(trim($procesoRegistroTurista)=="1")
		 {
		    //ingresar puntos
			$file1="";
			$AdjuntoConvenio = $request->file('file1');
			if($AdjuntoConvenio!="")
			 {
			  if( $AdjuntoConvenio->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoConvenio->move($destinationPath,$llaveArchivo.$AdjuntoConvenio->getClientOriginalName());	  
				 $file1=$llaveArchivo.$AdjuntoConvenio->getClientOriginalName();
			   }			  
			 }

			$file2="";
			$AdjuntoCDP = $request->file('file2');
			if($AdjuntoCDP!="")
			 {
			  if( $AdjuntoCDP->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoCDP->move($destinationPath,$llaveArchivo.$AdjuntoCDP->getClientOriginalName());	  
				 $file2=$llaveArchivo.$AdjuntoCDP->getClientOriginalName();
			   }			  
			 }

			$file3="";
			$AdjuntoTV = $request->file('file3');
			if($AdjuntoTV!="")
			 {
			  if( $AdjuntoTV->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoTV->move($destinationPath,$llaveArchivo.$AdjuntoTV->getClientOriginalName());	  
				 $file3=$llaveArchivo.$AdjuntoTV->getClientOriginalName();
			   }			  
			 }

			$file4="";
			$AdjuntoInternet = $request->file('file4');
			if($AdjuntoInternet!="")
			 {
			  if( $AdjuntoInternet->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoInternet->move($destinationPath,$llaveArchivo.$AdjuntoInternet->getClientOriginalName());	  
				 $file4=$llaveArchivo.$AdjuntoInternet->getClientOriginalName();
			   }			  
			 }

			$file5="";
			$AdjuntoPC = $request->file('file5');
			if($AdjuntoPC!="")
			 {
			  if( $AdjuntoPC->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoPC->move($destinationPath,$llaveArchivo.$AdjuntoPC->getClientOriginalName());	  
				 $file5=$llaveArchivo.$AdjuntoPC->getClientOriginalName();
			   }			  
			 }

			$file6="";
			$AdjuntoEnergia = $request->file('file6');
			if($AdjuntoEnergia!="")
			 {
			  if( $AdjuntoEnergia->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoEnergia->move($destinationPath,$llaveArchivo.$AdjuntoEnergia->getClientOriginalName());	  
				 $file6=$llaveArchivo.$AdjuntoEnergia->getClientOriginalName();
			   }			  
			 }

			$file7="";
			$AdjuntoInformador = $request->file('file7');
			if($AdjuntoInformador!="")
			 {
			  if( $AdjuntoInformador->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoInformador->move($destinationPath,$llaveArchivo.$AdjuntoInformador->getClientOriginalName());	  
				 $file7=$llaveArchivo.$AdjuntoInformador->getClientOriginalName();
			   }			  
			 }

			$file8="";
			$AdjuntoFormacionAcademicaTurismo = $request->file('file8');
			if($AdjuntoFormacionAcademicaTurismo!="")
			 {
			  if( $AdjuntoFormacionAcademicaTurismo->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoFormacionAcademicaTurismo->move($destinationPath,$llaveArchivo.$AdjuntoFormacionAcademicaTurismo->getClientOriginalName());	  
				 $file8=$llaveArchivo.$AdjuntoFormacionAcademicaTurismo->getClientOriginalName();
			   }			  
			 }

			$file9="";
			$AdjuntoInformadorSegundoIdioma = $request->file('file9');
			if($AdjuntoInformadorSegundoIdioma!="")
			 {
			  if( $AdjuntoInformadorSegundoIdioma->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoInformadorSegundoIdioma->move($destinationPath,$llaveArchivo.$AdjuntoInformadorSegundoIdioma->getClientOriginalName());	  
				 $file9=$llaveArchivo.$AdjuntoInformadorSegundoIdioma->getClientOriginalName();
			   }			  
			 }

			$file10="";
			$AdjuntoMantenimientoPIT = $request->file('file10');
			if($AdjuntoMantenimientoPIT!="")
			 {
			  if( $AdjuntoMantenimientoPIT->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoMantenimientoPIT->move($destinationPath,$llaveArchivo.$AdjuntoMantenimientoPIT->getClientOriginalName());	  
				 $file10=$llaveArchivo.$AdjuntoMantenimientoPIT->getClientOriginalName();
			   }			  
			 }
			 
			$file11="";
			$AdjuntoHorarioOperatividadVisible = $request->file('file11');
			if($AdjuntoHorarioOperatividadVisible!="")
			 {
			  if( $AdjuntoHorarioOperatividadVisible->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoHorarioOperatividadVisible->move($destinationPath,$llaveArchivo.$AdjuntoHorarioOperatividadVisible->getClientOriginalName());	  
				 $file11=$llaveArchivo.$AdjuntoHorarioOperatividadVisible->getClientOriginalName();
			   }			  
			 }

			$file12="";
			$AdjuntoMaterialPromocional = $request->file('file12');
			if($AdjuntoMaterialPromocional!="")
			 {
			  if( $AdjuntoMaterialPromocional->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $AdjuntoMaterialPromocional->move($destinationPath,$llaveArchivo.$AdjuntoMaterialPromocional->getClientOriginalName());	  
				 $file12=$llaveArchivo.$AdjuntoMaterialPromocional->getClientOriginalName();
			   }			  
			 }

			$file13="";
			$ElementosProteccionPit = $request->file('file13');
			if($ElementosProteccionPit!="")
			 {
			  if( $ElementosProteccionPit->getClientOriginalExtension() == "pdf" )  
			   {
				 $destinationPath = 'documentos';
				 $llaveArchivo=date("YmdHi").rand(1111,9999);
				 $ElementosProteccionPit->move($destinationPath,$llaveArchivo.$ElementosProteccionPit->getClientOriginalName());	  
				 $file13=$llaveArchivo.$ElementosProteccionPit->getClientOriginalName();
			   }			  
			 }
			 
		    Pits::crearProcesoPuntos($post,$file1,$file2,$file3,$file4,$file5,$file6,$file7,$file8,$file9,$file10,$file11,$file12,$file13,auth()->user()->name);
		 }
	
		if(trim($procesoEditarRegistroTurista)!="")
		 {
		    //editar puntos
		    Pits::editarProcesoPuntos($post,$procesoEditarRegistroTurista);
		 }
	
		//detalle registro
		$registro= PuntosController::detallePuntos($procesoEditarTurista);
		
		//paises
		$listadoPaises=Pits::listadoPaises();
		//ciudades
		$listadoCiudades=Pits::listadoCiudades();
		//motivos viaje
		$listadoMotivoViaje=Pits::listadoMotivoViaje();
		//tipo transporte
		$listadoTipoTransporte=Pits::listadoTipoTransporte();
		//tipo alojamiento
		$listadoTipoAlojamiento=Pits::listadoTipoAlojamiento();
		//duración estancia
		$listadoDuracionEstancia=Pits::listadoDuracionEstancia();
		//edad
		$listadoEdad=Pits::listadoEdad();
		//fidelidad
		$listadoFidelidad=Pits::listadoFidelidad();
		//motivo consulta
		$listadoMotivoConsulta=Pits::listadoMotivoConsulta();
		//listado puntos
		$listadoPuntos=Pits::listadoPuntos();
		//listado ciudades Colombia
		$listadoCiudadesPais=Pits::listadoMunicipio();
		
		//ciudades PITS
		$ciudadesPits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->join('taxonomy_term_field_data', 'taxonomy_term_field_data.tid', '=', 'node__field_ciudad.field_ciudad_target_id')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->select('taxonomy_term_field_data.*')->orderBy('taxonomy_term_field_data.name')->distinct()->get();
		
		//PITS ciudad del usuario actual
		$pits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->where('node__field_ciudad.field_ciudad_target_id',auth()->user()->IdCiudad)
		->select('node_field_data.*')->orderBy('node_field_data.title')->distinct()->get();
		
        return view('puntos', [
            'listadoPaises' => $listadoPaises, 
            'listadoCiudades' => $listadoCiudades,
            'listadoMotivoViaje' => $listadoMotivoViaje,
            'listadoTipoTransporte' => $listadoTipoTransporte,
            'listadoTipoAlojamiento' => $listadoTipoAlojamiento,
            'listadoDuracionEstancia' => $listadoDuracionEstancia,
            'listadoEdad' => $listadoEdad,
            'listadoFidelidad' => $listadoFidelidad,
            'listadoMotivoConsulta' => $listadoMotivoConsulta,
            'listadoPuntos' => $listadoPuntos,
            'procesoRegistroTurista' => $procesoRegistroTurista,
            'procesoEditarTurista' => $procesoEditarTurista,
            'procesoEditarRegistroTurista' => $procesoEditarRegistroTurista,
            'ciudadesPits' => $ciudadesPits,
            'listadoCiudadesPais' => $listadoCiudadesPais,
            'pits' => $pits,
            'IdCiudadUsuario' => auth()->user()->IdCiudad,
            'registro' => $registro
        ]);	
    }
	
  /*
  detallePuntos
  */
  function detallePuntos($IdPuntos)
  {
	  $registro["IdPuntos"]=$IdPuntos  ; 
	  $registro["IdPit"]=""; 
	  $registro["NombreCompleto"]=""; 
	  $registro["Cargo"]=""; 
      $registro["Celular"]="";  
	  $registro["Correo"]=""; 
	  $registro["NroRegistros"]=""; 
	  $registro["ConvenioCooperacion"]=""; 
	  $registro["AdjuntoConvenio"]="";  
	  $registro["CuentaConCDP"]=""; 
	  $registro["AdjuntoCDP"]=""; 
	  $registro["TieneTV"]=""; 
	  $registro["AdjuntoTV"]=""; 
	  $registro["TieneInternet"]=""; 
	  $registro["AdjuntoInternet"]=""; 
	  $registro["TienePC"]=""; 
	  $registro["AdjuntoPC"]=""; 
	  $registro["TieneEnergia"]=""; 
	  $registro["AdjuntoEnergia"]=""; 
	  $registro["TieneInformador"]=""; 
	  $registro["AdjuntoInformador"]=""; 
	  $registro["TiempoMesesInformador"]=""; 
	  $registro["FormacionAcademicaTurismo"]=""; 
	  $registro["FormacionAcademicaTurismo"]=""; 
	  $registro["InformadorSegundoIdioma"]=""; 
	  $registro["InformadorSegundoIdioma"]=""; 
	  $registro["InformadorSegundoIdioma"]=""; 
	  $registro["AdjuntoMantenimientoPIT"]=""; 
	  $registro["HorarioOperatividadVisible"]=""; 
	  $registro["AdjuntoHorarioOperatividadVisible"]=""; 
	  $registro["MaterialPromocional"]=""; 
	  $registro["AdjuntoMaterialPromocional"]=""; 
	  $registro["ProtocolosBioseguridad"]=""; 
	  $registro["ElementosProteccionPit"]=""; 
	  $registro["AdjuntoElementosProteccionPit"]=""; 
	  $registro["FechaRegistro"]=""; 
	  $registro["LlaveRegistro"]=""; 
	  $registro["UsuarioRegistro"]=""; 
	  $registro["MantenimientoPIT"]=""; 
	  
	   
	  if(trim($IdPuntos )!="" && trim($IdPuntos )!="0")
	   {
		  $listado=Pits::listadoDetallePuntos($IdPuntos);
		  foreach ($listado as $row) 
		   {
			  $registro["IdPuntos "]=$row->IdPuntos ; 
			  $registro["IdPit"]=$row->IdPit; 
			  $registro["NombreCompleto"]=$row->NombreCompleto; 
			  $registro["Cargo"]=$row->Cargo; 
			  $registro["Celular"]=$row->Celular; 
			  $registro["Correo"]=$row->Correo; 
			  $registro["NroRegistros"]=$row->NroRegistros; 
			  $registro["ConvenioCooperacion"]=$row->ConvenioCooperacion; 
			  $registro["AdjuntoConvenio"]=$row->AdjuntoConvenio; 
			  $registro["CuentaConCDP"]=$row->CuentaConCDP; 
			  $registro["AdjuntoCDP"]=$row->AdjuntoCDP; 
			  $registro["TieneTV"]=$row->TieneTV; 
			  $registro["AdjuntoTV"]=$row->AdjuntoTV; 
			  $registro["TieneInternet"]=$row->TieneInternet; 
			  $registro["AdjuntoInternet"]=$row->AdjuntoInternet; 
			  $registro["TienePC"]=$row->TienePC; 
			  $registro["AdjuntoPC"]=$row->AdjuntoPC; 
			  $registro["TieneEnergia"]=$row->TieneEnergia; 
			  $registro["AdjuntoEnergia"]=$row->AdjuntoEnergia; 
			  $registro["TieneInformador"]=$row->TieneInformador; 
			  $registro["TiempoMesesInformador"]=$row->TiempoMesesInformador; 
			  $registro["FormacionAcademicaTurismo"]=$row->FormacionAcademicaTurismo; 
			  $registro["AdjuntoFormacionAcademicaTurismo"]=$row->AdjuntoFormacionAcademicaTurismo; 
			  $registro["InformadorSegundoIdioma"]=$row->InformadorSegundoIdioma; 
			  $registro["AdjuntoInformadorSegundoIdioma"]=$row->AdjuntoInformadorSegundoIdioma; 
			  $registro["MantenimientoPIT"]=$row->MantenimientoPIT; 
			  $registro["AdjuntoMantenimientoPIT"]=$row->AdjuntoMantenimientoPIT; 
			  $registro["HorarioOperatividadVisible"]=$row->HorarioOperatividadVisible; 
			  $registro["AdjuntoHorarioOperatividadVisible"]=$row->AdjuntoHorarioOperatividadVisible; 
			  $registro["MaterialPromocional"]=$row->MaterialPromocional; 
			  $registro["AdjuntoMaterialPromocional"]=$row->AdjuntoMaterialPromocional; 
			  $registro["ProtocolosBioseguridad"]=$row->ProtocolosBioseguridad; 
			  $registro["ElementosProteccionPit"]=$row->ElementosProteccionPit; 
			  $registro["AdjuntoElementosProteccionPit"]=$row->AdjuntoElementosProteccionPit; 
		   }
	   }
      	 
	 return $registro;  
  }
	
    /*
	show
	*/
    public function show(Node $video)
	{
        $videos = Node::join('node__body','node.nid','=','node__body.entity_id')
		->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
		->join('node_field_data','node.nid','=','node_field_data.nid')
		->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
		->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
		->join('node__field_video','node.nid','=','node__field_video.entity_id')
		->where('node.nid',$video->nid)
		->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__body.body_value as body', 'node__field_video.field_video_value as video')
		->take(1)->get();
		return view('videos.video', ['videos' => $videos]);
    }
    
}
