<?php

namespace App\Http\Controllers;

use App\Models\Node;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NoticiaController extends Controller
{
    public function show(Node $noticia){ 
        $noticias = Node::join('node__field_cms_page_body','node.nid','=','node__field_cms_page_body.entity_id')
        ->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
        ->join('node_field_data','node.nid','=','node_field_data.nid')
        ->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
        ->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
        ->join('node__field_cms_blog_category','node.nid','=','node__field_cms_blog_category.entity_id')
        ->where('node.nid',$noticia->nid)
        ->where('node.type','cms_blog')
        ->where('node__field_cms_blog_category.field_cms_blog_category_target_id',9)
        ->where('node.langcode',"es")
        ->where('node__field_cms_page_body.langcode','es')
        ->where('node__field_cms_page_image.langcode','es')
        ->where('node_field_data.langcode','es')
        ->where('file_managed.langcode','es')
        ->where('node__field_fecha.langcode','es')
        ->where('node__field_cms_blog_category.langcode','es')
        ->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__field_cms_page_body.field_cms_page_body_value as body')->orderByDesc('node__field_fecha.field_fecha_value')
        ->take(1)->get();
        return view('noticias.noticia', ['noticias' => $noticias]);
    }

public function index(){
    $noticias = Node::join('node__field_cms_page_body','node.nid','=','node__field_cms_page_body.entity_id')
    ->join('node__field_cms_page_image','node.nid','=','node__field_cms_page_image.entity_id')
    ->join('node_field_data','node.nid','=','node_field_data.nid')
    ->join('file_managed','node__field_cms_page_image.field_cms_page_image_target_id','=','file_managed.fid')
    ->join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
    ->join('node__field_cms_blog_category','node.nid','=','node__field_cms_blog_category.entity_id')
    ->where('node.type','cms_blog')
    ->where('node__field_cms_blog_category.field_cms_blog_category_target_id',9)
    ->where('node.langcode',"es")
    ->where('node__field_cms_page_body.langcode','es')
    ->where('node__field_cms_page_image.langcode','es')
    ->where('node_field_data.langcode','es')
    ->where('file_managed.langcode','es')
    ->where('node__field_fecha.langcode','es')
    ->where('node__field_cms_blog_category.langcode','es')
    ->select('node.*', 'node_field_data.title as title', 'file_managed.uri as img','node__field_fecha.field_fecha_value as date', 'node__field_cms_page_body.field_cms_page_body_value as body')->orderByDesc('node__field_fecha.field_fecha_value')->paginate(9);
    return view('noticias.index', ['noticias' => $noticias]);
}

}
