<?php

namespace App\Http\Controllers;

use App\Models\Cargo;
use App\Models\Departamento;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Models\Pits;

class MaestrosController extends Controller
{
    public function getCargos(Request $request, $id)
    {
        if ($request->ajax()) {
            $cargos = Cargo::cargos($id);
            return response()->json($cargos);
        }
    }

    public function index(Request $request)
    {
        //$this->authorize('view', new Departamento);
		$procesoRegistroDocumento = $request->input('procesoRegistroDocumento', '');
		$procesoEditarDocumento = $request->input('procesoEditarDocumento', '');
		$procesoEditarRegistroDocumento = $request->input('procesoEditarRegistroDocumento', '');
		$post['valorActivo'] = $request->input('valorActivo', '');
		$tablaMaestra= $request->input('tablaMaestra', '');
		$valorDocumento= $request->input('valorDocumento', '');

		//configurar campos
		$tablaColumnaDetalle="";
		$tablaColumnaId="";
		
		if($tablaMaestra=="talla_camiseta")
		 {
			$tablaColumnaId="IdTalla";
			$tablaColumnaDetalle="DetalleTalla";
		 }
		if($tablaMaestra=="tipo_transporte")
		 {
			$tablaColumnaId="IdTipoTransporte ";
			$tablaColumnaDetalle="DetalleTipoTransporte";
		 }
		if($tablaMaestra=="tipo_alojamiento")
		 {
			$tablaColumnaId="IdTipoAlojamiento";
			$tablaColumnaDetalle="DetalleTipoAlojamiento";
		 }
		if($tablaMaestra=="motivo_viaje")
		 {
			$tablaColumnaId="IdMotivoViaje";
			$tablaColumnaDetalle="DetalleMotivoViaje";
		 }
		if($tablaMaestra=="motivo_consulta")
		 {
			$tablaColumnaId="IdMotivoConsulta";
			$tablaColumnaDetalle="DetalleMotivoConsulta";
		 }
		if($tablaMaestra=="genero")
		 {
			$tablaColumnaId="IdGenero";
			$tablaColumnaDetalle="DetalleGenero";
		 }
		if($tablaMaestra=="fidelidad")
		 {
			$tablaColumnaId="IdFidelidad";
			$tablaColumnaDetalle="DetalleFidelidad";
		 }
		if($tablaMaestra=="edad")
		 {
			$tablaColumnaId="IdEdad";
			$tablaColumnaDetalle="DetalleEdad";
		 }
		if($tablaMaestra=="duracion_estancia")
		 {
			$tablaColumnaId="IdDuracionEstancia";
			$tablaColumnaDetalle="DetalleDuracionEstancia";
		 }
		if($tablaMaestra=="aliado")
		 {
			$tablaColumnaId="IdAliado";
			$tablaColumnaDetalle="DetalleAliado";
		 }
		
		if(trim($procesoRegistroDocumento)=="1")
		 {
		    //ingresar  
		    Pits::crearTablaMaestra($tablaMaestra,$tablaColumnaDetalle,$valorDocumento);
		 }
		
		if(trim($procesoEditarRegistroDocumento)!="")
		 {
		    //editar  
			Pits::editarTablaMaestra($tablaMaestra,$tablaColumnaDetalle,$tablaColumnaId,$procesoEditarRegistroDocumento,$valorDocumento);
		 }
		
		//detalle registro
		$registro= MaestrosController::detalleDocumento($procesoEditarDocumento,$tablaMaestra,$tablaColumnaId,$tablaColumnaDetalle);
		
		//documentos  
		$listadoDocumentosHome=Pits::listadoTablaMaestra($tablaMaestra,$tablaColumnaId,$tablaColumnaDetalle);
		
        return view('maestros', [
            'tablaMaestra' => $tablaMaestra,
            'listadoDocumentosHome' => $listadoDocumentosHome,
            'procesoRegistroDocumento' => $procesoRegistroDocumento,
            'procesoRegistroDocumento' => $procesoRegistroDocumento,
            'procesoEditarRegistroDocumento' => $procesoEditarRegistroDocumento,
            'procesoEditarDocumento' => $procesoEditarDocumento,
            'registro' => $registro
        ]);
		
        //return view('departamentos.index', ['departamentos' => Departamento::all()]);
    }

  /*
  detalleDocumento
  */
  function detalleDocumento($Id,$tablaMaestra,$tablaColumnaId,$tablaColumnaDetalle)
  {
	  $registro["Id"]=$Id; 
	  $registro["Titulo"]=""; 

	  if(trim($Id)!="" && trim($Id)!="0")
	   {
		  $listado=Pits::listadoTablaMaestraDetalle($Id,$tablaMaestra,$tablaColumnaId,$tablaColumnaDetalle);
		  foreach ($listado as $row) 
		   {
			  $registro["Id"]=$row->Id; 
			  $registro["Titulo"]=$row->Titulo; 
		   }
	   }
	  
	 return $registro;  
  }
	
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', new Departamento);
        return view('departamentos.create', ['departamento' => new Departamento]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', new Departamento);
        $data = $request->validate(
            ['name' => 'required|unique:departamentos'],
            ['name.unique' => 'El departamento ya ha sido registrado']
        );
        $data['creator_user_id'] = auth()->user()->id;
        $data['updater_user_id'] = auth()->user()->id;
        Departamento::create($data);
        return redirect()->route('departamentos.index')->withFlash('El departamento ha sido creado de forma exitosa');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Departamento $departamento)
    {
        $this->authorize('view', new Departamento);
        return view('departamentos.show', compact('departamento'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Departamento $departamento)
    {
        $this->authorize('update', new Departamento);
        return view('departamentos.edit', compact('departamento'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Departamento $departamento)
    {
        $this->authorize('update', new Departamento);
        $data = $request->validate(['name' => ['required', Rule::unique('departamentos')->ignore($departamento->id)]], ['name.unique' => 'El departamento ya ha sido registrado']);
        if ($request->has('active')) {
            $data['active'] = true;
        } else {
            $data['active'] = false;
        }
        $data['updater_user_id'] = auth()->user()->id;
        $departamento->update($data);
        return redirect()->route('departamentos.index')->withFlash('El departamento ha sido actualizado de forma exitosa');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
