<?php

namespace App\Http\Controllers;

use App\Models\Node;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GaleriaController extends Controller
{

    public function index(){
        $galerias = Node::join('node__field_fecha','node.nid','=','node__field_fecha.entity_id')
        ->join('node_field_data','node.nid','=','node_field_data.nid')
        ->where('node.type','galeria')
        ->select(DB::raw('node.*, (select f.uri from node__field_image i inner join file_managed f on i.field_image_target_id = f.fid where node.nid = i.entity_id   LIMIT 1) as img, node_field_data.title as title, node__field_fecha.field_fecha_value as date'))
        ->orderByDesc('node__field_fecha.field_fecha_value')
        ->paginate(9); 
        return view('galerias.index', ['galerias' => $galerias]);
    }

    public function show(Node $galeria){

    $imagenes = Node::join('node__field_image','node.nid','=','node__field_image.entity_id')
                ->join('file_managed','node__field_image.field_image_target_id','=','file_managed.fid')
                ->join('node_field_data','node.nid','=','node_field_data.nid')
                ->where('node.nid',$galeria->nid)
                ->select('node.nid as id','file_managed.uri as img', 'node_field_data.title as title' )
                ->get();

    $title = $imagenes[0]->title; 
    
        return view('galerias.galeria', ['imagenes' => $imagenes, 'titulo' => $title]);
    }
}
