<?php

namespace App\Http\Controllers;

use App\Models\Pits;
use App\Models\Node;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Exports\TuristasExport;
use Maatwebsite\Excel\Facades\Excel;

class ExportableController extends Controller
{
	/*
	exportable
	*/
	public function exportable(Request $request)
	{
		set_time_limit(0);
		ini_set('memory_limit', '-1');

		$fileName = 'exportable.csv';

		$fechaFiltroDesde = $request->input('fechaFiltroDesde', '');
		$fechaFiltroHasta = $request->input('fechaFiltroHasta', '');

		$procesoEditarRegistroTurista = $request->input('procesoEditarRegistroTurista', '');
		$post['valorNombreConsultante'] = $request->input('valorNombreConsultante', '');
		$post['valorCorreo'] = $request->input('valorCorreo', '');
		$post['valorNacionalidad'] = $request->input('valorNacionalidad', '');
		$post['valorCiudad'] = $request->input('valorCiudad', '');
		$post['valorMotivoViaje'] = $request->input('valorMotivoViaje', '');
		$post['valorNroTuristas'] = $request->input('valorNroTuristas', '');
		$post['valorTipoTransporte'] = $request->input('valorTipoTransporte', '');
		$post['valorTipoAlojamiento'] = $request->input('valorTipoAlojamiento', '');
		$post['valorDuracionEstancia'] = $request->input('valorDuracionEstancia', '');
		$post['valorSexo'] = $request->input('valorSexo', '');
		$post['valorEdad'] = $request->input('valorEdad', '');
		$post['valorFidelidad'] = $request->input('valorFidelidad', '');
		$post['valorMotivoConsulta'] = $request->input('valorMotivoConsulta', '');
		$post['valorPitsCiudad'] = $request->input('valorPitsCiudad', '');
		$post['valorTipoReporte'] = $request->input('valorTipoReporte', '');

		/*
		$headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=".$fileName,
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('NombreConsultante', 'Correo', 'DESCRIPCIONPAIS', 'DESCRIPCIONCIUDAD', 'DetalleMotivoViaje', 'NumeroTuristas', 'DetalleTipoTransporte', 'DetalleTipoAlojamiento' , 'DetalleDuracionEstancia'  );
        */

		//listado turistas paginado
		$listadoTuristas = Pits::listadoTuristasFiltroReporteExportable($fechaFiltroDesde, $fechaFiltroHasta, $post);

		/*
        $callback = function() use($listadoTuristas, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($listadoTuristas as $row)
             {
                 if($row->IdSexo=="1")
    			  {
    			    $sexo="Masculino";  
    			  }
    			 else
    			  {
    			    $sexo="Femenino";  
    			  }
    			  
                $row2['NombreConsultante']  = $row->NombreConsultante;
                $row2['Correo']    = $row->Correo;
                $row2['DESCRIPCIONPAIS']    = $row->DESCRIPCIONPAIS;
                $row2['DESCRIPCIONCIUDAD']  = $row->DESCRIPCIONCIUDAD;
                $row2['DetalleMotivoViaje']  = $row->DetalleMotivoViaje;
                $row2['NumeroTuristas']  = $row->NumeroTuristas;
                $row2['DetalleTipoTransporte']  = $row->DetalleTipoTransporte;
                $row2['DetalleTipoAlojamiento']  = $row->DetalleTipoAlojamiento;
                $row2['DetalleDuracionEstancia']  = $row->DetalleDuracionEstancia;
                $row2['sexo']  = $sexo;
                $row2['DetalleEdad']  = $row->DetalleEdad;
                $row2['DetalleFidelidad']  = $row->DetalleFidelidad;
                $row2['DetalleMotivoConsulta']  = $row->DetalleMotivoConsulta;
                $row2['PitsDetalle']  = $row->PitsDetalle;
                $row2['FechaRegistro']  = $row->FechaRegistro;

                fputcsv($file, array($row2['NombreConsultante'], $row2['Correo'], $row2['DESCRIPCIONPAIS'], $row2['DESCRIPCIONCIUDAD'], $row2['DetalleMotivoViaje'],$row2['NumeroTuristas'],$row2['DetalleTipoTransporte'],$row2['DetalleTipoAlojamiento']  ,$row2['DetalleDuracionEstancia']  ,$row2['sexo']  ,$row2['DetalleEdad']  ,$row2['DetalleFidelidad']  ,$row2['DetalleMotivoConsulta']  ,$row2['PitsDetalle'] ,$row2['FechaRegistro'] )); 
             }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
        */

		$columnHeader = "NombreConsultante" . "\t" . "Correo" . "\t" . "DESCRIPCIONPAIS" . "\t" . "DESCRIPCIONCIUDAD" . "\t" . "DetalleMotivoViaje" . "\t" . "NumeroTuristas" . "\t" . "DetalleTipoTransporte" . "\t" . "DetalleTipoAlojamiento" . "\t" . "DetalleDuracionEstancia" . "\t" . "SEXO" . "\t" . "DetalleEdad" . "\t" . "DetalleFidelidad" . "\t" . "DetalleMotivoConsulta" . "\t" . "PitsDetalle" . "\t" . "FechaRegistro" . "\t" . "UsuarioRegistro";
		$setData = "";
		foreach ($listadoTuristas as $row) {
			if ($row->IdSexo == "1") {
				$sexo = "Masculino";
			} else {
				$sexo = "Femenino";
			}

			$rowData = "";
			$rowData = $rowData . $row->NombreConsultante . "\t";
			$rowData = $rowData . $row->Correo . "\t";
			$rowData = $rowData . $row->DESCRIPCIONPAIS . "\t";
			$rowData = $rowData . $row->DESCRIPCIONCIUDAD . "\t";
			$rowData = $rowData . $row->DetalleMotivoViaje . "\t";
			$rowData = $rowData . $row->NumeroTuristas . "\t";
			$rowData = $rowData . $row->DetalleTipoTransporte . "\t";
			$rowData = $rowData . $row->DetalleTipoAlojamiento . "\t";
			$rowData = $rowData . $row->DetalleDuracionEstancia . "\t";
			$rowData = $rowData . $sexo . "\t";
			$rowData = $rowData . $row->DetalleEdad . "\t";
			$rowData = $rowData . $row->DetalleFidelidad . "\t";
			$rowData = $rowData . $row->DetalleMotivoConsulta . "\t";
			$rowData = $rowData . $row->PitsDetalle . "\t";
			$rowData = $rowData . $row->FechaRegistro . "\t";
			$rowData = $rowData . $row->NombreUsuarioRegistro . "\t";

			$setData = $setData . trim($rowData) . "\n";
		}

		header("Content-type: application/octet-stream");
		header("Content-Disposition: attachment; filename=exportable.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		echo ucwords($columnHeader) . "\n" . $setData . "\n";
	}


	public function export(Request $request)
	{
		set_time_limit(0);
		ini_set('memory_limit', '-1');
		$fechaFiltroDesde = $request->input('fechaFiltroDesde', '');
		$fechaFiltroHasta = $request->input('fechaFiltroHasta', '');
		$valorPitsCiudad = $request->input('valorPitsCiudad', '');
		$valorNacionalidad = $request->input('valorNacionalidad', '');
		$valorCiudad = $request->input('valorCiudad', '');
		$valorMotivoViaje = $request->input('valorMotivoViaje', '');
		$valorTipoTransporte = $request->input('valorTipoTransporte', '');
		$valorTipoAlojamiento = $request->input('valorTipoAlojamiento', '');
		$valorDuracionEstancia = $request->input('valorDuracionEstancia', '');
		$valorSexo = $request->input('valorSexo', '');
		$valorEdad = $request->input('valorEdad', '');
		$valorFidelidad = $request->input('valorFidelidad', '');
		$valorMotivoConsulta = $request->input('valorMotivoConsulta', '');
		return (new TuristasExport($fechaFiltroDesde, $fechaFiltroHasta, $valorPitsCiudad,$valorNacionalidad,$valorCiudad,$valorMotivoViaje,
		$valorTipoTransporte,$valorTipoAlojamiento,$valorDuracionEstancia,$valorSexo,$valorEdad,$valorFidelidad,$valorMotivoConsulta))->download('turistas.xlsx');
		
	}
}
