<?php

namespace App\Http\Controllers;

use App\Models\Cargo;
use App\Models\Departamento;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Models\Pits;

class DepartamentoController extends Controller
{
    public function getCargos(Request $request, $id)
    {
        if ($request->ajax()) {
            $cargos = Cargo::cargos($id);
            return response()->json($cargos);
        }
    }

    public function index(Request $request)
    {
        //$this->authorize('view', new Departamento);
		$procesoRegistroDocumento = $request->input('procesoRegistroDocumento', '');
		$procesoEditarDocumento = $request->input('procesoEditarDocumento', '');
		$procesoEditarRegistroDocumento = $request->input('procesoEditarRegistroDocumento', '');
		$post['valorDocumento'] = $request->input('valorDocumento', '');
		$post['valorActivo'] = $request->input('valorActivo', '');
        $archivo = $request->file('archivo');
		$archivoAdjuntoSolicitud="";
		
		if($archivo!="")
		 {
		  if( $archivo->getClientOriginalExtension() == "pdf" )  
		   {
			 $destinationPath = 'documentos';
			 $llaveArchivo=date("YmdHi").rand(1111,9999);
			 $archivo->move($destinationPath,$llaveArchivo.$archivo->getClientOriginalName());	  
			 $archivoAdjuntoSolicitud=$llaveArchivo.$archivo->getClientOriginalName();
		   }			  
		 }
		 
		if(trim($procesoRegistroDocumento)=="1")
		 {
		    //ingresar documento
		    Pits::crearProcesoDocumento($post,$archivoAdjuntoSolicitud);
		 }
		
		if(trim($procesoEditarRegistroDocumento)!="")
		 {
		    //editar documento
		    Pits::actualizarProcesoDocumento($procesoEditarRegistroDocumento,$post,$archivoAdjuntoSolicitud);
		 }
		
		//detalle registro
		$registro= DepartamentoController::detalleDocumento($procesoEditarDocumento);
		
		//documentos  
		$listadoDocumentosHome=Pits::listadoDocumentosTodos();
		
        return view('departamentos.index', [
            'listadoDocumentosHome' => $listadoDocumentosHome,
            'procesoRegistroDocumento' => $procesoRegistroDocumento,
            'procesoRegistroDocumento' => $procesoRegistroDocumento,
            'procesoEditarRegistroDocumento' => $procesoEditarRegistroDocumento,
            'procesoEditarDocumento' => $procesoEditarDocumento,
            'registro' => $registro
        ]);
		
        //return view('departamentos.index', ['departamentos' => Departamento::all()]);
    }

  /*
  detalleDocumento
  */
  function detalleDocumento($IdDocumento)
  {
	  $registro["IdDocumento"]=$IdDocumento  ; 
	  $registro["Titulo"]=""; 
	  $registro["ActivoArchivo"]=""; 

	  if(trim($IdDocumento )!="" && trim($IdDocumento )!="0")
	   {
		  $listado=Pits::listadoDetalleDocumento($IdDocumento);
		  foreach ($listado as $row) 
		   {
			  $registro["IdDocumento"]=$row->IdDocumento; 
			  $registro["Titulo"]=$row->Titulo; 
			  $registro["ActivoArchivo"]=$row->ActivoArchivo; 
		   }
	   }
	  
	 return $registro;  
  }
	
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', new Departamento);
        return view('departamentos.create', ['departamento' => new Departamento]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', new Departamento);
        $data = $request->validate(
            ['name' => 'required|unique:departamentos'],
            ['name.unique' => 'El departamento ya ha sido registrado']
        );
        $data['creator_user_id'] = auth()->user()->id;
        $data['updater_user_id'] = auth()->user()->id;
        Departamento::create($data);
        return redirect()->route('departamentos.index')->withFlash('El departamento ha sido creado de forma exitosa');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Departamento $departamento)
    {
        $this->authorize('view', new Departamento);
        return view('departamentos.show', compact('departamento'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Departamento $departamento)
    {
        $this->authorize('update', new Departamento);
        return view('departamentos.edit', compact('departamento'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Departamento $departamento)
    {
        $this->authorize('update', new Departamento);
        $data = $request->validate(['name' => ['required', Rule::unique('departamentos')->ignore($departamento->id)]], ['name.unique' => 'El departamento ya ha sido registrado']);
        if ($request->has('active')) {
            $data['active'] = true;
        } else {
            $data['active'] = false;
        }
        $data['updater_user_id'] = auth()->user()->id;
        $departamento->update($data);
        return redirect()->route('departamentos.index')->withFlash('El departamento ha sido actualizado de forma exitosa');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
