<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Correspondencia;
use Illuminate\Support\Facades\Route;
use App\Models\Pits;
use App\Models\Node;

class CorrespondenciaController extends Controller
{
    public function index(Request $request)
    {
        //$correspondencias = Correspondencia::allowed()->latest()->get();
        $valorCiudad = $request->input('valorCiudad', '0');
		//directorio
		$listadoDirectorio=Pits::listadoDirectorio($valorCiudad);

        //ciudades PITS
		$ciudadesPits = Node::join('node__field_ciudad', 'node.nid', '=', 'node__field_ciudad.entity_id')
		->join('node_field_data', 'node.nid', '=', 'node_field_data.nid')
		->join('taxonomy_term_field_data', 'taxonomy_term_field_data.tid', '=', 'node__field_ciudad.field_ciudad_target_id')
		->where('node.type', "pits")
		->where('node.langcode', "es")
		->where('node_field_data.status', 1)
		->select('taxonomy_term_field_data.*')->orderBy('taxonomy_term_field_data.name')->distinct()->get();

		return view('correspondencias.index', [
            'listadoDirectorio' => $listadoDirectorio,
            'ciudadesPits' => $ciudadesPits,
            'valorCiudad' => $valorCiudad,
        ]);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'para' => 'required|min:3',
            'asunto' => 'required|min:3',
        ]);
        $data['user_id'] = auth()->user()->id;

        $correspondencia = Correspondencia::create($data);

        $msg = 'Tu correspondencia ha sido registrada con el ID: ' . $correspondencia->id;

        if (Route::currentRouteName() == 'correspondencia.store') {
            return redirect()->route('correspondencia.index')->withFlash($msg);
        } else {
            return redirect()->route('home')->withFlash($msg);
        }
    }
}
