<?php

namespace App\Exports;

use App\Models\Turista;
use Maatwebsite\Excel\Concerns\FromQuery;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;


class TuristasExport implements FromQuery, WithMapping, WithHeadings, WithColumnFormatting, WithStyles, ShouldAutoSize

{


    use Exportable;

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            1    => ['font' => ['bold' => true]],
        ];
    }

    public function columnFormats(): array
    {
        return [
            'T' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }

    public function headings(): array
    {
        return [
            'NOMBRE CONSULTANTE',
            'CORREO',
            'PAÍS',
            'CIUDAD',
            'MOTIVO VIAJE',
            'NÚMERO DE TURÍSTAS',
            'TIPO TRANSPORTE',
            'TIPO ALOJAMIENTO',
            'DURACIÓN ESTANCIA',
            'SEXO',
            'RANGO EDAD',
            'FIDELIDAD',
            'MOTIVO CONSULTA',
            'PITS',
            //'PITS ID',
            'FECHA REGISTRO',
            'USUARIO REGISTRO'
        ];
    }

    public function map($turista): array
    {
        return [
            $turista->NombreConsultante,
            $turista->Correo,
            $turista->pais == null ? "" : $turista->pais->DESCRIPCION,
            $turista->ciudad  == null ? "" : $turista->ciudad->DESCRIPCION,
            $turista->motivoViaje == null ? "" : $turista->motivoViaje->DetalleMotivoViaje,
            $turista->NumeroTuristas,
            $turista->tipoTransporte == null ? "" : $turista->tipoTransporte->DetalleTipoTransporte,
            $turista->tipoAlojamiento == null ? "" : $turista->tipoAlojamiento->DetalleTipoAlojamiento,
            $turista->duracionEstancia == null ? "" : $turista->duracionEstancia->DetalleDuracionEstancia,
            $turista->genero == null ? "" : $turista->genero->DetalleGenero,
            $turista->edad == null ? "" : $turista->edad->DetalleEdad,
            $turista->fidelidad == null ? "" : $turista->fidelidad->DetalleFidelidad,
            $turista->motivoConsulta == null ? "" : $turista->motivoConsulta->DetalleMotivoConsulta,
            $turista->PitsDetalle,
            //$turista->pits == null ? "":$turista->pits->title,
            $turista->FechaRegistro,
            $turista->usuario == null ? "" : $turista->usuario->name
        ];
    }

    public function __construct(
        $fechaFiltroDesde,
        $fechaFiltroHasta,
        $valorPitsCiudad,
        $valorNacionalidad,
        $valorCiudad,
        $valorMotivoViaje,
        $valorTipoTransporte,
        $valorTipoAlojamiento,
        $valorDuracionEstancia,
        $valorSexo,
        $valorEdad,
        $valorFidelidad,
        $valorMotivoConsulta
    ) {
        $this->fechaFiltroDesde = $fechaFiltroDesde;
        $this->fechaFiltroHasta = $fechaFiltroHasta;
        $this->valorPitsCiudad = $valorPitsCiudad;
        $this->valorNacionalidad = $valorNacionalidad;
        $this->valorCiudad = $valorCiudad;
        $this->valorMotivoViaje = $valorMotivoViaje;
        $this->valorTipoTransporte = $valorTipoTransporte;
        $this->valorTipoAlojamiento = $valorTipoAlojamiento;
        $this->valorDuracionEstancia = $valorDuracionEstancia;
        $this->valorSexo = $valorSexo;
        $this->valorEdad = $valorEdad;
        $this->valorFidelidad = $valorFidelidad;
        $this->valorMotivoConsulta = $valorMotivoConsulta;
    }

    public function query()
    {
        return Turista::query()->where(function ($q) {
            if (trim($this->fechaFiltroDesde) != "" && trim($this->fechaFiltroHasta) != "") {
                $q->whereBetween('FechaRegistro', [$this->fechaFiltroDesde.' 00:00:00', $this->fechaFiltroHasta.' 23:59:59']);
            }
            if (!in_array("0", $this->valorPitsCiudad)) {
                $q->whereIn('IdPits', $this->valorPitsCiudad);
            }
            if (trim($this->valorNacionalidad) != "") {
                $q->where('IdCatastroPais', $this->valorNacionalidad);
            }
            if (trim($this->valorCiudad) != "0" && trim($this->valorCiudad) != "") {
                $q->where('IdCatastroCiudad', $this->valorCiudad);
            }
            if (trim($this->valorMotivoViaje) != "") {
                $q->where('IdMotivoViaje', $this->valorMotivoViaje);
            }
            if (trim($this->valorTipoTransporte) != "") {
                $q->where('IdTipoTransporte', $this->valorTipoTransporte);
            }
            if (trim($this->valorTipoAlojamiento) != "") {
                $q->where('IdTipoAlojamiento', $this->valorTipoAlojamiento);
            }
            if (trim($this->valorDuracionEstancia) != "") {
                $q->where('IdDuracion', $this->valorDuracionEstancia);
            }
            if (trim($this->valorSexo) != "") {
                $q->where('IdSexo', $this->valorSexo);
            }
            if (trim($this->valorEdad) != "") {
                $q->where('IdEdad', $this->valorEdad);
            }
            if (trim($this->valorFidelidad) != "") {
                $q->where('IdFidelidad', $this->valorFidelidad);
            }
            if (trim($this->valorMotivoConsulta) != "") {
                $q->where('IdMotivoConsulta', $this->valorMotivoConsulta);
            }
        });
    }
}
